/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.test.util;

import org.apache.flink.client.program.ClusterClient;
import org.apache.flink.client.program.MiniClusterClient;
import org.apache.flink.client.program.rest.RestClusterClient;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.testutils.MiniClusterExtension;
import org.apache.flink.runtime.testutils.MiniClusterResourceConfiguration;
import org.apache.flink.streaming.util.TestStreamEnvironment;
import org.apache.flink.test.util.TestEnvironment;
import org.apache.flink.util.ExceptionUtils;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MiniClusterWithClientExtension
extends MiniClusterExtension {
    private static final Logger LOG = LoggerFactory.getLogger(MiniClusterWithClientExtension.class);
    private ClusterClient<?> clusterClient;
    private RestClusterClient<MiniClusterClient.MiniClusterId> restClusterClient;
    private TestEnvironment executionEnvironment;

    public MiniClusterWithClientExtension(MiniClusterResourceConfiguration miniClusterResourceConfiguration) {
        super(miniClusterResourceConfiguration);
    }

    public ClusterClient<?> getClusterClient() {
        return this.clusterClient;
    }

    public RestClusterClient<?> getRestClusterClient() throws Exception {
        return this.restClusterClient;
    }

    public TestEnvironment getTestEnvironment() {
        return this.executionEnvironment;
    }

    public void before(ExtensionContext context) throws Exception {
        super.before(context);
        this.clusterClient = this.createMiniClusterClient();
        this.restClusterClient = this.createRestClusterClient();
        this.executionEnvironment = new TestEnvironment(this.getMiniCluster(), this.getNumberSlots(), false);
        this.executionEnvironment.setAsContext();
        TestStreamEnvironment.setAsContext(this.getMiniCluster(), this.getNumberSlots());
    }

    public void after(ExtensionContext context) throws Exception {
        LOG.info("Finalization triggered: Cluster shutdown is going to be initiated.");
        TestStreamEnvironment.unsetAsContext();
        TestEnvironment.unsetAsContext();
        Exception exception = null;
        if (this.clusterClient != null) {
            try {
                this.clusterClient.close();
            }
            catch (Exception e) {
                exception = e;
            }
        }
        this.clusterClient = null;
        if (this.restClusterClient != null) {
            try {
                this.restClusterClient.close();
            }
            catch (Exception e) {
                exception = (Exception)ExceptionUtils.firstOrSuppressed((Throwable)e, (Throwable)exception);
            }
        }
        this.restClusterClient = null;
        super.after(context);
        if (exception != null) {
            LOG.warn("Could not properly shut down the MiniClusterWithClientResource.", (Throwable)exception);
        }
    }

    private MiniClusterClient createMiniClusterClient() {
        return new MiniClusterClient((Configuration)this.getClientConfiguration(), this.getMiniCluster());
    }

    private RestClusterClient<MiniClusterClient.MiniClusterId> createRestClusterClient() throws Exception {
        return new RestClusterClient((Configuration)this.getClientConfiguration(), (Object)MiniClusterClient.MiniClusterId.INSTANCE);
    }
}

