/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.test.junit5;

import java.util.function.Supplier;
import org.apache.flink.annotation.Experimental;
import org.apache.flink.client.program.ClusterClient;
import org.apache.flink.client.program.MiniClusterClient;
import org.apache.flink.client.program.rest.RestClusterClient;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.testutils.InternalMiniClusterExtension;
import org.apache.flink.runtime.testutils.MiniClusterResourceConfiguration;
import org.apache.flink.streaming.util.TestStreamEnvironment;
import org.apache.flink.test.junit5.InjectClusterClient;
import org.apache.flink.test.util.TestEnvironment;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;

@Experimental
public final class MiniClusterExtension
implements BeforeAllCallback,
BeforeEachCallback,
AfterEachCallback,
AfterAllCallback,
ParameterResolver {
    private static final ExtensionContext.Namespace NAMESPACE = ExtensionContext.Namespace.create((Object[])new Object[]{MiniClusterExtension.class});
    private static final String CLUSTER_REST_CLIENT = "clusterRestClient";
    private static final String MINI_CLUSTER_CLIENT = "miniClusterClient";
    private final Supplier<MiniClusterResourceConfiguration> miniClusterResourceConfigurationSupplier;
    private InternalMiniClusterExtension internalMiniClusterExtension;

    public MiniClusterExtension() {
        this(new MiniClusterResourceConfiguration.Builder().setNumberTaskManagers(1).setNumberSlotsPerTaskManager(1).build());
    }

    public MiniClusterExtension(MiniClusterResourceConfiguration miniClusterResourceConfiguration) {
        this(() -> miniClusterResourceConfiguration);
    }

    @Experimental
    public MiniClusterExtension(Supplier<MiniClusterResourceConfiguration> miniClusterResourceConfigurationSupplier) {
        this.miniClusterResourceConfigurationSupplier = miniClusterResourceConfigurationSupplier;
    }

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        Class<?> parameterType = parameterContext.getParameter().getType();
        if (parameterContext.isAnnotated(InjectClusterClient.class) && ClusterClient.class.isAssignableFrom(parameterType)) {
            return true;
        }
        return this.internalMiniClusterExtension.supportsParameter(parameterContext, extensionContext);
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        Class<?> parameterType = parameterContext.getParameter().getType();
        if (parameterContext.isAnnotated(InjectClusterClient.class)) {
            if (parameterType.equals(RestClusterClient.class)) {
                return ((CloseableParameter)extensionContext.getStore(NAMESPACE).getOrComputeIfAbsent((Object)CLUSTER_REST_CLIENT, k -> {
                    try {
                        return new CloseableParameter<RestClusterClient<MiniClusterClient.MiniClusterId>>(this.createRestClusterClient(this.internalMiniClusterExtension));
                    }
                    catch (Exception e) {
                        throw new ParameterResolutionException("Cannot create rest cluster client", (Throwable)e);
                    }
                }, CloseableParameter.class)).get();
            }
            return ((CloseableParameter)extensionContext.getStore(NAMESPACE).getOrComputeIfAbsent((Object)MINI_CLUSTER_CLIENT, k -> {
                try {
                    return new CloseableParameter<MiniClusterClient>(this.createMiniClusterClient(this.internalMiniClusterExtension));
                }
                catch (Exception e) {
                    throw new ParameterResolutionException("Cannot create mini cluster client", (Throwable)e);
                }
            }, CloseableParameter.class)).get();
        }
        return this.internalMiniClusterExtension.resolveParameter(parameterContext, extensionContext);
    }

    public void beforeAll(ExtensionContext context) throws Exception {
        this.internalMiniClusterExtension = new InternalMiniClusterExtension(this.miniClusterResourceConfigurationSupplier.get());
        this.internalMiniClusterExtension.beforeAll(context);
    }

    public void beforeEach(ExtensionContext context) throws Exception {
        this.registerEnv(this.internalMiniClusterExtension);
    }

    public void afterEach(ExtensionContext context) throws Exception {
        this.unregisterEnv(this.internalMiniClusterExtension);
    }

    public void afterAll(ExtensionContext context) throws Exception {
        if (this.internalMiniClusterExtension != null) {
            this.internalMiniClusterExtension.afterAll(context);
        }
    }

    private void registerEnv(InternalMiniClusterExtension internalMiniClusterExtension) {
        TestEnvironment executionEnvironment = new TestEnvironment(internalMiniClusterExtension.getMiniCluster(), internalMiniClusterExtension.getNumberSlots(), false);
        executionEnvironment.setAsContext();
        TestStreamEnvironment.setAsContext(internalMiniClusterExtension.getMiniCluster(), internalMiniClusterExtension.getNumberSlots());
    }

    private void unregisterEnv(InternalMiniClusterExtension internalMiniClusterExtension) {
        TestStreamEnvironment.unsetAsContext();
        TestEnvironment.unsetAsContext();
    }

    private MiniClusterClient createMiniClusterClient(InternalMiniClusterExtension internalMiniClusterExtension) {
        return new MiniClusterClient((Configuration)internalMiniClusterExtension.getClientConfiguration(), internalMiniClusterExtension.getMiniCluster());
    }

    private RestClusterClient<MiniClusterClient.MiniClusterId> createRestClusterClient(InternalMiniClusterExtension internalMiniClusterExtension) throws Exception {
        return new RestClusterClient((Configuration)internalMiniClusterExtension.getClientConfiguration(), (Object)MiniClusterClient.MiniClusterId.INSTANCE);
    }

    public Configuration getClientConfiguration() {
        return this.internalMiniClusterExtension.getClientConfiguration();
    }

    private static class CloseableParameter<T extends AutoCloseable>
    implements ExtensionContext.Store.CloseableResource {
        private final T autoCloseable;

        CloseableParameter(T autoCloseable) {
            this.autoCloseable = autoCloseable;
        }

        public T get() {
            return this.autoCloseable;
        }

        public void close() throws Throwable {
            this.autoCloseable.close();
        }
    }
}

