/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.wan;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.wan.GatewayReceiver;
import org.apache.geode.cache.wan.GatewayReceiverFactory;
import org.apache.geode.cache.wan.GatewayTransportFilter;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.distributed.internal.ResourceEvent;
import org.apache.geode.internal.cache.GemFireCacheImpl;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.wan.GatewayReceiverException;
import org.apache.geode.internal.cache.wan.GatewayReceiverImpl;
import org.apache.geode.internal.cache.xmlcache.CacheCreation;
import org.apache.geode.internal.cache.xmlcache.GatewayReceiverCreation;
import org.apache.geode.internal.i18n.LocalizedStrings;

public class GatewayReceiverFactoryImpl
implements GatewayReceiverFactory {
    private int startPort = 5000;
    private int endPort = 5500;
    private int timeBetPings = 60000;
    private int socketBuffSize = 524288;
    private String bindAdd = "";
    private String hostnameForSenders = "";
    private boolean manualStart = false;
    private List<GatewayTransportFilter> filters = new ArrayList<GatewayTransportFilter>();
    private InternalCache cache;

    public GatewayReceiverFactoryImpl() {
    }

    public GatewayReceiverFactoryImpl(InternalCache cache) {
        this.cache = cache;
    }

    public GatewayReceiverFactory addGatewayTransportFilter(GatewayTransportFilter filter) {
        this.filters.add(filter);
        return this;
    }

    public GatewayReceiverFactory removeGatewayTransportFilter(GatewayTransportFilter filter) {
        this.filters.remove(filter);
        return this;
    }

    public GatewayReceiverFactory setMaximumTimeBetweenPings(int time) {
        this.timeBetPings = time;
        return this;
    }

    public GatewayReceiverFactory setStartPort(int port) {
        this.startPort = port;
        return this;
    }

    public GatewayReceiverFactory setEndPort(int port) {
        this.endPort = port;
        return this;
    }

    public GatewayReceiverFactory setSocketBufferSize(int size) {
        this.socketBuffSize = size;
        return this;
    }

    public GatewayReceiverFactory setBindAddress(String address) {
        this.bindAdd = address;
        return this;
    }

    public GatewayReceiverFactory setHostnameForSenders(String address) {
        this.hostnameForSenders = address;
        return this;
    }

    public GatewayReceiverFactory setManualStart(boolean start) {
        this.manualStart = start;
        return this;
    }

    public GatewayReceiver create() {
        if (this.startPort > this.endPort) {
            throw new IllegalStateException("Please specify either start port a value which is less than end port.");
        }
        GatewayReceiverImpl recv = null;
        if (this.cache instanceof GemFireCacheImpl) {
            recv = new GatewayReceiverImpl(this.cache, this.startPort, this.endPort, this.timeBetPings, this.socketBuffSize, this.bindAdd, this.filters, this.hostnameForSenders, this.manualStart);
            this.cache.addGatewayReceiver((GatewayReceiver)recv);
            InternalDistributedSystem system = (InternalDistributedSystem)this.cache.getDistributedSystem();
            system.handleResourceEvent(ResourceEvent.GATEWAYRECEIVER_CREATE, (Object)recv);
            if (!this.manualStart) {
                try {
                    recv.start();
                }
                catch (IOException ioe) {
                    throw new GatewayReceiverException(LocalizedStrings.GatewayReceiver_EXCEPTION_WHILE_STARTING_GATEWAY_RECEIVER.toLocalizedString(), (Throwable)ioe);
                }
            }
        } else if (this.cache instanceof CacheCreation) {
            recv = new GatewayReceiverCreation((Cache)this.cache, this.startPort, this.endPort, this.timeBetPings, this.socketBuffSize, this.bindAdd, this.filters, this.hostnameForSenders, this.manualStart);
            this.cache.addGatewayReceiver((GatewayReceiver)recv);
        }
        return recv;
    }
}

