/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a.prefetch;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.hadoop.fs.impl.prefetch.BlockData;
import org.apache.hadoop.fs.impl.prefetch.CachingBlockManager;
import org.apache.hadoop.fs.impl.prefetch.ExecutorServiceFuturePool;
import org.apache.hadoop.fs.impl.prefetch.PrefetchingStatistics;
import org.apache.hadoop.fs.impl.prefetch.Validate;
import org.apache.hadoop.fs.s3a.prefetch.S3ARemoteObjectReader;
import org.apache.hadoop.fs.s3a.statistics.S3AInputStreamStatistics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class S3ACachingBlockManager
extends CachingBlockManager {
    private static final Logger LOG = LoggerFactory.getLogger(S3ACachingBlockManager.class);
    private final S3ARemoteObjectReader reader;

    public S3ACachingBlockManager(ExecutorServiceFuturePool futurePool, S3ARemoteObjectReader reader, BlockData blockData, int bufferPoolSize, S3AInputStreamStatistics streamStatistics) {
        super(futurePool, blockData, bufferPoolSize, (PrefetchingStatistics)streamStatistics);
        Validate.checkNotNull((Object)reader, (String)"reader");
        this.reader = reader;
    }

    protected S3ARemoteObjectReader getReader() {
        return this.reader;
    }

    public int read(ByteBuffer buffer, long startOffset, int size) throws IOException {
        return this.reader.read(buffer, startOffset, size);
    }

    public synchronized void close() {
        this.reader.close();
        super.close();
    }
}

