/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.EtagSource;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.azurebfs.AbfsConfiguration;
import org.apache.hadoop.fs.azurebfs.AbfsStatistic;
import org.apache.hadoop.fs.azurebfs.contracts.exceptions.AbfsRestOperationException;
import org.apache.hadoop.fs.azurebfs.contracts.exceptions.AzureBlobFileSystemException;
import org.apache.hadoop.fs.azurebfs.contracts.exceptions.ConcurrentWriteOperationDetectedException;
import org.apache.hadoop.fs.azurebfs.contracts.exceptions.FileSystemOperationUnhandledException;
import org.apache.hadoop.fs.azurebfs.contracts.exceptions.InvalidAbfsRestOperationException;
import org.apache.hadoop.fs.azurebfs.contracts.exceptions.InvalidFileSystemPropertyException;
import org.apache.hadoop.fs.azurebfs.contracts.exceptions.InvalidUriAuthorityException;
import org.apache.hadoop.fs.azurebfs.contracts.exceptions.InvalidUriException;
import org.apache.hadoop.fs.azurebfs.contracts.exceptions.TrileanConversionException;
import org.apache.hadoop.fs.azurebfs.contracts.services.AzureServiceErrorCode;
import org.apache.hadoop.fs.azurebfs.contracts.services.ListResultEntrySchema;
import org.apache.hadoop.fs.azurebfs.contracts.services.ListResultSchema;
import org.apache.hadoop.fs.azurebfs.enums.Trilean;
import org.apache.hadoop.fs.azurebfs.extensions.ExtensionHelper;
import org.apache.hadoop.fs.azurebfs.extensions.SASTokenProvider;
import org.apache.hadoop.fs.azurebfs.oauth2.AccessTokenProvider;
import org.apache.hadoop.fs.azurebfs.oauth2.AzureADAuthenticator;
import org.apache.hadoop.fs.azurebfs.oauth2.IdentityTransformer;
import org.apache.hadoop.fs.azurebfs.oauth2.IdentityTransformerInterface;
import org.apache.hadoop.fs.azurebfs.services.AbfsAclHelper;
import org.apache.hadoop.fs.azurebfs.services.AbfsClient;
import org.apache.hadoop.fs.azurebfs.services.AbfsClientContext;
import org.apache.hadoop.fs.azurebfs.services.AbfsClientContextBuilder;
import org.apache.hadoop.fs.azurebfs.services.AbfsClientRenameResult;
import org.apache.hadoop.fs.azurebfs.services.AbfsCounters;
import org.apache.hadoop.fs.azurebfs.services.AbfsHttpOperation;
import org.apache.hadoop.fs.azurebfs.services.AbfsInputStream;
import org.apache.hadoop.fs.azurebfs.services.AbfsInputStreamContext;
import org.apache.hadoop.fs.azurebfs.services.AbfsInputStreamStatisticsImpl;
import org.apache.hadoop.fs.azurebfs.services.AbfsLease;
import org.apache.hadoop.fs.azurebfs.services.AbfsOutputStream;
import org.apache.hadoop.fs.azurebfs.services.AbfsOutputStreamContext;
import org.apache.hadoop.fs.azurebfs.services.AbfsOutputStreamStatisticsImpl;
import org.apache.hadoop.fs.azurebfs.services.AbfsPerfInfo;
import org.apache.hadoop.fs.azurebfs.services.AbfsPerfTracker;
import org.apache.hadoop.fs.azurebfs.services.AbfsPermission;
import org.apache.hadoop.fs.azurebfs.services.AbfsRestOperation;
import org.apache.hadoop.fs.azurebfs.services.AuthType;
import org.apache.hadoop.fs.azurebfs.services.ExponentialRetryPolicy;
import org.apache.hadoop.fs.azurebfs.services.ListingSupport;
import org.apache.hadoop.fs.azurebfs.services.SharedKeyCredentials;
import org.apache.hadoop.fs.azurebfs.utils.Base64;
import org.apache.hadoop.fs.azurebfs.utils.CRC64;
import org.apache.hadoop.fs.azurebfs.utils.DateTimeUtils;
import org.apache.hadoop.fs.azurebfs.utils.TracingContext;
import org.apache.hadoop.fs.azurebfs.utils.UriUtils;
import org.apache.hadoop.fs.impl.BackReference;
import org.apache.hadoop.fs.impl.OpenFileParameters;
import org.apache.hadoop.fs.permission.AclEntry;
import org.apache.hadoop.fs.permission.AclStatus;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.fs.store.DataBlocks;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.thirdparty.com.google.common.base.Strings;
import org.apache.hadoop.thirdparty.com.google.common.util.concurrent.Futures;
import org.apache.hadoop.thirdparty.com.google.common.util.concurrent.ListenableFuture;
import org.apache.hadoop.util.BlockingThreadPoolExecutorService;
import org.apache.hadoop.util.Preconditions;
import org.apache.hadoop.util.SemaphoredDelegatingExecutor;
import org.apache.hadoop.util.concurrent.HadoopExecutors;
import org.apache.http.client.utils.URIBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class AzureBlobFileSystemStore
implements Closeable,
ListingSupport {
    private static final Logger LOG = LoggerFactory.getLogger(AzureBlobFileSystemStore.class);
    private AbfsClient client;
    private URI uri;
    private String userName;
    private String primaryUserGroup;
    private static final String TOKEN_DATE_PATTERN = "yyyy-MM-dd'T'HH:mm:ss.SSSSSSS'Z'";
    private static final String XMS_PROPERTIES_ENCODING = "ISO-8859-1";
    private static final int GET_SET_AGGREGATE_COUNT = 2;
    private final Map<AbfsLease, Object> leaseRefs;
    private final AbfsConfiguration abfsConfiguration;
    private final Set<String> azureAtomicRenameDirSet;
    private Set<String> azureInfiniteLeaseDirSet;
    private Trilean isNamespaceEnabled;
    private final AuthType authType;
    private final UserGroupInformation userGroupInformation;
    private final IdentityTransformerInterface identityTransformer;
    private final AbfsPerfTracker abfsPerfTracker;
    private final AbfsCounters abfsCounters;
    private Set<String> appendBlobDirSet;
    private DataBlocks.BlockFactory blockFactory;
    private int blockOutputActiveBlocks;
    private ExecutorService boundedThreadPool;
    private BackReference fsBackRef;

    public AzureBlobFileSystemStore(AzureBlobFileSystemStoreBuilder abfsStoreBuilder) throws IOException {
        this.uri = abfsStoreBuilder.uri;
        String[] authorityParts = this.authorityParts(this.uri);
        String fileSystemName = authorityParts[0];
        String accountName = authorityParts[1];
        this.fsBackRef = abfsStoreBuilder.fsBackRef;
        this.leaseRefs = Collections.synchronizedMap(new WeakHashMap());
        try {
            this.abfsConfiguration = new AbfsConfiguration(abfsStoreBuilder.configuration, accountName);
        }
        catch (IllegalAccessException exception) {
            throw new FileSystemOperationUnhandledException(exception);
        }
        LOG.trace("AbfsConfiguration init complete");
        this.isNamespaceEnabled = this.abfsConfiguration.getIsNamespaceEnabledAccount();
        this.userGroupInformation = UserGroupInformation.getCurrentUser();
        this.userName = this.userGroupInformation.getShortUserName();
        LOG.trace("UGI init complete");
        if (!this.abfsConfiguration.getSkipUserGroupMetadataDuringInitialization()) {
            try {
                this.primaryUserGroup = this.userGroupInformation.getPrimaryGroupName();
            }
            catch (IOException ex) {
                LOG.error("Failed to get primary group for {}, using user name as primary group name", (Object)this.userName);
                this.primaryUserGroup = this.userName;
            }
        } else {
            this.primaryUserGroup = this.userName;
        }
        LOG.trace("primaryUserGroup is {}", (Object)this.primaryUserGroup);
        this.azureAtomicRenameDirSet = new HashSet<String>(Arrays.asList(this.abfsConfiguration.getAzureAtomicRenameDirs().split(",")));
        this.updateInfiniteLeaseDirs();
        this.authType = this.abfsConfiguration.getAuthType(accountName);
        boolean usingOauth = this.authType == AuthType.OAuth;
        boolean useHttps = usingOauth || this.abfsConfiguration.isHttpsAlwaysUsed() ? true : abfsStoreBuilder.isSecureScheme;
        this.abfsPerfTracker = new AbfsPerfTracker(fileSystemName, accountName, this.abfsConfiguration);
        this.abfsCounters = abfsStoreBuilder.abfsCounters;
        this.initializeClient(this.uri, fileSystemName, accountName, useHttps);
        Class identityTransformerClass = abfsStoreBuilder.configuration.getClass("fs.azure.identity.transformer.class", IdentityTransformer.class, IdentityTransformerInterface.class);
        try {
            this.identityTransformer = (IdentityTransformerInterface)identityTransformerClass.getConstructor(Configuration.class).newInstance(abfsStoreBuilder.configuration);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new IOException(e);
        }
        LOG.trace("IdentityTransformer init complete");
        String appendBlobDirs = this.abfsConfiguration.getAppendBlobDirs();
        this.appendBlobDirSet = appendBlobDirs.trim().isEmpty() ? new HashSet<String>() : new HashSet<String>(Arrays.asList(this.abfsConfiguration.getAppendBlobDirs().split(",")));
        this.blockFactory = abfsStoreBuilder.blockFactory;
        this.blockOutputActiveBlocks = abfsStoreBuilder.blockOutputActiveBlocks;
        this.boundedThreadPool = BlockingThreadPoolExecutorService.newInstance((int)this.abfsConfiguration.getWriteMaxConcurrentRequestCount(), (int)this.abfsConfiguration.getMaxWriteRequestsToQueue(), (long)10L, (TimeUnit)TimeUnit.SECONDS, (String)"abfs-bounded");
    }

    public boolean isAppendBlobKey(String key) {
        return this.isKeyForDirectorySet(key, this.appendBlobDirSet);
    }

    public String getUser() {
        return this.userName;
    }

    public String getPrimaryGroup() {
        return this.primaryUserGroup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void close() throws IOException {
        ArrayList futures = new ArrayList();
        for (AbfsLease lease : this.leaseRefs.keySet()) {
            if (lease == null) continue;
            ListenableFuture<?> future = this.client.submit(() -> lease.free());
            futures.add(future);
        }
        try {
            Futures.allAsList(futures).get();
            HadoopExecutors.shutdown((ExecutorService)this.boundedThreadPool, (Logger)LOG, (long)30L, (TimeUnit)TimeUnit.SECONDS);
            this.boundedThreadPool = null;
        }
        catch (InterruptedException e) {
            LOG.error("Interrupted freeing leases", (Throwable)e);
            Thread.currentThread().interrupt();
            IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{this.client});
        }
        catch (ExecutionException e2) {
            LOG.error("Error freeing leases", (Throwable)e2);
            {
                catch (Throwable throwable) {
                    IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{this.client});
                    throw throwable;
                }
            }
            IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{this.client});
        }
        IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{this.client});
    }

    byte[] encodeAttribute(String value) throws UnsupportedEncodingException {
        return value.getBytes(XMS_PROPERTIES_ENCODING);
    }

    String decodeAttribute(byte[] value) throws UnsupportedEncodingException {
        return new String(value, XMS_PROPERTIES_ENCODING);
    }

    private String[] authorityParts(URI uri) throws InvalidUriAuthorityException, InvalidUriException {
        String authority = uri.getRawAuthority();
        if (null == authority) {
            throw new InvalidUriAuthorityException(uri.toString());
        }
        if (!authority.contains("@")) {
            throw new InvalidUriAuthorityException(uri.toString());
        }
        String[] authorityParts = authority.split("@", 2);
        if (authorityParts.length < 2 || authorityParts[0] != null && authorityParts[0].isEmpty()) {
            String errMsg = String.format("'%s' has a malformed authority, expected container name. Authority takes the form abfs://[<container name>@]<account name>", uri.toString());
            throw new InvalidUriException(errMsg);
        }
        return authorityParts;
    }

    public boolean getIsNamespaceEnabled(TracingContext tracingContext) throws AzureBlobFileSystemException {
        try {
            return this.isNamespaceEnabled.toBoolean();
        }
        catch (TrileanConversionException e) {
            LOG.debug("isNamespaceEnabled is UNKNOWN; fall back and determine through getAcl server call", (Throwable)e);
            LOG.debug("Get root ACL status");
            try (AbfsPerfInfo perfInfo = this.startTracking("getIsNamespaceEnabled", "getAclStatus");){
                AbfsRestOperation op = this.client.getAclStatus("/", tracingContext);
                perfInfo.registerResult(op.getResult());
                this.isNamespaceEnabled = Trilean.getTrilean(true);
                perfInfo.registerSuccess(true);
            }
            catch (AbfsRestOperationException ex) {
                if (400 != ex.getStatusCode()) {
                    throw ex;
                }
                this.isNamespaceEnabled = Trilean.getTrilean(false);
            }
            return this.isNamespaceEnabled.toBoolean();
        }
    }

    @VisibleForTesting
    URIBuilder getURIBuilder(String hostName, boolean isSecure) {
        String scheme = isSecure ? "https" : "http";
        URIBuilder uriBuilder = new URIBuilder();
        uriBuilder.setScheme(scheme);
        String endPoint = this.abfsConfiguration.get("fs.azure.abfs.endpoint");
        if (endPoint == null || !endPoint.contains(":")) {
            uriBuilder.setHost(hostName);
            return uriBuilder;
        }
        String[] data = endPoint.split(":");
        if (data.length != 2) {
            throw new RuntimeException(String.format("ABFS endpoint is not set correctly : %s, Do not specify scheme when using {IP}:{PORT}", endPoint));
        }
        uriBuilder.setHost(data[0].trim());
        uriBuilder.setPort(Integer.parseInt(data[1].trim()));
        uriBuilder.setPath("/" + UriUtils.extractAccountNameFromHostName(hostName));
        return uriBuilder;
    }

    public AbfsConfiguration getAbfsConfiguration() {
        return this.abfsConfiguration;
    }

    public Hashtable<String, String> getFilesystemProperties(TracingContext tracingContext) throws AzureBlobFileSystemException {
        try (AbfsPerfInfo perfInfo = this.startTracking("getFilesystemProperties", "getFilesystemProperties");){
            LOG.debug("getFilesystemProperties for filesystem: {}", (Object)this.client.getFileSystem());
            AbfsRestOperation op = this.client.getFilesystemProperties(tracingContext);
            perfInfo.registerResult(op.getResult());
            String xMsProperties = op.getResult().getResponseHeader("x-ms-properties");
            Hashtable<String, String> parsedXmsProperties = this.parseCommaSeparatedXmsProperties(xMsProperties);
            perfInfo.registerSuccess(true);
            Hashtable<String, String> hashtable = parsedXmsProperties;
            return hashtable;
        }
    }

    public void setFilesystemProperties(Hashtable<String, String> properties, TracingContext tracingContext) throws AzureBlobFileSystemException {
        if (properties == null || properties.isEmpty()) {
            LOG.trace("setFilesystemProperties no properties present");
            return;
        }
        LOG.debug("setFilesystemProperties for filesystem: {} with properties: {}", (Object)this.client.getFileSystem(), properties);
        try (AbfsPerfInfo perfInfo = this.startTracking("setFilesystemProperties", "setFilesystemProperties");){
            String commaSeparatedProperties;
            try {
                commaSeparatedProperties = this.convertXmsPropertiesToCommaSeparatedString(properties);
            }
            catch (CharacterCodingException ex) {
                throw new InvalidAbfsRestOperationException(ex);
            }
            AbfsRestOperation op = this.client.setFilesystemProperties(commaSeparatedProperties, tracingContext);
            perfInfo.registerResult(op.getResult()).registerSuccess(true);
        }
    }

    public Hashtable<String, String> getPathStatus(Path path, TracingContext tracingContext) throws AzureBlobFileSystemException {
        try (AbfsPerfInfo perfInfo = this.startTracking("getPathStatus", "getPathStatus");){
            LOG.debug("getPathStatus for filesystem: {} path: {}", (Object)this.client.getFileSystem(), (Object)path);
            AbfsRestOperation op = this.client.getPathStatus(this.getRelativePath(path), true, tracingContext);
            perfInfo.registerResult(op.getResult());
            String xMsProperties = op.getResult().getResponseHeader("x-ms-properties");
            Hashtable<String, String> parsedXmsProperties = this.parseCommaSeparatedXmsProperties(xMsProperties);
            perfInfo.registerSuccess(true);
            Hashtable<String, String> hashtable = parsedXmsProperties;
            return hashtable;
        }
    }

    public void setPathProperties(Path path, Hashtable<String, String> properties, TracingContext tracingContext) throws AzureBlobFileSystemException {
        try (AbfsPerfInfo perfInfo = this.startTracking("setPathProperties", "setPathProperties");){
            String commaSeparatedProperties;
            LOG.debug("setFilesystemProperties for filesystem: {} path: {} with properties: {}", new Object[]{this.client.getFileSystem(), path, properties});
            try {
                commaSeparatedProperties = this.convertXmsPropertiesToCommaSeparatedString(properties);
            }
            catch (CharacterCodingException ex) {
                throw new InvalidAbfsRestOperationException(ex);
            }
            AbfsRestOperation op = this.client.setPathProperties(this.getRelativePath(path), commaSeparatedProperties, tracingContext);
            perfInfo.registerResult(op.getResult()).registerSuccess(true);
        }
    }

    public void createFilesystem(TracingContext tracingContext) throws AzureBlobFileSystemException {
        try (AbfsPerfInfo perfInfo = this.startTracking("createFilesystem", "createFilesystem");){
            LOG.debug("createFilesystem for filesystem: {}", (Object)this.client.getFileSystem());
            AbfsRestOperation op = this.client.createFilesystem(tracingContext);
            perfInfo.registerResult(op.getResult()).registerSuccess(true);
        }
    }

    public void deleteFilesystem(TracingContext tracingContext) throws AzureBlobFileSystemException {
        try (AbfsPerfInfo perfInfo = this.startTracking("deleteFilesystem", "deleteFilesystem");){
            LOG.debug("deleteFilesystem for filesystem: {}", (Object)this.client.getFileSystem());
            AbfsRestOperation op = this.client.deleteFilesystem(tracingContext);
            perfInfo.registerResult(op.getResult()).registerSuccess(true);
        }
    }

    public OutputStream createFile(Path path, FileSystem.Statistics statistics, boolean overwrite, FsPermission permission, FsPermission umask, TracingContext tracingContext) throws IOException {
        try (AbfsPerfInfo perfInfo = this.startTracking("createFile", "createPath");){
            boolean isNamespaceEnabled = this.getIsNamespaceEnabled(tracingContext);
            LOG.debug("createFile filesystem: {} path: {} overwrite: {} permission: {} umask: {} isNamespaceEnabled: {}", new Object[]{this.client.getFileSystem(), path, overwrite, permission, umask, isNamespaceEnabled});
            String relativePath = this.getRelativePath(path);
            boolean isAppendBlob = false;
            if (this.isAppendBlobKey(path.toString())) {
                isAppendBlob = true;
            }
            boolean triggerConditionalCreateOverwrite = false;
            if (overwrite && this.abfsConfiguration.isConditionalCreateOverwriteEnabled()) {
                triggerConditionalCreateOverwrite = true;
            }
            AbfsRestOperation op = triggerConditionalCreateOverwrite ? this.conditionalCreateOverwriteFile(relativePath, statistics, isNamespaceEnabled ? this.getOctalNotation(permission) : null, isNamespaceEnabled ? this.getOctalNotation(umask) : null, isAppendBlob, tracingContext) : this.client.createPath(relativePath, true, overwrite, isNamespaceEnabled ? this.getOctalNotation(permission) : null, isNamespaceEnabled ? this.getOctalNotation(umask) : null, isAppendBlob, null, tracingContext);
            perfInfo.registerResult(op.getResult()).registerSuccess(true);
            AbfsLease lease = this.maybeCreateLease(relativePath, tracingContext);
            AbfsOutputStream abfsOutputStream = new AbfsOutputStream(this.populateAbfsOutputStreamContext(isAppendBlob, lease, this.client, statistics, relativePath, 0L, tracingContext));
            return abfsOutputStream;
        }
    }

    private AbfsRestOperation conditionalCreateOverwriteFile(String relativePath, FileSystem.Statistics statistics, String permission, String umask, boolean isAppendBlob, TracingContext tracingContext) throws AzureBlobFileSystemException {
        AbfsRestOperation op;
        try {
            op = this.client.createPath(relativePath, true, false, permission, umask, isAppendBlob, null, tracingContext);
        }
        catch (AbfsRestOperationException e) {
            if (e.getStatusCode() == 409) {
                try {
                    op = this.client.getPathStatus(relativePath, false, tracingContext);
                }
                catch (AbfsRestOperationException ex) {
                    if (ex.getStatusCode() == 404) {
                        throw new ConcurrentWriteOperationDetectedException("Parallel access to the create path detected. Failing request to honor single writer semantics");
                    }
                    throw ex;
                }
                String eTag = op.getResult().getResponseHeader("ETag");
                try {
                    op = this.client.createPath(relativePath, true, true, permission, umask, isAppendBlob, eTag, tracingContext);
                }
                catch (AbfsRestOperationException ex) {
                    if (ex.getStatusCode() == 412) {
                        throw new ConcurrentWriteOperationDetectedException("Parallel access to the create path detected. Failing request to honor single writer semantics");
                    }
                    throw ex;
                }
            }
            throw e;
        }
        return op;
    }

    private AbfsOutputStreamContext populateAbfsOutputStreamContext(boolean isAppendBlob, AbfsLease lease, AbfsClient client, FileSystem.Statistics statistics, String path, long position, TracingContext tracingContext) {
        int bufferSize = this.abfsConfiguration.getWriteBufferSize();
        if (isAppendBlob && bufferSize > 0x400000) {
            bufferSize = 0x400000;
        }
        return new AbfsOutputStreamContext(this.abfsConfiguration.getSasTokenRenewPeriodForStreamsInSeconds()).withWriteBufferSize(bufferSize).enableExpectHeader(this.abfsConfiguration.isExpectHeaderEnabled()).enableFlush(this.abfsConfiguration.isFlushEnabled()).enableSmallWriteOptimization(this.abfsConfiguration.isSmallWriteOptimizationEnabled()).disableOutputStreamFlush(this.abfsConfiguration.isOutputStreamFlushDisabled()).withStreamStatistics(new AbfsOutputStreamStatisticsImpl()).withAppendBlob(isAppendBlob).withWriteMaxConcurrentRequestCount(this.abfsConfiguration.getWriteMaxConcurrentRequestCount()).withMaxWriteRequestsToQueue(this.abfsConfiguration.getMaxWriteRequestsToQueue()).withLease(lease).withBlockFactory(this.blockFactory).withBlockOutputActiveBlocks(this.blockOutputActiveBlocks).withClient(client).withPosition(position).withFsStatistics(statistics).withPath(path).withExecutorService((ExecutorService)new SemaphoredDelegatingExecutor(this.boundedThreadPool, this.blockOutputActiveBlocks, true)).withTracingContext(tracingContext).withAbfsBackRef(this.fsBackRef).build();
    }

    public void createDirectory(Path path, FsPermission permission, FsPermission umask, TracingContext tracingContext) throws AzureBlobFileSystemException {
        try (AbfsPerfInfo perfInfo = this.startTracking("createDirectory", "createPath");){
            boolean isNamespaceEnabled = this.getIsNamespaceEnabled(tracingContext);
            LOG.debug("createDirectory filesystem: {} path: {} permission: {} umask: {} isNamespaceEnabled: {}", new Object[]{this.client.getFileSystem(), path, permission, umask, isNamespaceEnabled});
            boolean overwrite = !isNamespaceEnabled || this.abfsConfiguration.isEnabledMkdirOverwrite();
            AbfsRestOperation op = this.client.createPath(this.getRelativePath(path), false, overwrite, isNamespaceEnabled ? this.getOctalNotation(permission) : null, isNamespaceEnabled ? this.getOctalNotation(umask) : null, false, null, tracingContext);
            perfInfo.registerResult(op.getResult()).registerSuccess(true);
        }
    }

    public AbfsInputStream openFileForRead(Path path, FileSystem.Statistics statistics, TracingContext tracingContext) throws IOException {
        return this.openFileForRead(path, Optional.empty(), statistics, tracingContext);
    }

    public AbfsInputStream openFileForRead(Path path, Optional<OpenFileParameters> parameters, FileSystem.Statistics statistics, TracingContext tracingContext) throws IOException {
        try (AbfsPerfInfo perfInfo = this.startTracking("openFileForRead", "getPathStatus");){
            String eTag;
            long contentLength;
            String resourceType;
            LOG.debug("openFileForRead filesystem: {} path: {}", (Object)this.client.getFileSystem(), (Object)path);
            FileStatus fileStatus = parameters.map(OpenFileParameters::getStatus).orElse(null);
            String relativePath = this.getRelativePath(path);
            if (fileStatus instanceof VersionedFileStatus) {
                path = path.makeQualified(this.uri, path);
                Preconditions.checkArgument((boolean)fileStatus.getPath().equals((Object)path), (Object)String.format("Filestatus path [%s] does not match with given path [%s]", fileStatus.getPath(), path));
                resourceType = fileStatus.isFile() ? "file" : "directory";
                contentLength = fileStatus.getLen();
                eTag = ((VersionedFileStatus)fileStatus).getVersion();
            } else {
                if (fileStatus != null) {
                    LOG.debug("Fallback to getPathStatus REST call as provided filestatus is not of type VersionedFileStatus");
                }
                AbfsHttpOperation op = this.client.getPathStatus(relativePath, false, tracingContext).getResult();
                resourceType = op.getResponseHeader("x-ms-resource-type");
                contentLength = Long.parseLong(op.getResponseHeader("Content-Length"));
                eTag = op.getResponseHeader("ETag");
            }
            if (this.parseIsDirectory(resourceType)) {
                throw new AbfsRestOperationException(AzureServiceErrorCode.PATH_NOT_FOUND.getStatusCode(), AzureServiceErrorCode.PATH_NOT_FOUND.getErrorCode(), "openFileForRead must be used with files and not directories", null);
            }
            perfInfo.registerSuccess(true);
            AbfsInputStream abfsInputStream = new AbfsInputStream(this.client, statistics, relativePath, contentLength, this.populateAbfsInputStreamContext(parameters.map(OpenFileParameters::getOptions)), eTag, tracingContext);
            return abfsInputStream;
        }
    }

    private AbfsInputStreamContext populateAbfsInputStreamContext(Optional<Configuration> options) {
        boolean bufferedPreadDisabled = options.map(c -> c.getBoolean("fs.azure.buffered.pread.disable", false)).orElse(false);
        return new AbfsInputStreamContext(this.abfsConfiguration.getSasTokenRenewPeriodForStreamsInSeconds()).withReadBufferSize(this.abfsConfiguration.getReadBufferSize()).withReadAheadQueueDepth(this.abfsConfiguration.getReadAheadQueueDepth()).withTolerateOobAppends(this.abfsConfiguration.getTolerateOobAppends()).isReadAheadEnabled(this.abfsConfiguration.isReadAheadEnabled()).withReadSmallFilesCompletely(this.abfsConfiguration.readSmallFilesCompletely()).withOptimizeFooterRead(this.abfsConfiguration.optimizeFooterRead()).withReadAheadRange(this.abfsConfiguration.getReadAheadRange()).withStreamStatistics(new AbfsInputStreamStatisticsImpl()).withShouldReadBufferSizeAlways(this.abfsConfiguration.shouldReadBufferSizeAlways()).withReadAheadBlockSize(this.abfsConfiguration.getReadAheadBlockSize()).withBufferedPreadDisabled(bufferedPreadDisabled).withAbfsBackRef(this.fsBackRef).build();
    }

    public OutputStream openFileForWrite(Path path, FileSystem.Statistics statistics, boolean overwrite, TracingContext tracingContext) throws IOException {
        try (AbfsPerfInfo perfInfo = this.startTracking("openFileForWrite", "getPathStatus");){
            LOG.debug("openFileForWrite filesystem: {} path: {} overwrite: {}", new Object[]{this.client.getFileSystem(), path, overwrite});
            String relativePath = this.getRelativePath(path);
            AbfsRestOperation op = this.client.getPathStatus(relativePath, false, tracingContext);
            perfInfo.registerResult(op.getResult());
            String resourceType = op.getResult().getResponseHeader("x-ms-resource-type");
            Long contentLength = Long.valueOf(op.getResult().getResponseHeader("Content-Length"));
            if (this.parseIsDirectory(resourceType)) {
                throw new AbfsRestOperationException(AzureServiceErrorCode.PATH_NOT_FOUND.getStatusCode(), AzureServiceErrorCode.PATH_NOT_FOUND.getErrorCode(), "openFileForRead must be used with files and not directories", null);
            }
            long offset = overwrite ? 0L : contentLength;
            perfInfo.registerSuccess(true);
            boolean isAppendBlob = false;
            if (this.isAppendBlobKey(path.toString())) {
                isAppendBlob = true;
            }
            AbfsLease lease = this.maybeCreateLease(relativePath, tracingContext);
            AbfsOutputStream abfsOutputStream = new AbfsOutputStream(this.populateAbfsOutputStreamContext(isAppendBlob, lease, this.client, statistics, relativePath, offset, tracingContext));
            return abfsOutputStream;
        }
    }

    public void breakLease(Path path, TracingContext tracingContext) throws AzureBlobFileSystemException {
        LOG.debug("lease path: {}", (Object)path);
        this.client.breakLease(this.getRelativePath(path), tracingContext);
    }

    public boolean rename(Path source, Path destination, TracingContext tracingContext, String sourceEtag) throws AzureBlobFileSystemException {
        boolean shouldContinue;
        Instant startAggregate = this.abfsPerfTracker.getLatencyInstant();
        long countAggregate = 0L;
        if (this.isAtomicRenameKey(source.getName())) {
            LOG.warn("The atomic rename feature is not supported by the ABFS scheme; however rename, create and delete operations are atomic if Namespace is enabled for your Azure Storage account.");
        }
        LOG.debug("renameAsync filesystem: {} source: {} destination: {}", new Object[]{this.client.getFileSystem(), source, destination});
        String continuation = null;
        String sourceRelativePath = this.getRelativePath(source);
        String destinationRelativePath = this.getRelativePath(destination);
        boolean recovered = false;
        do {
            try (AbfsPerfInfo perfInfo = this.startTracking("rename", "renamePath");){
                boolean isNamespaceEnabled = this.getIsNamespaceEnabled(tracingContext);
                AbfsClientRenameResult abfsClientRenameResult = this.client.renamePath(sourceRelativePath, destinationRelativePath, continuation, tracingContext, sourceEtag, false, isNamespaceEnabled);
                AbfsRestOperation op = abfsClientRenameResult.getOp();
                perfInfo.registerResult(op.getResult());
                continuation = op.getResult().getResponseHeader("x-ms-continuation");
                perfInfo.registerSuccess(true);
                ++countAggregate;
                shouldContinue = continuation != null && !continuation.isEmpty();
                recovered |= abfsClientRenameResult.isRenameRecovered();
                this.populateRenameRecoveryStatistics(abfsClientRenameResult);
                if (shouldContinue) continue;
                perfInfo.registerAggregates(startAggregate, countAggregate);
            }
        } while (shouldContinue);
        return recovered;
    }

    public void delete(Path path, boolean recursive, TracingContext tracingContext) throws AzureBlobFileSystemException {
        Instant startAggregate = this.abfsPerfTracker.getLatencyInstant();
        long countAggregate = 0L;
        boolean shouldContinue = true;
        LOG.debug("delete filesystem: {} path: {} recursive: {}", new Object[]{this.client.getFileSystem(), path, String.valueOf(recursive)});
        String continuation = null;
        String relativePath = this.getRelativePath(path);
        do {
            try (AbfsPerfInfo perfInfo = this.startTracking("delete", "deletePath");){
                AbfsRestOperation op = this.client.deletePath(relativePath, recursive, continuation, tracingContext);
                perfInfo.registerResult(op.getResult());
                continuation = op.getResult().getResponseHeader("x-ms-continuation");
                perfInfo.registerSuccess(true);
                ++countAggregate;
                boolean bl = shouldContinue = continuation != null && !continuation.isEmpty();
                if (shouldContinue) continue;
                perfInfo.registerAggregates(startAggregate, countAggregate);
            }
        } while (shouldContinue);
    }

    public FileStatus getFileStatus(Path path, TracingContext tracingContext) throws IOException {
        try (AbfsPerfInfo perfInfo = this.startTracking("getFileStatus", "undetermined");){
            boolean resourceIsDir;
            long contentLength;
            AbfsRestOperation op;
            boolean isNamespaceEnabled = this.getIsNamespaceEnabled(tracingContext);
            LOG.debug("getFileStatus filesystem: {} path: {} isNamespaceEnabled: {}", new Object[]{this.client.getFileSystem(), path, isNamespaceEnabled});
            if (path.isRoot()) {
                if (isNamespaceEnabled) {
                    perfInfo.registerCallee("getAclStatus");
                    op = this.client.getAclStatus(this.getRelativePath(path), tracingContext);
                } else {
                    perfInfo.registerCallee("getFilesystemProperties");
                    op = this.client.getFilesystemProperties(tracingContext);
                }
            } else {
                perfInfo.registerCallee("getPathStatus");
                op = this.client.getPathStatus(this.getRelativePath(path), false, tracingContext);
            }
            perfInfo.registerResult(op.getResult());
            long blockSize = this.abfsConfiguration.getAzureBlockSize();
            AbfsHttpOperation result = op.getResult();
            String eTag = AzureBlobFileSystemStore.extractEtagHeader(result);
            String lastModified = result.getResponseHeader("Last-Modified");
            String permissions = result.getResponseHeader("x-ms-permissions");
            boolean hasAcl = AbfsPermission.isExtendedAcl(permissions);
            if (path.isRoot()) {
                contentLength = 0L;
                resourceIsDir = true;
            } else {
                contentLength = this.parseContentLength(result.getResponseHeader("Content-Length"));
                resourceIsDir = this.parseIsDirectory(result.getResponseHeader("x-ms-resource-type"));
            }
            String transformedOwner = this.identityTransformer.transformIdentityForGetRequest(result.getResponseHeader("x-ms-owner"), true, this.userName);
            String transformedGroup = this.identityTransformer.transformIdentityForGetRequest(result.getResponseHeader("x-ms-group"), false, this.primaryUserGroup);
            perfInfo.registerSuccess(true);
            VersionedFileStatus versionedFileStatus = new VersionedFileStatus(transformedOwner, transformedGroup, permissions == null ? new AbfsPermission(FsAction.ALL, FsAction.ALL, FsAction.ALL) : AbfsPermission.valueOf(permissions), hasAcl, contentLength, resourceIsDir, 1, blockSize, DateTimeUtils.parseLastModifiedTime(lastModified), path, eTag);
            return versionedFileStatus;
        }
    }

    @Override
    public FileStatus[] listStatus(Path path, TracingContext tracingContext) throws IOException {
        return this.listStatus(path, null, tracingContext);
    }

    @Override
    @InterfaceStability.Unstable
    public FileStatus[] listStatus(Path path, String startFrom, TracingContext tracingContext) throws IOException {
        ArrayList<FileStatus> fileStatuses = new ArrayList<FileStatus>();
        this.listStatus(path, startFrom, fileStatuses, true, null, tracingContext);
        return fileStatuses.toArray(new FileStatus[fileStatuses.size()]);
    }

    @Override
    public String listStatus(Path path, String startFrom, List<FileStatus> fileStatuses, boolean fetchAll, String continuation, TracingContext tracingContext) throws IOException {
        Instant startAggregate = this.abfsPerfTracker.getLatencyInstant();
        long countAggregate = 0L;
        boolean shouldContinue = true;
        LOG.debug("listStatus filesystem: {} path: {}, startFrom: {}", new Object[]{this.client.getFileSystem(), path, startFrom});
        String relativePath = this.getRelativePath(path);
        if ((continuation == null || continuation.isEmpty()) && startFrom != null && !startFrom.isEmpty()) {
            continuation = this.getIsNamespaceEnabled(tracingContext) ? this.generateContinuationTokenForXns(startFrom) : this.generateContinuationTokenForNonXns(relativePath, startFrom);
        }
        do {
            try (AbfsPerfInfo perfInfo = this.startTracking("listStatus", "listPath");){
                AbfsRestOperation op = this.client.listPath(relativePath, false, this.abfsConfiguration.getListMaxResults(), continuation, tracingContext);
                perfInfo.registerResult(op.getResult());
                continuation = op.getResult().getResponseHeader("x-ms-continuation");
                ListResultSchema retrievedSchema = op.getResult().getListResultSchema();
                if (retrievedSchema == null) {
                    throw new AbfsRestOperationException(AzureServiceErrorCode.PATH_NOT_FOUND.getStatusCode(), AzureServiceErrorCode.PATH_NOT_FOUND.getErrorCode(), "listStatusAsync path not found", null, op.getResult());
                }
                long blockSize = this.abfsConfiguration.getAzureBlockSize();
                for (ListResultEntrySchema entry : retrievedSchema.paths()) {
                    boolean isDirectory;
                    String owner = this.identityTransformer.transformIdentityForGetRequest(entry.owner(), true, this.userName);
                    String group = this.identityTransformer.transformIdentityForGetRequest(entry.group(), false, this.primaryUserGroup);
                    AbfsPermission fsPermission = entry.permissions() == null ? new AbfsPermission(FsAction.ALL, FsAction.ALL, FsAction.ALL) : AbfsPermission.valueOf(entry.permissions());
                    boolean hasAcl = AbfsPermission.isExtendedAcl(entry.permissions());
                    long lastModifiedMillis = 0L;
                    long contentLength = entry.contentLength() == null ? 0L : entry.contentLength();
                    boolean bl = isDirectory = entry.isDirectory() == null ? false : entry.isDirectory();
                    if (entry.lastModified() != null && !entry.lastModified().isEmpty()) {
                        lastModifiedMillis = DateTimeUtils.parseLastModifiedTime(entry.lastModified());
                    }
                    Path entryPath = new Path(File.separator + entry.name());
                    entryPath = entryPath.makeQualified(this.uri, entryPath);
                    fileStatuses.add(new VersionedFileStatus(owner, group, fsPermission, hasAcl, contentLength, isDirectory, 1, blockSize, lastModifiedMillis, entryPath, entry.eTag()));
                }
                perfInfo.registerSuccess(true);
                ++countAggregate;
                boolean bl = shouldContinue = fetchAll && continuation != null && !continuation.isEmpty();
                if (shouldContinue) continue;
                perfInfo.registerAggregates(startAggregate, countAggregate);
            }
        } while (shouldContinue);
        return continuation;
    }

    private String generateContinuationTokenForXns(String firstEntryName) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)firstEntryName) && !firstEntryName.startsWith("/") ? 1 : 0) != 0, (Object)"startFrom must be a dir/file name and it can not be a full path");
        StringBuilder sb = new StringBuilder();
        sb.append(firstEntryName).append("#$").append("0");
        CRC64 crc64 = new CRC64();
        StringBuilder token = new StringBuilder();
        token.append(crc64.compute(sb.toString().getBytes(StandardCharsets.UTF_8))).append(" ").append("0").append(" ").append(firstEntryName);
        return Base64.encode(token.toString().getBytes(StandardCharsets.UTF_8));
    }

    private String generateContinuationTokenForNonXns(String path, String firstEntryName) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)firstEntryName) && !firstEntryName.startsWith("/") ? 1 : 0) != 0, (Object)"startFrom must be a dir/file name and it can not be a full path");
        path = AbfsClient.getDirectoryQueryParameter(path);
        String startFrom = path.isEmpty() || path.equals("/") ? firstEntryName : path + "/" + firstEntryName;
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(TOKEN_DATE_PATTERN, Locale.US);
        String date = simpleDateFormat.format(new Date());
        String token = String.format("%06d!%s!%06d!%s!%06d!%s!", path.length(), path, startFrom.length(), startFrom, date.length(), date);
        String base64EncodedToken = Base64.encode(token.getBytes(StandardCharsets.UTF_8));
        StringBuilder encodedTokenBuilder = new StringBuilder(base64EncodedToken.length() + 5);
        encodedTokenBuilder.append(String.format("%s!%d!", "2", base64EncodedToken.length()));
        for (int i = 0; i < base64EncodedToken.length(); ++i) {
            int current = base64EncodedToken.charAt(i);
            if (47 == current) {
                current = 95;
            } else if (43 == current) {
                current = 42;
            } else if (61 == current) {
                current = 45;
            }
            encodedTokenBuilder.append((char)current);
        }
        return encodedTokenBuilder.toString();
    }

    public void setOwner(Path path, String owner, String group, TracingContext tracingContext) throws AzureBlobFileSystemException {
        if (!this.getIsNamespaceEnabled(tracingContext)) {
            throw new UnsupportedOperationException("This operation is only valid for storage accounts with the hierarchical namespace enabled.");
        }
        try (AbfsPerfInfo perfInfo = this.startTracking("setOwner", "setOwner");){
            LOG.debug("setOwner filesystem: {} path: {} owner: {} group: {}", new Object[]{this.client.getFileSystem(), path, owner, group});
            String transformedOwner = this.identityTransformer.transformUserOrGroupForSetRequest(owner);
            String transformedGroup = this.identityTransformer.transformUserOrGroupForSetRequest(group);
            AbfsRestOperation op = this.client.setOwner(this.getRelativePath(path), transformedOwner, transformedGroup, tracingContext);
            perfInfo.registerResult(op.getResult()).registerSuccess(true);
        }
    }

    public void setPermission(Path path, FsPermission permission, TracingContext tracingContext) throws AzureBlobFileSystemException {
        if (!this.getIsNamespaceEnabled(tracingContext)) {
            throw new UnsupportedOperationException("This operation is only valid for storage accounts with the hierarchical namespace enabled.");
        }
        try (AbfsPerfInfo perfInfo = this.startTracking("setPermission", "setPermission");){
            LOG.debug("setPermission filesystem: {} path: {} permission: {}", new Object[]{this.client.getFileSystem(), path, permission});
            AbfsRestOperation op = this.client.setPermission(this.getRelativePath(path), String.format("%04d", permission.toOctal()), tracingContext);
            perfInfo.registerResult(op.getResult()).registerSuccess(true);
        }
    }

    public void modifyAclEntries(Path path, List<AclEntry> aclSpec, TracingContext tracingContext) throws AzureBlobFileSystemException {
        if (!this.getIsNamespaceEnabled(tracingContext)) {
            throw new UnsupportedOperationException("This operation is only valid for storage accounts with the hierarchical namespace enabled.");
        }
        try (AbfsPerfInfo perfInfoGet = this.startTracking("modifyAclEntries", "getAclStatus");){
            LOG.debug("modifyAclEntries filesystem: {} path: {} aclSpec: {}", new Object[]{this.client.getFileSystem(), path, AclEntry.aclSpecToString(aclSpec)});
            this.identityTransformer.transformAclEntriesForSetRequest(aclSpec);
            Map<String, String> modifyAclEntries = AbfsAclHelper.deserializeAclSpec(AclEntry.aclSpecToString(aclSpec));
            boolean useUpn = AbfsAclHelper.isUpnFormatAclEntries(modifyAclEntries);
            String relativePath = this.getRelativePath(path);
            AbfsRestOperation op = this.client.getAclStatus(relativePath, useUpn, tracingContext);
            perfInfoGet.registerResult(op.getResult());
            String eTag = op.getResult().getResponseHeader("ETag");
            Map<String, String> aclEntries = AbfsAclHelper.deserializeAclSpec(op.getResult().getResponseHeader("x-ms-acl"));
            AbfsAclHelper.modifyAclEntriesInternal(aclEntries, modifyAclEntries);
            perfInfoGet.registerSuccess(true).finishTracking();
            try (AbfsPerfInfo perfInfoSet = this.startTracking("modifyAclEntries", "setAcl");){
                AbfsRestOperation setAclOp = this.client.setAcl(relativePath, AbfsAclHelper.serializeAclSpec(aclEntries), eTag, tracingContext);
                perfInfoSet.registerResult(setAclOp.getResult()).registerSuccess(true).registerAggregates(perfInfoGet.getTrackingStart(), 2L);
            }
        }
    }

    public void removeAclEntries(Path path, List<AclEntry> aclSpec, TracingContext tracingContext) throws AzureBlobFileSystemException {
        if (!this.getIsNamespaceEnabled(tracingContext)) {
            throw new UnsupportedOperationException("This operation is only valid for storage accounts with the hierarchical namespace enabled.");
        }
        try (AbfsPerfInfo perfInfoGet = this.startTracking("removeAclEntries", "getAclStatus");){
            LOG.debug("removeAclEntries filesystem: {} path: {} aclSpec: {}", new Object[]{this.client.getFileSystem(), path, AclEntry.aclSpecToString(aclSpec)});
            this.identityTransformer.transformAclEntriesForSetRequest(aclSpec);
            Map<String, String> removeAclEntries = AbfsAclHelper.deserializeAclSpec(AclEntry.aclSpecToString(aclSpec));
            boolean isUpnFormat = AbfsAclHelper.isUpnFormatAclEntries(removeAclEntries);
            String relativePath = this.getRelativePath(path);
            AbfsRestOperation op = this.client.getAclStatus(relativePath, isUpnFormat, tracingContext);
            perfInfoGet.registerResult(op.getResult());
            String eTag = op.getResult().getResponseHeader("ETag");
            Map<String, String> aclEntries = AbfsAclHelper.deserializeAclSpec(op.getResult().getResponseHeader("x-ms-acl"));
            AbfsAclHelper.removeAclEntriesInternal(aclEntries, removeAclEntries);
            perfInfoGet.registerSuccess(true).finishTracking();
            try (AbfsPerfInfo perfInfoSet = this.startTracking("removeAclEntries", "setAcl");){
                AbfsRestOperation setAclOp = this.client.setAcl(relativePath, AbfsAclHelper.serializeAclSpec(aclEntries), eTag, tracingContext);
                perfInfoSet.registerResult(setAclOp.getResult()).registerSuccess(true).registerAggregates(perfInfoGet.getTrackingStart(), 2L);
            }
        }
    }

    public void removeDefaultAcl(Path path, TracingContext tracingContext) throws AzureBlobFileSystemException {
        if (!this.getIsNamespaceEnabled(tracingContext)) {
            throw new UnsupportedOperationException("This operation is only valid for storage accounts with the hierarchical namespace enabled.");
        }
        try (AbfsPerfInfo perfInfoGet = this.startTracking("removeDefaultAcl", "getAclStatus");){
            LOG.debug("removeDefaultAcl filesystem: {} path: {}", (Object)this.client.getFileSystem(), (Object)path);
            String relativePath = this.getRelativePath(path);
            AbfsRestOperation op = this.client.getAclStatus(relativePath, tracingContext);
            perfInfoGet.registerResult(op.getResult());
            String eTag = op.getResult().getResponseHeader("ETag");
            Map<String, String> aclEntries = AbfsAclHelper.deserializeAclSpec(op.getResult().getResponseHeader("x-ms-acl"));
            HashMap<String, String> defaultAclEntries = new HashMap<String, String>();
            for (Map.Entry<String, String> aclEntry : aclEntries.entrySet()) {
                if (!aclEntry.getKey().startsWith("default:")) continue;
                defaultAclEntries.put(aclEntry.getKey(), aclEntry.getValue());
            }
            aclEntries.keySet().removeAll(defaultAclEntries.keySet());
            perfInfoGet.registerSuccess(true).finishTracking();
            try (AbfsPerfInfo perfInfoSet = this.startTracking("removeDefaultAcl", "setAcl");){
                AbfsRestOperation setAclOp = this.client.setAcl(relativePath, AbfsAclHelper.serializeAclSpec(aclEntries), eTag, tracingContext);
                perfInfoSet.registerResult(setAclOp.getResult()).registerSuccess(true).registerAggregates(perfInfoGet.getTrackingStart(), 2L);
            }
        }
    }

    public void removeAcl(Path path, TracingContext tracingContext) throws AzureBlobFileSystemException {
        if (!this.getIsNamespaceEnabled(tracingContext)) {
            throw new UnsupportedOperationException("This operation is only valid for storage accounts with the hierarchical namespace enabled.");
        }
        try (AbfsPerfInfo perfInfoGet = this.startTracking("removeAcl", "getAclStatus");){
            LOG.debug("removeAcl filesystem: {} path: {}", (Object)this.client.getFileSystem(), (Object)path);
            String relativePath = this.getRelativePath(path);
            AbfsRestOperation op = this.client.getAclStatus(relativePath, tracingContext);
            perfInfoGet.registerResult(op.getResult());
            String eTag = op.getResult().getResponseHeader("ETag");
            Map<String, String> aclEntries = AbfsAclHelper.deserializeAclSpec(op.getResult().getResponseHeader("x-ms-acl"));
            HashMap<String, String> newAclEntries = new HashMap<String, String>();
            newAclEntries.put("user:", aclEntries.get("user:"));
            newAclEntries.put("group:", aclEntries.get("group:"));
            newAclEntries.put("other:", aclEntries.get("other:"));
            perfInfoGet.registerSuccess(true).finishTracking();
            try (AbfsPerfInfo perfInfoSet = this.startTracking("removeAcl", "setAcl");){
                AbfsRestOperation setAclOp = this.client.setAcl(relativePath, AbfsAclHelper.serializeAclSpec(newAclEntries), eTag, tracingContext);
                perfInfoSet.registerResult(setAclOp.getResult()).registerSuccess(true).registerAggregates(perfInfoGet.getTrackingStart(), 2L);
            }
        }
    }

    public void setAcl(Path path, List<AclEntry> aclSpec, TracingContext tracingContext) throws AzureBlobFileSystemException {
        if (!this.getIsNamespaceEnabled(tracingContext)) {
            throw new UnsupportedOperationException("This operation is only valid for storage accounts with the hierarchical namespace enabled.");
        }
        try (AbfsPerfInfo perfInfoGet = this.startTracking("setAcl", "getAclStatus");){
            LOG.debug("setAcl filesystem: {} path: {} aclspec: {}", new Object[]{this.client.getFileSystem(), path, AclEntry.aclSpecToString(aclSpec)});
            this.identityTransformer.transformAclEntriesForSetRequest(aclSpec);
            Map<String, String> aclEntries = AbfsAclHelper.deserializeAclSpec(AclEntry.aclSpecToString(aclSpec));
            boolean isUpnFormat = AbfsAclHelper.isUpnFormatAclEntries(aclEntries);
            String relativePath = this.getRelativePath(path);
            AbfsRestOperation op = this.client.getAclStatus(relativePath, isUpnFormat, tracingContext);
            perfInfoGet.registerResult(op.getResult());
            String eTag = op.getResult().getResponseHeader("ETag");
            Map<String, String> getAclEntries = AbfsAclHelper.deserializeAclSpec(op.getResult().getResponseHeader("x-ms-acl"));
            AbfsAclHelper.setAclEntriesInternal(aclEntries, getAclEntries);
            perfInfoGet.registerSuccess(true).finishTracking();
            try (AbfsPerfInfo perfInfoSet = this.startTracking("setAcl", "setAcl");){
                AbfsRestOperation setAclOp = this.client.setAcl(relativePath, AbfsAclHelper.serializeAclSpec(aclEntries), eTag, tracingContext);
                perfInfoSet.registerResult(setAclOp.getResult()).registerSuccess(true).registerAggregates(perfInfoGet.getTrackingStart(), 2L);
            }
        }
    }

    public AclStatus getAclStatus(Path path, TracingContext tracingContext) throws IOException {
        if (!this.getIsNamespaceEnabled(tracingContext)) {
            throw new UnsupportedOperationException("This operation is only valid for storage accounts with the hierarchical namespace enabled.");
        }
        try (AbfsPerfInfo perfInfo = this.startTracking("getAclStatus", "getAclStatus");){
            LOG.debug("getAclStatus filesystem: {} path: {}", (Object)this.client.getFileSystem(), (Object)path);
            AbfsRestOperation op = this.client.getAclStatus(this.getRelativePath(path), tracingContext);
            AbfsHttpOperation result = op.getResult();
            perfInfo.registerResult(result);
            String transformedOwner = this.identityTransformer.transformIdentityForGetRequest(result.getResponseHeader("x-ms-owner"), true, this.userName);
            String transformedGroup = this.identityTransformer.transformIdentityForGetRequest(result.getResponseHeader("x-ms-group"), false, this.primaryUserGroup);
            String permissions = result.getResponseHeader("x-ms-permissions");
            String aclSpecString = op.getResult().getResponseHeader("x-ms-acl");
            List aclEntries = AclEntry.parseAclSpec((String)AbfsAclHelper.processAclString(aclSpecString), (boolean)true);
            this.identityTransformer.transformAclEntriesForGetRequest(aclEntries, this.userName, this.primaryUserGroup);
            AbfsPermission fsPermission = permissions == null ? new AbfsPermission(FsAction.ALL, FsAction.ALL, FsAction.ALL) : AbfsPermission.valueOf(permissions);
            AclStatus.Builder aclStatusBuilder = new AclStatus.Builder();
            aclStatusBuilder.owner(transformedOwner);
            aclStatusBuilder.group(transformedGroup);
            aclStatusBuilder.setPermission((FsPermission)fsPermission);
            aclStatusBuilder.stickyBit(fsPermission.getStickyBit());
            aclStatusBuilder.addEntries((Iterable)aclEntries);
            perfInfo.registerSuccess(true);
            AclStatus aclStatus = aclStatusBuilder.build();
            return aclStatus;
        }
    }

    public void access(Path path, FsAction mode, TracingContext tracingContext) throws AzureBlobFileSystemException {
        LOG.debug("access for filesystem: {}, path: {}, mode: {}", new Object[]{this.client.getFileSystem(), path, mode});
        if (!this.abfsConfiguration.isCheckAccessEnabled() || !this.getIsNamespaceEnabled(tracingContext)) {
            LOG.debug("Returning; either check access is not enabled or the account used is not namespace enabled");
            return;
        }
        try (AbfsPerfInfo perfInfo = this.startTracking("access", "checkAccess");){
            AbfsRestOperation op = this.client.checkAccess(this.getRelativePath(path), mode.SYMBOL, tracingContext);
            perfInfo.registerResult(op.getResult()).registerSuccess(true);
        }
    }

    public boolean isAtomicRenameKey(String key) {
        return this.isKeyForDirectorySet(key, this.azureAtomicRenameDirSet);
    }

    public boolean isInfiniteLeaseKey(String key) {
        if (this.azureInfiniteLeaseDirSet.isEmpty()) {
            return false;
        }
        return this.isKeyForDirectorySet(key, this.azureInfiniteLeaseDirSet);
    }

    private void initializeClient(URI uri, String fileSystemName, String accountName, boolean isSecure) throws IOException {
        URL baseUrl;
        if (this.client != null) {
            return;
        }
        URIBuilder uriBuilder = this.getURIBuilder(accountName, isSecure);
        String url = uriBuilder.toString() + "/" + fileSystemName;
        try {
            baseUrl = new URL(url);
        }
        catch (MalformedURLException e) {
            throw new InvalidUriException(uri.toString());
        }
        SharedKeyCredentials creds = null;
        AccessTokenProvider tokenProvider = null;
        SASTokenProvider sasTokenProvider = null;
        if (this.authType == AuthType.OAuth) {
            AzureADAuthenticator.init(this.abfsConfiguration);
        }
        if (this.authType == AuthType.SharedKey) {
            LOG.trace("Fetching SharedKey credentials");
            int dotIndex = accountName.indexOf(".");
            if (dotIndex <= 0) {
                throw new InvalidUriException(uri.toString() + " - account name is not fully qualified.");
            }
            creds = new SharedKeyCredentials(accountName.substring(0, dotIndex), this.abfsConfiguration.getStorageAccountKey());
        } else if (this.authType == AuthType.SAS) {
            LOG.trace("Fetching SAS token provider");
            sasTokenProvider = this.abfsConfiguration.getSASTokenProvider();
        } else {
            LOG.trace("Fetching token provider");
            tokenProvider = this.abfsConfiguration.getTokenProvider();
            ExtensionHelper.bind(tokenProvider, uri, this.abfsConfiguration.getRawConfiguration());
        }
        LOG.trace("Initializing AbfsClient for {}", (Object)baseUrl);
        this.client = tokenProvider != null ? new AbfsClient(baseUrl, creds, this.abfsConfiguration, tokenProvider, this.populateAbfsClientContext()) : new AbfsClient(baseUrl, creds, this.abfsConfiguration, sasTokenProvider, this.populateAbfsClientContext());
        LOG.trace("AbfsClient init complete");
    }

    private AbfsClientContext populateAbfsClientContext() {
        return new AbfsClientContextBuilder().withExponentialRetryPolicy(new ExponentialRetryPolicy(this.abfsConfiguration)).withAbfsCounters(this.abfsCounters).withAbfsPerfTracker(this.abfsPerfTracker).build();
    }

    private String getOctalNotation(FsPermission fsPermission) {
        Preconditions.checkNotNull((Object)fsPermission, (Object)"fsPermission");
        return String.format("%04d", fsPermission.toOctal());
    }

    private String getRelativePath(Path path) {
        Preconditions.checkNotNull((Object)path, (Object)"path");
        return path.toUri().getPath();
    }

    private long parseContentLength(String contentLength) {
        if (contentLength == null) {
            return -1L;
        }
        return Long.parseLong(contentLength);
    }

    private boolean parseIsDirectory(String resourceType) {
        return resourceType != null && resourceType.equalsIgnoreCase("directory");
    }

    private String convertXmsPropertiesToCommaSeparatedString(Hashtable<String, String> properties) throws CharacterCodingException {
        StringBuilder commaSeparatedProperties = new StringBuilder();
        CharsetEncoder encoder = Charset.forName(XMS_PROPERTIES_ENCODING).newEncoder();
        for (Map.Entry<String, String> propertyEntry : properties.entrySet()) {
            String key = propertyEntry.getKey();
            String value = propertyEntry.getValue();
            Boolean canEncodeValue = encoder.canEncode(value);
            if (!canEncodeValue.booleanValue()) {
                throw new CharacterCodingException();
            }
            String encodedPropertyValue = Base64.encode(encoder.encode(CharBuffer.wrap(value)).array());
            commaSeparatedProperties.append(key).append("=").append(encodedPropertyValue);
            commaSeparatedProperties.append(",");
        }
        if (commaSeparatedProperties.length() != 0) {
            commaSeparatedProperties.deleteCharAt(commaSeparatedProperties.length() - 1);
        }
        return commaSeparatedProperties.toString();
    }

    private Hashtable<String, String> parseCommaSeparatedXmsProperties(String xMsProperties) throws InvalidFileSystemPropertyException, InvalidAbfsRestOperationException {
        Hashtable<String, String> properties = new Hashtable<String, String>();
        CharsetDecoder decoder = Charset.forName(XMS_PROPERTIES_ENCODING).newDecoder();
        if (xMsProperties != null && !xMsProperties.isEmpty()) {
            String[] userProperties = xMsProperties.split(",");
            if (userProperties.length == 0) {
                return properties;
            }
            for (String property : userProperties) {
                String value;
                if (property.isEmpty()) {
                    throw new InvalidFileSystemPropertyException(xMsProperties);
                }
                String[] nameValue = property.split("=", 2);
                if (nameValue.length != 2) {
                    throw new InvalidFileSystemPropertyException(xMsProperties);
                }
                byte[] decodedValue = Base64.decode(nameValue[1]);
                try {
                    value = decoder.decode(ByteBuffer.wrap(decodedValue)).toString();
                }
                catch (CharacterCodingException ex) {
                    throw new InvalidAbfsRestOperationException(ex);
                }
                properties.put(nameValue[0], value);
            }
        }
        return properties;
    }

    private boolean isKeyForDirectorySet(String key, Set<String> dirSet) {
        for (String dir : dirSet) {
            if (dir.isEmpty() || key.startsWith(dir + "/")) {
                return true;
            }
            try {
                URI uri = new URI(dir);
                if (null != uri.getAuthority() || !key.startsWith(dir + "/")) continue;
                return true;
            }
            catch (URISyntaxException e) {
                LOG.info("URI syntax error creating URI for {}", (Object)dir);
            }
        }
        return false;
    }

    private AbfsPerfInfo startTracking(String callerName, String calleeName) {
        return new AbfsPerfInfo(this.abfsPerfTracker, callerName, calleeName);
    }

    @VisibleForTesting
    public AbfsClient getClient() {
        return this.client;
    }

    @VisibleForTesting
    void setClient(AbfsClient client) {
        this.client = client;
    }

    @VisibleForTesting
    void setNamespaceEnabled(Trilean isNamespaceEnabled) {
        this.isNamespaceEnabled = isNamespaceEnabled;
    }

    private void updateInfiniteLeaseDirs() {
        this.azureInfiniteLeaseDirSet = new HashSet<String>(Arrays.asList(this.abfsConfiguration.getAzureInfiniteLeaseDirs().split(",")));
        this.azureInfiniteLeaseDirSet.remove("");
    }

    private AbfsLease maybeCreateLease(String relativePath, TracingContext tracingContext) throws AzureBlobFileSystemException {
        boolean enableInfiniteLease = this.isInfiniteLeaseKey(relativePath);
        if (!enableInfiniteLease) {
            return null;
        }
        AbfsLease lease = new AbfsLease(this.client, relativePath, tracingContext);
        this.leaseRefs.put(lease, null);
        return lease;
    }

    @VisibleForTesting
    boolean areLeasesFreed() {
        for (AbfsLease lease : this.leaseRefs.keySet()) {
            if (lease == null || lease.isFreed()) continue;
            return false;
        }
        return true;
    }

    public static String extractEtagHeader(AbfsHttpOperation result) {
        String etag = result.getResponseHeader("ETag");
        if (etag != null) {
            if (etag.startsWith("W/\"")) {
                etag = etag.substring(3);
            } else if (etag.startsWith("\"")) {
                etag = etag.substring(1);
            }
            if (etag.endsWith("\"")) {
                etag = etag.substring(0, etag.length() - 1);
            }
        }
        return etag;
    }

    private void populateRenameRecoveryStatistics(AbfsClientRenameResult abfsClientRenameResult) {
        if (abfsClientRenameResult.isRenameRecovered()) {
            this.abfsCounters.incrementCounter(AbfsStatistic.RENAME_RECOVERY, 1L);
        }
        if (abfsClientRenameResult.isIncompleteMetadataState()) {
            this.abfsCounters.incrementCounter(AbfsStatistic.METADATA_INCOMPLETE_RENAME_FAILURES, 1L);
        }
    }

    public static final class AzureBlobFileSystemStoreBuilder {
        private URI uri;
        private boolean isSecureScheme;
        private Configuration configuration;
        private AbfsCounters abfsCounters;
        private DataBlocks.BlockFactory blockFactory;
        private int blockOutputActiveBlocks;
        private BackReference fsBackRef;

        public AzureBlobFileSystemStoreBuilder withUri(URI value) {
            this.uri = value;
            return this;
        }

        public AzureBlobFileSystemStoreBuilder withSecureScheme(boolean value) {
            this.isSecureScheme = value;
            return this;
        }

        public AzureBlobFileSystemStoreBuilder withConfiguration(Configuration value) {
            this.configuration = value;
            return this;
        }

        public AzureBlobFileSystemStoreBuilder withAbfsCounters(AbfsCounters value) {
            this.abfsCounters = value;
            return this;
        }

        public AzureBlobFileSystemStoreBuilder withBlockFactory(DataBlocks.BlockFactory value) {
            this.blockFactory = value;
            return this;
        }

        public AzureBlobFileSystemStoreBuilder withBlockOutputActiveBlocks(int value) {
            this.blockOutputActiveBlocks = value;
            return this;
        }

        public AzureBlobFileSystemStoreBuilder withBackReference(BackReference fsBackRef) {
            this.fsBackRef = fsBackRef;
            return this;
        }

        public AzureBlobFileSystemStoreBuilder build() {
            return this;
        }
    }

    private static final class VersionedFileStatus
    extends FileStatus
    implements EtagSource {
        private static final long serialVersionUID = -2009013240419749458L;
        private String version;

        private VersionedFileStatus(String owner, String group, FsPermission fsPermission, boolean hasAcl, long length, boolean isdir, int blockReplication, long blocksize, long modificationTime, Path path, String version) {
            super(length, isdir, blockReplication, blocksize, modificationTime, 0L, fsPermission, owner, group, null, path, hasAcl, false, false);
            this.version = version;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof FileStatus)) {
                return false;
            }
            FileStatus other = (FileStatus)obj;
            if (!this.getPath().equals((Object)other.getPath())) {
                return false;
            }
            if (other instanceof VersionedFileStatus) {
                return this.version.equals(((VersionedFileStatus)other).version);
            }
            return true;
        }

        public int hashCode() {
            int hash = this.getPath().hashCode();
            hash = 89 * hash + (this.version != null ? this.version.hashCode() : 0);
            return hash;
        }

        public String getVersion() {
            return this.version;
        }

        public String getEtag() {
            return this.getVersion();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("VersionedFileStatus{");
            sb.append(super.toString());
            sb.append("; version='").append(this.version).append('\'');
            sb.append('}');
            return sb.toString();
        }
    }
}

