/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs.services;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.List;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;
import org.apache.hadoop.fs.azurebfs.contracts.services.AbfsPerfLoggable;
import org.apache.hadoop.fs.azurebfs.contracts.services.ListResultSchema;
import org.apache.hadoop.fs.azurebfs.services.AbfsHttpHeader;
import org.apache.hadoop.fs.azurebfs.services.AbfsIoUtils;
import org.apache.hadoop.fs.azurebfs.utils.UriUtils;
import org.apache.hadoop.security.ssl.DelegatingSSLSocketFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbfsHttpOperation
implements AbfsPerfLoggable {
    private static final Logger LOG = LoggerFactory.getLogger(AbfsHttpOperation.class);
    private static final int CONNECT_TIMEOUT = 30000;
    private static final int READ_TIMEOUT = 30000;
    private static final int CLEAN_UP_BUFFER_SIZE = 65536;
    private static final int ONE_THOUSAND = 1000;
    private static final int ONE_MILLION = 1000000;
    private final String method;
    private final URL url;
    private String maskedUrl;
    private String maskedEncodedUrl;
    private HttpURLConnection connection;
    private int statusCode;
    private String statusDescription;
    private String storageErrorCode = "";
    private String storageErrorMessage = "";
    private String requestId = "";
    private String expectedAppendPos = "";
    private ListResultSchema listResultSchema = null;
    private int bytesSent;
    private int expectedBytesToBeSent;
    private long bytesReceived;
    private final boolean isTraceEnabled = LOG.isTraceEnabled();
    private long connectionTimeMs;
    private long sendRequestTimeMs;
    private long recvResponseTimeMs;
    private boolean shouldMask = false;

    public static AbfsHttpOperation getAbfsHttpOperationWithFixedResult(URL url, String method, int httpStatus) {
        AbfsHttpOperationWithFixedResult httpOp = new AbfsHttpOperationWithFixedResult(url, method, httpStatus);
        return httpOp;
    }

    protected AbfsHttpOperation(URL url, String method, int httpStatus) {
        this.url = url;
        this.method = method;
        this.statusCode = httpStatus;
    }

    protected HttpURLConnection getConnection() {
        return this.connection;
    }

    public String getMethod() {
        return this.method;
    }

    public String getHost() {
        return this.url.getHost();
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public String getStatusDescription() {
        return this.statusDescription;
    }

    public String getStorageErrorCode() {
        return this.storageErrorCode;
    }

    public String getStorageErrorMessage() {
        return this.storageErrorMessage;
    }

    public String getClientRequestId() {
        return this.connection.getRequestProperty("x-ms-client-request-id");
    }

    public String getExpectedAppendPos() {
        return this.expectedAppendPos;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public void setMaskForSAS() {
        this.shouldMask = true;
    }

    public int getBytesSent() {
        return this.bytesSent;
    }

    public int getExpectedBytesToBeSent() {
        return this.expectedBytesToBeSent;
    }

    public long getBytesReceived() {
        return this.bytesReceived;
    }

    public ListResultSchema getListResultSchema() {
        return this.listResultSchema;
    }

    public String getResponseHeader(String httpHeader) {
        return this.connection.getHeaderField(httpHeader);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.statusCode);
        sb.append(",");
        sb.append(this.storageErrorCode);
        sb.append(",");
        sb.append(this.expectedAppendPos);
        sb.append(",cid=");
        sb.append(this.getClientRequestId());
        sb.append(",rid=");
        sb.append(this.requestId);
        if (this.isTraceEnabled) {
            sb.append(",connMs=");
            sb.append(this.connectionTimeMs);
            sb.append(",sendMs=");
            sb.append(this.sendRequestTimeMs);
            sb.append(",recvMs=");
            sb.append(this.recvResponseTimeMs);
        }
        sb.append(",sent=");
        sb.append(this.bytesSent);
        sb.append(",recv=");
        sb.append(this.bytesReceived);
        sb.append(",");
        sb.append(this.method);
        sb.append(",");
        sb.append(this.getMaskedUrl());
        return sb.toString();
    }

    @Override
    public String getLogString() {
        StringBuilder sb = new StringBuilder();
        sb.append("s=").append(this.statusCode).append(" e=").append(this.storageErrorCode).append(" ci=").append(this.getClientRequestId()).append(" ri=").append(this.requestId);
        if (this.isTraceEnabled) {
            sb.append(" ct=").append(this.connectionTimeMs).append(" st=").append(this.sendRequestTimeMs).append(" rt=").append(this.recvResponseTimeMs);
        }
        sb.append(" bs=").append(this.bytesSent).append(" br=").append(this.bytesReceived).append(" m=").append(this.method).append(" u=").append(this.getMaskedEncodedUrl());
        return sb.toString();
    }

    public String getMaskedUrl() {
        if (!this.shouldMask) {
            return this.url.toString();
        }
        if (this.maskedUrl != null) {
            return this.maskedUrl;
        }
        this.maskedUrl = UriUtils.getMaskedUrl(this.url);
        return this.maskedUrl;
    }

    public String getMaskedEncodedUrl() {
        if (this.maskedEncodedUrl != null) {
            return this.maskedEncodedUrl;
        }
        this.maskedEncodedUrl = UriUtils.encodedUrlStr(this.getMaskedUrl());
        return this.maskedEncodedUrl;
    }

    public AbfsHttpOperation(URL url, String method, List<AbfsHttpHeader> requestHeaders) throws IOException {
        this.url = url;
        this.method = method;
        this.connection = this.openConnection();
        if (this.connection instanceof HttpsURLConnection) {
            HttpsURLConnection secureConn = (HttpsURLConnection)this.connection;
            DelegatingSSLSocketFactory sslSocketFactory = DelegatingSSLSocketFactory.getDefaultFactory();
            if (sslSocketFactory != null) {
                secureConn.setSSLSocketFactory((SSLSocketFactory)sslSocketFactory);
            }
        }
        this.connection.setConnectTimeout(30000);
        this.connection.setReadTimeout(30000);
        this.connection.setRequestMethod(method);
        for (AbfsHttpHeader header : requestHeaders) {
            this.setRequestProperty(header.getName(), header.getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendRequest(byte[] buffer, int offset, int length) throws IOException {
        this.connection.setDoOutput(true);
        this.connection.setFixedLengthStreamingMode(length);
        if (buffer == null) {
            buffer = new byte[]{};
            offset = 0;
            length = 0;
        }
        long startTime = 0L;
        if (this.isTraceEnabled) {
            startTime = System.nanoTime();
        }
        OutputStream outputStream = null;
        this.expectedBytesToBeSent = length;
        try {
            try {
                outputStream = this.getConnOutputStream();
            }
            catch (IOException e) {
                String expectHeader = this.getConnProperty("Expect");
                if (expectHeader != null && expectHeader.equals("100-continue")) {
                    LOG.debug("Getting output stream failed with expect header enabled, returning back ", (Throwable)e);
                    if (outputStream != null) {
                        outputStream.close();
                    }
                    if (this.isTraceEnabled) {
                        this.sendRequestTimeMs = this.elapsedTimeMs(startTime);
                    }
                    return;
                }
                LOG.debug("Getting output stream failed without expect header enabled, throwing exception ", (Throwable)e);
                throw e;
            }
            this.bytesSent = length;
            outputStream.write(buffer, offset, length);
        }
        finally {
            if (outputStream != null) {
                outputStream.close();
            }
            if (this.isTraceEnabled) {
                this.sendRequestTimeMs = this.elapsedTimeMs(startTime);
            }
        }
    }

    public void processResponse(byte[] buffer, int offset, int length) throws IOException {
        long startTime = 0L;
        if (this.isTraceEnabled) {
            startTime = System.nanoTime();
        }
        this.statusCode = this.getConnResponseCode();
        if (this.isTraceEnabled) {
            this.recvResponseTimeMs = this.elapsedTimeMs(startTime);
        }
        this.statusDescription = this.getConnResponseMessage();
        this.requestId = this.connection.getHeaderField("x-ms-request-id");
        if (this.requestId == null) {
            this.requestId = "";
        }
        AbfsIoUtils.dumpHeadersToDebugLog("Response Headers", this.connection.getHeaderFields());
        if ("HEAD".equals(this.method)) {
            return;
        }
        if (this.isTraceEnabled) {
            startTime = System.nanoTime();
        }
        if (this.statusCode >= 400) {
            this.processStorageErrorResponse();
            if (this.isTraceEnabled) {
                this.recvResponseTimeMs += this.elapsedTimeMs(startTime);
            }
            this.bytesReceived = this.connection.getHeaderFieldLong("Content-Length", 0L);
        } else {
            int totalBytesRead;
            try (InputStream stream = this.connection.getInputStream();){
                if (this.isNullInputStream(stream)) {
                    return;
                }
                boolean endOfStream = false;
                if ("GET".equals(this.method) && buffer == null) {
                    this.parseListFilesResponse(stream);
                } else {
                    int bytesRead;
                    if (buffer != null) {
                        for (totalBytesRead = 0; totalBytesRead < length; totalBytesRead += bytesRead) {
                            bytesRead = stream.read(buffer, offset + totalBytesRead, length - totalBytesRead);
                            if (bytesRead != -1) continue;
                            endOfStream = true;
                            break;
                        }
                    }
                    if (!endOfStream && stream.read() != -1) {
                        bytesRead = 0;
                        byte[] b = new byte[65536];
                        while ((bytesRead = stream.read(b)) >= 0) {
                            totalBytesRead += bytesRead;
                        }
                    }
                }
            }
            catch (IOException ex) {
                LOG.warn("IO/Network error: {} {}: {}", new Object[]{this.method, this.getMaskedUrl(), ex.getMessage()});
                LOG.debug("IO Error: ", (Throwable)ex);
                throw ex;
            }
            finally {
                if (this.isTraceEnabled) {
                    this.recvResponseTimeMs += this.elapsedTimeMs(startTime);
                }
                this.bytesReceived = totalBytesRead;
            }
        }
    }

    public void setRequestProperty(String key, String value) {
        this.connection.setRequestProperty(key, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HttpURLConnection openConnection() throws IOException {
        if (!this.isTraceEnabled) {
            return (HttpURLConnection)this.url.openConnection();
        }
        long start = System.nanoTime();
        try {
            HttpURLConnection httpURLConnection = (HttpURLConnection)this.url.openConnection();
            return httpURLConnection;
        }
        finally {
            this.connectionTimeMs = this.elapsedTimeMs(start);
        }
    }

    private void processStorageErrorResponse() {
        try (InputStream stream = this.connection.getErrorStream();){
            if (stream == null) {
                return;
            }
            JsonFactory jf = new JsonFactory();
            try (JsonParser jp = jf.createParser(stream);){
                jp.nextToken();
                jp.nextToken();
                jp.nextToken();
                jp.nextToken();
                while (jp.hasCurrentToken()) {
                    if (jp.getCurrentToken() == JsonToken.FIELD_NAME) {
                        String fieldName = jp.getCurrentName();
                        jp.nextToken();
                        String fieldValue = jp.getText();
                        switch (fieldName) {
                            case "code": {
                                this.storageErrorCode = fieldValue;
                                break;
                            }
                            case "message": {
                                this.storageErrorMessage = fieldValue;
                                break;
                            }
                            case "ExpectedAppendPos": {
                                this.expectedAppendPos = fieldValue;
                                break;
                            }
                        }
                    }
                    jp.nextToken();
                }
            }
        }
        catch (IOException ex) {
            LOG.debug("ExpectedError: ", (Throwable)ex);
        }
    }

    private long elapsedTimeMs(long startTime) {
        return (System.nanoTime() - startTime) / 1000000L;
    }

    private void parseListFilesResponse(InputStream stream) throws IOException {
        if (stream == null) {
            return;
        }
        if (this.listResultSchema != null) {
            return;
        }
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            this.listResultSchema = (ListResultSchema)objectMapper.readValue(stream, ListResultSchema.class);
        }
        catch (IOException ex) {
            LOG.error("Unable to deserialize list results", (Throwable)ex);
            throw ex;
        }
    }

    private boolean isNullInputStream(InputStream stream) {
        return stream == null;
    }

    String getConnProperty(String key) {
        return this.connection.getRequestProperty(key);
    }

    URL getConnUrl() {
        return this.connection.getURL();
    }

    String getConnRequestMethod() {
        return this.connection.getRequestMethod();
    }

    Integer getConnResponseCode() throws IOException {
        return this.connection.getResponseCode();
    }

    OutputStream getConnOutputStream() throws IOException {
        return this.connection.getOutputStream();
    }

    String getConnResponseMessage() throws IOException {
        return this.connection.getResponseMessage();
    }

    public static class AbfsHttpOperationWithFixedResult
    extends AbfsHttpOperation {
        public AbfsHttpOperationWithFixedResult(URL url, String method, int httpStatus) {
            super(url, method, httpStatus);
        }

        @Override
        public String getResponseHeader(String httpHeader) {
            return "";
        }
    }
}

