/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.nio.channels.ClosedChannelException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nonnull;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.hdfs.AddBlockFlag;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.DFSClientFaultInjector;
import org.apache.hadoop.hdfs.DFSOutputStream;
import org.apache.hadoop.hdfs.DFSPacket;
import org.apache.hadoop.hdfs.DFSUtilClient;
import org.apache.hadoop.hdfs.ExceptionLastSeen;
import org.apache.hadoop.hdfs.client.impl.DfsClientConf;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.protocol.HdfsFileStatus;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.QuotaExceededException;
import org.apache.hadoop.hdfs.protocol.datatransfer.BlockConstructionStage;
import org.apache.hadoop.hdfs.protocol.datatransfer.DataTransferProtoUtil;
import org.apache.hadoop.hdfs.protocol.datatransfer.DataTransferProtocol;
import org.apache.hadoop.hdfs.protocol.datatransfer.IOStreamPair;
import org.apache.hadoop.hdfs.protocol.datatransfer.InvalidEncryptionKeyException;
import org.apache.hadoop.hdfs.protocol.datatransfer.PacketHeader;
import org.apache.hadoop.hdfs.protocol.datatransfer.PipelineAck;
import org.apache.hadoop.hdfs.protocol.datatransfer.Sender;
import org.apache.hadoop.hdfs.protocol.proto.DataTransferProtos;
import org.apache.hadoop.hdfs.protocolPB.PBHelperClient;
import org.apache.hadoop.hdfs.security.token.block.BlockTokenIdentifier;
import org.apache.hadoop.hdfs.server.datanode.CachingStrategy;
import org.apache.hadoop.hdfs.util.ByteArrayManager;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.MultipleIOException;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.thirdparty.com.google.common.cache.CacheBuilder;
import org.apache.hadoop.thirdparty.com.google.common.cache.CacheLoader;
import org.apache.hadoop.thirdparty.com.google.common.cache.LoadingCache;
import org.apache.hadoop.thirdparty.com.google.common.cache.RemovalListener;
import org.apache.hadoop.thirdparty.com.google.common.cache.RemovalNotification;
import org.apache.hadoop.tracing.Span;
import org.apache.hadoop.tracing.SpanContext;
import org.apache.hadoop.tracing.TraceScope;
import org.apache.hadoop.tracing.Tracer;
import org.apache.hadoop.util.Daemon;
import org.apache.hadoop.util.DataChecksum;
import org.apache.hadoop.util.Progressable;
import org.apache.hadoop.util.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
class DataStreamer
extends Daemon {
    static final Logger LOG = LoggerFactory.getLogger(DataStreamer.class);
    private volatile boolean streamerClosed = false;
    protected final BlockToWrite block;
    protected Token<BlockTokenIdentifier> accessToken;
    private DataOutputStream blockStream;
    private DataInputStream blockReplyStream;
    private ResponseProcessor response = null;
    private volatile DatanodeInfo[] nodes = null;
    private volatile StorageType[] storageTypes = null;
    private volatile String[] storageIDs = null;
    private final ErrorState errorState;
    private volatile BlockConstructionStage stage;
    protected long bytesSent = 0L;
    private final boolean isLazyPersistFile;
    private long lastPacket;
    private final List<DatanodeInfo> failed = new ArrayList<DatanodeInfo>();
    private List<DatanodeInfo> restartingNodes = new ArrayList<DatanodeInfo>();
    private volatile int pipelineRecoveryCount = 0;
    private boolean isHflushed = false;
    private final boolean isAppend;
    private long currentSeqno = 0L;
    private long lastQueuedSeqno = -1L;
    private long lastAckedSeqno = -1L;
    private long bytesCurBlock = 0L;
    private final LastExceptionInStreamer lastException = new LastExceptionInStreamer();
    private Socket s;
    protected final DFSClient dfsClient;
    protected final String src;
    final DataChecksum checksum4WriteBlock;
    final Progressable progress;
    protected final HdfsFileStatus stat;
    private volatile boolean appendChunk = false;
    protected final LinkedList<DFSPacket> dataQueue = new LinkedList();
    private final Map<Long, Long> packetSendTime = new HashMap<Long, Long>();
    private final LinkedList<DFSPacket> ackQueue = new LinkedList();
    private final AtomicReference<CachingStrategy> cachingStrategy;
    private final ByteArrayManager byteArrayManager;
    private final AtomicBoolean persistBlocks = new AtomicBoolean(false);
    private boolean failPacket = false;
    private final long dfsclientSlowLogThresholdMs;
    private long artificialSlowdown = 0L;
    private final List<DatanodeInfo> congestedNodes = new ArrayList<DatanodeInfo>();
    private final Map<DatanodeInfo, Integer> slowNodeMap = new HashMap<DatanodeInfo, Integer>();
    private static final int CONGESTION_BACKOFF_MEAN_TIME_IN_MS = 5000;
    private static final int CONGESTION_BACK_OFF_MAX_TIME_IN_MS = 50000;
    private int lastCongestionBackoffTime;
    private int maxPipelineRecoveryRetries;
    private int markSlowNodeAsBadNodeThreshold;
    protected final LoadingCache<DatanodeInfo, DatanodeInfo> excludedNodes;
    private final String[] favoredNodes;
    private final EnumSet<AddBlockFlag> addBlockFlags;

    static Socket createSocketForPipeline(DatanodeInfo first, int length, DFSClient client) throws IOException {
        DfsClientConf conf = client.getConf();
        String dnAddr = first.getXferAddr(conf.isConnectToDnViaHostname());
        LOG.debug("Connecting to datanode {}", (Object)dnAddr);
        InetSocketAddress isa = NetUtils.createSocketAddr(dnAddr);
        Socket sock = client.socketFactory.createSocket();
        int timeout = client.getDatanodeReadTimeout(length);
        NetUtils.connect(sock, isa, client.getRandomLocalInterfaceAddr(), conf.getSocketTimeout());
        sock.setTcpNoDelay(conf.getDataTransferTcpNoDelay());
        sock.setSoTimeout(timeout);
        sock.setKeepAlive(true);
        if (conf.getSocketSendBufferSize() > 0) {
            sock.setSendBufferSize(conf.getSocketSendBufferSize());
        }
        LOG.debug("Send buf size {}", (Object)sock.getSendBufferSize());
        return sock;
    }

    static boolean isLazyPersist(HdfsFileStatus stat) {
        return stat.getStoragePolicy() == 15;
    }

    private static void releaseBuffer(List<DFSPacket> packets, ByteArrayManager bam) {
        for (DFSPacket p : packets) {
            p.releaseBuffer(bam);
        }
        packets.clear();
    }

    private DataStreamer(HdfsFileStatus stat, ExtendedBlock block, DFSClient dfsClient, String src, Progressable progress, DataChecksum checksum, AtomicReference<CachingStrategy> cachingStrategy, ByteArrayManager byteArrayManage, boolean isAppend, String[] favoredNodes, EnumSet<AddBlockFlag> flags) {
        this.block = new BlockToWrite(block);
        this.dfsClient = dfsClient;
        this.src = src;
        this.progress = progress;
        this.stat = stat;
        this.checksum4WriteBlock = checksum;
        this.cachingStrategy = cachingStrategy;
        this.byteArrayManager = byteArrayManage;
        this.isLazyPersistFile = DataStreamer.isLazyPersist(stat);
        this.isAppend = isAppend;
        this.favoredNodes = favoredNodes;
        DfsClientConf conf = dfsClient.getConf();
        this.dfsclientSlowLogThresholdMs = conf.getSlowIoWarningThresholdMs();
        this.excludedNodes = DataStreamer.initExcludedNodes(conf.getExcludedNodesCacheExpiry());
        this.errorState = new ErrorState(conf.getDatanodeRestartTimeout());
        this.addBlockFlags = flags;
        this.maxPipelineRecoveryRetries = conf.getMaxPipelineRecoveryRetries();
        this.markSlowNodeAsBadNodeThreshold = conf.getMarkSlowNodeAsBadNodeThreshold();
    }

    DataStreamer(HdfsFileStatus stat, ExtendedBlock block, DFSClient dfsClient, String src, Progressable progress, DataChecksum checksum, AtomicReference<CachingStrategy> cachingStrategy, ByteArrayManager byteArrayManage, String[] favoredNodes, EnumSet<AddBlockFlag> flags) {
        this(stat, block, dfsClient, src, progress, checksum, cachingStrategy, byteArrayManage, false, favoredNodes, flags);
        this.stage = BlockConstructionStage.PIPELINE_SETUP_CREATE;
    }

    DataStreamer(LocatedBlock lastBlock, HdfsFileStatus stat, DFSClient dfsClient, String src, Progressable progress, DataChecksum checksum, AtomicReference<CachingStrategy> cachingStrategy, ByteArrayManager byteArrayManage) {
        this(stat, lastBlock.getBlock(), dfsClient, src, progress, checksum, cachingStrategy, byteArrayManage, true, null, null);
        this.stage = BlockConstructionStage.PIPELINE_SETUP_APPEND;
        this.bytesSent = this.block.getNumBytes();
        this.accessToken = lastBlock.getBlockToken();
    }

    void setPipelineInConstruction(LocatedBlock lastBlock) throws IOException {
        this.setPipeline(lastBlock);
        if (this.nodes.length < 1) {
            throw new IOException("Unable to retrieve blocks locations  for last block " + this.block + " of file " + this.src);
        }
    }

    void setAccessToken(Token<BlockTokenIdentifier> t) {
        this.accessToken = t;
    }

    private void setPipeline(LocatedBlock lb) {
        this.setPipeline(lb.getLocations(), lb.getStorageTypes(), lb.getStorageIDs());
    }

    private void setPipeline(DatanodeInfo[] nodes, StorageType[] storageTypes, String[] storageIDs) {
        this.nodes = nodes;
        this.storageTypes = storageTypes;
        this.storageIDs = storageIDs;
    }

    private void initDataStreaming() {
        this.setName("DataStreamer for file " + this.src + " block " + this.block);
        if (LOG.isDebugEnabled()) {
            LOG.debug("nodes {} storageTypes {} storageIDs {}", new Object[]{Arrays.toString(this.nodes), Arrays.toString((Object[])this.storageTypes), Arrays.toString(this.storageIDs)});
        }
        this.response = new ResponseProcessor(this.nodes);
        this.response.start();
        this.stage = BlockConstructionStage.DATA_STREAMING;
        this.lastPacket = Time.monotonicNow();
    }

    protected void endBlock() {
        LOG.debug("Closing old block {}", (Object)this.block);
        this.setName("DataStreamer for file " + this.src);
        this.closeResponder();
        this.closeStream();
        this.setPipeline(null, null, null);
        this.stage = BlockConstructionStage.PIPELINE_SETUP_CREATE;
    }

    private boolean shouldStop() {
        return this.streamerClosed || this.errorState.hasError() || !this.dfsClient.clientRunning;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        TraceScope scope = null;
        while (!this.streamerClosed && this.dfsClient.clientRunning) {
            if (this.errorState.hasError()) {
                this.closeResponder();
            }
            try {
                DFSPacket one;
                boolean doSleep = this.processDatanodeOrExternalError();
                LinkedList<DFSPacket> linkedList = this.dataQueue;
                synchronized (linkedList) {
                    block60: {
                        while (!this.shouldStop() && this.dataQueue.isEmpty() || doSleep) {
                            long timeout = 1000L;
                            if (this.stage == BlockConstructionStage.DATA_STREAMING) {
                                timeout = this.sendHeartbeat();
                            }
                            try {
                                this.dataQueue.wait(timeout);
                            }
                            catch (InterruptedException e) {
                                LOG.debug("Thread interrupted", (Throwable)e);
                            }
                            doSleep = false;
                        }
                        if (!this.shouldStop()) break block60;
                        continue;
                    }
                    one = this.dataQueue.getFirst();
                    SpanContext[] parents = one.getTraceParents();
                    if (parents != null && parents.length > 0) {
                        scope = this.dfsClient.getTracer().newScope("dataStreamer", parents[0], false);
                    }
                }
                try {
                    this.backOffIfNecessary();
                }
                catch (InterruptedException e) {
                    LOG.debug("Thread interrupted", (Throwable)e);
                }
                LOG.debug("stage={}, {}", (Object)this.stage, (Object)this);
                if (this.stage == BlockConstructionStage.PIPELINE_SETUP_CREATE) {
                    LOG.debug("Allocating new block: {}", (Object)this);
                    this.setPipeline(this.nextBlockOutputStream());
                    this.initDataStreaming();
                } else if (this.stage == BlockConstructionStage.PIPELINE_SETUP_APPEND) {
                    LOG.debug("Append to block {}", (Object)this.block);
                    this.setupPipelineForAppendOrRecovery();
                    if (this.streamerClosed) continue;
                    this.initDataStreaming();
                }
                long lastByteOffsetInBlock = one.getLastByteOffsetBlock();
                if (lastByteOffsetInBlock > this.stat.getBlockSize()) {
                    throw new IOException("BlockSize " + this.stat.getBlockSize() + " < lastByteOffsetInBlock, " + this + ", " + one);
                }
                if (one.isLastPacketInBlock()) {
                    this.waitForAllAcks();
                    if (this.shouldStop()) continue;
                    this.stage = BlockConstructionStage.PIPELINE_CLOSE;
                }
                SpanContext spanContext = null;
                LinkedList<DFSPacket> e = this.dataQueue;
                synchronized (e) {
                    if (!one.isHeartbeatPacket()) {
                        if (scope != null) {
                            one.setSpan(scope.span());
                            spanContext = scope.span().getContext();
                            scope.close();
                        }
                        scope = null;
                        this.dataQueue.removeFirst();
                        this.ackQueue.addLast(one);
                        this.packetSendTime.put(one.getSeqno(), Time.monotonicNow());
                        this.dataQueue.notifyAll();
                    }
                }
                LOG.debug("{} sending {}", (Object)this, (Object)one);
                try (TraceScope ignored = this.dfsClient.getTracer().newScope("DataStreamer#writeTo", spanContext);){
                    this.sendPacket(one);
                }
                catch (IOException e2) {
                    this.errorState.markFirstNodeIfNotMarked();
                    throw e2;
                }
                long tmpBytesSent = one.getLastByteOffsetBlock();
                if (this.bytesSent < tmpBytesSent) {
                    this.bytesSent = tmpBytesSent;
                }
                if (this.shouldStop()) continue;
                if (one.isLastPacketInBlock()) {
                    try {
                        this.waitForAllAcks();
                    }
                    catch (IOException ioe) {
                        LinkedList<DFSPacket> linkedList2 = this.dataQueue;
                        synchronized (linkedList2) {
                            if (!this.ackQueue.isEmpty()) {
                                throw ioe;
                            }
                        }
                    }
                    if (this.shouldStop()) continue;
                    this.endBlock();
                }
                if (this.progress != null) {
                    this.progress.progress();
                }
                if (this.artificialSlowdown == 0L || !this.dfsClient.clientRunning) continue;
                Thread.sleep(this.artificialSlowdown);
            }
            catch (Throwable e) {
                if (!this.errorState.isRestartingNode()) {
                    if (e instanceof QuotaExceededException) {
                        LOG.debug("DataStreamer Quota Exception", e);
                    } else {
                        LOG.warn("DataStreamer Exception", e);
                    }
                }
                this.lastException.set(e);
                assert (!(e instanceof NullPointerException));
                this.errorState.setInternalError();
                if (this.errorState.isNodeMarked()) continue;
                this.streamerClosed = true;
            }
            finally {
                if (scope == null) continue;
                scope.close();
                scope = null;
            }
        }
        this.closeInternal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForAllAcks() throws IOException {
        LinkedList<DFSPacket> linkedList = this.dataQueue;
        synchronized (linkedList) {
            while (!this.shouldStop() && !this.ackQueue.isEmpty()) {
                try {
                    this.dataQueue.wait(this.sendHeartbeat());
                }
                catch (InterruptedException e) {
                    LOG.debug("Thread interrupted ", (Throwable)e);
                }
            }
        }
    }

    private void sendPacket(DFSPacket packet) throws IOException {
        try {
            packet.writeTo(this.blockStream);
            this.blockStream.flush();
        }
        catch (IOException e) {
            this.errorState.markFirstNodeIfNotMarked();
            throw e;
        }
        this.lastPacket = Time.monotonicNow();
    }

    private long sendHeartbeat() throws IOException {
        long heartbeatInterval = this.dfsClient.getConf().getSocketTimeout() / 2;
        long timeout = heartbeatInterval - (Time.monotonicNow() - this.lastPacket);
        if (timeout <= 0L) {
            this.sendPacket(this.createHeartbeatPacket());
            timeout = heartbeatInterval;
        }
        return timeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeInternal() {
        this.closeResponder();
        this.closeStream();
        this.streamerClosed = true;
        this.release();
        LinkedList<DFSPacket> linkedList = this.dataQueue;
        synchronized (linkedList) {
            this.dataQueue.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void release() {
        LinkedList<DFSPacket> linkedList = this.dataQueue;
        synchronized (linkedList) {
            DataStreamer.releaseBuffer(this.dataQueue, this.byteArrayManager);
            DataStreamer.releaseBuffer(this.ackQueue, this.byteArrayManager);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void waitForAckedSeqno(long seqno) throws IOException {
        try (TraceScope ignored = this.dfsClient.getTracer().newScope("waitForAckedSeqno");){
            LOG.debug("{} waiting for ack for: {}", (Object)this, (Object)seqno);
            int dnodes = this.nodes != null ? this.nodes.length : 3;
            int writeTimeout = this.dfsClient.getDatanodeWriteTimeout(dnodes);
            long begin = Time.monotonicNow();
            try {
                LinkedList<DFSPacket> linkedList = this.dataQueue;
                synchronized (linkedList) {
                    while (!this.streamerClosed) {
                        this.checkClosed();
                        if (this.lastAckedSeqno >= seqno) break;
                        try {
                            this.dataQueue.wait(1000L);
                            long duration = Time.monotonicNow() - begin;
                            if (duration <= (long)writeTimeout) continue;
                            LOG.error("No ack received, took {}ms (threshold={}ms). File being written: {}, block: {}, Write pipeline datanodes: {}.", new Object[]{duration, writeTimeout, this.src, this.block, this.nodes});
                            throw new InterruptedIOException("No ack received after " + duration / 1000L + "s and a timeout of " + writeTimeout / 1000 + "s");
                        }
                        catch (InterruptedException ie) {
                            throw new InterruptedIOException("Interrupted while waiting for data to be acknowledged by pipeline");
                        }
                    }
                }
                this.checkClosed();
            }
            catch (ClosedChannelException cce) {
                LOG.debug("Closed channel exception", (Throwable)cce);
            }
            long duration = Time.monotonicNow() - begin;
            if (duration > this.dfsclientSlowLogThresholdMs) {
                LOG.warn("Slow waitForAckedSeqno took {}ms (threshold={}ms). File being written: {}, block: {}, Write pipeline datanodes: {}.", new Object[]{duration, this.dfsclientSlowLogThresholdMs, this.src, this.block, this.nodes});
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void waitAndQueuePacket(DFSPacket packet) throws IOException {
        LinkedList<DFSPacket> linkedList = this.dataQueue;
        synchronized (linkedList) {
            try {
                Span span;
                boolean firstWait = true;
                try {
                    while (!this.streamerClosed && this.dataQueue.size() + this.ackQueue.size() > this.dfsClient.getConf().getWriteMaxPackets()) {
                        if (firstWait) {
                            span = Tracer.getCurrentSpan();
                            if (span != null) {
                                span.addTimelineAnnotation("dataQueue.wait");
                            }
                            firstWait = false;
                        }
                        try {
                            this.dataQueue.wait();
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                            break;
                        }
                    }
                }
                finally {
                    span = Tracer.getCurrentSpan();
                    if (span != null && !firstWait) {
                        span.addTimelineAnnotation("end.wait");
                    }
                }
                this.checkClosed();
                this.queuePacket(packet);
            }
            catch (ClosedChannelException cce) {
                LOG.debug("Closed channel exception", (Throwable)cce);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close(boolean force) {
        this.streamerClosed = true;
        LinkedList<DFSPacket> linkedList = this.dataQueue;
        synchronized (linkedList) {
            this.dataQueue.notifyAll();
        }
        if (force) {
            this.interrupt();
        }
    }

    void setStreamerAsClosed() {
        this.streamerClosed = true;
    }

    private void checkClosed() throws IOException {
        if (this.streamerClosed) {
            this.lastException.throwException4Close();
        }
    }

    private void closeResponder() {
        if (this.response != null) {
            try {
                this.response.close();
                this.response.join();
            }
            catch (InterruptedException e) {
                LOG.debug("Thread interrupted", (Throwable)e);
                Thread.currentThread().interrupt();
            }
            finally {
                this.response = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void closeStream() {
        IOException ioe;
        MultipleIOException.Builder b = new MultipleIOException.Builder();
        if (this.blockStream != null) {
            try {
                this.blockStream.close();
            }
            catch (IOException e) {
                b.add(e);
            }
            finally {
                this.blockStream = null;
            }
        }
        if (this.blockReplyStream != null) {
            try {
                this.blockReplyStream.close();
            }
            catch (IOException e) {
                b.add(e);
            }
            finally {
                this.blockReplyStream = null;
            }
        }
        if (null != this.s) {
            try {
                this.s.close();
            }
            catch (IOException e) {
                b.add(e);
            }
            finally {
                this.s = null;
            }
        }
        if ((ioe = b.build()) != null) {
            this.lastException.set(ioe);
        }
    }

    boolean shouldWaitForRestart(int index) {
        InetAddress addr;
        block4: {
            if (this.nodes.length == 1) {
                return true;
            }
            if (DFSClientFaultInjector.get().skipRollingRestartWait()) {
                return false;
            }
            addr = null;
            try {
                addr = InetAddress.getByName(this.nodes[index].getIpAddr());
            }
            catch (UnknownHostException e) {
                if ($assertionsDisabled) break block4;
                throw new AssertionError();
            }
        }
        return addr != null && NetUtils.isLocalAddress(addr);
    }

    private boolean shouldHandleExternalError() {
        return this.errorState.hasExternalError() && this.blockStream != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean processDatanodeOrExternalError() throws IOException {
        if (!this.errorState.hasDatanodeError() && !this.shouldHandleExternalError()) {
            return false;
        }
        LOG.debug("start process datanode/external error, {}", (Object)this);
        if (this.response != null) {
            LOG.info("Error Recovery for " + this.block + " waiting for responder to exit. ");
            return true;
        }
        this.closeStream();
        LinkedList<DFSPacket> linkedList = this.dataQueue;
        synchronized (linkedList) {
            this.dataQueue.addAll(0, this.ackQueue);
            this.ackQueue.clear();
            this.packetSendTime.clear();
        }
        if (!this.errorState.isRestartingNode() && ++this.pipelineRecoveryCount > this.maxPipelineRecoveryRetries) {
            LOG.warn("Error recovering pipeline for writing " + this.block + ". Already retried " + this.maxPipelineRecoveryRetries + " times for the same packet.");
            this.lastException.set(new IOException("Failing write. Tried pipeline recovery " + this.maxPipelineRecoveryRetries + " times without success."));
            this.streamerClosed = true;
            return false;
        }
        this.setupPipelineForAppendOrRecovery();
        if (!this.streamerClosed && this.dfsClient.clientRunning) {
            if (this.stage == BlockConstructionStage.PIPELINE_CLOSE) {
                linkedList = this.dataQueue;
                synchronized (linkedList) {
                    DFSPacket endOfBlockPacket = this.dataQueue.remove();
                    Span span = endOfBlockPacket.getSpan();
                    if (span != null) {
                        span.finish();
                        endOfBlockPacket.setSpan(null);
                    }
                    assert (endOfBlockPacket.isLastPacketInBlock());
                    assert (this.lastAckedSeqno == endOfBlockPacket.getSeqno() - 1L);
                    this.lastAckedSeqno = endOfBlockPacket.getSeqno();
                    this.pipelineRecoveryCount = 0;
                    this.dataQueue.notifyAll();
                }
                this.endBlock();
            } else {
                this.initDataStreaming();
            }
        }
        return false;
    }

    void setHflush() {
        this.isHflushed = true;
    }

    private int findNewDatanode(DatanodeInfo[] original) throws IOException {
        if (this.nodes.length != original.length + 1) {
            throw new IOException("Failed to replace a bad datanode on the existing pipeline due to no more good datanodes being available to try. (Nodes: current=" + Arrays.asList(this.nodes) + ", original=" + Arrays.asList(original) + "). The current failed datanode replacement policy is " + this.dfsClient.dtpReplaceDatanodeOnFailure + ", and a client may configure this via '" + "dfs.client.block.write.replace-datanode-on-failure.policy" + "' in its configuration.");
        }
        for (int i = 0; i < this.nodes.length; ++i) {
            int j;
            for (j = 0; j < original.length && !this.nodes[i].equals(original[j]); ++j) {
            }
            if (j != original.length) continue;
            return i;
        }
        throw new IOException("Failed: new datanode not found: nodes=" + Arrays.asList(this.nodes) + ", original=" + Arrays.asList(original));
    }

    private void addDatanode2ExistingPipeline() throws IOException {
        DataTransferProtocol.LOG.debug("lastAckedSeqno = {}", (Object)this.lastAckedSeqno);
        if (!this.isAppend && this.lastAckedSeqno < 0L && this.stage == BlockConstructionStage.PIPELINE_SETUP_CREATE) {
            return;
        }
        DatanodeInfo[] original = this.nodes;
        StorageType[] originalTypes = this.storageTypes;
        String[] originalIDs = this.storageIDs;
        IOException caughtException = null;
        ArrayList<DatanodeInfo> exclude = new ArrayList<DatanodeInfo>(this.failed);
        for (int tried = 0; tried < 3; ++tried) {
            int d;
            LocatedBlock lb = this.dfsClient.namenode.getAdditionalDatanode(this.src, this.stat.getFileId(), this.block.getCurrentBlock(), this.nodes, this.storageIDs, exclude.toArray(new DatanodeInfo[exclude.size()]), 1, this.dfsClient.clientName);
            this.setPipeline(lb);
            try {
                d = this.findNewDatanode(original);
            }
            catch (IOException ioe) {
                if (this.dfsClient.dtpReplaceDatanodeOnFailureReplication > 0 && this.nodes.length >= this.dfsClient.dtpReplaceDatanodeOnFailureReplication) {
                    DFSClient.LOG.warn("Failed to find a new datanode to add to the write pipeline, continue to write to the pipeline with " + this.nodes.length + " nodes since it's no less than minimum replication: " + this.dfsClient.dtpReplaceDatanodeOnFailureReplication + " configured by " + "dfs.client.block.write.replace-datanode-on-failure.min-replication" + ".", (Throwable)ioe);
                    return;
                }
                throw ioe;
            }
            DatanodeInfo src = original[tried % original.length];
            DatanodeInfo[] targets = new DatanodeInfo[]{this.nodes[d]};
            StorageType[] targetStorageTypes = new StorageType[]{this.storageTypes[d]};
            String[] targetStorageIDs = new String[]{this.storageIDs[d]};
            try {
                this.transfer(src, targets, targetStorageTypes, targetStorageIDs, lb.getBlockToken());
            }
            catch (IOException ioe) {
                DFSClient.LOG.warn("Error transferring data from " + src + " to " + this.nodes[d] + ": " + ioe.getMessage());
                caughtException = ioe;
                exclude.add(this.nodes[d]);
                this.setPipeline(original, originalTypes, originalIDs);
                continue;
            }
            return;
        }
        throw caughtException != null ? caughtException : new IOException("Failed to add a node");
    }

    private long computeTransferWriteTimeout() {
        return this.dfsClient.getDatanodeWriteTimeout(2);
    }

    private long computeTransferReadTimeout() {
        int multi = 2 + (int)(this.bytesSent / (long)this.dfsClient.getConf().getWritePacketSize()) / 200;
        return this.dfsClient.getDatanodeReadTimeout(multi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void transfer(DatanodeInfo src, DatanodeInfo[] targets, StorageType[] targetStorageTypes, String[] targetStorageIDs, Token<BlockTokenIdentifier> blockToken) throws IOException {
        RefetchEncryptionKeyPolicy policy = new RefetchEncryptionKeyPolicy(src);
        do {
            StreamerStreams streams = null;
            try {
                long writeTimeout = this.computeTransferWriteTimeout();
                long readTimeout = this.computeTransferReadTimeout();
                streams = new StreamerStreams(src, writeTimeout, readTimeout, blockToken);
                streams.sendTransferBlock(targets, targetStorageTypes, targetStorageIDs, blockToken);
                IOUtils.closeStream(streams);
                return;
            }
            catch (InvalidEncryptionKeyException e) {
                policy.recordFailure(e);
            }
            finally {
                IOUtils.closeStream(streams);
            }
        } while (policy.continueRetryingOrThrow());
    }

    private void setupPipelineForAppendOrRecovery() throws IOException {
        if (this.nodes == null || this.nodes.length == 0) {
            String msg = "Could not get block locations. Source file \"" + this.src + "\" - Aborting..." + this;
            LOG.warn(msg);
            this.lastException.set(new IOException(msg));
            this.streamerClosed = true;
            return;
        }
        this.setupPipelineInternal(this.nodes, this.storageTypes, this.storageIDs);
    }

    protected void setupPipelineInternal(DatanodeInfo[] datanodes, StorageType[] nodeStorageTypes, String[] nodeStorageIDs) throws IOException {
        boolean success = false;
        long newGS = 0L;
        while (!success && !this.streamerClosed && this.dfsClient.clientRunning) {
            if (!this.handleRestartingDatanode()) {
                return;
            }
            boolean isRecovery = this.errorState.hasInternalError();
            if (!this.handleBadDatanode()) {
                return;
            }
            this.handleDatanodeReplacement();
            LocatedBlock lb = this.updateBlockForPipeline();
            newGS = lb.getBlock().getGenerationStamp();
            this.accessToken = lb.getBlockToken();
            success = this.createBlockOutputStream(this.nodes, this.storageTypes, this.storageIDs, newGS, isRecovery);
            this.failPacket4Testing();
            this.errorState.checkRestartingNodeDeadline(this.nodes);
        }
        if (success) {
            this.updatePipeline(newGS);
        }
    }

    boolean handleRestartingDatanode() {
        if (this.errorState.isRestartingNode()) {
            if (!this.errorState.doWaitForRestart()) {
                this.errorState.setBadNodeIndex(this.errorState.getRestartingNodeIndex());
                return true;
            }
            long delay = Math.min(this.errorState.datanodeRestartTimeout, 4000L);
            try {
                Thread.sleep(delay);
            }
            catch (InterruptedException ie) {
                this.lastException.set(new IOException("Interrupted while waiting for restarting " + this.nodes[this.errorState.getRestartingNodeIndex()]));
                this.streamerClosed = true;
                return false;
            }
        }
        return true;
    }

    boolean handleBadDatanode() {
        int badNodeIndex = this.errorState.getBadNodeIndex();
        if (badNodeIndex >= 0) {
            if (this.nodes.length <= 1) {
                this.lastException.set(new IOException("All datanodes " + Arrays.toString(this.nodes) + " are bad. Aborting..."));
                this.streamerClosed = true;
                return false;
            }
            String reason = "bad.";
            if (this.errorState.getRestartingNodeIndex() == badNodeIndex) {
                reason = "restarting.";
                this.restartingNodes.add(this.nodes[badNodeIndex]);
            }
            LOG.warn("Error Recovery for " + this.block + " in pipeline " + Arrays.toString(this.nodes) + ": datanode " + badNodeIndex + "(" + this.nodes[badNodeIndex] + ") is " + reason);
            this.failed.add(this.nodes[badNodeIndex]);
            DatanodeInfo[] newnodes = new DatanodeInfo[this.nodes.length - 1];
            DataStreamer.arraycopy(this.nodes, newnodes, badNodeIndex);
            StorageType[] newStorageTypes = new StorageType[newnodes.length];
            DataStreamer.arraycopy(this.storageTypes, newStorageTypes, badNodeIndex);
            String[] newStorageIDs = new String[newnodes.length];
            DataStreamer.arraycopy(this.storageIDs, newStorageIDs, badNodeIndex);
            this.setPipeline(newnodes, newStorageTypes, newStorageIDs);
            this.errorState.adjustState4RestartingNode();
            this.lastException.clear();
        }
        return true;
    }

    private void handleDatanodeReplacement() throws IOException {
        if (this.dfsClient.dtpReplaceDatanodeOnFailure.satisfy(this.stat.getReplication(), this.nodes, this.isAppend, this.isHflushed)) {
            try {
                this.addDatanode2ExistingPipeline();
            }
            catch (IOException ioe) {
                if (!this.dfsClient.dtpReplaceDatanodeOnFailure.isBestEffort()) {
                    throw ioe;
                }
                LOG.warn("Failed to replace datanode. Continue with the remaining datanodes since dfs.client.block.write.replace-datanode-on-failure.best-effort is set to true.", (Throwable)ioe);
            }
        }
    }

    void failPacket4Testing() {
        if (this.failPacket) {
            this.failPacket = false;
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException e) {
                LOG.debug("Thread interrupted", (Throwable)e);
            }
        }
    }

    private LocatedBlock updateBlockForPipeline() throws IOException {
        return this.dfsClient.namenode.updateBlockForPipeline(this.block.getCurrentBlock(), this.dfsClient.clientName);
    }

    void updateBlockGS(long newGS) {
        this.block.setGenerationStamp(newGS);
    }

    @VisibleForTesting
    public void updatePipeline(long newGS) throws IOException {
        ExtendedBlock oldBlock = this.block.getCurrentBlock();
        this.updateBlockGS(newGS);
        this.dfsClient.namenode.updatePipeline(this.dfsClient.clientName, oldBlock, this.block.getCurrentBlock(), this.nodes, this.storageIDs);
    }

    DatanodeInfo[] getExcludedNodes() {
        return (DatanodeInfo[])this.excludedNodes.getAllPresent(this.excludedNodes.asMap().keySet()).keySet().toArray((Object[])DatanodeInfo.EMPTY_ARRAY);
    }

    protected LocatedBlock nextBlockOutputStream() throws IOException {
        LocatedBlock lb;
        boolean success;
        int count = this.dfsClient.getConf().getNumBlockWriteRetry();
        ExtendedBlock oldBlock = this.block.getCurrentBlock();
        do {
            this.errorState.resetInternalError();
            this.lastException.clear();
            DatanodeInfo[] excluded = this.getExcludedNodes();
            lb = this.locateFollowingBlock((DatanodeInfo[])(excluded.length > 0 ? excluded : null), oldBlock);
            this.block.setCurrentBlock(lb.getBlock());
            this.block.setNumBytes(0L);
            this.bytesSent = 0L;
            this.accessToken = lb.getBlockToken();
            DatanodeInfo[] nodes = lb.getLocations();
            StorageType[] nextStorageTypes = lb.getStorageTypes();
            String[] nextStorageIDs = lb.getStorageIDs();
            success = this.createBlockOutputStream(nodes, nextStorageTypes, nextStorageIDs, 0L, false);
            if (success) continue;
            LOG.warn("Abandoning " + this.block);
            this.dfsClient.namenode.abandonBlock(this.block.getCurrentBlock(), this.stat.getFileId(), this.src, this.dfsClient.clientName);
            this.block.setCurrentBlock(null);
            DatanodeInfo badNode = nodes[this.errorState.getBadNodeIndex()];
            LOG.warn("Excluding datanode " + badNode);
            this.excludedNodes.put((Object)badNode, (Object)badNode);
        } while (!success && --count >= 0);
        if (!success) {
            throw new IOException("Unable to create new block.");
        }
        return lb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean createBlockOutputStream(DatanodeInfo[] nodes, StorageType[] nodeStorageTypes, String[] nodeStorageIDs, long newGS, boolean recoveryFlag) {
        boolean result;
        if (nodes.length == 0) {
            LOG.info("nodes are empty for write pipeline of " + this.block);
            return false;
        }
        String firstBadLink = "";
        boolean checkRestart = false;
        if (LOG.isDebugEnabled()) {
            LOG.debug("pipeline = " + Arrays.toString(nodes) + ", " + this);
        }
        this.persistBlocks.set(true);
        int refetchEncryptionKey = 1;
        while (true) {
            result = false;
            DataOutputStream out = null;
            try {
                assert (null == this.s) : "Previous socket unclosed";
                assert (null == this.blockReplyStream) : "Previous blockReplyStream unclosed";
                this.s = DataStreamer.createSocketForPipeline(nodes[0], nodes.length, this.dfsClient);
                long writeTimeout = this.dfsClient.getDatanodeWriteTimeout(nodes.length);
                long readTimeout = this.dfsClient.getDatanodeReadTimeout(nodes.length);
                OutputStream unbufOut = NetUtils.getOutputStream(this.s, writeTimeout);
                InputStream unbufIn = NetUtils.getInputStream(this.s, readTimeout);
                IOStreamPair saslStreams = this.dfsClient.saslClient.socketSend(this.s, unbufOut, unbufIn, this.dfsClient, this.accessToken, nodes[0]);
                unbufOut = saslStreams.out;
                unbufIn = saslStreams.in;
                out = new DataOutputStream(new BufferedOutputStream(unbufOut, DFSUtilClient.getSmallBufferSize(this.dfsClient.getConfiguration())));
                this.blockReplyStream = new DataInputStream(unbufIn);
                BlockConstructionStage bcs = recoveryFlag ? this.stage.getRecoveryStage() : this.stage;
                ExtendedBlock blockCopy = this.block.getCurrentBlock();
                blockCopy.setNumBytes(this.stat.getBlockSize());
                boolean[] targetPinnings = this.getPinnings(nodes);
                new Sender(out).writeBlock(blockCopy, nodeStorageTypes[0], this.accessToken, this.dfsClient.clientName, nodes, nodeStorageTypes, null, bcs, nodes.length, this.block.getNumBytes(), this.bytesSent, newGS, this.checksum4WriteBlock, this.cachingStrategy.get(), this.isLazyPersistFile, targetPinnings != null && targetPinnings[0], targetPinnings, nodeStorageIDs[0], nodeStorageIDs);
                DataTransferProtos.BlockOpResponseProto resp = DataTransferProtos.BlockOpResponseProto.parseFrom(PBHelperClient.vintPrefixed(this.blockReplyStream));
                DataTransferProtos.Status pipelineStatus = resp.getStatus();
                firstBadLink = resp.getFirstBadLink();
                if (PipelineAck.isRestartOOBStatus(pipelineStatus) && !this.errorState.isRestartingNode()) {
                    checkRestart = true;
                    throw new IOException("A datanode is restarting.");
                }
                String logInfo = "ack with firstBadLink as " + firstBadLink;
                DataTransferProtoUtil.checkBlockOpStatus(resp, logInfo);
                assert (null == this.blockStream) : "Previous blockStream unclosed";
                this.blockStream = out;
                result = true;
                this.errorState.resetInternalError();
                this.lastException.clear();
                this.failed.removeAll(this.restartingNodes);
                this.restartingNodes.clear();
                if (result) break;
            }
            catch (IOException ie) {
                int i;
                block19: {
                    block18: {
                        if (!this.errorState.isRestartingNode()) {
                            LOG.warn("Exception in createBlockOutputStream " + this, (Throwable)ie);
                        }
                        if (ie instanceof InvalidEncryptionKeyException && refetchEncryptionKey > 0) {
                            LOG.info("Will fetch a new encryption key and retry, encryption key was invalid when connecting to " + nodes[0] + " : " + ie);
                            --refetchEncryptionKey;
                            this.dfsClient.clearDataEncryptionKey();
                            continue;
                        }
                        if (firstBadLink.length() == 0) break block18;
                        for (i = 0; i < nodes.length; ++i) {
                            if (!firstBadLink.equals(nodes[i].getXferAddr())) continue;
                            this.errorState.setBadNodeIndex(i);
                            break block19;
                        }
                        break block19;
                    }
                    assert (!checkRestart);
                    this.errorState.setBadNodeIndex(0);
                }
                i = this.errorState.getBadNodeIndex();
                if (checkRestart) {
                    this.errorState.initRestartingNode(i, "Datanode " + i + " is restarting: " + nodes[i], this.shouldWaitForRestart(i));
                }
                this.errorState.setInternalError();
                this.lastException.set(ie);
                result = false;
                break;
            }
            finally {
                if (result) continue;
                IOUtils.closeSocket(this.s);
                this.s = null;
                IOUtils.closeStream(out);
                IOUtils.closeStream(this.blockReplyStream);
                this.blockReplyStream = null;
                continue;
            }
            IOUtils.closeSocket(this.s);
            this.s = null;
            IOUtils.closeStream(out);
            IOUtils.closeStream(this.blockReplyStream);
            this.blockReplyStream = null;
            break;
        }
        return result;
    }

    private boolean[] getPinnings(DatanodeInfo[] nodes) {
        if (this.favoredNodes == null) {
            return null;
        }
        boolean[] pinnings = new boolean[nodes.length];
        HashSet<String> favoredSet = new HashSet<String>(Arrays.asList(this.favoredNodes));
        for (int i = 0; i < nodes.length; ++i) {
            pinnings[i] = favoredSet.remove(nodes[i].getXferAddrWithHostname());
            LOG.debug("{} was chosen by name node (favored={}).", (Object)nodes[i].getXferAddrWithHostname(), (Object)pinnings[i]);
        }
        if (!favoredSet.isEmpty()) {
            LOG.warn("These favored nodes were specified but not chosen: " + favoredSet + " Specified favored nodes: " + Arrays.toString(this.favoredNodes));
        }
        return pinnings;
    }

    private LocatedBlock locateFollowingBlock(DatanodeInfo[] excluded, ExtendedBlock oldBlock) throws IOException {
        return DFSOutputStream.addBlock(excluded, this.dfsClient, this.src, oldBlock, this.stat.getFileId(), this.favoredNodes, this.addBlockFlags);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void backOffIfNecessary() throws InterruptedException {
        int t = 0;
        List<DatanodeInfo> list = this.congestedNodes;
        synchronized (list) {
            if (!this.congestedNodes.isEmpty()) {
                StringBuilder sb = new StringBuilder("DataNode");
                for (DatanodeInfo i : this.congestedNodes) {
                    sb.append(' ').append(i);
                }
                int range = Math.abs(this.lastCongestionBackoffTime * 3 - 5000);
                int base = Math.min(this.lastCongestionBackoffTime * 3, 5000);
                this.lastCongestionBackoffTime = t = Math.min(50000, (int)((double)base + Math.random() * (double)range));
                sb.append(" are congested. Backing off for ").append(t).append(" ms");
                LOG.info(sb.toString());
                this.congestedNodes.clear();
            }
        }
        if (t != 0) {
            Thread.sleep(t);
        }
    }

    ExtendedBlock getBlock() {
        return this.block.getCurrentBlock();
    }

    DatanodeInfo[] getNodes() {
        return this.nodes;
    }

    String[] getStorageIDs() {
        return this.storageIDs;
    }

    BlockConstructionStage getStage() {
        return this.stage;
    }

    Token<BlockTokenIdentifier> getBlockToken() {
        return this.accessToken;
    }

    ErrorState getErrorState() {
        return this.errorState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void queuePacket(DFSPacket packet) {
        LinkedList<DFSPacket> linkedList = this.dataQueue;
        synchronized (linkedList) {
            if (packet == null) {
                return;
            }
            packet.addTraceParent(Tracer.getCurrentSpan());
            this.dataQueue.addLast(packet);
            this.lastQueuedSeqno = packet.getSeqno();
            LOG.debug("Queued {}, {}", (Object)packet, (Object)this);
            this.dataQueue.notifyAll();
        }
    }

    private DFSPacket createHeartbeatPacket() {
        byte[] buf = new byte[PacketHeader.PKT_MAX_HEADER_LEN];
        return new DFSPacket(buf, 0, 0L, -1L, 0, false);
    }

    private static LoadingCache<DatanodeInfo, DatanodeInfo> initExcludedNodes(long excludedNodesCacheExpiry) {
        return CacheBuilder.newBuilder().expireAfterWrite(excludedNodesCacheExpiry, TimeUnit.MILLISECONDS).removalListener((RemovalListener)new RemovalListener<DatanodeInfo, DatanodeInfo>(){

            public void onRemoval(@Nonnull RemovalNotification<DatanodeInfo, DatanodeInfo> notification) {
                LOG.info("Removing node " + notification.getKey() + " from the excluded nodes list");
            }
        }).build((CacheLoader)new CacheLoader<DatanodeInfo, DatanodeInfo>(){

            public DatanodeInfo load(DatanodeInfo key) throws Exception {
                return key;
            }
        });
    }

    private static <T> void arraycopy(T[] srcs, T[] dsts, int skipIndex) {
        System.arraycopy(srcs, 0, dsts, 0, skipIndex);
        System.arraycopy(srcs, skipIndex + 1, dsts, skipIndex, dsts.length - skipIndex);
    }

    AtomicBoolean getPersistBlocks() {
        return this.persistBlocks;
    }

    void setAppendChunk(boolean appendChunk) {
        this.appendChunk = appendChunk;
    }

    boolean getAppendChunk() {
        return this.appendChunk;
    }

    LastExceptionInStreamer getLastException() {
        return this.lastException;
    }

    void setSocketToNull() {
        this.s = null;
    }

    long getAndIncCurrentSeqno() {
        long old = this.currentSeqno++;
        return old;
    }

    long getLastQueuedSeqno() {
        return this.lastQueuedSeqno;
    }

    long getBytesCurBlock() {
        return this.bytesCurBlock;
    }

    void setBytesCurBlock(long bytesCurBlock) {
        this.bytesCurBlock = bytesCurBlock;
    }

    void incBytesCurBlock(long len) {
        this.bytesCurBlock += len;
    }

    void setArtificialSlowdown(long period) {
        this.artificialSlowdown = period;
    }

    boolean streamerClosed() {
        return this.streamerClosed;
    }

    @VisibleForTesting
    int getPipelineRecoveryCount() {
        return this.pipelineRecoveryCount;
    }

    void closeSocket() throws IOException {
        if (this.s != null) {
            this.s.close();
        }
    }

    @Override
    public String toString() {
        ExtendedBlock extendedBlock = this.block.getCurrentBlock();
        return extendedBlock == null ? "block==null" : "" + extendedBlock.getLocalBlock();
    }

    private class ResponseProcessor
    extends Daemon {
        private volatile boolean responderClosed = false;
        private DatanodeInfo[] targets = null;
        private boolean isLastPacketInBlock = false;

        ResponseProcessor(DatanodeInfo[] targets) {
            this.targets = targets;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.setName("ResponseProcessor for block " + DataStreamer.this.block);
            PipelineAck ack = new PipelineAck();
            TraceScope scope = null;
            while (!this.responderClosed && DataStreamer.this.dfsClient.clientRunning && !this.isLastPacketInBlock) {
                try {
                    DFSPacket one;
                    List i2;
                    long duration;
                    Long begin;
                    ack.readFields(DataStreamer.this.blockReplyStream);
                    if (ack.getSeqno() != -1L && (begin = (Long)DataStreamer.this.packetSendTime.get(ack.getSeqno())) != null && (duration = Time.monotonicNow() - begin) > DataStreamer.this.dfsclientSlowLogThresholdMs) {
                        LOG.info("Slow ReadProcessor read fields for block " + DataStreamer.this.block + " took " + duration + "ms (threshold=" + DataStreamer.this.dfsclientSlowLogThresholdMs + "ms); ack: " + ack + ", targets: " + Arrays.asList(this.targets));
                    }
                    LOG.debug("DFSClient {}", (Object)ack);
                    long seqno = ack.getSeqno();
                    ArrayList<DatanodeInfo> congestedNodesFromAck = new ArrayList<DatanodeInfo>();
                    ArrayList<DatanodeInfo> slownodesFromAck = new ArrayList<DatanodeInfo>();
                    for (int i2 = ack.getNumOfReplies() - 1; i2 >= 0 && DataStreamer.this.dfsClient.clientRunning; --i2) {
                        DataTransferProtos.Status reply = PipelineAck.getStatusFromHeader(ack.getHeaderFlag(i2));
                        if (PipelineAck.getECNFromHeader(ack.getHeaderFlag(i2)) == PipelineAck.ECN.CONGESTED) {
                            congestedNodesFromAck.add(this.targets[i2]);
                        }
                        if (PipelineAck.getSLOWFromHeader(ack.getHeaderFlag(i2)) == PipelineAck.SLOW.SLOW) {
                            slownodesFromAck.add(this.targets[i2]);
                        }
                        if (PipelineAck.isRestartOOBStatus(reply)) {
                            String message = "Datanode " + i2 + " is restarting: " + this.targets[i2];
                            DataStreamer.this.errorState.initRestartingNode(i2, message, DataStreamer.this.shouldWaitForRestart(i2));
                            throw new IOException(message);
                        }
                        if (reply == DataTransferProtos.Status.SUCCESS) continue;
                        DataStreamer.this.errorState.setBadNodeIndex(i2);
                        throw new IOException("Bad response " + (Object)((Object)reply) + " for " + DataStreamer.this.block + " from datanode " + this.targets[i2]);
                    }
                    if (!congestedNodesFromAck.isEmpty()) {
                        i2 = DataStreamer.this.congestedNodes;
                        synchronized (i2) {
                            DataStreamer.this.congestedNodes.clear();
                            DataStreamer.this.congestedNodes.addAll(congestedNodesFromAck);
                        }
                    }
                    i2 = DataStreamer.this.congestedNodes;
                    synchronized (i2) {
                        DataStreamer.this.congestedNodes.clear();
                        DataStreamer.this.lastCongestionBackoffTime = 0;
                    }
                    if (slownodesFromAck.isEmpty()) {
                        if (!DataStreamer.this.slowNodeMap.isEmpty()) {
                            DataStreamer.this.slowNodeMap.clear();
                        }
                    } else {
                        this.markSlowNode(slownodesFromAck);
                        LOG.debug("SlowNodeMap content: {}.", (Object)DataStreamer.this.slowNodeMap);
                    }
                    assert (seqno != -2L) : "Ack for unknown seqno should be a failed ack: " + ack;
                    if (seqno == -1L) continue;
                    LinkedList<DFSPacket> linkedList = DataStreamer.this.dataQueue;
                    synchronized (linkedList) {
                        one = (DFSPacket)DataStreamer.this.ackQueue.getFirst();
                    }
                    if (one.getSeqno() != seqno) {
                        throw new IOException("ResponseProcessor: Expecting seqno " + one.getSeqno() + " for block " + DataStreamer.this.block + " but received " + seqno);
                    }
                    this.isLastPacketInBlock = one.isLastPacketInBlock();
                    if (DFSClientFaultInjector.get().failPacket() && this.isLastPacketInBlock) {
                        DataStreamer.this.failPacket = true;
                        throw new IOException("Failing the last packet for testing.");
                    }
                    DataStreamer.this.block.setNumBytes(one.getLastByteOffsetBlock());
                    linkedList = DataStreamer.this.dataQueue;
                    synchronized (linkedList) {
                        if (one.getSpan() != null) {
                            scope = new TraceScope(new Span());
                            one.setSpan(null);
                        }
                        DataStreamer.this.lastAckedSeqno = seqno;
                        DataStreamer.this.pipelineRecoveryCount = 0;
                        DataStreamer.this.ackQueue.removeFirst();
                        DataStreamer.this.packetSendTime.remove(seqno);
                        DataStreamer.this.dataQueue.notifyAll();
                        one.releaseBuffer(DataStreamer.this.byteArrayManager);
                    }
                }
                catch (Throwable e) {
                    if (this.responderClosed) continue;
                    DataStreamer.this.lastException.set(e);
                    DataStreamer.this.errorState.setInternalError();
                    DataStreamer.this.errorState.markFirstNodeIfNotMarked();
                    LinkedList<DFSPacket> linkedList = DataStreamer.this.dataQueue;
                    synchronized (linkedList) {
                        DataStreamer.this.dataQueue.notifyAll();
                    }
                    if (!DataStreamer.this.errorState.isRestartingNode()) {
                        LOG.warn("Exception for " + DataStreamer.this.block, e);
                    }
                    this.responderClosed = true;
                }
                finally {
                    if (scope != null) {
                        scope.close();
                    }
                    scope = null;
                }
            }
        }

        void markSlowNode(List<DatanodeInfo> slownodesFromAck) throws IOException {
            HashSet discontinuousNodes = new HashSet(DataStreamer.this.slowNodeMap.keySet());
            for (DatanodeInfo datanodeInfo : slownodesFromAck) {
                if (!DataStreamer.this.slowNodeMap.containsKey(datanodeInfo)) {
                    DataStreamer.this.slowNodeMap.put(datanodeInfo, 1);
                } else {
                    int oldCount = (Integer)DataStreamer.this.slowNodeMap.get(datanodeInfo);
                    DataStreamer.this.slowNodeMap.put(datanodeInfo, ++oldCount);
                }
                discontinuousNodes.remove(datanodeInfo);
            }
            for (DatanodeInfo datanodeInfo : discontinuousNodes) {
                DataStreamer.this.slowNodeMap.remove(datanodeInfo);
            }
            if (!DataStreamer.this.slowNodeMap.isEmpty()) {
                for (Map.Entry entry : DataStreamer.this.slowNodeMap.entrySet()) {
                    if ((Integer)entry.getValue() < DataStreamer.this.markSlowNodeAsBadNodeThreshold) continue;
                    DatanodeInfo slowNode = (DatanodeInfo)entry.getKey();
                    int index = this.getDatanodeIndex(slowNode);
                    if (index >= 0) {
                        DataStreamer.this.errorState.setBadNodeIndex(index);
                        throw new IOException("Receive reply from slowNode " + slowNode + " for continuous " + DataStreamer.this.markSlowNodeAsBadNodeThreshold + " times, treating it as badNode");
                    }
                    DataStreamer.this.slowNodeMap.remove(entry.getKey());
                }
            }
        }

        void close() {
            this.responderClosed = true;
            this.interrupt();
        }

        int getDatanodeIndex(DatanodeInfo datanodeInfo) {
            for (int i = 0; i < this.targets.length; ++i) {
                if (!this.targets[i].equals(datanodeInfo)) continue;
                return i;
            }
            return -1;
        }
    }

    static class ErrorState {
        ErrorType error = ErrorType.NONE;
        private int badNodeIndex = -1;
        private boolean waitForRestart = true;
        private int restartingNodeIndex = -1;
        private long restartingNodeDeadline = 0L;
        private final long datanodeRestartTimeout;

        ErrorState(long datanodeRestartTimeout) {
            this.datanodeRestartTimeout = datanodeRestartTimeout;
        }

        synchronized void resetInternalError() {
            if (this.hasInternalError()) {
                this.error = ErrorType.NONE;
            }
            this.badNodeIndex = -1;
            this.restartingNodeIndex = -1;
            this.restartingNodeDeadline = 0L;
            this.waitForRestart = true;
        }

        synchronized void reset() {
            this.error = ErrorType.NONE;
            this.badNodeIndex = -1;
            this.restartingNodeIndex = -1;
            this.restartingNodeDeadline = 0L;
            this.waitForRestart = true;
        }

        synchronized boolean hasInternalError() {
            return this.error == ErrorType.INTERNAL;
        }

        synchronized boolean hasExternalError() {
            return this.error == ErrorType.EXTERNAL;
        }

        synchronized boolean hasError() {
            return this.error != ErrorType.NONE;
        }

        synchronized boolean hasDatanodeError() {
            return this.error == ErrorType.INTERNAL && this.isNodeMarked();
        }

        synchronized void setInternalError() {
            this.error = ErrorType.INTERNAL;
        }

        synchronized void setExternalError() {
            if (!this.hasInternalError()) {
                this.error = ErrorType.EXTERNAL;
            }
        }

        synchronized void setBadNodeIndex(int index) {
            this.badNodeIndex = index;
        }

        synchronized int getBadNodeIndex() {
            return this.badNodeIndex;
        }

        synchronized int getRestartingNodeIndex() {
            return this.restartingNodeIndex;
        }

        synchronized void initRestartingNode(int i, String message, boolean shouldWait) {
            this.restartingNodeIndex = i;
            if (shouldWait) {
                this.restartingNodeDeadline = Time.monotonicNow() + this.datanodeRestartTimeout;
                this.badNodeIndex = -1;
            } else {
                this.waitForRestart = false;
            }
            LOG.info(message);
        }

        synchronized boolean isRestartingNode() {
            return this.restartingNodeIndex >= 0;
        }

        synchronized boolean isNodeMarked() {
            return this.badNodeIndex >= 0 || this.isRestartingNode() && this.doWaitForRestart();
        }

        synchronized void markFirstNodeIfNotMarked() {
            if (!this.isNodeMarked()) {
                this.badNodeIndex = 0;
            }
        }

        synchronized void adjustState4RestartingNode() {
            if (this.restartingNodeIndex >= 0) {
                if (this.badNodeIndex > this.restartingNodeIndex) {
                    this.restartingNodeIndex = -1;
                } else if (this.badNodeIndex < this.restartingNodeIndex) {
                    --this.restartingNodeIndex;
                } else if (this.waitForRestart) {
                    throw new IllegalStateException("badNodeIndex = " + this.badNodeIndex + " = restartingNodeIndex = " + this.restartingNodeIndex);
                }
            }
            if (!this.isRestartingNode()) {
                this.error = ErrorType.NONE;
            }
            this.badNodeIndex = -1;
        }

        synchronized void checkRestartingNodeDeadline(DatanodeInfo[] nodes) {
            if (this.restartingNodeIndex >= 0) {
                if (this.error == ErrorType.NONE) {
                    throw new IllegalStateException("error=false while checking restarting node deadline");
                }
                if (this.badNodeIndex == this.restartingNodeIndex) {
                    this.badNodeIndex = -1;
                }
                if (Time.monotonicNow() >= this.restartingNodeDeadline) {
                    this.restartingNodeDeadline = 0L;
                    int i = this.restartingNodeIndex;
                    this.restartingNodeIndex = -1;
                    LOG.warn("Datanode " + i + " did not restart within " + this.datanodeRestartTimeout + "ms: " + nodes[i]);
                    if (this.badNodeIndex == -1) {
                        this.badNodeIndex = i;
                    }
                }
            }
        }

        boolean doWaitForRestart() {
            return this.waitForRestart;
        }
    }

    static enum ErrorType {
        NONE,
        INTERNAL,
        EXTERNAL;

    }

    class LastExceptionInStreamer
    extends ExceptionLastSeen {
        LastExceptionInStreamer() {
        }

        @Override
        synchronized void check(boolean resetToNull) throws IOException {
            IOException thrown = this.get();
            if (thrown != null) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Got Exception while checking, " + DataStreamer.this, new Throwable(thrown));
                }
                super.check(resetToNull);
            }
        }
    }

    static class BlockToWrite {
        private ExtendedBlock currentBlock;

        BlockToWrite(ExtendedBlock block) {
            this.setCurrentBlock(block);
        }

        synchronized ExtendedBlock getCurrentBlock() {
            return this.currentBlock == null ? null : new ExtendedBlock(this.currentBlock);
        }

        synchronized long getNumBytes() {
            return this.currentBlock == null ? 0L : this.currentBlock.getNumBytes();
        }

        synchronized void setCurrentBlock(ExtendedBlock block) {
            this.currentBlock = block == null || block.getLocalBlock() == null ? null : new ExtendedBlock(block);
        }

        synchronized void setNumBytes(long numBytes) {
            assert (this.currentBlock != null);
            this.currentBlock.setNumBytes(numBytes);
        }

        synchronized void setGenerationStamp(long generationStamp) {
            assert (this.currentBlock != null);
            this.currentBlock.setGenerationStamp(generationStamp);
        }

        public synchronized String toString() {
            return this.currentBlock == null ? "null" : this.currentBlock.toString();
        }
    }

    private class StreamerStreams
    implements Closeable {
        private Socket sock = null;
        private DataOutputStream out = null;
        private DataInputStream in = null;

        StreamerStreams(DatanodeInfo src, long writeTimeout, long readTimeout, Token<BlockTokenIdentifier> blockToken) throws IOException {
            this.sock = DataStreamer.createSocketForPipeline(src, 2, DataStreamer.this.dfsClient);
            OutputStream unbufOut = NetUtils.getOutputStream(this.sock, writeTimeout);
            InputStream unbufIn = NetUtils.getInputStream(this.sock, readTimeout);
            IOStreamPair saslStreams = DataStreamer.this.dfsClient.saslClient.socketSend(this.sock, unbufOut, unbufIn, DataStreamer.this.dfsClient, blockToken, src);
            unbufOut = saslStreams.out;
            unbufIn = saslStreams.in;
            this.out = new DataOutputStream(new BufferedOutputStream(unbufOut, DFSUtilClient.getSmallBufferSize(DataStreamer.this.dfsClient.getConfiguration())));
            this.in = new DataInputStream(unbufIn);
        }

        void sendTransferBlock(DatanodeInfo[] targets, StorageType[] targetStorageTypes, String[] targetStorageIDs, Token<BlockTokenIdentifier> blockToken) throws IOException {
            new Sender(this.out).transferBlock(DataStreamer.this.block.getCurrentBlock(), blockToken, DataStreamer.this.dfsClient.clientName, targets, targetStorageTypes, targetStorageIDs);
            this.out.flush();
            DataTransferProtos.BlockOpResponseProto transferResponse = DataTransferProtos.BlockOpResponseProto.parseFrom(PBHelperClient.vintPrefixed(this.in));
            if (DataTransferProtos.Status.SUCCESS != transferResponse.getStatus()) {
                throw new IOException("Failed to add a datanode. Response status: " + (Object)((Object)transferResponse.getStatus()));
            }
        }

        @Override
        public void close() throws IOException {
            IOUtils.closeStream(this.in);
            IOUtils.closeStream(this.out);
            IOUtils.closeSocket(this.sock);
        }
    }

    private class RefetchEncryptionKeyPolicy {
        private int fetchEncryptionKeyTimes = 0;
        private InvalidEncryptionKeyException lastException;
        private final DatanodeInfo src;

        RefetchEncryptionKeyPolicy(DatanodeInfo src) {
            this.src = src;
        }

        boolean continueRetryingOrThrow() throws InvalidEncryptionKeyException {
            if (this.fetchEncryptionKeyTimes >= 2) {
                throw this.lastException;
            }
            LOG.info("Will fetch a new encryption key and retry, encryption key was invalid when connecting to " + this.src + ": ", (Throwable)this.lastException);
            DataStreamer.this.dfsClient.clearDataEncryptionKey();
            return true;
        }

        void recordFailure(InvalidEncryptionKeyException e) throws InvalidEncryptionKeyException {
            ++this.fetchEncryptionKeyTimes;
            this.lastException = e;
        }
    }
}

