/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.apache.zookeeper.cli;

import java.util.List;
import org.apache.hadoop.shaded.org.apache.commons.cli.CommandLine;
import org.apache.hadoop.shaded.org.apache.commons.cli.Options;
import org.apache.hadoop.shaded.org.apache.commons.cli.ParseException;
import org.apache.hadoop.shaded.org.apache.commons.cli.PosixParser;
import org.apache.hadoop.shaded.org.apache.zookeeper.KeeperException;
import org.apache.hadoop.shaded.org.apache.zookeeper.cli.CliCommand;
import org.apache.hadoop.shaded.org.apache.zookeeper.cli.CliException;
import org.apache.hadoop.shaded.org.apache.zookeeper.cli.CliParseException;
import org.apache.hadoop.shaded.org.apache.zookeeper.cli.CliWrapperException;
import org.apache.hadoop.shaded.org.apache.zookeeper.cli.MalformedPathException;

public class GetEphemeralsCommand
extends CliCommand {
    private static Options options = new Options();
    private String[] args;

    public GetEphemeralsCommand() {
        super("getEphemerals", "path");
    }

    @Override
    public CliCommand parse(String[] cmdArgs) throws CliParseException {
        CommandLine cl;
        PosixParser parser = new PosixParser();
        try {
            cl = parser.parse(options, cmdArgs);
        }
        catch (ParseException ex) {
            throw new CliParseException(ex);
        }
        this.args = cl.getArgs();
        return this;
    }

    @Override
    public boolean exec() throws CliException {
        List<String> ephemerals;
        try {
            if (this.args.length < 2) {
                ephemerals = this.zk.getEphemerals();
            } else {
                String path = this.args[1];
                ephemerals = this.zk.getEphemerals(path);
            }
        }
        catch (IllegalArgumentException ex) {
            throw new MalformedPathException(ex.getMessage());
        }
        catch (InterruptedException | KeeperException ex) {
            throw new CliWrapperException(ex);
        }
        this.out.println(ephemerals);
        return false;
    }
}

