/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.shaded.org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.hadoop.shaded.org.apache.commons.lang3.tuple.Pair;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.AbstractQueueCapacityCalculator;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CalculationContext;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.DefaultQueueResourceRoundingStrategy;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.ManagedParentQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.QueueCapacityUpdateContext;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.QueueCapacityVector;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.QueueResourceRoundingStrategy;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.QueueUpdateWarning;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.ResourceVector;

public class ResourceCalculationDriver {
    private static final QueueCapacityVector.ResourceUnitCapacityType[] CALCULATOR_PRECEDENCE = new QueueCapacityVector.ResourceUnitCapacityType[]{QueueCapacityVector.ResourceUnitCapacityType.ABSOLUTE, QueueCapacityVector.ResourceUnitCapacityType.PERCENTAGE, QueueCapacityVector.ResourceUnitCapacityType.WEIGHT};
    static final String MB_UNIT = "Mi";
    protected final QueueResourceRoundingStrategy roundingStrategy = new DefaultQueueResourceRoundingStrategy(CALCULATOR_PRECEDENCE);
    protected final CSQueue queue;
    protected final QueueCapacityUpdateContext updateContext;
    protected final Map<QueueCapacityVector.ResourceUnitCapacityType, AbstractQueueCapacityCalculator> calculators;
    protected final Collection<String> definedResources;
    protected final Map<String, ResourceVector> overallRemainingResourcePerLabel = new HashMap<String, ResourceVector>();
    protected final Map<String, ResourceVector> batchRemainingResourcePerLabel = new HashMap<String, ResourceVector>();
    protected final Map<String, ResourceVector> normalizedResourceRatioPerLabel = new HashMap<String, ResourceVector>();
    protected final Map<String, Map<String, Double>> sumWeightsPerLabel = new HashMap<String, Map<String, Double>>();
    protected Map<String, Double> usedResourceByCurrentCalculatorPerLabel = new HashMap<String, Double>();

    public ResourceCalculationDriver(CSQueue queue, QueueCapacityUpdateContext updateContext, Map<QueueCapacityVector.ResourceUnitCapacityType, AbstractQueueCapacityCalculator> calculators, Collection<String> definedResources) {
        this.queue = queue;
        this.updateContext = updateContext;
        this.calculators = calculators;
        this.definedResources = definedResources;
    }

    public CSQueue getQueue() {
        return this.queue;
    }

    public Collection<CSQueue> getChildQueues() {
        return this.queue.getChildQueues();
    }

    public QueueCapacityUpdateContext getUpdateContext() {
        return this.updateContext;
    }

    public void incrementWeight(String label, String resourceName, double value) {
        this.sumWeightsPerLabel.putIfAbsent(label, new HashMap());
        this.sumWeightsPerLabel.get(label).put(resourceName, this.sumWeightsPerLabel.get(label).getOrDefault(resourceName, 0.0) + value);
    }

    public double getSumWeightsByResource(String label, String resourceName) {
        return this.sumWeightsPerLabel.get(label).get(resourceName);
    }

    public Map<String, ResourceVector> getNormalizedResourceRatios() {
        return this.normalizedResourceRatioPerLabel;
    }

    public double getRemainingRatioOfResource(String label, String resourceName) {
        return this.batchRemainingResourcePerLabel.get(label).getValue(resourceName) / (double)this.queue.getEffectiveCapacity(label).getResourceValue(resourceName);
    }

    public double getParentAbsoluteMinCapacity(String label, String resourceName) {
        return (double)this.queue.getEffectiveCapacity(label).getResourceValue(resourceName) / (double)this.getUpdateContext().getUpdatedClusterResource(label).getResourceValue(resourceName);
    }

    public double getParentAbsoluteMaxCapacity(String label, String resourceName) {
        return (double)this.queue.getEffectiveMaxCapacity(label).getResourceValue(resourceName) / (double)this.getUpdateContext().getUpdatedClusterResource(label).getResourceValue(resourceName);
    }

    public ResourceVector getBatchRemainingResource(String label) {
        this.batchRemainingResourcePerLabel.putIfAbsent(label, ResourceVector.newInstance());
        return this.batchRemainingResourcePerLabel.get(label);
    }

    public void calculateResources() {
        for (String label : this.queue.getConfiguredNodeLabels()) {
            this.overallRemainingResourcePerLabel.put(label, ResourceVector.of(this.queue.getEffectiveCapacity(label)));
            this.batchRemainingResourcePerLabel.put(label, ResourceVector.of(this.queue.getEffectiveCapacity(label)));
        }
        for (AbstractQueueCapacityCalculator capacityCalculator : this.calculators.values()) {
            capacityCalculator.calculateResourcePrerequisites(this);
        }
        for (String resourceName : this.definedResources) {
            for (QueueCapacityVector.ResourceUnitCapacityType capacityType : CALCULATOR_PRECEDENCE) {
                for (CSQueue cSQueue : this.getChildQueues()) {
                    CalculationContext context = new CalculationContext(resourceName, capacityType, cSQueue);
                    this.calculateResourceOnChild(context);
                }
                for (Map.Entry entry : this.usedResourceByCurrentCalculatorPerLabel.entrySet()) {
                    this.batchRemainingResourcePerLabel.get(entry.getKey()).decrement(resourceName, (Double)entry.getValue());
                }
                this.usedResourceByCurrentCalculatorPerLabel = new HashMap<String, Double>();
            }
        }
        this.validateRemainingResource();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void calculateResourceOnChild(CalculationContext context) {
        context.getQueue().getWriteLock().lock();
        try {
            for (String label : context.getQueue().getConfiguredNodeLabels()) {
                if (!context.getQueue().getConfiguredCapacityVector(label).isResourceOfType(context.getResourceName(), context.getCapacityType())) continue;
                double usedResourceByChild = this.setChildResources(context, label);
                double aggregatedUsedResource = this.usedResourceByCurrentCalculatorPerLabel.getOrDefault(label, 0.0);
                double resourceUsedByLabel = aggregatedUsedResource + usedResourceByChild;
                this.overallRemainingResourcePerLabel.get(label).decrement(context.getResourceName(), usedResourceByChild);
                this.usedResourceByCurrentCalculatorPerLabel.put(label, resourceUsedByLabel);
            }
        }
        finally {
            context.getQueue().getWriteLock().unlock();
        }
    }

    private double setChildResources(CalculationContext context, String label) {
        QueueCapacityVector.QueueCapacityVectorEntry capacityVectorEntry = context.getQueue().getConfiguredCapacityVector(label).getResource(context.getResourceName());
        QueueCapacityVector.QueueCapacityVectorEntry maximumCapacityVectorEntry = context.getQueue().getConfiguredMaxCapacityVector(label).getResource(context.getResourceName());
        AbstractQueueCapacityCalculator maximumCapacityCalculator = this.calculators.get((Object)maximumCapacityVectorEntry.getVectorResourceType());
        double minimumResource = this.calculators.get((Object)context.getCapacityType()).calculateMinimumResource(this, context, label);
        double maximumResource = maximumCapacityCalculator.calculateMaximumResource(this, context, label);
        minimumResource = this.roundingStrategy.getRoundedResource(minimumResource, capacityVectorEntry);
        maximumResource = this.roundingStrategy.getRoundedResource(maximumResource, maximumCapacityVectorEntry);
        Pair<Double, Double> resources = this.validateCalculatedResources(context, label, (Pair<Double, Double>)new ImmutablePair((Object)minimumResource, (Object)maximumResource));
        minimumResource = (Double)resources.getLeft();
        maximumResource = (Double)resources.getRight();
        context.getQueue().getQueueResourceQuotas().getEffectiveMinResource(label).setResourceValue(context.getResourceName(), (long)minimumResource);
        context.getQueue().getQueueResourceQuotas().getEffectiveMaxResource(label).setResourceValue(context.getResourceName(), (long)maximumResource);
        return minimumResource;
    }

    private Pair<Double, Double> validateCalculatedResources(CalculationContext context, String label, Pair<Double, Double> calculatedResources) {
        double minimumResource = (Double)calculatedResources.getLeft();
        long minimumMemoryResource = context.getQueue().getQueueResourceQuotas().getEffectiveMinResource(label).getMemorySize();
        double remainingResourceUnderParent = this.overallRemainingResourcePerLabel.get(label).getValue(context.getResourceName());
        long parentMaximumResource = this.queue.getEffectiveMaxCapacity(label).getResourceValue(context.getResourceName());
        double maximumResource = (Double)calculatedResources.getRight();
        if (!context.getResourceName().equals("memory-mb") && minimumMemoryResource == 0L) {
            minimumResource = 0.0;
        }
        if (maximumResource != 0.0 && maximumResource > (double)parentMaximumResource) {
            this.updateContext.addUpdateWarning(QueueUpdateWarning.QueueUpdateWarningType.QUEUE_MAX_RESOURCE_EXCEEDS_PARENT.ofQueue(context.getQueue().getQueuePath()));
        }
        double d = maximumResource = maximumResource == 0.0 ? (double)parentMaximumResource : Math.min(maximumResource, (double)parentMaximumResource);
        if (maximumResource < minimumResource) {
            this.updateContext.addUpdateWarning(QueueUpdateWarning.QueueUpdateWarningType.QUEUE_EXCEEDS_MAX_RESOURCE.ofQueue(context.getQueue().getQueuePath()));
            minimumResource = maximumResource;
        }
        if (minimumResource > remainingResourceUnderParent) {
            if (this.queue instanceof ManagedParentQueue) {
                minimumResource = 0.0;
            } else {
                this.updateContext.addUpdateWarning(QueueUpdateWarning.QueueUpdateWarningType.QUEUE_OVERUTILIZED.ofQueue(context.getQueue().getQueuePath()).withInfo("Resource name: " + context.getResourceName() + " resource value: " + minimumResource));
                minimumResource = remainingResourceUnderParent;
            }
        }
        if (minimumResource == 0.0) {
            this.updateContext.addUpdateWarning(QueueUpdateWarning.QueueUpdateWarningType.QUEUE_ZERO_RESOURCE.ofQueue(context.getQueue().getQueuePath()).withInfo("Resource name: " + context.getResourceName()));
        }
        return new ImmutablePair((Object)minimumResource, (Object)maximumResource);
    }

    private void validateRemainingResource() {
        for (String label : this.queue.getConfiguredNodeLabels()) {
            if (this.batchRemainingResourcePerLabel.get(label).equals(ResourceVector.newInstance())) continue;
            this.updateContext.addUpdateWarning(QueueUpdateWarning.QueueUpdateWarningType.BRANCH_UNDERUTILIZED.ofQueue(this.queue.getQueuePath()).withInfo("Label: " + label));
        }
    }
}

