/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode;

import java.util.HashMap;
import java.util.Stack;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.server.common.AutoCloseDataSetLock;
import org.apache.hadoop.hdfs.server.common.DataNodeLockManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataSetLockManager
implements DataNodeLockManager<AutoCloseDataSetLock> {
    public static final Logger LOG = LoggerFactory.getLogger(DataSetLockManager.class);
    private final HashMap<String, TrackLog> threadCountMap = new HashMap();
    private final LockMap lockMap = new LockMap();
    private boolean isFair = true;
    private final boolean openLockTrace;
    private Exception lastException;

    private String generateLockName(DataNodeLockManager.LockLevel level, String ... resources) {
        if (resources.length == 1 && level == DataNodeLockManager.LockLevel.BLOCK_POOl) {
            if (resources[0] == null) {
                throw new IllegalArgumentException("acquire a null block pool lock");
            }
            return resources[0];
        }
        if (resources.length == 2 && level == DataNodeLockManager.LockLevel.VOLUME) {
            if (resources[0] == null || resources[1] == null) {
                throw new IllegalArgumentException("acquire a null bp lock : " + resources[0] + "volume lock :" + resources[1]);
            }
            return resources[0] + resources[1];
        }
        throw new IllegalArgumentException("lock level do not match resource");
    }

    public DataSetLockManager(Configuration conf) {
        this.isFair = conf.getBoolean("dfs.datanode.lock.fair", true);
        this.openLockTrace = conf.getBoolean("dfs.datanode.lockmanager.trace", false);
    }

    public DataSetLockManager() {
        this.openLockTrace = true;
    }

    @Override
    public AutoCloseDataSetLock readLock(DataNodeLockManager.LockLevel level, String ... resources) {
        if (level == DataNodeLockManager.LockLevel.BLOCK_POOl) {
            return this.getReadLock(level, resources[0]);
        }
        AutoCloseDataSetLock bpLock = this.getReadLock(DataNodeLockManager.LockLevel.BLOCK_POOl, resources[0]);
        AutoCloseDataSetLock volLock = this.getReadLock(level, resources);
        volLock.setParentLock(bpLock);
        if (this.openLockTrace) {
            LOG.info("Sub lock " + resources[0] + resources[1] + " parent lock " + resources[0]);
        }
        return volLock;
    }

    @Override
    public AutoCloseDataSetLock writeLock(DataNodeLockManager.LockLevel level, String ... resources) {
        if (level == DataNodeLockManager.LockLevel.BLOCK_POOl) {
            return this.getWriteLock(level, resources[0]);
        }
        AutoCloseDataSetLock bpLock = this.getReadLock(DataNodeLockManager.LockLevel.BLOCK_POOl, resources[0]);
        AutoCloseDataSetLock volLock = this.getWriteLock(level, resources);
        volLock.setParentLock(bpLock);
        if (this.openLockTrace) {
            LOG.info("Sub lock " + resources[0] + resources[1] + " parent lock " + resources[0]);
        }
        return volLock;
    }

    private AutoCloseDataSetLock getReadLock(DataNodeLockManager.LockLevel level, String ... resources) {
        String lockName = this.generateLockName(level, resources);
        AutoCloseDataSetLock lock = this.lockMap.getReadLock(lockName);
        if (lock == null) {
            LOG.warn("Ignore this error during dn restart: Not existing readLock " + lockName);
            this.lockMap.addLock(lockName, new ReentrantReadWriteLock(this.isFair));
            lock = this.lockMap.getReadLock(lockName);
        }
        lock.lock();
        if (this.openLockTrace) {
            this.putThreadName(this.getThreadName());
        }
        return lock;
    }

    private AutoCloseDataSetLock getWriteLock(DataNodeLockManager.LockLevel level, String ... resources) {
        String lockName = this.generateLockName(level, resources);
        AutoCloseDataSetLock lock = this.lockMap.getWriteLock(lockName);
        if (lock == null) {
            LOG.warn("Ignore this error during dn restart: Not existing writeLock" + lockName);
            this.lockMap.addLock(lockName, new ReentrantReadWriteLock(this.isFair));
            lock = this.lockMap.getWriteLock(lockName);
        }
        lock.lock();
        if (this.openLockTrace) {
            this.putThreadName(this.getThreadName());
        }
        return lock;
    }

    @Override
    public void addLock(DataNodeLockManager.LockLevel level, String ... resources) {
        String lockName = this.generateLockName(level, resources);
        if (level == DataNodeLockManager.LockLevel.BLOCK_POOl) {
            this.lockMap.addLock(lockName, new ReentrantReadWriteLock(this.isFair));
        } else {
            this.lockMap.addLock(resources[0], new ReentrantReadWriteLock(this.isFair));
            this.lockMap.addLock(lockName, new ReentrantReadWriteLock(this.isFair));
        }
    }

    @Override
    public void removeLock(DataNodeLockManager.LockLevel level, String ... resources) {
        String lockName = this.generateLockName(level, resources);
        try (AutoCloseDataSetLock lock = this.writeLock(level, resources);){
            this.lockMap.removeLock(lockName);
        }
    }

    @Override
    public void hook() {
        if (this.openLockTrace) {
            this.removeThreadName(this.getThreadName());
        }
    }

    private synchronized void putThreadName(String thread) {
        if (this.threadCountMap.containsKey(thread)) {
            TrackLog trackLog = this.threadCountMap.get(thread);
            trackLog.incrLockCount();
        }
        this.threadCountMap.putIfAbsent(thread, new TrackLog(thread));
    }

    public void lockLeakCheck() {
        if (!this.openLockTrace) {
            LOG.warn("not open lock leak check func");
            return;
        }
        if (this.threadCountMap.isEmpty()) {
            LOG.warn("all lock has release");
            return;
        }
        this.setLastException(new Exception("lock Leak"));
        this.threadCountMap.forEach((name, trackLog) -> trackLog.showLockMessage());
    }

    private synchronized void removeThreadName(String thread) {
        if (this.threadCountMap.containsKey(thread)) {
            TrackLog trackLog = this.threadCountMap.get(thread);
            if (trackLog.shouldClear()) {
                this.threadCountMap.remove(thread);
                return;
            }
            trackLog.decrLockCount();
        }
    }

    private void setLastException(Exception e) {
        this.lastException = e;
    }

    public Exception getLastException() {
        return this.lastException;
    }

    private String getThreadName() {
        return Thread.currentThread().getName() + Thread.currentThread().getId();
    }

    private static class TrackLog {
        private final Stack<Exception> logStack = new Stack();
        private int lockCount = 0;
        private final String threadName;

        TrackLog(String threadName) {
            this.threadName = threadName;
            this.incrLockCount();
        }

        public void incrLockCount() {
            this.logStack.push(new Exception("lock stack trace"));
            ++this.lockCount;
        }

        public void decrLockCount() {
            this.logStack.pop();
            --this.lockCount;
        }

        public void showLockMessage() {
            LOG.error("hold lock thread name is:" + this.threadName + " hold count is:" + this.lockCount);
            while (!this.logStack.isEmpty()) {
                Exception e = this.logStack.pop();
                LOG.error("lock stack ", (Throwable)e);
            }
        }

        public boolean shouldClear() {
            return this.lockCount == 1;
        }
    }

    private class LockMap {
        private final HashMap<String, AutoCloseDataSetLock> readlockMap = new HashMap();
        private final HashMap<String, AutoCloseDataSetLock> writeLockMap = new HashMap();

        private LockMap() {
        }

        public synchronized void addLock(String name, ReentrantReadWriteLock lock) {
            AutoCloseDataSetLock readLock = new AutoCloseDataSetLock(lock.readLock());
            AutoCloseDataSetLock writeLock = new AutoCloseDataSetLock(lock.writeLock());
            if (DataSetLockManager.this.openLockTrace) {
                readLock.setDataNodeLockManager(DataSetLockManager.this);
                writeLock.setDataNodeLockManager(DataSetLockManager.this);
            }
            this.readlockMap.putIfAbsent(name, readLock);
            this.writeLockMap.putIfAbsent(name, writeLock);
        }

        public synchronized void removeLock(String name) {
            if (!this.readlockMap.containsKey(name) || !this.writeLockMap.containsKey(name)) {
                LOG.error("The lock " + name + " is not in LockMap");
            }
            this.readlockMap.remove(name);
            this.writeLockMap.remove(name);
        }

        public synchronized AutoCloseDataSetLock getReadLock(String name) {
            return this.readlockMap.get(name);
        }

        public synchronized AutoCloseDataSetLock getWriteLock(String name) {
            return this.writeLockMap.get(name);
        }
    }
}

