/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.federation.utils;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.retry.RetryPolicies;
import org.apache.hadoop.io.retry.RetryPolicy;
import org.apache.hadoop.io.retry.RetryProxy;
import org.apache.hadoop.security.token.delegation.DelegationKey;
import org.apache.hadoop.shaded.com.zaxxer.hikari.pool.HikariPool;
import org.apache.hadoop.shaded.javax.cache.integration.CacheLoaderException;
import org.apache.hadoop.shaded.org.apache.commons.collections.CollectionUtils;
import org.apache.hadoop.shaded.org.apache.commons.collections.MapUtils;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.util.Time;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.api.records.ReservationId;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.security.client.RMDelegationTokenIdentifier;
import org.apache.hadoop.yarn.security.client.YARNDelegationTokenIdentifier;
import org.apache.hadoop.yarn.server.federation.cache.FederationCache;
import org.apache.hadoop.yarn.server.federation.policies.exceptions.FederationPolicyException;
import org.apache.hadoop.yarn.server.federation.resolver.SubClusterResolver;
import org.apache.hadoop.yarn.server.federation.store.FederationStateStore;
import org.apache.hadoop.yarn.server.federation.store.exception.FederationStateStoreRetriableException;
import org.apache.hadoop.yarn.server.federation.store.records.AddApplicationHomeSubClusterRequest;
import org.apache.hadoop.yarn.server.federation.store.records.AddApplicationHomeSubClusterResponse;
import org.apache.hadoop.yarn.server.federation.store.records.AddReservationHomeSubClusterRequest;
import org.apache.hadoop.yarn.server.federation.store.records.AddReservationHomeSubClusterResponse;
import org.apache.hadoop.yarn.server.federation.store.records.ApplicationHomeSubCluster;
import org.apache.hadoop.yarn.server.federation.store.records.DeleteReservationHomeSubClusterRequest;
import org.apache.hadoop.yarn.server.federation.store.records.GetApplicationHomeSubClusterRequest;
import org.apache.hadoop.yarn.server.federation.store.records.GetApplicationHomeSubClusterResponse;
import org.apache.hadoop.yarn.server.federation.store.records.GetReservationHomeSubClusterRequest;
import org.apache.hadoop.yarn.server.federation.store.records.GetReservationHomeSubClusterResponse;
import org.apache.hadoop.yarn.server.federation.store.records.GetSubClusterInfoRequest;
import org.apache.hadoop.yarn.server.federation.store.records.GetSubClusterInfoResponse;
import org.apache.hadoop.yarn.server.federation.store.records.GetSubClusterPoliciesConfigurationsRequest;
import org.apache.hadoop.yarn.server.federation.store.records.GetSubClusterPolicyConfigurationRequest;
import org.apache.hadoop.yarn.server.federation.store.records.GetSubClusterPolicyConfigurationResponse;
import org.apache.hadoop.yarn.server.federation.store.records.GetSubClustersInfoRequest;
import org.apache.hadoop.yarn.server.federation.store.records.ReservationHomeSubCluster;
import org.apache.hadoop.yarn.server.federation.store.records.RouterMasterKey;
import org.apache.hadoop.yarn.server.federation.store.records.RouterMasterKeyRequest;
import org.apache.hadoop.yarn.server.federation.store.records.RouterMasterKeyResponse;
import org.apache.hadoop.yarn.server.federation.store.records.RouterRMTokenRequest;
import org.apache.hadoop.yarn.server.federation.store.records.RouterRMTokenResponse;
import org.apache.hadoop.yarn.server.federation.store.records.RouterStoreToken;
import org.apache.hadoop.yarn.server.federation.store.records.SetSubClusterPolicyConfigurationRequest;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterDeregisterRequest;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterDeregisterResponse;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterId;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterInfo;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterPolicyConfiguration;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterState;
import org.apache.hadoop.yarn.server.federation.store.records.UpdateApplicationHomeSubClusterRequest;
import org.apache.hadoop.yarn.server.federation.store.records.UpdateReservationHomeSubClusterRequest;
import org.apache.hadoop.yarn.webapp.NotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FederationStateStoreFacade {
    private static final Logger LOG = LoggerFactory.getLogger(FederationStateStoreFacade.class);
    private static final FederationStateStoreFacade FACADE = new FederationStateStoreFacade();
    private static Random rand = new Random(System.currentTimeMillis());
    private FederationStateStore stateStore;
    private Configuration conf;
    private SubClusterResolver subclusterResolver;
    private FederationCache federationCache;

    private FederationStateStoreFacade() {
        this.initializeFacadeInternal(new Configuration());
    }

    private void initializeFacadeInternal(Configuration config) {
        this.conf = config;
        try {
            this.stateStore = (FederationStateStore)FederationStateStoreFacade.createRetryInstance(this.conf, "yarn.federation.state-store.class", "org.apache.hadoop.yarn.server.federation.store.impl.MemoryFederationStateStore", FederationStateStore.class, FederationStateStoreFacade.createRetryPolicy(this.conf));
            this.stateStore.init(this.conf);
            this.subclusterResolver = FederationStateStoreFacade.createInstance(this.conf, "yarn.federation.subcluster-resolver.class", "org.apache.hadoop.yarn.server.federation.resolver.DefaultSubClusterResolverImpl", SubClusterResolver.class);
            this.subclusterResolver.load();
            this.federationCache = FederationStateStoreFacade.createInstance(this.conf, "yarn.federation.cache.class", "org.apache.hadoop.yarn.server.federation.cache.FederationJCache", FederationCache.class);
            this.federationCache.initCache(config, this.stateStore);
        }
        catch (YarnException ex) {
            LOG.error("Failed to initialize the FederationStateStoreFacade object", (Throwable)ex);
            throw new RuntimeException(ex);
        }
    }

    @VisibleForTesting
    public synchronized void reinitialize(FederationStateStore store, Configuration config) {
        this.conf = config;
        this.stateStore = store;
        this.federationCache.clearCache();
        this.federationCache.initCache(config, this.stateStore);
    }

    public static RetryPolicy createRetryPolicy(Configuration conf) {
        RetryPolicy basePolicy = RetryPolicies.exponentialBackoffRetry((int)conf.getInt("yarn.client.failover-retries", 32), (long)conf.getLong("yarn.client.failover-sleep-base-ms", 30000L), (TimeUnit)TimeUnit.MILLISECONDS);
        HashMap<Class<HikariPool.PoolInitializationException>, RetryPolicy> exceptionToPolicyMap = new HashMap<Class<HikariPool.PoolInitializationException>, RetryPolicy>();
        exceptionToPolicyMap.put(FederationStateStoreRetriableException.class, basePolicy);
        exceptionToPolicyMap.put(CacheLoaderException.class, basePolicy);
        exceptionToPolicyMap.put(HikariPool.PoolInitializationException.class, basePolicy);
        RetryPolicy retryPolicy = RetryPolicies.retryByException((RetryPolicy)RetryPolicies.TRY_ONCE_THEN_FAIL, exceptionToPolicyMap);
        return retryPolicy;
    }

    public static FederationStateStoreFacade getInstance() {
        return FACADE;
    }

    public SubClusterInfo getSubCluster(SubClusterId subClusterId) throws YarnException {
        if (this.federationCache.isCachingEnabled()) {
            return this.getSubClusters(false).get(subClusterId);
        }
        GetSubClusterInfoResponse response = this.stateStore.getSubCluster(GetSubClusterInfoRequest.newInstance(subClusterId));
        if (response == null) {
            return null;
        }
        return response.getSubClusterInfo();
    }

    public SubClusterInfo getSubCluster(SubClusterId subClusterId, boolean flushCache) throws YarnException {
        if (flushCache && this.federationCache.isCachingEnabled()) {
            LOG.info("Flushing subClusters from cache and rehydrating from store, most likely on account of RM failover.");
            this.federationCache.removeSubCluster(false);
        }
        return this.getSubCluster(subClusterId);
    }

    public Map<SubClusterId, SubClusterInfo> getSubClusters(boolean filterInactiveSubClusters) throws YarnException {
        try {
            if (this.federationCache.isCachingEnabled()) {
                return this.federationCache.getSubClusters(filterInactiveSubClusters);
            }
            GetSubClustersInfoRequest request = GetSubClustersInfoRequest.newInstance(filterInactiveSubClusters);
            return FederationCache.buildSubClusterInfoMap(this.stateStore.getSubClusters(request));
        }
        catch (Throwable ex) {
            throw new YarnException(ex);
        }
    }

    public Map<SubClusterId, SubClusterInfo> getSubClusters(boolean filterInactiveSubClusters, boolean flushCache) throws YarnException {
        if (flushCache && this.federationCache.isCachingEnabled()) {
            LOG.info("Flushing subClusters from cache and rehydrating from store.");
            this.federationCache.removeSubCluster(flushCache);
        }
        return this.getSubClusters(filterInactiveSubClusters);
    }

    public SubClusterPolicyConfiguration getPolicyConfiguration(String queue) throws YarnException {
        if (this.federationCache.isCachingEnabled()) {
            return this.getPoliciesConfigurations().get(queue);
        }
        GetSubClusterPolicyConfigurationRequest request = GetSubClusterPolicyConfigurationRequest.newInstance(queue);
        GetSubClusterPolicyConfigurationResponse response = this.stateStore.getPolicyConfiguration(request);
        if (response == null) {
            return null;
        }
        return response.getPolicyConfiguration();
    }

    public void setPolicyConfiguration(SubClusterPolicyConfiguration policyConf) throws YarnException {
        this.stateStore.setPolicyConfiguration(SetSubClusterPolicyConfigurationRequest.newInstance(policyConf));
    }

    public Map<String, SubClusterPolicyConfiguration> getPoliciesConfigurations() throws YarnException {
        try {
            if (this.federationCache.isCachingEnabled()) {
                return this.federationCache.getPoliciesConfigurations();
            }
            GetSubClusterPoliciesConfigurationsRequest request = GetSubClusterPoliciesConfigurationsRequest.newInstance();
            return FederationCache.buildPolicyConfigMap(this.stateStore.getPoliciesConfigurations(request));
        }
        catch (Throwable ex) {
            throw new YarnException(ex);
        }
    }

    public SubClusterId addApplicationHomeSubCluster(ApplicationHomeSubCluster appHomeSubCluster) throws YarnException {
        AddApplicationHomeSubClusterResponse response = this.stateStore.addApplicationHomeSubCluster(AddApplicationHomeSubClusterRequest.newInstance(appHomeSubCluster));
        return response.getHomeSubCluster();
    }

    public void updateApplicationHomeSubCluster(ApplicationHomeSubCluster appHomeSubCluster) throws YarnException {
        this.stateStore.updateApplicationHomeSubCluster(UpdateApplicationHomeSubClusterRequest.newInstance(appHomeSubCluster));
    }

    public SubClusterId getApplicationHomeSubCluster(ApplicationId appId) throws YarnException {
        try {
            if (this.federationCache.isCachingEnabled()) {
                return this.federationCache.getApplicationHomeSubCluster(appId);
            }
            GetApplicationHomeSubClusterResponse response = this.stateStore.getApplicationHomeSubCluster(GetApplicationHomeSubClusterRequest.newInstance(appId));
            return response.getApplicationHomeSubCluster().getHomeSubCluster();
        }
        catch (Throwable ex) {
            throw new YarnException(ex);
        }
    }

    public SubClusterResolver getSubClusterResolver() {
        return this.subclusterResolver;
    }

    public Configuration getConf() {
        return this.conf;
    }

    public SubClusterId addReservationHomeSubCluster(ReservationHomeSubCluster appHomeSubCluster) throws YarnException {
        AddReservationHomeSubClusterResponse response = this.stateStore.addReservationHomeSubCluster(AddReservationHomeSubClusterRequest.newInstance(appHomeSubCluster));
        return response.getHomeSubCluster();
    }

    public SubClusterId getReservationHomeSubCluster(ReservationId reservationId) throws YarnException {
        GetReservationHomeSubClusterResponse response = this.stateStore.getReservationHomeSubCluster(GetReservationHomeSubClusterRequest.newInstance(reservationId));
        return response.getReservationHomeSubCluster().getHomeSubCluster();
    }

    public void updateReservationHomeSubCluster(ReservationHomeSubCluster appHomeSubCluster) throws YarnException {
        UpdateReservationHomeSubClusterRequest request = UpdateReservationHomeSubClusterRequest.newInstance(appHomeSubCluster);
        this.stateStore.updateReservationHomeSubCluster(request);
    }

    public void deleteReservationHomeSubCluster(ReservationId reservationId) throws YarnException {
        DeleteReservationHomeSubClusterRequest request = DeleteReservationHomeSubClusterRequest.newInstance(reservationId);
        this.stateStore.deleteReservationHomeSubCluster(request);
    }

    public static <T> Object createRetryInstance(Configuration conf, String configuredClassName, String defaultValue, Class<T> type, RetryPolicy retryPolicy) {
        return RetryProxy.create(type, FederationStateStoreFacade.createInstance(conf, configuredClassName, defaultValue, type), (RetryPolicy)retryPolicy);
    }

    public static <T> T createInstance(Configuration conf, String configuredClassName, String defaultValue, Class<T> type) {
        String className = conf.get(configuredClassName, defaultValue);
        try {
            Class clusterResolverClass = conf.getClassByName(className);
            if (type.isAssignableFrom(clusterResolverClass)) {
                return (T)ReflectionUtils.newInstance((Class)clusterResolverClass, (Configuration)conf);
            }
            throw new YarnRuntimeException("Class: " + className + " not instance of " + type.getCanonicalName());
        }
        catch (ClassNotFoundException e) {
            throw new YarnRuntimeException("Could not instantiate : " + className, (Throwable)e);
        }
    }

    @VisibleForTesting
    public FederationStateStore getStateStore() {
        return this.stateStore;
    }

    public RouterMasterKeyResponse storeNewMasterKey(DelegationKey newKey) throws YarnException, IOException {
        LOG.info("Storing master key with keyID {}.", (Object)newKey.getKeyId());
        ByteBuffer keyBytes = ByteBuffer.wrap(newKey.getEncodedKey());
        RouterMasterKey masterKey = RouterMasterKey.newInstance(newKey.getKeyId(), keyBytes, newKey.getExpiryDate());
        RouterMasterKeyRequest keyRequest = RouterMasterKeyRequest.newInstance(masterKey);
        return this.stateStore.storeNewMasterKey(keyRequest);
    }

    public void removeStoredMasterKey(DelegationKey newKey) throws YarnException, IOException {
        LOG.info("Removing master key with keyID {}.", (Object)newKey.getKeyId());
        ByteBuffer keyBytes = ByteBuffer.wrap(newKey.getEncodedKey());
        RouterMasterKey masterKey = RouterMasterKey.newInstance(newKey.getKeyId(), keyBytes, newKey.getExpiryDate());
        RouterMasterKeyRequest keyRequest = RouterMasterKeyRequest.newInstance(masterKey);
        this.stateStore.removeStoredMasterKey(keyRequest);
    }

    public RouterMasterKeyResponse getMasterKeyByDelegationKey(DelegationKey newKey) throws YarnException, IOException {
        LOG.info("Storing master key with keyID {}.", (Object)newKey.getKeyId());
        ByteBuffer keyBytes = ByteBuffer.wrap(newKey.getEncodedKey());
        RouterMasterKey masterKey = RouterMasterKey.newInstance(newKey.getKeyId(), keyBytes, newKey.getExpiryDate());
        RouterMasterKeyRequest keyRequest = RouterMasterKeyRequest.newInstance(masterKey);
        return this.stateStore.getMasterKeyByDelegationKey(keyRequest);
    }

    public void storeNewToken(RMDelegationTokenIdentifier identifier, long renewDate) throws YarnException, IOException {
        LOG.info("storing RMDelegation token with sequence number: {}.", (Object)identifier.getSequenceNumber());
        RouterStoreToken storeToken = RouterStoreToken.newInstance((YARNDelegationTokenIdentifier)identifier, renewDate);
        RouterRMTokenRequest request = RouterRMTokenRequest.newInstance(storeToken);
        this.stateStore.storeNewToken(request);
    }

    public void storeNewToken(RMDelegationTokenIdentifier identifier, long renewDate, String tokenInfo) throws YarnException, IOException {
        LOG.info("storing RMDelegation token with sequence number: {}.", (Object)identifier.getSequenceNumber());
        RouterStoreToken storeToken = RouterStoreToken.newInstance((YARNDelegationTokenIdentifier)identifier, renewDate, tokenInfo);
        RouterRMTokenRequest request = RouterRMTokenRequest.newInstance(storeToken);
        this.stateStore.storeNewToken(request);
    }

    public void updateStoredToken(RMDelegationTokenIdentifier identifier, long renewDate) throws YarnException, IOException {
        LOG.info("updating RMDelegation token with sequence number: {}.", (Object)identifier.getSequenceNumber());
        RouterStoreToken storeToken = RouterStoreToken.newInstance((YARNDelegationTokenIdentifier)identifier, renewDate);
        RouterRMTokenRequest request = RouterRMTokenRequest.newInstance(storeToken);
        this.stateStore.updateStoredToken(request);
    }

    public void updateStoredToken(RMDelegationTokenIdentifier identifier, long renewDate, String tokenInfo) throws YarnException, IOException {
        LOG.info("updating RMDelegation token with sequence number: {}.", (Object)identifier.getSequenceNumber());
        RouterStoreToken storeToken = RouterStoreToken.newInstance((YARNDelegationTokenIdentifier)identifier, renewDate, tokenInfo);
        RouterRMTokenRequest request = RouterRMTokenRequest.newInstance(storeToken);
        this.stateStore.updateStoredToken(request);
    }

    public void removeStoredToken(RMDelegationTokenIdentifier identifier) throws YarnException, IOException {
        LOG.info("removing RMDelegation token with sequence number: {}.", (Object)identifier.getSequenceNumber());
        RouterStoreToken storeToken = RouterStoreToken.newInstance((YARNDelegationTokenIdentifier)identifier, 0L);
        RouterRMTokenRequest request = RouterRMTokenRequest.newInstance(storeToken);
        this.stateStore.removeStoredToken(request);
    }

    public RouterRMTokenResponse getTokenByRouterStoreToken(RMDelegationTokenIdentifier identifier) throws YarnException, IOException {
        LOG.info("get RouterStoreToken token with sequence number: {}.", (Object)identifier.getSequenceNumber());
        RouterStoreToken storeToken = RouterStoreToken.newInstance((YARNDelegationTokenIdentifier)identifier, 0L);
        RouterRMTokenRequest request = RouterRMTokenRequest.newInstance(storeToken);
        return this.stateStore.getTokenByRouterStoreToken(request);
    }

    public int incrementDelegationTokenSeqNum() {
        return this.stateStore.incrementDelegationTokenSeqNum();
    }

    public int getDelegationTokenSeqNum() {
        return this.stateStore.getDelegationTokenSeqNum();
    }

    public void setDelegationTokenSeqNum(int seqNum) {
        this.stateStore.setDelegationTokenSeqNum(seqNum);
    }

    public int getCurrentKeyId() {
        return this.stateStore.getCurrentKeyId();
    }

    public int incrementCurrentKeyId() {
        return this.stateStore.incrementCurrentKeyId();
    }

    public int getActiveSubClustersCount() throws YarnException {
        Map<SubClusterId, SubClusterInfo> activeSubClusters = this.getSubClusters(true);
        if (activeSubClusters == null || activeSubClusters.isEmpty()) {
            return 0;
        }
        return activeSubClusters.size();
    }

    public static SubClusterId getRandomActiveSubCluster(Map<SubClusterId, SubClusterInfo> activeSubClusters, List<SubClusterId> blackList) throws YarnException {
        if (MapUtils.isEmpty(activeSubClusters)) {
            throw new FederationPolicyException("No active SubCluster available to submit the request.");
        }
        ArrayList<SubClusterId> subClusterIds = new ArrayList<SubClusterId>(activeSubClusters.keySet());
        if (CollectionUtils.isNotEmpty(blackList)) {
            subClusterIds.removeAll(blackList);
        }
        if (CollectionUtils.isEmpty(subClusterIds)) {
            throw new FederationPolicyException("No active SubCluster available to submit the request.");
        }
        return (SubClusterId)subClusterIds.get(rand.nextInt(subClusterIds.size()));
    }

    public int getRetryNumbers(int configRetries) throws YarnException {
        int activeSubClustersCount = this.getActiveSubClustersCount();
        int actualRetryNums = Math.min(activeSubClustersCount, configRetries);
        if (actualRetryNums < 0) {
            return 0;
        }
        return actualRetryNums;
    }

    public boolean existsApplicationHomeSubCluster(ApplicationId applicationId) {
        try {
            SubClusterId subClusterId = this.getApplicationHomeSubCluster(applicationId);
            if (subClusterId != null) {
                return true;
            }
        }
        catch (YarnException e) {
            LOG.debug("get homeSubCluster by applicationId = {} error.", (Object)applicationId, (Object)e);
        }
        return false;
    }

    public void addApplicationHomeSubCluster(ApplicationId applicationId, ApplicationHomeSubCluster homeSubCluster) throws YarnException {
        try {
            this.addApplicationHomeSubCluster(homeSubCluster);
        }
        catch (YarnException e) {
            String msg = String.format("Unable to insert the ApplicationId %s into the FederationStateStore.", applicationId);
            throw new YarnException(msg, (Throwable)e);
        }
    }

    public void updateApplicationHomeSubCluster(SubClusterId subClusterId, ApplicationId applicationId, ApplicationHomeSubCluster homeSubCluster) throws YarnException {
        try {
            this.updateApplicationHomeSubCluster(homeSubCluster);
        }
        catch (YarnException e) {
            SubClusterId subClusterIdInStateStore = this.getApplicationHomeSubCluster(applicationId);
            if (subClusterId == subClusterIdInStateStore) {
                LOG.info("Application {} already submitted on SubCluster {}.", (Object)applicationId, (Object)subClusterId);
            }
            String msg = String.format("Unable to update the ApplicationId %s into the FederationStateStore.", applicationId);
            throw new YarnException(msg, (Throwable)e);
        }
    }

    public void addOrUpdateApplicationHomeSubCluster(ApplicationId applicationId, SubClusterId subClusterId, int retryCount, ApplicationSubmissionContext appSubmissionContext) throws YarnException {
        Boolean exists = this.existsApplicationHomeSubCluster(applicationId);
        ApplicationHomeSubCluster appHomeSubCluster = ApplicationHomeSubCluster.newInstance(applicationId, Time.now(), subClusterId, appSubmissionContext);
        if (!exists.booleanValue() || retryCount == 0) {
            this.addApplicationHomeSubCluster(applicationId, appHomeSubCluster);
        } else {
            this.updateApplicationHomeSubCluster(subClusterId, applicationId, appHomeSubCluster);
        }
    }

    public boolean existsReservationHomeSubCluster(ReservationId reservationId) {
        try {
            SubClusterId subClusterId = this.getReservationHomeSubCluster(reservationId);
            if (subClusterId != null) {
                return true;
            }
        }
        catch (YarnException e) {
            LOG.debug("get homeSubCluster by reservationId = {} error.", (Object)reservationId, (Object)e);
        }
        return false;
    }

    public void addReservationHomeSubCluster(ReservationId reservationId, ReservationHomeSubCluster homeSubCluster) throws YarnException {
        try {
            this.addReservationHomeSubCluster(homeSubCluster);
        }
        catch (YarnException e) {
            String msg = String.format("Unable to insert the ReservationId %s into the FederationStateStore.", reservationId);
            throw new YarnException(msg, (Throwable)e);
        }
    }

    public void updateReservationHomeSubCluster(SubClusterId subClusterId, ReservationId reservationId, ReservationHomeSubCluster homeSubCluster) throws YarnException {
        try {
            this.updateReservationHomeSubCluster(homeSubCluster);
        }
        catch (YarnException e) {
            SubClusterId subClusterIdInStateStore = this.getReservationHomeSubCluster(reservationId);
            if (subClusterId == subClusterIdInStateStore) {
                LOG.info("Reservation {} already submitted on SubCluster {}.", (Object)reservationId, (Object)subClusterId);
            }
            String msg = String.format("Unable to update the ReservationId %s into the FederationStateStore.", reservationId);
            throw new YarnException(msg, (Throwable)e);
        }
    }

    public void addOrUpdateReservationHomeSubCluster(ReservationId reservationId, SubClusterId subClusterId, int retryCount) throws YarnException {
        Boolean exists = this.existsReservationHomeSubCluster(reservationId);
        ReservationHomeSubCluster reservationHomeSubCluster = ReservationHomeSubCluster.newInstance(reservationId, subClusterId);
        if (!exists.booleanValue() || retryCount == 0) {
            this.addReservationHomeSubCluster(reservationId, reservationHomeSubCluster);
        } else {
            this.updateReservationHomeSubCluster(subClusterId, reservationId, reservationHomeSubCluster);
        }
    }

    public boolean deregisterSubCluster(SubClusterId subClusterId, SubClusterState subClusterState) throws YarnException {
        SubClusterDeregisterRequest deregisterRequest = SubClusterDeregisterRequest.newInstance(subClusterId, subClusterState);
        SubClusterDeregisterResponse response = this.stateStore.deregisterSubCluster(deregisterRequest);
        return response != null;
    }

    public Collection<SubClusterInfo> getActiveSubClusters() throws NotFoundException {
        try {
            Map<SubClusterId, SubClusterInfo> subClusterMap = this.getSubClusters(true);
            if (MapUtils.isEmpty(subClusterMap)) {
                throw new NotFoundException("Not Found SubClusters.");
            }
            return subClusterMap.values();
        }
        catch (Exception e) {
            LOG.error("getActiveSubClusters failed.", (Throwable)e);
            return null;
        }
    }

    public ApplicationSubmissionContext getApplicationSubmissionContext(ApplicationId appId) {
        try {
            GetApplicationHomeSubClusterResponse response = this.stateStore.getApplicationHomeSubCluster(GetApplicationHomeSubClusterRequest.newInstance(appId));
            ApplicationHomeSubCluster appHomeSubCluster = response.getApplicationHomeSubCluster();
            return appHomeSubCluster.getApplicationSubmissionContext();
        }
        catch (Exception e) {
            LOG.error("getApplicationSubmissionContext error, applicationId = {}.", (Object)appId, (Object)e);
            return null;
        }
    }

    @VisibleForTesting
    public FederationCache getFederationCache() {
        return this.federationCache;
    }
}

