/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.webproxy;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.shaded.org.apache.commons.lang3.tuple.Pair;
import org.apache.hadoop.yarn.api.ApplicationClientProtocol;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.client.ClientRMProxy;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.federation.failover.FederationProxyProviderUtil;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterId;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterInfo;
import org.apache.hadoop.yarn.server.federation.utils.FederationStateStoreFacade;
import org.apache.hadoop.yarn.server.webproxy.AppReportFetcher;
import org.apache.hadoop.yarn.util.StringHelper;
import org.apache.hadoop.yarn.webapp.util.WebAppUtils;

public class FedAppReportFetcher
extends AppReportFetcher {
    private final Map<SubClusterId, Pair<SubClusterInfo, ApplicationClientProtocol>> subClusters = new ConcurrentHashMap<SubClusterId, Pair<SubClusterInfo, ApplicationClientProtocol>>();
    private FederationStateStoreFacade federationFacade = FederationStateStoreFacade.getInstance();

    public FedAppReportFetcher(Configuration conf) {
        super(conf);
    }

    @Override
    public AppReportFetcher.FetchedAppReport getApplicationReport(ApplicationId appId) throws YarnException, IOException {
        SubClusterId scid = this.federationFacade.getApplicationHomeSubCluster(appId);
        this.createSubclusterIfAbsent(scid);
        ApplicationClientProtocol applicationsManager = (ApplicationClientProtocol)this.subClusters.get(scid).getRight();
        return super.getApplicationReport(applicationsManager, appId);
    }

    @Override
    public String getRmAppPageUrlBase(ApplicationId appId) throws IOException, YarnException {
        SubClusterId scid = this.federationFacade.getApplicationHomeSubCluster(appId);
        this.createSubclusterIfAbsent(scid);
        SubClusterInfo subClusterInfo = (SubClusterInfo)this.subClusters.get(scid).getLeft();
        String scheme = WebAppUtils.getHttpSchemePrefix((Configuration)this.getConf());
        return StringHelper.pjoin((Object[])new Object[]{scheme + subClusterInfo.getRMWebServiceAddress(), "cluster", "app"});
    }

    private void createSubclusterIfAbsent(SubClusterId scId) throws YarnException, IOException {
        if (this.subClusters.containsKey(scId)) {
            return;
        }
        SubClusterInfo subClusterInfo = this.federationFacade.getSubCluster(scId);
        Configuration subClusterConf = new Configuration(this.getConf());
        FederationProxyProviderUtil.updateConfForFederation(subClusterConf, subClusterInfo.getSubClusterId().toString());
        ApplicationClientProtocol proxy = (ApplicationClientProtocol)ClientRMProxy.createRMProxy((Configuration)subClusterConf, ApplicationClientProtocol.class);
        this.subClusters.put(scId, (Pair<SubClusterInfo, ApplicationClientProtocol>)Pair.of((Object)subClusterInfo, (Object)proxy));
    }

    @Override
    public void stop() {
        super.stop();
        for (Pair<SubClusterInfo, ApplicationClientProtocol> pair : this.subClusters.values()) {
            RPC.stopProxy((Object)pair.getRight());
        }
    }

    @VisibleForTesting
    public void registerSubCluster(SubClusterInfo info, ApplicationClientProtocol proxy) {
        this.subClusters.put(info.getSubClusterId(), (Pair<SubClusterInfo, ApplicationClientProtocol>)Pair.of((Object)info, (Object)proxy));
    }
}

