/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.apache.commons.net.finger;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.apache.hadoop.shaded.org.apache.commons.net.SocketClient;
import org.apache.hadoop.shaded.org.apache.commons.net.util.Charsets;

public class FingerClient
extends SocketClient {
    public static final int DEFAULT_PORT = 79;
    private static final String LONG_FLAG = "/W ";
    private final transient char[] buffer = new char[1024];

    public FingerClient() {
        this.setDefaultPort(79);
    }

    public String query(boolean longOutput, String username) throws IOException {
        StringBuilder result = new StringBuilder(this.buffer.length);
        try (BufferedReader input = new BufferedReader(new InputStreamReader(this.getInputStream(longOutput, username), this.getCharset()));){
            int read;
            while ((read = input.read(this.buffer, 0, this.buffer.length)) > 0) {
                result.append(this.buffer, 0, read);
            }
        }
        return result.toString();
    }

    public String query(boolean longOutput) throws IOException {
        return this.query(longOutput, "");
    }

    public InputStream getInputStream(boolean longOutput, String username) throws IOException {
        return this.getInputStream(longOutput, username, null);
    }

    public InputStream getInputStream(boolean longOutput, String username, String encoding) throws IOException {
        StringBuilder buffer = new StringBuilder(64);
        if (longOutput) {
            buffer.append(LONG_FLAG);
        }
        buffer.append(username);
        buffer.append("\r\n");
        byte[] encodedQuery = buffer.toString().getBytes(Charsets.toCharset(encoding).name());
        DataOutputStream output = new DataOutputStream(new BufferedOutputStream(this._output_, 1024));
        output.write(encodedQuery, 0, encodedQuery.length);
        output.flush();
        return this._input_;
    }

    public InputStream getInputStream(boolean longOutput) throws IOException {
        return this.getInputStream(longOutput, "");
    }
}

