/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.apache.kerby.kerberos.kerb.admin.kadmin.remote.command;

import java.io.File;
import java.util.List;
import org.apache.hadoop.shaded.org.apache.kerby.kerberos.kerb.KrbException;
import org.apache.hadoop.shaded.org.apache.kerby.kerberos.kerb.admin.kadmin.remote.AdminClient;
import org.apache.hadoop.shaded.org.apache.kerby.kerberos.kerb.admin.kadmin.remote.command.RemoteCommand;

public class RemoteKeytabAddCommand
extends RemoteCommand {
    private static final String USAGE = "Usage: ktadd [-k[eytab] keytab] [principal | -glob princ-exp] [...]\n\tExample:\n\t\tktadd hello@TEST.COM -k /keytab/location\n";
    private static final String DEFAULT_KEYTAB_FILE_LOCATION = "/etc/krb5.keytab";

    public RemoteKeytabAddCommand(AdminClient adminClient) {
        super(adminClient);
    }

    @Override
    public void execute(String input) throws KrbException {
        String[] items = input.split("\\s+");
        if (items.length < 2) {
            System.err.println(USAGE);
            return;
        }
        String principal = null;
        String keytabFileLocation = null;
        boolean glob = false;
        for (int index = 1; index < items.length; ++index) {
            String command = items[index];
            if (command.equals("-k")) {
                if (++index >= items.length) {
                    System.err.println(USAGE);
                    return;
                }
                keytabFileLocation = items[index].trim();
                continue;
            }
            if (command.equals("-glob")) {
                glob = true;
                continue;
            }
            if (command.startsWith("-")) continue;
            principal = command;
        }
        if (keytabFileLocation == null) {
            keytabFileLocation = DEFAULT_KEYTAB_FILE_LOCATION;
        }
        File keytabFile = new File(keytabFileLocation);
        if (principal == null) {
            System.out.println((glob ? "princ-exp" : "principal") + " not specified!");
            System.err.println(USAGE);
            return;
        }
        try {
            if (glob) {
                List<String> principals = this.adminClient.requestGetprincsWithExp(principal);
                this.adminClient.requestExportKeytab(keytabFile, principals);
            } else {
                this.adminClient.requestExportKeytab(keytabFile, principal);
            }
            System.out.println("Export Keytab to " + keytabFileLocation);
        }
        catch (KrbException e) {
            System.err.println("Principal \"" + principal + "\" fail to add entry to keytab. " + e.toString());
        }
    }
}

