/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.shell.find;

import java.io.IOException;
import java.util.LinkedList;
import org.apache.hadoop.fs.shell.PathData;
import org.apache.hadoop.fs.shell.find.And;
import org.apache.hadoop.fs.shell.find.Expression;
import org.apache.hadoop.fs.shell.find.FindOptions;
import org.apache.hadoop.fs.shell.find.Result;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class TestAnd {
    @Test(timeout=1000L)
    public void testPass() throws IOException {
        And and = new And();
        PathData pathData = (PathData)Mockito.mock(PathData.class);
        Expression first = (Expression)Mockito.mock(Expression.class);
        Mockito.when((Object)first.apply(pathData, -1)).thenReturn((Object)Result.PASS);
        Expression second = (Expression)Mockito.mock(Expression.class);
        Mockito.when((Object)second.apply(pathData, -1)).thenReturn((Object)Result.PASS);
        LinkedList<Expression> children = new LinkedList<Expression>();
        children.add(second);
        children.add(first);
        and.addChildren(children);
        Assert.assertEquals((Object)Result.PASS, (Object)and.apply(pathData, -1));
        ((Expression)Mockito.verify((Object)first)).apply(pathData, -1);
        ((Expression)Mockito.verify((Object)second)).apply(pathData, -1);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{first});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{second});
    }

    @Test(timeout=1000L)
    public void testFailFirst() throws IOException {
        And and = new And();
        PathData pathData = (PathData)Mockito.mock(PathData.class);
        Expression first = (Expression)Mockito.mock(Expression.class);
        Mockito.when((Object)first.apply(pathData, -1)).thenReturn((Object)Result.FAIL);
        Expression second = (Expression)Mockito.mock(Expression.class);
        Mockito.when((Object)second.apply(pathData, -1)).thenReturn((Object)Result.PASS);
        LinkedList<Expression> children = new LinkedList<Expression>();
        children.add(second);
        children.add(first);
        and.addChildren(children);
        Assert.assertEquals((Object)Result.FAIL, (Object)and.apply(pathData, -1));
        ((Expression)Mockito.verify((Object)first)).apply(pathData, -1);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{first});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{second});
    }

    @Test(timeout=1000L)
    public void testFailSecond() throws IOException {
        And and = new And();
        PathData pathData = (PathData)Mockito.mock(PathData.class);
        Expression first = (Expression)Mockito.mock(Expression.class);
        Mockito.when((Object)first.apply(pathData, -1)).thenReturn((Object)Result.PASS);
        Expression second = (Expression)Mockito.mock(Expression.class);
        Mockito.when((Object)second.apply(pathData, -1)).thenReturn((Object)Result.FAIL);
        LinkedList<Expression> children = new LinkedList<Expression>();
        children.add(second);
        children.add(first);
        and.addChildren(children);
        Assert.assertEquals((Object)Result.FAIL, (Object)and.apply(pathData, -1));
        ((Expression)Mockito.verify((Object)first)).apply(pathData, -1);
        ((Expression)Mockito.verify((Object)second)).apply(pathData, -1);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{first});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{second});
    }

    @Test(timeout=1000L)
    public void testFailBoth() throws IOException {
        And and = new And();
        PathData pathData = (PathData)Mockito.mock(PathData.class);
        Expression first = (Expression)Mockito.mock(Expression.class);
        Mockito.when((Object)first.apply(pathData, -1)).thenReturn((Object)Result.FAIL);
        Expression second = (Expression)Mockito.mock(Expression.class);
        Mockito.when((Object)second.apply(pathData, -1)).thenReturn((Object)Result.FAIL);
        LinkedList<Expression> children = new LinkedList<Expression>();
        children.add(second);
        children.add(first);
        and.addChildren(children);
        Assert.assertEquals((Object)Result.FAIL, (Object)and.apply(pathData, -1));
        ((Expression)Mockito.verify((Object)first)).apply(pathData, -1);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{first});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{second});
    }

    @Test(timeout=1000L)
    public void testStopFirst() throws IOException {
        And and = new And();
        PathData pathData = (PathData)Mockito.mock(PathData.class);
        Expression first = (Expression)Mockito.mock(Expression.class);
        Mockito.when((Object)first.apply(pathData, -1)).thenReturn((Object)Result.STOP);
        Expression second = (Expression)Mockito.mock(Expression.class);
        Mockito.when((Object)second.apply(pathData, -1)).thenReturn((Object)Result.PASS);
        LinkedList<Expression> children = new LinkedList<Expression>();
        children.add(second);
        children.add(first);
        and.addChildren(children);
        Assert.assertEquals((Object)Result.STOP, (Object)and.apply(pathData, -1));
        ((Expression)Mockito.verify((Object)first)).apply(pathData, -1);
        ((Expression)Mockito.verify((Object)second)).apply(pathData, -1);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{first});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{second});
    }

    @Test(timeout=1000L)
    public void testStopSecond() throws IOException {
        And and = new And();
        PathData pathData = (PathData)Mockito.mock(PathData.class);
        Expression first = (Expression)Mockito.mock(Expression.class);
        Mockito.when((Object)first.apply(pathData, -1)).thenReturn((Object)Result.PASS);
        Expression second = (Expression)Mockito.mock(Expression.class);
        Mockito.when((Object)second.apply(pathData, -1)).thenReturn((Object)Result.STOP);
        LinkedList<Expression> children = new LinkedList<Expression>();
        children.add(second);
        children.add(first);
        and.addChildren(children);
        Assert.assertEquals((Object)Result.STOP, (Object)and.apply(pathData, -1));
        ((Expression)Mockito.verify((Object)first)).apply(pathData, -1);
        ((Expression)Mockito.verify((Object)second)).apply(pathData, -1);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{first});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{second});
    }

    @Test(timeout=1000L)
    public void testStopFail() throws IOException {
        And and = new And();
        PathData pathData = (PathData)Mockito.mock(PathData.class);
        Expression first = (Expression)Mockito.mock(Expression.class);
        Mockito.when((Object)first.apply(pathData, -1)).thenReturn((Object)Result.STOP);
        Expression second = (Expression)Mockito.mock(Expression.class);
        Mockito.when((Object)second.apply(pathData, -1)).thenReturn((Object)Result.FAIL);
        LinkedList<Expression> children = new LinkedList<Expression>();
        children.add(second);
        children.add(first);
        and.addChildren(children);
        Assert.assertEquals((Object)Result.STOP.combine(Result.FAIL), (Object)and.apply(pathData, -1));
        ((Expression)Mockito.verify((Object)first)).apply(pathData, -1);
        ((Expression)Mockito.verify((Object)second)).apply(pathData, -1);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{first});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{second});
    }

    @Test(timeout=1000L)
    public void testSetOptions() throws IOException {
        And and = new And();
        Expression first = (Expression)Mockito.mock(Expression.class);
        Expression second = (Expression)Mockito.mock(Expression.class);
        LinkedList<Expression> children = new LinkedList<Expression>();
        children.add(second);
        children.add(first);
        and.addChildren(children);
        FindOptions options = (FindOptions)Mockito.mock(FindOptions.class);
        and.setOptions(options);
        ((Expression)Mockito.verify((Object)first)).setOptions(options);
        ((Expression)Mockito.verify((Object)second)).setOptions(options);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{first});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{second});
    }

    @Test(timeout=1000L)
    public void testPrepare() throws IOException {
        And and = new And();
        Expression first = (Expression)Mockito.mock(Expression.class);
        Expression second = (Expression)Mockito.mock(Expression.class);
        LinkedList<Expression> children = new LinkedList<Expression>();
        children.add(second);
        children.add(first);
        and.addChildren(children);
        and.prepare();
        ((Expression)Mockito.verify((Object)first)).prepare();
        ((Expression)Mockito.verify((Object)second)).prepare();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{first});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{second});
    }

    @Test(timeout=1000L)
    public void testFinish() throws IOException {
        And and = new And();
        Expression first = (Expression)Mockito.mock(Expression.class);
        Expression second = (Expression)Mockito.mock(Expression.class);
        LinkedList<Expression> children = new LinkedList<Expression>();
        children.add(second);
        children.add(first);
        and.addChildren(children);
        and.finish();
        ((Expression)Mockito.verify((Object)first)).finish();
        ((Expression)Mockito.verify((Object)second)).finish();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{first});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{second});
    }
}

