/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security.ssl;

import com.google.common.base.Supplier;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.KeyPair;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.concurrent.TimeoutException;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.security.ssl.KeyStoreTestUtil;
import org.apache.hadoop.security.ssl.ReloadingX509TrustManager;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestReloadingX509TrustManager {
    private static final String BASEDIR = GenericTestUtils.getTempPath(TestReloadingX509TrustManager.class.getSimpleName());
    private X509Certificate cert1;
    private X509Certificate cert2;
    private final GenericTestUtils.LogCapturer reloaderLog = GenericTestUtils.LogCapturer.captureLogs(ReloadingX509TrustManager.LOG);

    @BeforeClass
    public static void setUp() throws Exception {
        File base = new File(BASEDIR);
        FileUtil.fullyDelete((File)base);
        base.mkdirs();
    }

    @Test(expected=IOException.class)
    public void testLoadMissingTrustStore() throws Exception {
        String truststoreLocation = BASEDIR + "/testmissing.jks";
        ReloadingX509TrustManager tm = new ReloadingX509TrustManager("jks", truststoreLocation, "password", 10L);
        try {
            tm.init();
        }
        finally {
            tm.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=IOException.class)
    public void testLoadCorruptTrustStore() throws Exception {
        String truststoreLocation = BASEDIR + "/testcorrupt.jks";
        FileOutputStream os = new FileOutputStream(truststoreLocation);
        ((OutputStream)os).write(1);
        ((OutputStream)os).close();
        ReloadingX509TrustManager tm = new ReloadingX509TrustManager("jks", truststoreLocation, "password", 10L);
        try {
            tm.init();
        }
        finally {
            tm.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=30000L)
    public void testReload() throws Exception {
        KeyPair kp = KeyStoreTestUtil.generateKeyPair("RSA");
        this.cert1 = KeyStoreTestUtil.generateCertificate("CN=Cert1", kp, 30, "SHA1withRSA");
        this.cert2 = KeyStoreTestUtil.generateCertificate("CN=Cert2", kp, 30, "SHA1withRSA");
        String truststoreLocation = BASEDIR + "/testreload.jks";
        KeyStoreTestUtil.createTrustStore(truststoreLocation, "password", "cert1", this.cert1);
        final ReloadingX509TrustManager tm = new ReloadingX509TrustManager("jks", truststoreLocation, "password", 10L);
        try {
            tm.init();
            Assert.assertEquals((long)1L, (long)tm.getAcceptedIssuers().length);
            Thread.sleep(tm.getReloadInterval() + 1000L);
            HashMap<String, X509Certificate> certs = new HashMap<String, X509Certificate>();
            certs.put("cert1", this.cert1);
            certs.put("cert2", this.cert2);
            KeyStoreTestUtil.createTrustStore(truststoreLocation, "password", certs);
            GenericTestUtils.waitFor(new Supplier<Boolean>(){

                public Boolean get() {
                    return tm.getAcceptedIssuers().length == 2;
                }
            }, (int)tm.getReloadInterval(), 10000);
        }
        finally {
            tm.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=30000L)
    public void testReloadMissingTrustStore() throws Exception {
        KeyPair kp = KeyStoreTestUtil.generateKeyPair("RSA");
        this.cert1 = KeyStoreTestUtil.generateCertificate("CN=Cert1", kp, 30, "SHA1withRSA");
        this.cert2 = KeyStoreTestUtil.generateCertificate("CN=Cert2", kp, 30, "SHA1withRSA");
        String truststoreLocation = BASEDIR + "/testmissing.jks";
        KeyStoreTestUtil.createTrustStore(truststoreLocation, "password", "cert1", this.cert1);
        ReloadingX509TrustManager tm = new ReloadingX509TrustManager("jks", truststoreLocation, "password", 10L);
        try {
            tm.init();
            Assert.assertEquals((long)1L, (long)tm.getAcceptedIssuers().length);
            X509Certificate cert = tm.getAcceptedIssuers()[0];
            Assert.assertFalse((boolean)this.reloaderLog.getOutput().contains("Could not load truststore (keep using existing one) : "));
            new File(truststoreLocation).delete();
            this.waitForFailedReloadAtLeastOnce((int)tm.getReloadInterval());
            Assert.assertEquals((long)1L, (long)tm.getAcceptedIssuers().length);
            Assert.assertEquals((Object)cert, (Object)tm.getAcceptedIssuers()[0]);
        }
        finally {
            this.reloaderLog.stopCapturing();
            tm.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=30000L)
    public void testReloadCorruptTrustStore() throws Exception {
        KeyPair kp = KeyStoreTestUtil.generateKeyPair("RSA");
        this.cert1 = KeyStoreTestUtil.generateCertificate("CN=Cert1", kp, 30, "SHA1withRSA");
        this.cert2 = KeyStoreTestUtil.generateCertificate("CN=Cert2", kp, 30, "SHA1withRSA");
        String truststoreLocation = BASEDIR + "/testcorrupt.jks";
        KeyStoreTestUtil.createTrustStore(truststoreLocation, "password", "cert1", this.cert1);
        ReloadingX509TrustManager tm = new ReloadingX509TrustManager("jks", truststoreLocation, "password", 10L);
        try {
            tm.init();
            Assert.assertEquals((long)1L, (long)tm.getAcceptedIssuers().length);
            X509Certificate cert = tm.getAcceptedIssuers()[0];
            Thread.sleep(tm.getReloadInterval() + 1000L);
            Assert.assertFalse((boolean)this.reloaderLog.getOutput().contains("Could not load truststore (keep using existing one) : "));
            FileOutputStream os = new FileOutputStream(truststoreLocation);
            ((OutputStream)os).write(1);
            ((OutputStream)os).close();
            this.waitForFailedReloadAtLeastOnce((int)tm.getReloadInterval());
            Assert.assertEquals((long)1L, (long)tm.getAcceptedIssuers().length);
            Assert.assertEquals((Object)cert, (Object)tm.getAcceptedIssuers()[0]);
        }
        finally {
            this.reloaderLog.stopCapturing();
            tm.destroy();
        }
    }

    private void waitForFailedReloadAtLeastOnce(int reloadInterval) throws InterruptedException, TimeoutException {
        GenericTestUtils.waitFor(new Supplier<Boolean>(){

            public Boolean get() {
                return TestReloadingX509TrustManager.this.reloaderLog.getOutput().contains("Could not load truststore (keep using existing one) : ");
            }
        }, reloadInterval, 10000);
    }
}

