/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ipc;

import java.lang.reflect.Constructor;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;

public class CallQueueManager<E> {
    public static final Log LOG = LogFactory.getLog(CallQueueManager.class);
    private static final int CHECKPOINT_NUM = 20;
    private static final long CHECKPOINT_INTERVAL_MS = 10L;
    private final boolean clientBackOffEnabled;
    private final AtomicReference<BlockingQueue<E>> putRef;
    private final AtomicReference<BlockingQueue<E>> takeRef;

    static <E> Class<? extends BlockingQueue<E>> convertQueueClass(Class<?> queueClass, Class<E> elementClass) {
        return queueClass;
    }

    public CallQueueManager(Class<? extends BlockingQueue<E>> backingClass, boolean clientBackOffEnabled, int maxQueueSize, String namespace, Configuration conf) {
        BlockingQueue<E> bq = this.createCallQueueInstance(backingClass, maxQueueSize, namespace, conf);
        this.clientBackOffEnabled = clientBackOffEnabled;
        this.putRef = new AtomicReference<BlockingQueue<E>>(bq);
        this.takeRef = new AtomicReference<BlockingQueue<E>>(bq);
        LOG.info((Object)("Using callQueue " + backingClass));
    }

    private <T extends BlockingQueue<E>> T createCallQueueInstance(Class<T> theClass, int maxLen, String ns, Configuration conf) {
        try {
            Constructor<T> ctor = theClass.getDeclaredConstructor(Integer.TYPE, String.class, Configuration.class);
            return (T)((BlockingQueue)ctor.newInstance(maxLen, ns, conf));
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            try {
                Constructor<T> ctor = theClass.getDeclaredConstructor(Integer.TYPE);
                return (T)((BlockingQueue)ctor.newInstance(maxLen));
            }
            catch (RuntimeException e2) {
                throw e2;
            }
            catch (Exception e3) {
                try {
                    Constructor<T> ctor = theClass.getDeclaredConstructor(new Class[0]);
                    return (T)((BlockingQueue)ctor.newInstance(new Object[0]));
                }
                catch (RuntimeException e4) {
                    throw e4;
                }
                catch (Exception e5) {
                    throw new RuntimeException(theClass.getName() + " could not be constructed.");
                }
            }
        }
    }

    boolean isClientBackoffEnabled() {
        return this.clientBackOffEnabled;
    }

    public void put(E e) throws InterruptedException {
        this.putRef.get().put(e);
    }

    public boolean offer(E e) throws InterruptedException {
        return this.putRef.get().offer(e);
    }

    public E take() throws InterruptedException {
        E e = null;
        while (e == null) {
            e = this.takeRef.get().poll(1000L, TimeUnit.MILLISECONDS);
        }
        return e;
    }

    public int size() {
        return this.takeRef.get().size();
    }

    public synchronized void swapQueue(Class<? extends BlockingQueue<E>> queueClassToUse, int maxSize, String ns, Configuration conf) {
        BlockingQueue<E> newQ = this.createCallQueueInstance(queueClassToUse, maxSize, ns, conf);
        BlockingQueue<E> oldQ = this.putRef.get();
        this.putRef.set(newQ);
        while (!this.queueIsReallyEmpty(oldQ)) {
        }
        this.takeRef.set(newQ);
        LOG.info((Object)("Old Queue: " + this.stringRepr(oldQ) + ", " + "Replacement: " + this.stringRepr(newQ)));
    }

    private boolean queueIsReallyEmpty(BlockingQueue<?> q) {
        for (int i = 0; i < 20; ++i) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException ie) {
                return false;
            }
            if (q.isEmpty()) continue;
            return false;
        }
        return true;
    }

    private String stringRepr(Object o) {
        return o.getClass().getName() + '@' + Integer.toHexString(o.hashCode());
    }
}

