/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ShutdownHookManager {
    private static final ShutdownHookManager MGR = new ShutdownHookManager();
    private static final Log LOG = LogFactory.getLog(ShutdownHookManager.class);
    private Set<HookEntry> hooks = Collections.synchronizedSet(new HashSet());
    private AtomicBoolean shutdownInProgress = new AtomicBoolean(false);

    public static ShutdownHookManager get() {
        return MGR;
    }

    private ShutdownHookManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<Runnable> getShutdownHooksInOrder() {
        ArrayList<HookEntry> list;
        Set<HookEntry> set = ShutdownHookManager.MGR.hooks;
        synchronized (set) {
            list = new ArrayList<HookEntry>(ShutdownHookManager.MGR.hooks);
        }
        Collections.sort(list, new Comparator<HookEntry>(){

            @Override
            public int compare(HookEntry o1, HookEntry o2) {
                return o2.priority - o1.priority;
            }
        });
        ArrayList<Runnable> ordered = new ArrayList<Runnable>();
        for (HookEntry entry : list) {
            ordered.add(entry.hook);
        }
        return ordered;
    }

    public void addShutdownHook(Runnable shutdownHook, int priority) {
        if (shutdownHook == null) {
            throw new IllegalArgumentException("shutdownHook cannot be NULL");
        }
        if (this.shutdownInProgress.get()) {
            throw new IllegalStateException("Shutdown in progress, cannot add a shutdownHook");
        }
        this.hooks.add(new HookEntry(shutdownHook, priority));
    }

    public boolean removeShutdownHook(Runnable shutdownHook) {
        if (this.shutdownInProgress.get()) {
            throw new IllegalStateException("Shutdown in progress, cannot remove a shutdownHook");
        }
        return this.hooks.remove(new HookEntry(shutdownHook, 0));
    }

    public boolean hasShutdownHook(Runnable shutdownHook) {
        return this.hooks.contains(new HookEntry(shutdownHook, 0));
    }

    public boolean isShutdownInProgress() {
        return this.shutdownInProgress.get();
    }

    public void clearShutdownHooks() {
        this.hooks.clear();
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                MGR.shutdownInProgress.set(true);
                for (Runnable hook : MGR.getShutdownHooksInOrder()) {
                    try {
                        hook.run();
                    }
                    catch (Throwable ex) {
                        LOG.warn((Object)("ShutdownHook '" + hook.getClass().getSimpleName() + "' failed, " + ex.toString()), ex);
                    }
                }
            }
        });
    }

    private static class HookEntry {
        Runnable hook;
        int priority;

        public HookEntry(Runnable hook, int priority) {
            this.hook = hook;
            this.priority = priority;
        }

        public int hashCode() {
            return this.hook.hashCode();
        }

        public boolean equals(Object obj) {
            boolean eq = false;
            if (obj != null && obj instanceof HookEntry) {
                eq = this.hook == ((HookEntry)obj).hook;
            }
            return eq;
        }
    }
}

