/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.crypto.key;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.List;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.crypto.key.CachingKeyProvider;
import org.apache.hadoop.crypto.key.KeyProvider;
import org.apache.hadoop.crypto.key.KeyProviderCryptoExtension;
import org.apache.hadoop.crypto.key.UserProvider;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.Timeout;

public class TestKeyProviderCryptoExtension {
    private static final String CIPHER = "AES";
    private static final String ENCRYPTION_KEY_NAME = "fooKey";
    private static Configuration conf;
    private static KeyProvider kp;
    private static KeyProviderCryptoExtension kpExt;
    private static KeyProvider.Options options;
    private static KeyProvider.KeyVersion encryptionKey;
    @Rule
    public Timeout testTimeout = new Timeout(180000);

    @BeforeClass
    public static void setup() throws Exception {
        conf = new Configuration();
        kp = new UserProvider.Factory().createProvider(new URI("user:///"), conf);
        kpExt = KeyProviderCryptoExtension.createKeyProviderCryptoExtension((KeyProvider)kp);
        options = new KeyProvider.Options(conf);
        options.setCipher(CIPHER);
        options.setBitLength(128);
        encryptionKey = kp.createKey(ENCRYPTION_KEY_NAME, SecureRandom.getSeed(16), options);
    }

    @Test
    public void testGenerateEncryptedKey() throws Exception {
        KeyProviderCryptoExtension.EncryptedKeyVersion ek1 = kpExt.generateEncryptedKey(encryptionKey.getName());
        Assert.assertEquals((String)"Version name of EEK should be EEK", (Object)"EEK", (Object)ek1.getEncryptedKeyVersion().getVersionName());
        Assert.assertEquals((String)"Name of EEK should be encryption key name", (Object)ENCRYPTION_KEY_NAME, (Object)ek1.getEncryptionKeyName());
        Assert.assertNotNull((String)"Expected encrypted key material", (Object)ek1.getEncryptedKeyVersion().getMaterial());
        Assert.assertEquals((String)"Length of encryption key material and EEK material should be the same", (long)encryptionKey.getMaterial().length, (long)ek1.getEncryptedKeyVersion().getMaterial().length);
        KeyProvider.KeyVersion k1 = kpExt.decryptEncryptedKey(ek1);
        Assert.assertEquals((Object)"EK", (Object)k1.getVersionName());
        Assert.assertEquals((long)encryptionKey.getMaterial().length, (long)k1.getMaterial().length);
        if (Arrays.equals(k1.getMaterial(), encryptionKey.getMaterial())) {
            Assert.fail((String)"Encrypted key material should not equal encryption key material");
        }
        if (Arrays.equals(ek1.getEncryptedKeyVersion().getMaterial(), encryptionKey.getMaterial())) {
            Assert.fail((String)"Encrypted key material should not equal decrypted key material");
        }
        KeyProvider.KeyVersion k1a = kpExt.decryptEncryptedKey(ek1);
        Assert.assertArrayEquals((byte[])k1.getMaterial(), (byte[])k1a.getMaterial());
        KeyProviderCryptoExtension.EncryptedKeyVersion ek2 = kpExt.generateEncryptedKey(encryptionKey.getName());
        KeyProvider.KeyVersion k2 = kpExt.decryptEncryptedKey(ek2);
        if (Arrays.equals(k1.getMaterial(), k2.getMaterial())) {
            Assert.fail((String)"Generated EEKs should have different material!");
        }
        if (Arrays.equals(ek1.getEncryptedKeyIv(), ek2.getEncryptedKeyIv())) {
            Assert.fail((String)"Generated EEKs should have different IVs!");
        }
    }

    @Test
    public void testEncryptDecrypt() throws Exception {
        KeyProviderCryptoExtension.EncryptedKeyVersion eek = kpExt.generateEncryptedKey(encryptionKey.getName());
        byte[] encryptedKeyIv = eek.getEncryptedKeyIv();
        byte[] encryptedKeyMaterial = eek.getEncryptedKeyVersion().getMaterial();
        Cipher cipher = Cipher.getInstance("AES/CTR/NoPadding");
        cipher.init(2, (Key)new SecretKeySpec(encryptionKey.getMaterial(), CIPHER), new IvParameterSpec(KeyProviderCryptoExtension.EncryptedKeyVersion.deriveIV((byte[])encryptedKeyIv)));
        byte[] manualMaterial = cipher.doFinal(encryptedKeyMaterial);
        KeyProviderCryptoExtension.EncryptedKeyVersion eek2 = KeyProviderCryptoExtension.EncryptedKeyVersion.createForDecryption((String)eek.getEncryptionKeyName(), (String)eek.getEncryptionKeyVersionName(), (byte[])eek.getEncryptedKeyIv(), (byte[])eek.getEncryptedKeyVersion().getMaterial());
        KeyProvider.KeyVersion decryptedKey = kpExt.decryptEncryptedKey(eek2);
        byte[] apiMaterial = decryptedKey.getMaterial();
        Assert.assertArrayEquals((String)"Wrong key material from decryptEncryptedKey", (byte[])manualMaterial, (byte[])apiMaterial);
    }

    @Test
    public void testReencryptEncryptedKey() throws Exception {
        KeyProviderCryptoExtension.EncryptedKeyVersion ek1 = kpExt.generateEncryptedKey(encryptionKey.getName());
        KeyProvider.KeyVersion k1 = kpExt.decryptEncryptedKey(ek1);
        Assert.assertEquals((Object)"EK", (Object)k1.getVersionName());
        Assert.assertEquals((long)encryptionKey.getMaterial().length, (long)k1.getMaterial().length);
        if (Arrays.equals(k1.getMaterial(), encryptionKey.getMaterial())) {
            Assert.fail((String)"Encrypted key material should not equal encryption key material");
        }
        kpExt.rollNewVersion(ek1.getEncryptionKeyName());
        KeyProviderCryptoExtension.EncryptedKeyVersion ek2 = kpExt.reencryptEncryptedKey(ek1);
        Assert.assertEquals((String)"Version name of EEK should be EEK", (Object)"EEK", (Object)ek2.getEncryptedKeyVersion().getVersionName());
        Assert.assertEquals((String)"Name of EEK should be encryption key name", (Object)ENCRYPTION_KEY_NAME, (Object)ek2.getEncryptionKeyName());
        Assert.assertNotNull((String)"Expected encrypted key material", (Object)ek2.getEncryptedKeyVersion().getMaterial());
        Assert.assertEquals((String)"Length of encryption key material and EEK material should be the same", (long)encryptionKey.getMaterial().length, (long)ek2.getEncryptedKeyVersion().getMaterial().length);
        if (Arrays.equals(ek2.getEncryptedKeyVersion().getMaterial(), encryptionKey.getMaterial())) {
            Assert.fail((String)"Encrypted key material should not equal decrypted key material");
        }
        if (Arrays.equals(ek2.getEncryptedKeyVersion().getMaterial(), ek1.getEncryptedKeyVersion().getMaterial())) {
            Assert.fail((String)"Re-encrypted EEK should have different material");
        }
        KeyProvider.KeyVersion k2 = kpExt.decryptEncryptedKey(ek2);
        Assert.assertEquals((Object)"EK", (Object)k2.getVersionName());
        Assert.assertEquals((long)encryptionKey.getMaterial().length, (long)k2.getMaterial().length);
        if (Arrays.equals(k2.getMaterial(), encryptionKey.getMaterial())) {
            Assert.fail((String)"Encrypted key material should not equal encryption key material");
        }
        KeyProviderCryptoExtension.EncryptedKeyVersion ek2a = kpExt.reencryptEncryptedKey(ek1);
        Assert.assertEquals((String)"Version name of EEK should be EEK", (Object)"EEK", (Object)ek2a.getEncryptedKeyVersion().getVersionName());
        Assert.assertEquals((String)"Name of EEK should be encryption key name", (Object)ENCRYPTION_KEY_NAME, (Object)ek2a.getEncryptionKeyName());
        Assert.assertNotNull((String)"Expected encrypted key material", (Object)ek2a.getEncryptedKeyVersion().getMaterial());
        Assert.assertEquals((String)"Length of encryption key material and EEK material should be the same", (long)encryptionKey.getMaterial().length, (long)ek2a.getEncryptedKeyVersion().getMaterial().length);
        if (Arrays.equals(ek2a.getEncryptedKeyVersion().getMaterial(), encryptionKey.getMaterial())) {
            Assert.fail((String)"Encrypted key material should not equal decrypted key material");
        }
        if (Arrays.equals(ek2a.getEncryptedKeyVersion().getMaterial(), ek1.getEncryptedKeyVersion().getMaterial())) {
            Assert.fail((String)"Re-encrypted EEK should have different material");
        }
        Assert.assertArrayEquals((byte[])ek2.getEncryptedKeyVersion().getMaterial(), (byte[])ek2a.getEncryptedKeyVersion().getMaterial());
        KeyProviderCryptoExtension.EncryptedKeyVersion ek3 = kpExt.reencryptEncryptedKey(ek2);
        Assert.assertEquals((String)"Version name of EEK should be EEK", (Object)"EEK", (Object)ek3.getEncryptedKeyVersion().getVersionName());
        Assert.assertEquals((String)"Name of EEK should be encryption key name", (Object)ENCRYPTION_KEY_NAME, (Object)ek3.getEncryptionKeyName());
        Assert.assertNotNull((String)"Expected encrypted key material", (Object)ek3.getEncryptedKeyVersion().getMaterial());
        Assert.assertEquals((String)"Length of encryption key material and EEK material should be the same", (long)encryptionKey.getMaterial().length, (long)ek3.getEncryptedKeyVersion().getMaterial().length);
        if (Arrays.equals(ek3.getEncryptedKeyVersion().getMaterial(), encryptionKey.getMaterial())) {
            Assert.fail((String)"Encrypted key material should not equal decrypted key material");
        }
        if (Arrays.equals(ek3.getEncryptedKeyVersion().getMaterial(), ek1.getEncryptedKeyVersion().getMaterial())) {
            Assert.fail((String)"Re-encrypted EEK should have different material");
        }
        Assert.assertArrayEquals((byte[])ek2.getEncryptedKeyVersion().getMaterial(), (byte[])ek3.getEncryptedKeyVersion().getMaterial());
    }

    @Test
    public void testNonDefaultCryptoExtensionSelectionWithCachingKeyProvider() throws Exception {
        Configuration config = new Configuration();
        DummyCryptoExtensionKeyProvider localKp = new DummyCryptoExtensionKeyProvider(config);
        localKp = new CachingKeyProvider((KeyProvider)localKp, 30000L, 30000L);
        KeyProviderCryptoExtension.EncryptedKeyVersion localEkv = this.getEncryptedKeyVersion(config, localKp);
        Assert.assertEquals((Object)"dummyFakeKey@1", (Object)localEkv.getEncryptionKeyVersionName());
    }

    @Test
    public void testDefaultCryptoExtensionSelectionWithCachingKeyProvider() throws Exception {
        Configuration config = new Configuration();
        KeyProvider localKp = new UserProvider.Factory().createProvider(new URI("user:///"), config);
        localKp = new CachingKeyProvider(localKp, 30000L, 30000L);
        KeyProviderCryptoExtension.EncryptedKeyVersion localEkv = this.getEncryptedKeyVersion(config, localKp);
        Assert.assertEquals((Object)"fooKey@0", (Object)localEkv.getEncryptionKeyVersionName());
    }

    @Test
    public void testNonDefaultCryptoExtensionSelectionOnKeyProviderExtension() throws Exception {
        Configuration config = new Configuration();
        Object localKp = new UserProvider.Factory().createProvider(new URI("user:///"), config);
        localKp = new DummyCachingCryptoExtensionKeyProvider((KeyProvider)localKp, 30000L, 30000L);
        KeyProviderCryptoExtension.EncryptedKeyVersion localEkv = this.getEncryptedKeyVersion(config, (KeyProvider)localKp);
        Assert.assertEquals((Object)"dummyCachingFakeKey@1", (Object)localEkv.getEncryptionKeyVersionName());
    }

    private KeyProviderCryptoExtension.EncryptedKeyVersion getEncryptedKeyVersion(Configuration config, KeyProvider localKp) throws IOException, GeneralSecurityException {
        KeyProvider.Options localOptions = new KeyProvider.Options(config);
        localOptions.setCipher(CIPHER);
        localOptions.setBitLength(128);
        KeyProvider.KeyVersion localEncryptionKey = localKp.createKey(ENCRYPTION_KEY_NAME, SecureRandom.getSeed(16), localOptions);
        KeyProviderCryptoExtension localKpExt = KeyProviderCryptoExtension.createKeyProviderCryptoExtension((KeyProvider)localKp);
        return localKpExt.generateEncryptedKey(localEncryptionKey.getName());
    }

    public class DummyCachingCryptoExtensionKeyProvider
    extends CachingKeyProvider
    implements KeyProviderCryptoExtension.CryptoExtension {
        private KeyProvider kp;
        private KeyProvider.KeyVersion kv;
        private KeyProviderCryptoExtension.EncryptedKeyVersion ekv;

        public DummyCachingCryptoExtensionKeyProvider(KeyProvider keyProvider, long keyTimeoutMillis, long currKeyTimeoutMillis) {
            super(keyProvider, keyTimeoutMillis, currKeyTimeoutMillis);
            conf = new Configuration();
            try {
                this.kp = new UserProvider.Factory().createProvider(new URI("user:///"), conf);
                this.kv = new KeyProvider.KeyVersion(TestKeyProviderCryptoExtension.ENCRYPTION_KEY_NAME, "dummyCachingFakeKey@1", new byte[16]);
                this.ekv = new KeyProviderCryptoExtension.EncryptedKeyVersion(TestKeyProviderCryptoExtension.ENCRYPTION_KEY_NAME, "dummyCachingFakeKey@1", new byte[16], this.kv);
            }
            catch (URISyntaxException e) {
                Assert.fail((String)e.getMessage());
            }
            catch (IOException e) {
                Assert.fail((String)e.getMessage());
            }
        }

        public void warmUpEncryptedKeys(String ... keyNames) throws IOException {
        }

        public void drain(String keyName) {
        }

        public KeyProviderCryptoExtension.EncryptedKeyVersion generateEncryptedKey(String encryptionKeyName) throws IOException, GeneralSecurityException {
            return this.ekv;
        }

        public KeyProvider.KeyVersion decryptEncryptedKey(KeyProviderCryptoExtension.EncryptedKeyVersion encryptedKeyVersion) throws IOException, GeneralSecurityException {
            return this.kv;
        }

        public KeyProviderCryptoExtension.EncryptedKeyVersion reencryptEncryptedKey(KeyProviderCryptoExtension.EncryptedKeyVersion ekv) throws IOException, GeneralSecurityException {
            return ekv;
        }
    }

    public class DummyCryptoExtensionKeyProvider
    extends KeyProvider
    implements KeyProviderCryptoExtension.CryptoExtension {
        private KeyProvider kp;
        private KeyProvider.KeyVersion kv;
        private KeyProviderCryptoExtension.EncryptedKeyVersion ekv;

        public DummyCryptoExtensionKeyProvider(Configuration conf) {
            super(conf);
            conf = new Configuration();
            try {
                this.kp = new UserProvider.Factory().createProvider(new URI("user:///"), conf);
                this.kv = new KeyProvider.KeyVersion(TestKeyProviderCryptoExtension.ENCRYPTION_KEY_NAME, "dummyFakeKey@1", new byte[16]);
                this.ekv = new KeyProviderCryptoExtension.EncryptedKeyVersion(TestKeyProviderCryptoExtension.ENCRYPTION_KEY_NAME, "dummyFakeKey@1", new byte[16], this.kv);
            }
            catch (URISyntaxException e) {
                Assert.fail((String)e.getMessage());
            }
            catch (IOException e) {
                Assert.fail((String)e.getMessage());
            }
        }

        public void warmUpEncryptedKeys(String ... keyNames) throws IOException {
        }

        public void drain(String keyName) {
        }

        public KeyProviderCryptoExtension.EncryptedKeyVersion generateEncryptedKey(String encryptionKeyName) throws IOException, GeneralSecurityException {
            return this.ekv;
        }

        public KeyProviderCryptoExtension.EncryptedKeyVersion reencryptEncryptedKey(KeyProviderCryptoExtension.EncryptedKeyVersion ekv) throws IOException, GeneralSecurityException {
            return ekv;
        }

        public KeyProvider.KeyVersion decryptEncryptedKey(KeyProviderCryptoExtension.EncryptedKeyVersion encryptedKeyVersion) throws IOException, GeneralSecurityException {
            return this.kv;
        }

        public KeyProvider.KeyVersion getKeyVersion(String versionName) throws IOException {
            return this.kp.getKeyVersion(versionName);
        }

        public List<String> getKeys() throws IOException {
            return this.kp.getKeys();
        }

        public List<KeyProvider.KeyVersion> getKeyVersions(String name) throws IOException {
            return this.kp.getKeyVersions(name);
        }

        public KeyProvider.Metadata getMetadata(String name) throws IOException {
            return this.kp.getMetadata(name);
        }

        public KeyProvider.KeyVersion createKey(String name, byte[] material, KeyProvider.Options localOptions) throws IOException {
            return this.kp.createKey(name, material, localOptions);
        }

        public void deleteKey(String name) throws IOException {
            this.kp.deleteKey(name);
        }

        public KeyProvider.KeyVersion rollNewVersion(String name, byte[] material) throws IOException {
            return this.kp.rollNewVersion(name, material);
        }

        public void flush() throws IOException {
            this.kp.flush();
        }
    }
}

