/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalDirAllocator;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.test.PlatformAssumptions;
import org.apache.hadoop.util.DiskChecker;
import org.apache.hadoop.util.Shell;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TestLocalDirAllocator {
    private static final Configuration conf = new Configuration();
    private static final String BUFFER_DIR_ROOT = "build/test/temp";
    private static final String ABSOLUTE_DIR_ROOT;
    private static final String QUALIFIED_DIR_ROOT;
    private static final Path BUFFER_PATH_ROOT;
    private static final File BUFFER_ROOT;
    private static final String CONTEXT = "mapred.local.dir";
    private static final String FILENAME = "block";
    private static final LocalDirAllocator dirAllocator;
    static LocalFileSystem localFs;
    static final int SMALL_FILE_SIZE = 100;
    private static final String RELATIVE = "/RELATIVE";
    private static final String ABSOLUTE = "/ABSOLUTE";
    private static final String QUALIFIED = "/QUALIFIED";
    private final String ROOT;
    private final String PREFIX;
    static final int TRIALS = 100;

    public TestLocalDirAllocator(String root, String prefix) {
        this.ROOT = root;
        this.PREFIX = prefix;
    }

    @Parameterized.Parameters
    public static Collection<Object[]> params() {
        Object[][] data = new Object[][]{{BUFFER_DIR_ROOT, RELATIVE}, {ABSOLUTE_DIR_ROOT, ABSOLUTE}, {QUALIFIED_DIR_ROOT, QUALIFIED}};
        return Arrays.asList(data);
    }

    private static void rmBufferDirs() throws IOException {
        Assert.assertTrue((!localFs.exists(BUFFER_PATH_ROOT) || localFs.delete(BUFFER_PATH_ROOT, true) ? 1 : 0) != 0);
    }

    private static void validateTempDirCreation(String dir) throws IOException {
        File result = TestLocalDirAllocator.createTempFile(100L);
        Assert.assertTrue((String)("Checking for " + dir + " in " + result + " - FAILED!"), (boolean)result.getPath().startsWith(new Path(dir, FILENAME).toUri().getPath()));
    }

    private static File createTempFile() throws IOException {
        return TestLocalDirAllocator.createTempFile(-1L);
    }

    private static File createTempFile(long size) throws IOException {
        File result = dirAllocator.createTmpFileForWrite(FILENAME, size, conf);
        result.delete();
        return result;
    }

    private String buildBufferDir(String dir, int i) {
        return dir + this.PREFIX + i;
    }

    @Test(timeout=30000L)
    public void test0() throws Exception {
        PlatformAssumptions.assumeNotWindows();
        String dir0 = this.buildBufferDir(this.ROOT, 0);
        String dir1 = this.buildBufferDir(this.ROOT, 1);
        try {
            conf.set(CONTEXT, dir0 + "," + dir1);
            Assert.assertTrue((boolean)localFs.mkdirs(new Path(dir1)));
            BUFFER_ROOT.setReadOnly();
            TestLocalDirAllocator.validateTempDirCreation(dir1);
            TestLocalDirAllocator.validateTempDirCreation(dir1);
        }
        finally {
            Shell.execCommand((String[])Shell.getSetPermissionCommand((String)"u+w", (boolean)false, (String)BUFFER_DIR_ROOT));
            TestLocalDirAllocator.rmBufferDirs();
        }
    }

    @Test(timeout=30000L)
    public void testROBufferDirAndRWBufferDir() throws Exception {
        PlatformAssumptions.assumeNotWindows();
        String dir1 = this.buildBufferDir(this.ROOT, 1);
        String dir2 = this.buildBufferDir(this.ROOT, 2);
        try {
            conf.set(CONTEXT, dir1 + "," + dir2);
            Assert.assertTrue((boolean)localFs.mkdirs(new Path(dir2)));
            BUFFER_ROOT.setReadOnly();
            TestLocalDirAllocator.validateTempDirCreation(dir2);
            TestLocalDirAllocator.validateTempDirCreation(dir2);
        }
        finally {
            Shell.execCommand((String[])Shell.getSetPermissionCommand((String)"u+w", (boolean)false, (String)BUFFER_DIR_ROOT));
            TestLocalDirAllocator.rmBufferDirs();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=30000L)
    public void testDirsNotExist() throws Exception {
        PlatformAssumptions.assumeNotWindows();
        String dir2 = this.buildBufferDir(this.ROOT, 2);
        String dir3 = this.buildBufferDir(this.ROOT, 3);
        try {
            conf.set(CONTEXT, dir2 + "," + dir3);
            TestLocalDirAllocator.createTempFile(100L);
            int firstDirIdx = dirAllocator.getCurrentDirectoryIndex() == 0 ? 2 : 3;
            int secondDirIdx = firstDirIdx == 2 ? 3 : 2;
            TestLocalDirAllocator.validateTempDirCreation(this.buildBufferDir(this.ROOT, firstDirIdx));
            TestLocalDirAllocator.validateTempDirCreation(this.buildBufferDir(this.ROOT, secondDirIdx));
            TestLocalDirAllocator.validateTempDirCreation(this.buildBufferDir(this.ROOT, firstDirIdx));
        }
        finally {
            TestLocalDirAllocator.rmBufferDirs();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=30000L)
    public void testRWBufferDirBecomesRO() throws Exception {
        PlatformAssumptions.assumeNotWindows();
        String dir3 = this.buildBufferDir(this.ROOT, 3);
        String dir4 = this.buildBufferDir(this.ROOT, 4);
        try {
            conf.set(CONTEXT, dir3 + "," + dir4);
            Assert.assertTrue((boolean)localFs.mkdirs(new Path(dir3)));
            Assert.assertTrue((boolean)localFs.mkdirs(new Path(dir4)));
            TestLocalDirAllocator.createTempFile(100L);
            int nextDirIdx = dirAllocator.getCurrentDirectoryIndex() == 0 ? 3 : 4;
            TestLocalDirAllocator.validateTempDirCreation(this.buildBufferDir(this.ROOT, nextDirIdx));
            new File(new Path(dir4).toUri().getPath()).setReadOnly();
            TestLocalDirAllocator.validateTempDirCreation(dir3);
            TestLocalDirAllocator.validateTempDirCreation(dir3);
        }
        finally {
            TestLocalDirAllocator.rmBufferDirs();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=30000L)
    public void testCreateManyFiles() throws Exception {
        PlatformAssumptions.assumeNotWindows();
        String dir5 = this.buildBufferDir(this.ROOT, 5);
        String dir6 = this.buildBufferDir(this.ROOT, 6);
        try {
            conf.set(CONTEXT, dir5 + "," + dir6);
            Assert.assertTrue((boolean)localFs.mkdirs(new Path(dir5)));
            Assert.assertTrue((boolean)localFs.mkdirs(new Path(dir6)));
            int inDir5 = 0;
            int inDir6 = 0;
            for (int i = 0; i < 100; ++i) {
                File result = TestLocalDirAllocator.createTempFile();
                if (result.getPath().startsWith(new Path(dir5, FILENAME).toUri().getPath())) {
                    ++inDir5;
                } else if (result.getPath().startsWith(new Path(dir6, FILENAME).toUri().getPath())) {
                    ++inDir6;
                }
                result.delete();
            }
            Assert.assertTrue((inDir5 + inDir6 == 100 ? 1 : 0) != 0);
        }
        finally {
            TestLocalDirAllocator.rmBufferDirs();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=30000L)
    public void testLocalPathForWriteDirCreation() throws IOException {
        String dir0 = this.buildBufferDir(this.ROOT, 0);
        String dir1 = this.buildBufferDir(this.ROOT, 1);
        try {
            conf.set(CONTEXT, dir0 + "," + dir1);
            Assert.assertTrue((boolean)localFs.mkdirs(new Path(dir1)));
            BUFFER_ROOT.setReadOnly();
            Path p1 = dirAllocator.getLocalPathForWrite("p1/x", 100L, conf);
            Assert.assertTrue((boolean)localFs.getFileStatus(p1.getParent()).isDirectory());
            Path p2 = dirAllocator.getLocalPathForWrite("p2/x", 100L, conf, false);
            try {
                localFs.getFileStatus(p2.getParent());
            }
            catch (Exception e) {
                Assert.assertEquals(e.getClass(), FileNotFoundException.class);
            }
        }
        finally {
            Shell.execCommand((String[])Shell.getSetPermissionCommand((String)"u+w", (boolean)false, (String)BUFFER_DIR_ROOT));
            TestLocalDirAllocator.rmBufferDirs();
        }
    }

    @Test(timeout=30000L)
    public void testShouldNotthrowNPE() throws Exception {
        Configuration conf1 = new Configuration();
        try {
            dirAllocator.getLocalPathForWrite("/test", conf1);
            Assert.fail((String)"Exception not thrown when mapred.local.dir is not set");
        }
        catch (IOException e) {
            Assert.assertEquals((Object)"mapred.local.dir not configured", (Object)e.getMessage());
        }
        catch (NullPointerException e) {
            Assert.fail((String)"Lack of configuration should not have thrown a NPE.");
        }
        String NEW_CONTEXT = "mapred.local.dir.new";
        conf1.set(NEW_CONTEXT, "");
        LocalDirAllocator newDirAllocator = new LocalDirAllocator(NEW_CONTEXT);
        try {
            newDirAllocator.getLocalPathForWrite("/test", conf1);
            Assert.fail((String)("Exception not thrown when " + NEW_CONTEXT + " is set to empty string"));
        }
        catch (IOException e) {
            Assert.assertTrue((boolean)(e instanceof DiskChecker.DiskErrorException));
        }
        catch (NullPointerException e) {
            Assert.fail((String)"Wrong configuration should not have thrown a NPE.");
        }
        try {
            newDirAllocator.getLocalPathToRead("/test", conf1);
            Assert.fail((String)("Exception not thrown when " + NEW_CONTEXT + " is set to empty string"));
        }
        catch (IOException e) {
            Assert.assertTrue((boolean)(e instanceof DiskChecker.DiskErrorException));
        }
        catch (NullPointerException e) {
            Assert.fail((String)"Wrong configuration should not have thrown a NPE.");
        }
    }

    @Test(timeout=30000L)
    public void testNoSideEffects() throws IOException {
        PlatformAssumptions.assumeNotWindows();
        String dir = this.buildBufferDir(this.ROOT, 0);
        try {
            conf.set(CONTEXT, dir);
            File result = dirAllocator.createTmpFileForWrite(FILENAME, -1L, conf);
            Assert.assertTrue((boolean)result.delete());
            Assert.assertTrue((boolean)result.getParentFile().delete());
            Assert.assertFalse((boolean)new File(dir).exists());
        }
        finally {
            Shell.execCommand((String[])Shell.getSetPermissionCommand((String)"u+w", (boolean)false, (String)BUFFER_DIR_ROOT));
            TestLocalDirAllocator.rmBufferDirs();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=30000L)
    public void testGetLocalPathToRead() throws IOException {
        PlatformAssumptions.assumeNotWindows();
        String dir = this.buildBufferDir(this.ROOT, 0);
        try {
            conf.set(CONTEXT, dir);
            Assert.assertTrue((boolean)localFs.mkdirs(new Path(dir)));
            File f1 = dirAllocator.createTmpFileForWrite(FILENAME, 100L, conf);
            Path p1 = dirAllocator.getLocalPathToRead(f1.getName(), conf);
            Assert.assertEquals((Object)f1.getName(), (Object)p1.getName());
            Assert.assertEquals((Object)"file", (Object)p1.getFileSystem(conf).getUri().getScheme());
        }
        finally {
            Shell.execCommand((String[])Shell.getSetPermissionCommand((String)"u+w", (boolean)false, (String)BUFFER_DIR_ROOT));
            TestLocalDirAllocator.rmBufferDirs();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=30000L)
    public void testGetAllLocalPathsToRead() throws IOException {
        PlatformAssumptions.assumeNotWindows();
        String dir0 = this.buildBufferDir(this.ROOT, 0);
        String dir1 = this.buildBufferDir(this.ROOT, 1);
        try {
            conf.set(CONTEXT, dir0 + "," + dir1);
            Assert.assertTrue((boolean)localFs.mkdirs(new Path(dir0)));
            Assert.assertTrue((boolean)localFs.mkdirs(new Path(dir1)));
            localFs.create(new Path(dir0 + "/" + FILENAME));
            localFs.create(new Path(dir1 + "/" + FILENAME));
            Iterable pathIterable = dirAllocator.getAllLocalPathsToRead(FILENAME, conf);
            int count = 0;
            for (Path p : pathIterable) {
                ++count;
                Assert.assertEquals((Object)FILENAME, (Object)p.getName());
                Assert.assertEquals((Object)"file", (Object)p.getFileSystem(conf).getUri().getScheme());
            }
            Assert.assertEquals((long)2L, (long)count);
            try {
                Path p = (Path)pathIterable.iterator().next();
                Assert.assertFalse((String)("NoSuchElementException must be thrown, but returned [" + p + "] instead."), (boolean)true);
            }
            catch (NoSuchElementException p) {
                // empty catch block
            }
            Iterable pathIterable2 = dirAllocator.getAllLocalPathsToRead(FILENAME, conf);
            Iterator it = pathIterable2.iterator();
            try {
                it.remove();
                Assert.assertFalse((boolean)true);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        }
        catch (Throwable throwable) {
            Shell.execCommand((String[])new String[]{"chmod", "u+w", BUFFER_DIR_ROOT});
            TestLocalDirAllocator.rmBufferDirs();
            throw throwable;
        }
        Shell.execCommand((String[])new String[]{"chmod", "u+w", BUFFER_DIR_ROOT});
        TestLocalDirAllocator.rmBufferDirs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=30000L)
    public void testRemoveContext() throws IOException {
        String dir = this.buildBufferDir(this.ROOT, 0);
        try {
            String contextCfgItemName = "application_1340842292563_0004.app.cache.dirs";
            conf.set(contextCfgItemName, dir);
            LocalDirAllocator localDirAllocator = new LocalDirAllocator(contextCfgItemName);
            localDirAllocator.getLocalPathForWrite("p1/x", 100L, conf);
            Assert.assertTrue((boolean)LocalDirAllocator.isContextValid((String)contextCfgItemName));
            LocalDirAllocator.removeContext((String)contextCfgItemName);
            Assert.assertFalse((boolean)LocalDirAllocator.isContextValid((String)contextCfgItemName));
        }
        finally {
            TestLocalDirAllocator.rmBufferDirs();
        }
    }

    @Test(timeout=30000L)
    public void testGetLocalPathForWriteForInvalidPaths() throws Exception {
        conf.set(CONTEXT, " ");
        try {
            dirAllocator.getLocalPathForWrite("/test", conf);
            Assert.fail((String)"not throwing the exception");
        }
        catch (IOException e) {
            Assert.assertEquals((String)"Incorrect exception message", (Object)"No space available in any of the local directories.", (Object)e.getMessage());
        }
    }

    static {
        BUFFER_PATH_ROOT = new Path(BUFFER_DIR_ROOT);
        BUFFER_ROOT = new File(BUFFER_DIR_ROOT);
        dirAllocator = new LocalDirAllocator(CONTEXT);
        try {
            localFs = FileSystem.getLocal((Configuration)conf);
            TestLocalDirAllocator.rmBufferDirs();
        }
        catch (IOException e) {
            System.out.println(e.getMessage());
            e.printStackTrace();
            System.exit(-1);
        }
        ABSOLUTE_DIR_ROOT = new Path(localFs.getWorkingDirectory(), BUFFER_DIR_ROOT).toUri().getPath();
        QUALIFIED_DIR_ROOT = new Path(localFs.getWorkingDirectory(), BUFFER_DIR_ROOT).toUri().toString();
    }
}

