/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ipc;

import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ipc.CallQueueManager;
import org.apache.hadoop.ipc.FairCallQueue;
import org.apache.hadoop.ipc.IdentityProvider;
import org.apache.hadoop.ipc.RetriableException;
import org.apache.hadoop.ipc.RpcMultiplexer;
import org.apache.hadoop.ipc.RpcServerException;
import org.apache.hadoop.ipc.Schedulable;
import org.apache.hadoop.ipc.UserIdentityProvider;
import org.apache.hadoop.ipc.protobuf.RpcHeaderProtos;
import org.apache.hadoop.security.UserGroupInformation;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestFairCallQueue
extends TestCase {
    private FairCallQueue<Schedulable> fcq;

    private Schedulable mockCall(String id, int priority) {
        Schedulable mockCall = (Schedulable)Mockito.mock(Schedulable.class);
        UserGroupInformation ugi = (UserGroupInformation)Mockito.mock(UserGroupInformation.class);
        Mockito.when((Object)ugi.getUserName()).thenReturn((Object)id);
        Mockito.when((Object)mockCall.getUserGroupInformation()).thenReturn((Object)ugi);
        Mockito.when((Object)mockCall.getPriorityLevel()).thenReturn((Object)priority);
        Mockito.when((Object)mockCall.toString()).thenReturn((Object)("id=" + id + " priority=" + priority));
        return mockCall;
    }

    private Schedulable mockCall(String id) {
        return this.mockCall(id, 0);
    }

    public void setUp() {
        Configuration conf = new Configuration();
        conf.setInt("ns.faircallqueue.priority-levels", 2);
        this.fcq = new FairCallQueue(2, 10, "ns", conf);
    }

    public void testTotalCapacityOfSubQueues() {
        Configuration conf = new Configuration();
        FairCallQueue fairCallQueue = new FairCallQueue(1, 1000, "ns", conf);
        TestFairCallQueue.assertEquals((int)fairCallQueue.remainingCapacity(), (int)1000);
        fairCallQueue = new FairCallQueue(4, 1000, "ns", conf);
        TestFairCallQueue.assertEquals((int)fairCallQueue.remainingCapacity(), (int)1000);
        fairCallQueue = new FairCallQueue(7, 1000, "ns", conf);
        TestFairCallQueue.assertEquals((int)fairCallQueue.remainingCapacity(), (int)1000);
        fairCallQueue = new FairCallQueue(1, 1025, "ns", conf);
        TestFairCallQueue.assertEquals((int)fairCallQueue.remainingCapacity(), (int)1025);
        fairCallQueue = new FairCallQueue(4, 1025, "ns", conf);
        TestFairCallQueue.assertEquals((int)fairCallQueue.remainingCapacity(), (int)1025);
        fairCallQueue = new FairCallQueue(7, 1025, "ns", conf);
        TestFairCallQueue.assertEquals((int)fairCallQueue.remainingCapacity(), (int)1025);
    }

    @Test
    public void testPrioritization() {
        int numQueues = 10;
        Configuration conf = new Configuration();
        this.fcq = new FairCallQueue(numQueues, numQueues, "ns", conf);
        ArrayList<Schedulable> calls = new ArrayList<Schedulable>();
        for (int i = 0; i < numQueues; ++i) {
            Schedulable call = this.mockCall("u", i);
            calls.add(call);
            this.fcq.add(call);
        }
        final AtomicInteger currentIndex = new AtomicInteger();
        this.fcq.setMultiplexer(new RpcMultiplexer(){

            public int getAndAdvanceCurrentIndex() {
                return currentIndex.get();
            }
        });
        currentIndex.set(3);
        TestFairCallQueue.assertSame(calls.get(3), (Object)this.fcq.poll());
        TestFairCallQueue.assertSame(calls.get(0), (Object)this.fcq.poll());
        TestFairCallQueue.assertSame(calls.get(1), (Object)this.fcq.poll());
        currentIndex.set(6);
        TestFairCallQueue.assertSame(calls.get(6), (Object)this.fcq.poll());
        TestFairCallQueue.assertSame(calls.get(2), (Object)this.fcq.poll());
        TestFairCallQueue.assertSame(calls.get(4), (Object)this.fcq.poll());
        currentIndex.set(8);
        TestFairCallQueue.assertSame(calls.get(8), (Object)this.fcq.poll());
        currentIndex.set(9);
        TestFairCallQueue.assertSame(calls.get(9), (Object)this.fcq.poll());
        TestFairCallQueue.assertSame(calls.get(5), (Object)this.fcq.poll());
        TestFairCallQueue.assertSame(calls.get(7), (Object)this.fcq.poll());
        TestFairCallQueue.assertNull((Object)this.fcq.poll());
        TestFairCallQueue.assertNull((Object)this.fcq.poll());
    }

    @Test
    public void testInsertion() throws Exception {
        Configuration conf = new Configuration();
        this.fcq = (FairCallQueue)Mockito.spy((Object)new FairCallQueue(3, 6, "ns", conf));
        Schedulable p0 = this.mockCall("a", 0);
        Schedulable p1 = this.mockCall("b", 1);
        Schedulable p2 = this.mockCall("c", 2);
        Mockito.reset((Object[])new FairCallQueue[]{this.fcq});
        this.fcq.add(p0);
        ((FairCallQueue)Mockito.verify(this.fcq, (VerificationMode)Mockito.times((int)1))).offerQueue(0, p0);
        ((FairCallQueue)Mockito.verify(this.fcq, (VerificationMode)Mockito.times((int)0))).offerQueue(1, p0);
        ((FairCallQueue)Mockito.verify(this.fcq, (VerificationMode)Mockito.times((int)0))).offerQueue(2, p0);
        Mockito.reset((Object[])new FairCallQueue[]{this.fcq});
        Mockito.reset((Object[])new FairCallQueue[]{this.fcq});
        this.fcq.add(p1);
        ((FairCallQueue)Mockito.verify(this.fcq, (VerificationMode)Mockito.times((int)0))).offerQueue(0, p1);
        ((FairCallQueue)Mockito.verify(this.fcq, (VerificationMode)Mockito.times((int)1))).offerQueue(1, p1);
        ((FairCallQueue)Mockito.verify(this.fcq, (VerificationMode)Mockito.times((int)0))).offerQueue(2, p1);
        Mockito.reset((Object[])new FairCallQueue[]{this.fcq});
        this.fcq.add(p0);
        ((FairCallQueue)Mockito.verify(this.fcq, (VerificationMode)Mockito.times((int)1))).offerQueue(0, p0);
        ((FairCallQueue)Mockito.verify(this.fcq, (VerificationMode)Mockito.times((int)0))).offerQueue(1, p0);
        ((FairCallQueue)Mockito.verify(this.fcq, (VerificationMode)Mockito.times((int)0))).offerQueue(2, p0);
        Mockito.reset((Object[])new FairCallQueue[]{this.fcq});
        this.fcq.add(p0);
        ((FairCallQueue)Mockito.verify(this.fcq, (VerificationMode)Mockito.times((int)1))).offerQueue(0, p0);
        ((FairCallQueue)Mockito.verify(this.fcq, (VerificationMode)Mockito.times((int)1))).offerQueue(1, p0);
        ((FairCallQueue)Mockito.verify(this.fcq, (VerificationMode)Mockito.times((int)0))).offerQueue(2, p0);
        Mockito.reset((Object[])new FairCallQueue[]{this.fcq});
        this.fcq.add(p1);
        ((FairCallQueue)Mockito.verify(this.fcq, (VerificationMode)Mockito.times((int)0))).offerQueue(0, p1);
        ((FairCallQueue)Mockito.verify(this.fcq, (VerificationMode)Mockito.times((int)1))).offerQueue(1, p1);
        ((FairCallQueue)Mockito.verify(this.fcq, (VerificationMode)Mockito.times((int)1))).offerQueue(2, p1);
        Mockito.reset((Object[])new FairCallQueue[]{this.fcq});
        this.fcq.add(p0);
        ((FairCallQueue)Mockito.verify(this.fcq, (VerificationMode)Mockito.times((int)1))).offerQueue(0, p0);
        ((FairCallQueue)Mockito.verify(this.fcq, (VerificationMode)Mockito.times((int)1))).offerQueue(1, p0);
        ((FairCallQueue)Mockito.verify(this.fcq, (VerificationMode)Mockito.times((int)1))).offerQueue(2, p0);
        Mockito.reset((Object[])new FairCallQueue[]{this.fcq});
        try {
            this.fcq.add(p0);
            TestFairCallQueue.fail((String)"didn't fail");
        }
        catch (IllegalStateException ise) {
            this.checkOverflowException(ise, RpcHeaderProtos.RpcResponseHeaderProto.RpcStatusProto.ERROR);
        }
        ((FairCallQueue)Mockito.verify(this.fcq, (VerificationMode)Mockito.times((int)1))).offerQueue(0, p0);
        ((FairCallQueue)Mockito.verify(this.fcq, (VerificationMode)Mockito.times((int)1))).offerQueue(1, p0);
        ((FairCallQueue)Mockito.verify(this.fcq, (VerificationMode)Mockito.times((int)1))).offerQueue(2, p0);
        Mockito.reset((Object[])new FairCallQueue[]{this.fcq});
        try {
            this.fcq.add(p1);
            TestFairCallQueue.fail((String)"didn't fail");
        }
        catch (IllegalStateException ise) {
            this.checkOverflowException(ise, RpcHeaderProtos.RpcResponseHeaderProto.RpcStatusProto.ERROR);
        }
        ((FairCallQueue)Mockito.verify(this.fcq, (VerificationMode)Mockito.times((int)0))).offerQueue(0, p1);
        ((FairCallQueue)Mockito.verify(this.fcq, (VerificationMode)Mockito.times((int)1))).offerQueue(1, p1);
        ((FairCallQueue)Mockito.verify(this.fcq, (VerificationMode)Mockito.times((int)1))).offerQueue(2, p1);
        Mockito.reset((Object[])new FairCallQueue[]{this.fcq});
        try {
            this.fcq.add(p2);
            TestFairCallQueue.fail((String)"didn't fail");
        }
        catch (IllegalStateException ise) {
            this.checkOverflowException(ise, RpcHeaderProtos.RpcResponseHeaderProto.RpcStatusProto.FATAL);
        }
        ((FairCallQueue)Mockito.verify(this.fcq, (VerificationMode)Mockito.times((int)0))).offerQueue(0, p2);
        ((FairCallQueue)Mockito.verify(this.fcq, (VerificationMode)Mockito.times((int)0))).offerQueue(1, p2);
        ((FairCallQueue)Mockito.verify(this.fcq, (VerificationMode)Mockito.times((int)1))).offerQueue(2, p2);
        Mockito.reset((Object[])new FairCallQueue[]{this.fcq});
        RuntimeException stopPuts = new RuntimeException();
        Mockito.reset((Object[])new FairCallQueue[]{this.fcq});
        try {
            ((FairCallQueue)Mockito.doThrow((Throwable)stopPuts).when(this.fcq)).putQueue(Mockito.anyInt(), (Schedulable)Mockito.anyObject());
            this.fcq.put(p0);
            TestFairCallQueue.fail((String)"didn't fail");
        }
        catch (Exception e) {
            TestFairCallQueue.assertSame((Object)stopPuts, (Object)e);
        }
        ((FairCallQueue)Mockito.verify(this.fcq, (VerificationMode)Mockito.times((int)1))).offerQueue(0, p0);
        ((FairCallQueue)Mockito.verify(this.fcq, (VerificationMode)Mockito.times((int)1))).offerQueue(1, p0);
        ((FairCallQueue)Mockito.verify(this.fcq, (VerificationMode)Mockito.times((int)0))).offerQueue(2, p0);
        ((FairCallQueue)Mockito.verify(this.fcq, (VerificationMode)Mockito.times((int)1))).putQueue(2, p0);
        Mockito.reset((Object[])new FairCallQueue[]{this.fcq});
        try {
            ((FairCallQueue)Mockito.doThrow((Throwable)stopPuts).when(this.fcq)).putQueue(Mockito.anyInt(), (Schedulable)Mockito.anyObject());
            this.fcq.put(p2);
            TestFairCallQueue.fail((String)"didn't fail");
        }
        catch (Exception e) {
            TestFairCallQueue.assertSame((Object)stopPuts, (Object)e);
        }
        ((FairCallQueue)Mockito.verify(this.fcq, (VerificationMode)Mockito.times((int)0))).offerQueue(0, p2);
        ((FairCallQueue)Mockito.verify(this.fcq, (VerificationMode)Mockito.times((int)0))).offerQueue(1, p2);
        ((FairCallQueue)Mockito.verify(this.fcq, (VerificationMode)Mockito.times((int)0))).offerQueue(2, p2);
        ((FairCallQueue)Mockito.verify(this.fcq, (VerificationMode)Mockito.times((int)1))).putQueue(2, p2);
    }

    private void checkOverflowException(Exception ex, RpcHeaderProtos.RpcResponseHeaderProto.RpcStatusProto status) {
        TestFairCallQueue.assertTrue((String)(ex.getClass().getName() + " != CallQueueOverflowException"), (boolean)(ex instanceof CallQueueManager.CallQueueOverflowException));
        IOException ioe = ((CallQueueManager.CallQueueOverflowException)ex).getCause();
        TestFairCallQueue.assertNotNull((Object)ioe);
        TestFairCallQueue.assertTrue((String)(ioe.getClass().getName() + " != RpcServerException"), (boolean)(ioe instanceof RpcServerException));
        RpcServerException rse = (RpcServerException)ioe;
        TestFairCallQueue.assertEquals((Object)status, (Object)rse.getRpcStatusProto());
        TestFairCallQueue.assertTrue((String)(rse.getClass().getName() + " != RetriableException"), (boolean)(rse.getCause() instanceof RetriableException));
    }

    public void testPollReturnsNullWhenEmpty() {
        TestFairCallQueue.assertNull((Object)this.fcq.poll());
    }

    public void testPollReturnsTopCallWhenNotEmpty() {
        Schedulable call = this.mockCall("c");
        TestFairCallQueue.assertTrue((boolean)this.fcq.offer(call));
        TestFairCallQueue.assertEquals((Object)call, (Object)this.fcq.poll());
        TestFairCallQueue.assertEquals((int)0, (int)this.fcq.size());
    }

    public void testOfferSucceeds() {
        for (int i = 0; i < 5; ++i) {
            TestFairCallQueue.assertTrue((boolean)this.fcq.offer(this.mockCall("c")));
        }
        TestFairCallQueue.assertEquals((int)5, (int)this.fcq.size());
    }

    public void testOfferFailsWhenFull() {
        for (int i = 0; i < 5; ++i) {
            TestFairCallQueue.assertTrue((boolean)this.fcq.offer(this.mockCall("c")));
        }
        TestFairCallQueue.assertFalse((boolean)this.fcq.offer(this.mockCall("c")));
        TestFairCallQueue.assertEquals((int)5, (int)this.fcq.size());
    }

    public void testOfferSucceedsWhenScheduledLowPriority() {
        int[] mockedPriorities = new int[]{0, 0, 0, 0, 0, 1, 0};
        for (int i = 0; i < 5; ++i) {
            TestFairCallQueue.assertTrue((boolean)this.fcq.offer(this.mockCall("c", mockedPriorities[i])));
        }
        TestFairCallQueue.assertTrue((boolean)this.fcq.offer(this.mockCall("c", mockedPriorities[5])));
        TestFairCallQueue.assertEquals((int)6, (int)this.fcq.size());
    }

    public void testPeekNullWhenEmpty() {
        TestFairCallQueue.assertNull((Object)this.fcq.peek());
    }

    public void testPeekNonDestructive() {
        Schedulable call = this.mockCall("c", 0);
        TestFairCallQueue.assertTrue((boolean)this.fcq.offer(call));
        TestFairCallQueue.assertEquals((Object)call, (Object)this.fcq.peek());
        TestFairCallQueue.assertEquals((Object)call, (Object)this.fcq.peek());
        TestFairCallQueue.assertEquals((int)1, (int)this.fcq.size());
    }

    public void testPeekPointsAtHead() {
        Schedulable call = this.mockCall("c", 0);
        Schedulable next = this.mockCall("b", 0);
        this.fcq.offer(call);
        this.fcq.offer(next);
        TestFairCallQueue.assertEquals((Object)call, (Object)this.fcq.peek());
    }

    public void testPollTimeout() throws InterruptedException {
        TestFairCallQueue.assertNull((Object)this.fcq.poll(10L, TimeUnit.MILLISECONDS));
    }

    public void testPollSuccess() throws InterruptedException {
        Schedulable call = this.mockCall("c", 0);
        TestFairCallQueue.assertTrue((boolean)this.fcq.offer(call));
        TestFairCallQueue.assertEquals((Object)call, (Object)this.fcq.poll(10L, TimeUnit.MILLISECONDS));
        TestFairCallQueue.assertEquals((int)0, (int)this.fcq.size());
    }

    public void testOfferTimeout() throws InterruptedException {
        for (int i = 0; i < 5; ++i) {
            TestFairCallQueue.assertTrue((boolean)this.fcq.offer(this.mockCall("c"), 10L, TimeUnit.MILLISECONDS));
        }
        TestFairCallQueue.assertFalse((boolean)this.fcq.offer(this.mockCall("e"), 10L, TimeUnit.MILLISECONDS));
        TestFairCallQueue.assertEquals((int)5, (int)this.fcq.size());
    }

    public void testDrainTo() {
        Configuration conf = new Configuration();
        conf.setInt("ns.faircallqueue.priority-levels", 2);
        FairCallQueue fcq2 = new FairCallQueue(2, 10, "ns", conf);
        for (int i = 0; i < 3; ++i) {
            this.fcq.offer(this.mockCall("c"));
        }
        this.fcq.drainTo((Collection)fcq2);
        TestFairCallQueue.assertEquals((int)0, (int)this.fcq.size());
        TestFairCallQueue.assertEquals((int)3, (int)fcq2.size());
    }

    public void testDrainToWithLimit() {
        Configuration conf = new Configuration();
        conf.setInt("ns.faircallqueue.priority-levels", 2);
        FairCallQueue fcq2 = new FairCallQueue(2, 10, "ns", conf);
        for (int i = 0; i < 3; ++i) {
            this.fcq.offer(this.mockCall("c"));
        }
        this.fcq.drainTo((Collection)fcq2, 2);
        TestFairCallQueue.assertEquals((int)1, (int)this.fcq.size());
        TestFairCallQueue.assertEquals((int)2, (int)fcq2.size());
    }

    public void testInitialRemainingCapacity() {
        TestFairCallQueue.assertEquals((int)10, (int)this.fcq.remainingCapacity());
    }

    public void testFirstQueueFullRemainingCapacity() {
        while (this.fcq.offer(this.mockCall("c"))) {
        }
        TestFairCallQueue.assertEquals((int)5, (int)this.fcq.remainingCapacity());
    }

    public void testAllQueuesFullRemainingCapacity() {
        int[] mockedPriorities = new int[]{0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 0};
        int i = 0;
        while (this.fcq.offer(this.mockCall("c", mockedPriorities[i++]))) {
        }
        TestFairCallQueue.assertEquals((int)0, (int)this.fcq.remainingCapacity());
        TestFairCallQueue.assertEquals((int)10, (int)this.fcq.size());
    }

    public void testQueuesPartialFilledRemainingCapacity() {
        int[] mockedPriorities = new int[]{0, 1, 0, 1, 0};
        for (int i = 0; i < 5; ++i) {
            this.fcq.offer(this.mockCall("c", mockedPriorities[i]));
        }
        TestFairCallQueue.assertEquals((int)5, (int)this.fcq.remainingCapacity());
        TestFairCallQueue.assertEquals((int)5, (int)this.fcq.size());
    }

    public void assertCanTake(BlockingQueue<Schedulable> cq, int numberOfTakes, int takeAttempts) throws InterruptedException {
        CountDownLatch latch = new CountDownLatch(numberOfTakes);
        Taker taker = new Taker(cq, takeAttempts, "default", latch);
        Thread t = new Thread(taker);
        t.start();
        latch.await();
        TestFairCallQueue.assertEquals((int)numberOfTakes, (int)taker.callsTaken);
        t.interrupt();
    }

    public void assertCanPut(BlockingQueue<Schedulable> cq, int numberOfPuts, int putAttempts) throws InterruptedException {
        CountDownLatch latch = new CountDownLatch(numberOfPuts);
        Putter putter = new Putter(cq, putAttempts, null, latch);
        Thread t = new Thread(putter);
        t.start();
        latch.await();
        TestFairCallQueue.assertEquals((int)numberOfPuts, (int)putter.callsAdded);
        t.interrupt();
    }

    public void testPutOverflows() throws InterruptedException {
        this.assertCanPut((BlockingQueue<Schedulable>)this.fcq, 8, 8);
        TestFairCallQueue.assertEquals((int)8, (int)this.fcq.size());
    }

    public void testPutBlocksWhenAllFull() throws InterruptedException {
        this.assertCanPut((BlockingQueue<Schedulable>)this.fcq, 10, 10);
        TestFairCallQueue.assertEquals((int)10, (int)this.fcq.size());
        this.assertCanPut((BlockingQueue<Schedulable>)this.fcq, 0, 1);
    }

    public void testTakeBlocksWhenEmpty() throws InterruptedException {
        this.assertCanTake((BlockingQueue<Schedulable>)this.fcq, 0, 1);
    }

    public void testTakeRemovesCall() throws InterruptedException {
        Schedulable call = this.mockCall("c");
        this.fcq.offer(call);
        TestFairCallQueue.assertEquals((Object)call, (Object)this.fcq.take());
        TestFairCallQueue.assertEquals((int)0, (int)this.fcq.size());
    }

    public void testTakeTriesNextQueue() throws InterruptedException {
        RpcMultiplexer q0mux = (RpcMultiplexer)Mockito.mock(RpcMultiplexer.class);
        Mockito.when((Object)q0mux.getAndAdvanceCurrentIndex()).thenReturn((Object)0);
        this.fcq.setMultiplexer(q0mux);
        Schedulable call = this.mockCall("c", 1);
        this.fcq.put(call);
        TestFairCallQueue.assertEquals((Object)call, (Object)this.fcq.take());
        TestFairCallQueue.assertEquals((int)0, (int)this.fcq.size());
    }

    public void testFairCallQueueMXBean() throws Exception {
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        ObjectName mxbeanName = new ObjectName("Hadoop:service=ns,name=FairCallQueue");
        Schedulable call = this.mockCall("c");
        this.fcq.put(call);
        int[] queueSizes = (int[])mbs.getAttribute(mxbeanName, "QueueSizes");
        TestFairCallQueue.assertEquals((int)1, (int)queueSizes[0]);
        TestFairCallQueue.assertEquals((int)0, (int)queueSizes[1]);
        this.fcq.take();
        queueSizes = (int[])mbs.getAttribute(mxbeanName, "QueueSizes");
        TestFairCallQueue.assertEquals((int)0, (int)queueSizes[0]);
        TestFairCallQueue.assertEquals((int)0, (int)queueSizes[1]);
    }

    public class Taker
    implements Runnable {
        private final BlockingQueue<Schedulable> cq;
        public final String tag;
        public volatile int callsTaken = 0;
        public volatile Schedulable lastResult = null;
        private final int maxCalls;
        private final CountDownLatch latch;
        private IdentityProvider uip;

        public Taker(BlockingQueue<Schedulable> aCq, int maxCalls, String tag, CountDownLatch latch) {
            this.maxCalls = maxCalls;
            this.cq = aCq;
            this.tag = tag;
            this.uip = new UserIdentityProvider();
            this.latch = latch;
        }

        @Override
        public void run() {
            try {
                while (this.callsTaken < this.maxCalls || this.maxCalls < 0) {
                    Schedulable res = this.cq.take();
                    String identity = this.uip.makeIdentity(res);
                    if (this.tag != null && this.tag.equals(identity)) {
                        this.cq.put(res);
                        continue;
                    }
                    ++this.callsTaken;
                    this.latch.countDown();
                    this.lastResult = res;
                }
            }
            catch (InterruptedException e) {
                return;
            }
        }
    }

    public class Putter
    implements Runnable {
        private final BlockingQueue<Schedulable> cq;
        public final String tag;
        public volatile int callsAdded = 0;
        private final int maxCalls;
        private final CountDownLatch latch;

        public Putter(BlockingQueue<Schedulable> aCq, int maxCalls, String tag, CountDownLatch latch) {
            this.maxCalls = maxCalls;
            this.cq = aCq;
            this.tag = tag;
            this.latch = latch;
        }

        private String getTag() {
            if (this.tag != null) {
                return this.tag;
            }
            return "";
        }

        @Override
        public void run() {
            try {
                while (this.callsAdded < this.maxCalls || this.maxCalls < 0) {
                    this.cq.put(TestFairCallQueue.this.mockCall(this.getTag()));
                    ++this.callsAdded;
                    this.latch.countDown();
                }
            }
            catch (InterruptedException e) {
                return;
            }
        }
    }
}

