/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.metrics2.source;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.metrics2.MetricsCollector;
import org.apache.hadoop.metrics2.MetricsInfo;
import org.apache.hadoop.metrics2.MetricsRecordBuilder;
import org.apache.hadoop.metrics2.MetricsSource;
import org.apache.hadoop.metrics2.impl.MsInfo;
import org.apache.hadoop.metrics2.source.JvmMetrics;
import org.apache.hadoop.metrics2.source.JvmMetricsInfo;
import org.apache.hadoop.service.Service;
import org.apache.hadoop.service.ServiceOperations;
import org.apache.hadoop.service.ServiceStateException;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.test.MetricsAsserts;
import org.apache.hadoop.util.JvmPauseMonitor;
import org.junit.After;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.Timeout;
import org.mockito.Mockito;

public class TestJvmMetrics {
    @Rule
    public Timeout timeout = new Timeout(30000);
    private JvmPauseMonitor pauseMonitor;

    @After
    public void teardown() {
        ServiceOperations.stop((Service)this.pauseMonitor);
    }

    @Test
    public void testPresence() {
        this.pauseMonitor = new JvmPauseMonitor();
        this.pauseMonitor.init(new Configuration());
        this.pauseMonitor.start();
        JvmMetrics jvmMetrics = new JvmMetrics("test", "test");
        jvmMetrics.setPauseMonitor(this.pauseMonitor);
        MetricsRecordBuilder rb = MetricsAsserts.getMetrics((MetricsSource)jvmMetrics);
        MetricsCollector mc = rb.parent();
        ((MetricsCollector)Mockito.verify((Object)mc)).addRecord((MetricsInfo)JvmMetricsInfo.JvmMetrics);
        ((MetricsRecordBuilder)Mockito.verify((Object)rb)).tag((MetricsInfo)MsInfo.ProcessName, "test");
        ((MetricsRecordBuilder)Mockito.verify((Object)rb)).tag((MetricsInfo)MsInfo.SessionId, "test");
        for (JvmMetricsInfo info : JvmMetricsInfo.values()) {
            if (info.name().startsWith("Mem")) {
                ((MetricsRecordBuilder)Mockito.verify((Object)rb)).addGauge((MetricsInfo)Mockito.eq((Object)info), Mockito.anyFloat());
                continue;
            }
            if (info.name().startsWith("Gc")) {
                ((MetricsRecordBuilder)Mockito.verify((Object)rb)).addCounter((MetricsInfo)Mockito.eq((Object)info), Mockito.anyLong());
                continue;
            }
            if (info.name().startsWith("Threads")) {
                ((MetricsRecordBuilder)Mockito.verify((Object)rb)).addGauge((MetricsInfo)Mockito.eq((Object)info), Mockito.anyInt());
                continue;
            }
            if (!info.name().startsWith("Log")) continue;
            ((MetricsRecordBuilder)Mockito.verify((Object)rb)).addCounter((MetricsInfo)Mockito.eq((Object)info), Mockito.anyLong());
        }
    }

    @Test
    public void testDoubleStop() throws Throwable {
        this.pauseMonitor = new JvmPauseMonitor();
        this.pauseMonitor.init(new Configuration());
        this.pauseMonitor.start();
        this.pauseMonitor.stop();
        this.pauseMonitor.stop();
    }

    @Test
    public void testDoubleStart() throws Throwable {
        this.pauseMonitor = new JvmPauseMonitor();
        this.pauseMonitor.init(new Configuration());
        this.pauseMonitor.start();
        this.pauseMonitor.start();
        this.pauseMonitor.stop();
    }

    @Test
    public void testStopBeforeStart() throws Throwable {
        this.pauseMonitor = new JvmPauseMonitor();
        try {
            this.pauseMonitor.init(new Configuration());
            this.pauseMonitor.stop();
            this.pauseMonitor.start();
            Assert.fail((String)("Expected an exception, got " + this.pauseMonitor));
        }
        catch (ServiceStateException e) {
            GenericTestUtils.assertExceptionContains("cannot enter state", e);
        }
    }

    @Test
    public void testStopBeforeInit() throws Throwable {
        this.pauseMonitor = new JvmPauseMonitor();
        try {
            this.pauseMonitor.stop();
            this.pauseMonitor.init(new Configuration());
            Assert.fail((String)("Expected an exception, got " + this.pauseMonitor));
        }
        catch (ServiceStateException e) {
            GenericTestUtils.assertExceptionContains("cannot enter state", e);
        }
    }
}

