/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io.compress.zlib;

import java.io.IOException;
import java.util.zip.Checksum;
import java.util.zip.Deflater;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.compress.Compressor;
import org.apache.hadoop.io.compress.DoNotPool;
import org.apache.hadoop.io.compress.zlib.BuiltInGzipDecompressor;
import org.apache.hadoop.io.compress.zlib.ZlibCompressor;
import org.apache.hadoop.io.compress.zlib.ZlibFactory;
import org.apache.hadoop.util.DataChecksum;

@DoNotPool
public class BuiltInGzipCompressor
implements Compressor {
    private final byte[] gzipHeader = new byte[]{31, -117, 8, 0, 0, 0, 0, 0, 0, 0};
    private final byte[] gzipTrailer = new byte[]{0, 0, 0, 0, 0, 0, 0, 0};
    private final int gzipHeaderLen = this.gzipHeader.length;
    private final int gzipTrailerLen = this.gzipTrailer.length;
    private Deflater deflater;
    private int headerOff = 0;
    private int trailerOff = 0;
    private int numExtraBytesWritten = 0;
    private int accuBufLen = 0;
    private final Checksum crc = DataChecksum.newCrc32();
    private BuiltInGzipDecompressor.GzipStateLabel state;

    public BuiltInGzipCompressor(Configuration conf) {
        this.init(conf);
    }

    @Override
    public boolean finished() {
        return this.state == BuiltInGzipDecompressor.GzipStateLabel.FINISHED && this.deflater.finished();
    }

    @Override
    public boolean needsInput() {
        return this.deflater.needsInput() && this.state != BuiltInGzipDecompressor.GzipStateLabel.TRAILER_CRC;
    }

    @Override
    public int compress(byte[] b, int off, int len) throws IOException {
        if (this.finished()) {
            throw new IOException("compress called on finished compressor");
        }
        int compressedBytesWritten = 0;
        if (this.state == BuiltInGzipDecompressor.GzipStateLabel.HEADER_BASIC) {
            int outputHeaderSize = this.writeHeader(b, off, len);
            this.numExtraBytesWritten += outputHeaderSize;
            compressedBytesWritten += outputHeaderSize;
            if (outputHeaderSize == len) {
                return compressedBytesWritten;
            }
            off += outputHeaderSize;
            len -= outputHeaderSize;
        }
        if (this.state == BuiltInGzipDecompressor.GzipStateLabel.INFLATE_STREAM) {
            int deflated = this.deflater.deflate(b, off, len);
            compressedBytesWritten += deflated;
            off += deflated;
            len -= deflated;
            if (this.deflater.finished()) {
                this.state = BuiltInGzipDecompressor.GzipStateLabel.TRAILER_CRC;
                this.fillTrailer();
            } else {
                return compressedBytesWritten;
            }
        }
        if (this.state == BuiltInGzipDecompressor.GzipStateLabel.TRAILER_CRC) {
            int outputTrailerSize = this.writeTrailer(b, off, len);
            this.numExtraBytesWritten += outputTrailerSize;
            compressedBytesWritten += outputTrailerSize;
        }
        return compressedBytesWritten;
    }

    @Override
    public long getBytesRead() {
        return this.deflater.getTotalIn();
    }

    @Override
    public long getBytesWritten() {
        return this.numExtraBytesWritten + this.deflater.getTotalOut();
    }

    @Override
    public void end() {
        this.deflater.end();
    }

    @Override
    public void finish() {
        this.deflater.finish();
    }

    private void init(Configuration conf) {
        ZlibCompressor.CompressionLevel level = ZlibFactory.getCompressionLevel(conf);
        ZlibCompressor.CompressionStrategy strategy = ZlibFactory.getCompressionStrategy(conf);
        this.deflater = new Deflater(level.compressionLevel(), true);
        this.deflater.setStrategy(strategy.compressionStrategy());
        this.state = BuiltInGzipDecompressor.GzipStateLabel.HEADER_BASIC;
    }

    @Override
    public void reinit(Configuration conf) {
        this.init(conf);
        this.numExtraBytesWritten = 0;
        this.headerOff = 0;
        this.trailerOff = 0;
        this.crc.reset();
        this.accuBufLen = 0;
    }

    @Override
    public void reset() {
        this.deflater.reset();
        this.state = BuiltInGzipDecompressor.GzipStateLabel.HEADER_BASIC;
        this.numExtraBytesWritten = 0;
        this.headerOff = 0;
        this.trailerOff = 0;
        this.crc.reset();
        this.accuBufLen = 0;
    }

    @Override
    public void setDictionary(byte[] b, int off, int len) {
        this.deflater.setDictionary(b, off, len);
    }

    @Override
    public void setInput(byte[] b, int off, int len) {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || off > b.length - len) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.deflater.setInput(b, off, len);
        this.crc.update(b, off, len);
        this.accuBufLen += len;
    }

    private int writeHeader(byte[] b, int off, int len) {
        if (len <= 0) {
            return 0;
        }
        int n = Math.min(len, this.gzipHeaderLen - this.headerOff);
        System.arraycopy(this.gzipHeader, this.headerOff, b, off, n);
        this.headerOff += n;
        if (this.headerOff == this.gzipHeaderLen) {
            this.state = BuiltInGzipDecompressor.GzipStateLabel.INFLATE_STREAM;
        }
        return n;
    }

    private void fillTrailer() {
        if (this.state == BuiltInGzipDecompressor.GzipStateLabel.TRAILER_CRC) {
            int streamCrc = (int)this.crc.getValue();
            this.gzipTrailer[0] = (byte)(streamCrc & 0xFF);
            this.gzipTrailer[1] = (byte)((streamCrc & 0xFF00) >> 8);
            this.gzipTrailer[2] = (byte)((streamCrc & 0xFF0000) >> 16);
            this.gzipTrailer[3] = (byte)((streamCrc & 0xFF000000) >> 24);
            this.gzipTrailer[4] = (byte)(this.accuBufLen & 0xFF);
            this.gzipTrailer[5] = (byte)((this.accuBufLen & 0xFF00) >> 8);
            this.gzipTrailer[6] = (byte)((this.accuBufLen & 0xFF0000) >> 16);
            this.gzipTrailer[7] = (byte)((this.accuBufLen & 0xFF000000) >> 24);
            this.crc.reset();
            this.accuBufLen = 0;
        }
    }

    private int writeTrailer(byte[] b, int off, int len) {
        if (len <= 0) {
            return 0;
        }
        int n = Math.min(len, this.gzipTrailerLen - this.trailerOff);
        System.arraycopy(this.gzipTrailer, this.trailerOff, b, off, n);
        this.trailerOff += n;
        if (this.trailerOff == this.gzipTrailerLen) {
            this.state = BuiltInGzipDecompressor.GzipStateLabel.FINISHED;
            this.headerOff = 0;
            this.trailerOff = 0;
        }
        return n;
    }
}

