/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.shell;

import java.io.IOException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.LinkedList;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.fs.PathIOException;
import org.apache.hadoop.fs.PathIsDirectoryException;
import org.apache.hadoop.fs.PathNotFoundException;
import org.apache.hadoop.fs.shell.CommandFactory;
import org.apache.hadoop.fs.shell.CommandFormat;
import org.apache.hadoop.fs.shell.FsCommand;
import org.apache.hadoop.fs.shell.PathData;
import org.apache.hadoop.util.StringUtils;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class TouchCommands
extends FsCommand {
    public static void registerCommands(CommandFactory factory) {
        factory.addClass(Touchz.class, "-touchz");
        factory.addClass(Touch.class, "-touch");
    }

    public static class Touch
    extends TouchCommands {
        private static final String OPTION_CHANGE_ONLY_MODIFICATION_TIME = "m";
        private static final String OPTION_CHANGE_ONLY_ACCESS_TIME = "a";
        private static final String OPTION_USE_TIMESTAMP = "t";
        private static final String OPTION_DO_NOT_CREATE_FILE = "c";
        public static final String NAME = "touch";
        public static final String USAGE = "[-a] [-m] [-t TIMESTAMP (yyyyMMdd:HHmmss) ] [-c] <path> ...";
        public static final String DESCRIPTION = "Updates the access and modification times of the file specified by the <path> to the current time. If the file does not exist, then a zero length file is created at <path> with current time as the timestamp of that <path>.\n-a Change only the access time \n-m Change only the modification time \n-t TIMESTAMP Use specified timestamp instead of current time\n TIMESTAMP format yyyyMMdd:HHmmss\n-c Do not create any files";
        private boolean changeModTime = false;
        private boolean changeAccessTime = false;
        private boolean doNotCreate = false;
        private String timestamp;
        private final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd:HHmmss");

        @InterfaceAudience.Private
        @VisibleForTesting
        public DateFormat getDateFormat() {
            return this.dateFormat;
        }

        @Override
        protected void processOptions(LinkedList<String> args) {
            this.timestamp = StringUtils.popOptionWithArgument("-t", args);
            CommandFormat cf = new CommandFormat(1, Integer.MAX_VALUE, OPTION_USE_TIMESTAMP, OPTION_CHANGE_ONLY_ACCESS_TIME, OPTION_CHANGE_ONLY_MODIFICATION_TIME, OPTION_DO_NOT_CREATE_FILE);
            cf.parse(args);
            this.changeModTime = cf.getOpt(OPTION_CHANGE_ONLY_MODIFICATION_TIME);
            this.changeAccessTime = cf.getOpt(OPTION_CHANGE_ONLY_ACCESS_TIME);
            this.doNotCreate = cf.getOpt(OPTION_DO_NOT_CREATE_FILE);
        }

        @Override
        protected void processPath(PathData item) throws IOException {
            if (item.stat.isDirectory()) {
                throw new PathIsDirectoryException(item.toString());
            }
            this.touch(item);
        }

        @Override
        protected void processNonexistentPath(PathData item) throws IOException {
            if (!item.parentExists()) {
                throw new PathNotFoundException(item.toString()).withFullyQualifiedPath(item.path.toUri().toString());
            }
            this.touch(item);
        }

        private void touch(PathData item) throws IOException {
            if (!item.fs.exists(item.path)) {
                if (this.doNotCreate) {
                    return;
                }
                item.fs.create(item.path).close();
                if (this.timestamp != null) {
                    this.updateTime(item);
                }
            } else {
                this.updateTime(item);
            }
        }

        private void updateTime(PathData item) throws IOException {
            long time = System.currentTimeMillis();
            if (this.timestamp != null) {
                try {
                    time = this.dateFormat.parse(this.timestamp).getTime();
                }
                catch (ParseException e) {
                    throw new IllegalArgumentException("Unable to parse the specified timestamp " + this.timestamp + ". The expected format is " + this.dateFormat.toPattern(), e);
                }
            }
            if (this.changeModTime ^ this.changeAccessTime) {
                long atime = this.changeModTime ? -1L : time;
                long mtime = this.changeAccessTime ? -1L : time;
                item.fs.setTimes(item.path, mtime, atime);
            } else {
                item.fs.setTimes(item.path, time, time);
            }
        }
    }

    public static class Touchz
    extends TouchCommands {
        public static final String NAME = "touchz";
        public static final String USAGE = "<path> ...";
        public static final String DESCRIPTION = "Creates a file of zero length at <path> with current time as the timestamp of that <path>. An error is returned if the file exists with non-zero length\n";

        @Override
        protected void processOptions(LinkedList<String> args) {
            CommandFormat cf = new CommandFormat(1, Integer.MAX_VALUE, new String[0]);
            cf.parse(args);
        }

        @Override
        protected void processPath(PathData item) throws IOException {
            if (item.stat.isDirectory()) {
                throw new PathIsDirectoryException(item.toString());
            }
            if (item.stat.getLen() != 0L) {
                throw new PathIOException(item.toString(), "Not a zero-length file");
            }
            this.touchz(item);
        }

        @Override
        protected void processNonexistentPath(PathData item) throws IOException {
            if (!item.parentExists()) {
                throw new PathNotFoundException(item.toString()).withFullyQualifiedPath(item.path.toUri().toString());
            }
            this.touchz(item);
        }

        private void touchz(PathData item) throws IOException {
            item.fs.create(item.path).close();
        }
    }
}

