/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.InetAddress;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.naming.AuthenticationException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import javax.naming.spi.InitialContextFactory;
import javax.net.SocketFactory;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.GroupMappingServiceProvider;
import org.apache.hadoop.thirdparty.com.google.common.collect.Iterators;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.LimitedPrivate(value={"HDFS", "MapReduce"})
@InterfaceStability.Evolving
public class LdapGroupsMapping
implements GroupMappingServiceProvider,
Configurable {
    public static final String LDAP_CONFIG_PREFIX = "hadoop.security.group.mapping.ldap";
    public static final String LDAP_URL_KEY = "hadoop.security.group.mapping.ldap.url";
    public static final String LDAP_URL_DEFAULT = "";
    public static final String LDAP_USE_SSL_KEY = "hadoop.security.group.mapping.ldap.ssl";
    public static final Boolean LDAP_USE_SSL_DEFAULT = false;
    public static final String LDAP_KEYSTORE_KEY = "hadoop.security.group.mapping.ldap.ssl.keystore";
    public static final String LDAP_KEYSTORE_DEFAULT = "";
    public static final String LDAP_KEYSTORE_PASSWORD_KEY = "hadoop.security.group.mapping.ldap.ssl.keystore.password";
    public static final String LDAP_KEYSTORE_PASSWORD_DEFAULT = "";
    public static final String LDAP_KEYSTORE_PASSWORD_FILE_KEY = "hadoop.security.group.mapping.ldap.ssl.keystore.password.file";
    public static final String LDAP_KEYSTORE_PASSWORD_FILE_DEFAULT = "";
    public static final String LDAP_TRUSTSTORE_KEY = "hadoop.security.group.mapping.ldap.ssl.truststore";
    public static final String LDAP_TRUSTSTORE_PASSWORD_KEY = "hadoop.security.group.mapping.ldap.ssl.truststore.password";
    public static final String LDAP_TRUSTSTORE_PASSWORD_FILE_KEY = "hadoop.security.group.mapping.ldap.ssl.truststore.password.file";
    public static final String BIND_USERS_KEY = "hadoop.security.group.mapping.ldap.bind.users";
    public static final String BIND_USER_SUFFIX = ".bind.user";
    public static final String BIND_USER_KEY = "hadoop.security.group.mapping.ldap.bind.user";
    public static final String BIND_USER_DEFAULT = "";
    public static final String BIND_PASSWORD_SUFFIX = ".bind.password";
    public static final String BIND_PASSWORD_KEY = "hadoop.security.group.mapping.ldap.bind.password";
    public static final String BIND_PASSWORD_DEFAULT = "";
    public static final String BIND_PASSWORD_FILE_SUFFIX = ".bind.password.file";
    public static final String BIND_PASSWORD_FILE_KEY = "hadoop.security.group.mapping.ldap.bind.password.file";
    public static final String BIND_PASSWORD_FILE_DEFAULT = "";
    public static final String BIND_PASSWORD_ALIAS_SUFFIX = ".bind.password.alias";
    public static final String BIND_PASSWORD_ALIAS_KEY = "hadoop.security.group.mapping.ldap.bind.password.alias";
    public static final String BIND_PASSWORD_ALIAS_DEFAULT = "";
    public static final String BASE_DN_KEY = "hadoop.security.group.mapping.ldap.base";
    public static final String BASE_DN_DEFAULT = "";
    public static final String USER_BASE_DN_KEY = "hadoop.security.group.mapping.ldap.userbase";
    public static final String GROUP_BASE_DN_KEY = "hadoop.security.group.mapping.ldap.groupbase";
    public static final String USER_SEARCH_FILTER_KEY = "hadoop.security.group.mapping.ldap.search.filter.user";
    public static final String USER_SEARCH_FILTER_DEFAULT = "(&(objectClass=user)(sAMAccountName={0}))";
    public static final String GROUP_SEARCH_FILTER_KEY = "hadoop.security.group.mapping.ldap.search.filter.group";
    public static final String GROUP_SEARCH_FILTER_DEFAULT = "(objectClass=group)";
    public static final String MEMBEROF_ATTR_KEY = "hadoop.security.group.mapping.ldap.search.attr.memberof";
    public static final String MEMBEROF_ATTR_DEFAULT = "";
    public static final String GROUP_MEMBERSHIP_ATTR_KEY = "hadoop.security.group.mapping.ldap.search.attr.member";
    public static final String GROUP_MEMBERSHIP_ATTR_DEFAULT = "member";
    public static final String GROUP_NAME_ATTR_KEY = "hadoop.security.group.mapping.ldap.search.attr.group.name";
    public static final String GROUP_NAME_ATTR_DEFAULT = "cn";
    public static final String GROUP_HIERARCHY_LEVELS_KEY = "hadoop.security.group.mapping.ldap.search.group.hierarchy.levels";
    public static final int GROUP_HIERARCHY_LEVELS_DEFAULT = 0;
    public static final String POSIX_UID_ATTR_KEY = "hadoop.security.group.mapping.ldap.posix.attr.uid.name";
    public static final String POSIX_UID_ATTR_DEFAULT = "uidNumber";
    public static final String POSIX_GID_ATTR_KEY = "hadoop.security.group.mapping.ldap.posix.attr.gid.name";
    public static final String POSIX_GID_ATTR_DEFAULT = "gidNumber";
    public static final String POSIX_GROUP = "posixGroup";
    public static final String POSIX_ACCOUNT = "posixAccount";
    public static final String DIRECTORY_SEARCH_TIMEOUT = "hadoop.security.group.mapping.ldap.directory.search.timeout";
    public static final int DIRECTORY_SEARCH_TIMEOUT_DEFAULT = 10000;
    public static final String CONNECTION_TIMEOUT = "hadoop.security.group.mapping.ldap.connection.timeout.ms";
    public static final int CONNECTION_TIMEOUT_DEFAULT = 60000;
    public static final String READ_TIMEOUT = "hadoop.security.group.mapping.ldap.read.timeout.ms";
    public static final int READ_TIMEOUT_DEFAULT = 60000;
    public static final String LDAP_NUM_ATTEMPTS_KEY = "hadoop.security.group.mapping.ldap.num.attempts";
    public static final int LDAP_NUM_ATTEMPTS_DEFAULT = 3;
    public static final String LDAP_NUM_ATTEMPTS_BEFORE_FAILOVER_KEY = "hadoop.security.group.mapping.ldap.num.attempts.before.failover";
    public static final int LDAP_NUM_ATTEMPTS_BEFORE_FAILOVER_DEFAULT = 3;
    public static final String LDAP_CTX_FACTORY_CLASS_KEY = "hadoop.security.group.mapping.ldap.ctx.factory.class";
    public static final String LDAP_CTX_FACTORY_CLASS_DEFAULT = "com.sun.jndi.ldap.LdapCtxFactory";
    private static final String LDAP_SOCKET_FACTORY_ENV_KEY = "java.naming.ldap.factory.socket";
    private static final Logger LOG = LoggerFactory.getLogger(LdapGroupsMapping.class);
    static final SearchControls SEARCH_CONTROLS = new SearchControls();
    private DirContext ctx;
    private volatile Configuration conf;
    private volatile Iterator<String> ldapUrls;
    private String currentLdapUrl;
    private volatile boolean useSsl;
    private String keystore;
    private String keystorePass;
    private String truststore;
    private String truststorePass;
    private Iterator<BindUserInfo> bindUsers;
    private BindUserInfo currentBindUser;
    private volatile String userbaseDN;
    private String groupbaseDN;
    private String groupSearchFilter;
    private volatile String userSearchFilter;
    private volatile String memberOfAttr;
    private String groupMemberAttr;
    private volatile String groupNameAttr;
    private volatile int groupHierarchyLevels;
    private volatile String posixUidAttr;
    private volatile String posixGidAttr;
    private boolean isPosix;
    private volatile boolean useOneQuery;
    private int numAttempts;
    private volatile int numAttemptsBeforeFailover;
    private volatile String ldapCtxFactoryClassName;

    @Override
    public synchronized List<String> getGroups(String user) {
        return new ArrayList<String>(this.getGroupsSet(user));
    }

    private String getRelativeDistinguishedName(String distinguishedName) throws NamingException {
        LdapName ldn = new LdapName(distinguishedName);
        List<Rdn> rdns = ldn.getRdns();
        if (rdns.isEmpty()) {
            throw new NamingException("DN is empty");
        }
        Rdn rdn = rdns.get(rdns.size() - 1);
        if (rdn.getType().equalsIgnoreCase(this.groupNameAttr)) {
            String groupName = (String)rdn.getValue();
            return groupName;
        }
        throw new NamingException("Unable to find RDN: The DN " + distinguishedName + " is malformed.");
    }

    private NamingEnumeration<SearchResult> lookupPosixGroup(SearchResult result, DirContext c) throws NamingException {
        String gidNumber = null;
        String uidNumber = null;
        Attribute gidAttribute = result.getAttributes().get(this.posixGidAttr);
        Attribute uidAttribute = result.getAttributes().get(this.posixUidAttr);
        String reason = "";
        if (gidAttribute == null) {
            reason = "Can't find attribute '" + this.posixGidAttr + "'.";
        } else {
            gidNumber = gidAttribute.get().toString();
        }
        if (uidAttribute == null) {
            reason = "Can't find attribute '" + this.posixUidAttr + "'.";
        } else {
            uidNumber = uidAttribute.get().toString();
        }
        if (uidNumber != null && gidNumber != null) {
            return c.search(this.groupbaseDN, "(&" + this.groupSearchFilter + "(|(" + this.posixGidAttr + "={0})(" + this.groupMemberAttr + "={1})))", new Object[]{gidNumber, uidNumber}, SEARCH_CONTROLS);
        }
        throw new NamingException("The server does not support posixGroups semantics. Reason: " + reason + " Returned user object: " + result.toString());
    }

    private Set<String> lookupGroup(SearchResult result, DirContext c, int goUpHierarchy) throws NamingException {
        NamingEnumeration<SearchResult> groupResults;
        LinkedHashSet<String> groups = new LinkedHashSet<String>();
        HashSet<String> groupDNs = new HashSet<String>();
        if (this.isPosix) {
            groupResults = this.lookupPosixGroup(result, c);
        } else {
            String userDn = result.getNameInNamespace();
            groupResults = c.search(this.groupbaseDN, "(&" + this.groupSearchFilter + "(" + this.groupMemberAttr + "={0}))", new Object[]{userDn}, SEARCH_CONTROLS);
        }
        if (groupResults != null) {
            while (groupResults.hasMoreElements()) {
                SearchResult groupResult = (SearchResult)groupResults.nextElement();
                this.getGroupNames(groupResult, groups, groupDNs, goUpHierarchy > 0);
            }
            if (goUpHierarchy > 0 && !this.isPosix) {
                this.goUpGroupHierarchy(groupDNs, goUpHierarchy, groups);
            }
        }
        return groups;
    }

    Set<String> doGetGroups(String user, int goUpHierarchy) throws NamingException {
        DirContext c = this.getDirContext();
        NamingEnumeration<SearchResult> results = c.search(this.userbaseDN, this.userSearchFilter, new Object[]{user}, SEARCH_CONTROLS);
        if (!results.hasMoreElements()) {
            LOG.debug("doGetGroups({}) returned no groups because the user is not found.", (Object)user);
            return Collections.emptySet();
        }
        SearchResult result = (SearchResult)results.nextElement();
        Set<String> groups = Collections.emptySet();
        if (this.useOneQuery) {
            try {
                Attribute groupDNAttr = result.getAttributes().get(this.memberOfAttr);
                if (groupDNAttr == null) {
                    throw new NamingException("The user object does not have '" + this.memberOfAttr + "' attribute.Returned user object: " + result.toString());
                }
                groups = new LinkedHashSet();
                NamingEnumeration<?> groupEnumeration = groupDNAttr.getAll();
                while (groupEnumeration.hasMore()) {
                    String groupDN = groupEnumeration.next().toString();
                    groups.add(this.getRelativeDistinguishedName(groupDN));
                }
            }
            catch (NamingException e) {
                LOG.info("Failed to get groups from the first lookup. Initiating the second LDAP query using the user's DN.", (Throwable)e);
            }
        }
        if (groups.isEmpty() || goUpHierarchy > 0) {
            groups = this.lookupGroup(result, c, goUpHierarchy);
        }
        LOG.debug("doGetGroups({}) returned {}", (Object)user, groups);
        return groups;
    }

    void getGroupNames(SearchResult groupResult, Collection<String> groups, Collection<String> groupDNs, boolean doGetDNs) throws NamingException {
        Attribute groupName = groupResult.getAttributes().get(this.groupNameAttr);
        if (groupName == null) {
            throw new NamingException("The group object does not have attribute '" + this.groupNameAttr + "'.");
        }
        groups.add(groupName.get().toString());
        if (doGetDNs) {
            groupDNs.add(groupResult.getNameInNamespace());
        }
    }

    void goUpGroupHierarchy(Set<String> groupDNs, int goUpHierarchy, Set<String> groups) throws NamingException {
        if (goUpHierarchy <= 0 || groups.isEmpty()) {
            return;
        }
        DirContext context = this.getDirContext();
        HashSet<String> nextLevelGroups = new HashSet<String>();
        StringBuilder filter = new StringBuilder();
        filter.append("(&").append(this.groupSearchFilter).append("(|");
        for (String dn : groupDNs) {
            filter.append("(").append(this.groupMemberAttr).append("=").append(dn).append(")");
        }
        filter.append("))");
        LOG.debug("Ldap group query string: " + filter.toString());
        NamingEnumeration<SearchResult> groupResults = context.search(this.groupbaseDN, filter.toString(), SEARCH_CONTROLS);
        while (groupResults.hasMoreElements()) {
            SearchResult groupResult = (SearchResult)groupResults.nextElement();
            this.getGroupNames(groupResult, groups, nextLevelGroups, true);
        }
        this.goUpGroupHierarchy(nextLevelGroups, goUpHierarchy - 1, groups);
    }

    protected boolean failover(int attemptsMadeWithSameLdap, int maxAttemptsBeforeFailover) {
        if (attemptsMadeWithSameLdap >= maxAttemptsBeforeFailover) {
            String previousLdapUrl = this.currentLdapUrl;
            this.currentLdapUrl = this.ldapUrls.next();
            LOG.info("Reached {} attempts on {}, failing over to {}", new Object[]{attemptsMadeWithSameLdap, previousLdapUrl, this.currentLdapUrl});
            return true;
        }
        return false;
    }

    protected void switchBindUser(AuthenticationException e) {
        BindUserInfo oldBindUser = this.currentBindUser;
        this.currentBindUser = this.bindUsers.next();
        if (!oldBindUser.equals(this.currentBindUser)) {
            LOG.info("Switched from {} to {} after an AuthenticationException: {}", new Object[]{oldBindUser, this.currentBindUser, e.getMessage()});
        }
    }

    private DirContext getDirContext() throws NamingException {
        if (this.ctx == null) {
            Hashtable<String, String> env = new Hashtable<String, String>();
            env.put("java.naming.factory.initial", this.ldapCtxFactoryClassName);
            env.put("java.naming.provider.url", this.currentLdapUrl);
            env.put("java.naming.security.authentication", "simple");
            if (this.useSsl) {
                env.put("java.naming.security.protocol", "ssl");
                LdapSslSocketFactory.setConfigurations(this.keystore, this.keystorePass, this.truststore, this.truststorePass);
                env.put(LDAP_SOCKET_FACTORY_ENV_KEY, LdapSslSocketFactory.class.getName());
            }
            env.put("java.naming.security.principal", this.currentBindUser.username);
            env.put("java.naming.security.credentials", this.currentBindUser.password);
            env.put("com.sun.jndi.ldap.connect.timeout", this.conf.get(CONNECTION_TIMEOUT, String.valueOf(60000)));
            env.put("com.sun.jndi.ldap.read.timeout", this.conf.get(READ_TIMEOUT, String.valueOf(60000)));
            ClassLoader currentContextLoader = Thread.currentThread().getContextClassLoader();
            if (currentContextLoader == null) {
                try {
                    Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
                    this.ctx = new InitialDirContext(env);
                }
                finally {
                    Thread.currentThread().setContextClassLoader(null);
                }
            } else {
                this.ctx = new InitialDirContext(env);
            }
        }
        return this.ctx;
    }

    @Override
    public void cacheGroupsRefresh() {
    }

    @Override
    public void cacheGroupsAdd(List<String> groups) {
    }

    @Override
    public Set<String> getGroupsSet(String user) {
        int atemptsBeforeFailover = 1;
        int attempt = 1;
        while (attempt <= this.numAttempts) {
            block4: {
                try {
                    return this.doGetGroups(user, this.groupHierarchyLevels);
                }
                catch (AuthenticationException e) {
                    this.switchBindUser(e);
                }
                catch (NamingException e) {
                    LOG.warn("Failed to get groups for user {} (attempt={}/{}) using {}. Exception: ", new Object[]{user, attempt, this.numAttempts, this.currentLdapUrl, e});
                    LOG.trace("TRACE", (Throwable)e);
                    if (!this.failover(atemptsBeforeFailover, this.numAttemptsBeforeFailover)) break block4;
                    atemptsBeforeFailover = 0;
                }
            }
            this.ctx = null;
            ++attempt;
            ++atemptsBeforeFailover;
        }
        return Collections.emptySet();
    }

    @Override
    public synchronized Configuration getConf() {
        return this.conf;
    }

    @Override
    public synchronized void setConf(Configuration conf) {
        this.conf = conf;
        Object[] urls = conf.getStrings(LDAP_URL_KEY, "");
        if (urls == null || urls.length == 0) {
            throw new RuntimeException("LDAP URL(s) are not configured");
        }
        this.ldapUrls = Iterators.cycle((Object[])urls);
        this.currentLdapUrl = this.ldapUrls.next();
        this.useSsl = conf.getBoolean(LDAP_USE_SSL_KEY, LDAP_USE_SSL_DEFAULT);
        if (this.useSsl) {
            this.loadSslConf(conf);
        }
        this.initializeBindUsers();
        String baseDN = conf.getTrimmed(BASE_DN_KEY, "");
        this.userbaseDN = conf.getTrimmed(USER_BASE_DN_KEY, baseDN);
        LOG.debug("Usersearch baseDN: {}", (Object)this.userbaseDN);
        this.groupbaseDN = conf.getTrimmed(GROUP_BASE_DN_KEY, baseDN);
        LOG.debug("Groupsearch baseDN: {}", (Object)this.groupbaseDN);
        this.groupSearchFilter = conf.get(GROUP_SEARCH_FILTER_KEY, GROUP_SEARCH_FILTER_DEFAULT);
        this.userSearchFilter = conf.get(USER_SEARCH_FILTER_KEY, USER_SEARCH_FILTER_DEFAULT);
        this.isPosix = this.groupSearchFilter.contains(POSIX_GROUP) && this.userSearchFilter.contains(POSIX_ACCOUNT);
        this.memberOfAttr = conf.get(MEMBEROF_ATTR_KEY, "");
        this.useOneQuery = !this.memberOfAttr.isEmpty();
        this.groupMemberAttr = conf.get(GROUP_MEMBERSHIP_ATTR_KEY, GROUP_MEMBERSHIP_ATTR_DEFAULT);
        this.groupNameAttr = conf.get(GROUP_NAME_ATTR_KEY, GROUP_NAME_ATTR_DEFAULT);
        this.groupHierarchyLevels = conf.getInt(GROUP_HIERARCHY_LEVELS_KEY, 0);
        this.posixUidAttr = conf.get(POSIX_UID_ATTR_KEY, POSIX_UID_ATTR_DEFAULT);
        this.posixGidAttr = conf.get(POSIX_GID_ATTR_KEY, POSIX_GID_ATTR_DEFAULT);
        int dirSearchTimeout = conf.getInt(DIRECTORY_SEARCH_TIMEOUT, 10000);
        SEARCH_CONTROLS.setTimeLimit(dirSearchTimeout);
        String[] returningAttributes = this.useOneQuery ? new String[]{this.groupNameAttr, this.posixUidAttr, this.posixGidAttr, this.memberOfAttr} : new String[]{this.groupNameAttr, this.posixUidAttr, this.posixGidAttr};
        SEARCH_CONTROLS.setReturningAttributes(returningAttributes);
        Class<InitialContextFactory> ldapCtxFactoryClass = conf.getClass(LDAP_CTX_FACTORY_CLASS_KEY, null, InitialContextFactory.class);
        this.ldapCtxFactoryClassName = ldapCtxFactoryClass != null ? ldapCtxFactoryClass.getName() : LDAP_CTX_FACTORY_CLASS_DEFAULT;
        this.numAttempts = conf.getInt(LDAP_NUM_ATTEMPTS_KEY, 3);
        this.numAttemptsBeforeFailover = conf.getInt(LDAP_NUM_ATTEMPTS_BEFORE_FAILOVER_KEY, 3);
    }

    public Iterator<String> getLdapUrls() {
        return this.ldapUrls;
    }

    private void loadSslConf(Configuration sslConf) {
        this.keystore = sslConf.get(LDAP_KEYSTORE_KEY, "");
        this.keystorePass = this.getPassword(sslConf, LDAP_KEYSTORE_PASSWORD_KEY, "");
        if (this.keystorePass.isEmpty()) {
            this.keystorePass = this.extractPassword(sslConf.get(LDAP_KEYSTORE_PASSWORD_FILE_KEY, ""));
        }
        this.truststore = sslConf.get(LDAP_TRUSTSTORE_KEY, "");
        this.truststorePass = this.getPasswordFromCredentialProviders(sslConf, LDAP_TRUSTSTORE_PASSWORD_KEY, "");
        if (this.truststorePass.isEmpty()) {
            this.truststorePass = this.extractPassword(sslConf.get(LDAP_TRUSTSTORE_PASSWORD_FILE_KEY, ""));
        }
    }

    String getPasswordFromCredentialProviders(Configuration config, String alias, String defaultPass) {
        String password = defaultPass;
        try {
            char[] passchars = config.getPasswordFromCredentialProviders(alias);
            if (passchars != null) {
                password = new String(passchars);
            }
        }
        catch (IOException ioe) {
            LOG.warn("Exception while trying to get password for alias {}: {}", (Object)alias, (Object)ioe);
        }
        return password;
    }

    @Deprecated
    String getPassword(Configuration conf, String alias, String defaultPass) {
        String password = defaultPass;
        try {
            char[] passchars = conf.getPassword(alias);
            if (passchars != null) {
                password = new String(passchars);
            }
        }
        catch (IOException ioe) {
            LOG.warn("Exception while trying to get password for alias {}:", (Object)alias, (Object)ioe);
        }
        return password;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    String extractPassword(String pwFile) {
        if (pwFile.isEmpty()) {
            return "";
        }
        StringBuilder password = new StringBuilder();
        try (InputStreamReader reader = new InputStreamReader(Files.newInputStream(Paths.get(pwFile, new String[0]), new OpenOption[0]), StandardCharsets.UTF_8);){
            int c = ((Reader)reader).read();
            while (c > -1) {
                password.append((char)c);
                c = ((Reader)reader).read();
            }
            String string = password.toString().trim();
            return string;
        }
        catch (IOException ioe) {
            throw new RuntimeException("Could not read password file: " + pwFile, ioe);
        }
    }

    private void initializeBindUsers() {
        ArrayList<BindUserInfo> bindUsersConfigured = new ArrayList<BindUserInfo>();
        String[] bindUserAliases = this.conf.getStrings(BIND_USERS_KEY);
        if (bindUserAliases != null && bindUserAliases.length > 0) {
            for (String bindUserAlias : bindUserAliases) {
                String userConfPrefix = "hadoop.security.group.mapping.ldap.bind.users." + bindUserAlias;
                String bindUsername = this.conf.get(userConfPrefix + BIND_USER_SUFFIX);
                String bindPassword = this.getPasswordForBindUser(userConfPrefix);
                if (bindUsername == null || bindPassword == null) {
                    throw new RuntimeException("Bind username or password not configured for user: " + bindUserAlias);
                }
                bindUsersConfigured.add(new BindUserInfo(bindUsername, bindPassword));
            }
        } else {
            String bindUsername = this.conf.get(BIND_USER_KEY, "");
            String bindPassword = this.getPasswordForBindUser(LDAP_CONFIG_PREFIX);
            bindUsersConfigured.add(new BindUserInfo(bindUsername, bindPassword));
        }
        this.bindUsers = Iterators.cycle(bindUsersConfigured);
        this.currentBindUser = this.bindUsers.next();
    }

    private String getPasswordForBindUser(String keyPrefix) {
        String alias = this.conf.get(keyPrefix + BIND_PASSWORD_ALIAS_SUFFIX, "");
        String password = this.getPasswordFromCredentialProviders(this.conf, alias, "");
        if (password.isEmpty() && (password = this.getPassword(this.conf, keyPrefix + BIND_PASSWORD_SUFFIX, "")).isEmpty()) {
            password = this.extractPassword(this.conf.get(keyPrefix + BIND_PASSWORD_FILE_SUFFIX, ""));
        }
        return password;
    }

    static {
        SEARCH_CONTROLS.setSearchScope(2);
    }

    @InterfaceAudience.Private
    public static class LdapSslSocketFactory
    extends SocketFactory {
        private static LdapSslSocketFactory defaultSslFactory;
        private static String keyStoreLocation;
        private static String keyStorePassword;
        private static String trustStoreLocation;
        private static String trustStorePassword;
        private final SSLSocketFactory socketFactory;

        LdapSslSocketFactory(SSLSocketFactory wrappedSocketFactory) {
            this.socketFactory = wrappedSocketFactory;
        }

        public static synchronized SocketFactory getDefault() {
            if (defaultSslFactory == null) {
                try {
                    SSLContext context = SSLContext.getInstance("TLS");
                    context.init(LdapSslSocketFactory.createKeyManagers(), LdapSslSocketFactory.createTrustManagers(), null);
                    defaultSslFactory = new LdapSslSocketFactory(context.getSocketFactory());
                    LOG.info("Successfully instantiated LdapSslSocketFactory with keyStoreLocation = {} and trustStoreLocation = {}", (Object)keyStoreLocation, (Object)trustStoreLocation);
                }
                catch (IOException | GeneralSecurityException e) {
                    throw new RuntimeException("Unable to create SSLSocketFactory", e);
                }
            }
            return defaultSslFactory;
        }

        static synchronized void setConfigurations(String newKeyStoreLocation, String newKeyStorePassword, String newTrustStoreLocation, String newTrustStorePassword) {
            keyStoreLocation = newKeyStoreLocation;
            keyStorePassword = newKeyStorePassword;
            trustStoreLocation = newTrustStoreLocation;
            trustStorePassword = newTrustStorePassword;
        }

        private static KeyManager[] createKeyManagers() throws IOException, GeneralSecurityException {
            if (keyStoreLocation.isEmpty()) {
                return null;
            }
            KeyManagerFactory keyMgrFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            keyMgrFactory.init(LdapSslSocketFactory.createKeyStore(keyStoreLocation, keyStorePassword), LdapSslSocketFactory.getPasswordCharArray(keyStorePassword));
            return keyMgrFactory.getKeyManagers();
        }

        private static TrustManager[] createTrustManagers() throws IOException, GeneralSecurityException {
            if (trustStoreLocation.isEmpty()) {
                return null;
            }
            TrustManagerFactory trustMgrFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustMgrFactory.init(LdapSslSocketFactory.createKeyStore(trustStoreLocation, trustStorePassword));
            return trustMgrFactory.getTrustManagers();
        }

        private static KeyStore createKeyStore(String location, String password) throws IOException, GeneralSecurityException {
            KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            try (FileInputStream keyStoreInput = new FileInputStream(location);){
                keyStore.load(keyStoreInput, LdapSslSocketFactory.getPasswordCharArray(password));
            }
            return keyStore;
        }

        private static char[] getPasswordCharArray(String password) {
            if (password == null || password.isEmpty()) {
                return null;
            }
            return password.toCharArray();
        }

        @Override
        public Socket createSocket() throws IOException {
            return this.socketFactory.createSocket();
        }

        @Override
        public Socket createSocket(String host, int port) throws IOException {
            return this.socketFactory.createSocket(host, port);
        }

        @Override
        public Socket createSocket(String host, int port, InetAddress localHost, int localPort) throws IOException {
            return this.socketFactory.createSocket(host, port, localHost, localPort);
        }

        @Override
        public Socket createSocket(InetAddress host, int port) throws IOException {
            return this.socketFactory.createSocket(host, port);
        }

        @Override
        public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
            return this.socketFactory.createSocket(address, port, localAddress, localPort);
        }
    }

    private static final class BindUserInfo {
        private final String username;
        private final String password;

        private BindUserInfo(String username, String password) {
            this.username = username;
            this.password = password;
        }

        public boolean equals(Object o) {
            if (!(o instanceof BindUserInfo)) {
                return false;
            }
            return this.username.equals(((BindUserInfo)o).username);
        }

        public int hashCode() {
            return this.username.hashCode();
        }

        public String toString() {
            return this.username;
        }
    }
}

