/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util;

import org.apache.hadoop.util.SysInfoWindows;
import org.junit.Assert;
import org.junit.Test;

public class TestSysInfoWindows {
    @Test(timeout=10000L)
    public void parseSystemInfoString() {
        SysInfoWindowsMock tester = new SysInfoWindowsMock();
        tester.setSysinfoString("17177038848,8589467648,15232745472,6400417792,1,2805000,6261812,1234567,2345678,3456789,4567890\r\n");
        Assert.assertEquals((long)17177038848L, (long)tester.getVirtualMemorySize());
        Assert.assertEquals((long)8589467648L, (long)tester.getPhysicalMemorySize());
        Assert.assertEquals((long)15232745472L, (long)tester.getAvailableVirtualMemorySize());
        Assert.assertEquals((long)6400417792L, (long)tester.getAvailablePhysicalMemorySize());
        Assert.assertEquals((long)1L, (long)tester.getNumProcessors());
        Assert.assertEquals((long)1L, (long)tester.getNumCores());
        Assert.assertEquals((long)2805000L, (long)tester.getCpuFrequency());
        Assert.assertEquals((long)6261812L, (long)tester.getCumulativeCpuTime());
        Assert.assertEquals((long)1234567L, (long)tester.getStorageBytesRead());
        Assert.assertEquals((long)2345678L, (long)tester.getStorageBytesWritten());
        Assert.assertEquals((long)3456789L, (long)tester.getNetworkBytesRead());
        Assert.assertEquals((long)4567890L, (long)tester.getNetworkBytesWritten());
        Assert.assertEquals((double)-1.0, (double)tester.getCpuUsagePercentage(), (double)0.0);
        Assert.assertEquals((double)-1.0, (double)tester.getNumVCoresUsed(), (double)0.0);
    }

    @Test(timeout=10000L)
    public void refreshAndCpuUsage() throws InterruptedException {
        SysInfoWindowsMock tester = new SysInfoWindowsMock();
        tester.setSysinfoString("17177038848,8589467648,15232745472,6400417792,1,2805000,6261812,1234567,2345678,3456789,4567890\r\n");
        tester.getAvailablePhysicalMemorySize();
        Assert.assertEquals((long)6400417792L, (long)tester.getAvailablePhysicalMemorySize());
        Assert.assertEquals((double)-1.0, (double)tester.getCpuUsagePercentage(), (double)0.0);
        Assert.assertEquals((double)-1.0, (double)tester.getNumVCoresUsed(), (double)0.0);
        tester.setSysinfoString("17177038848,8589467648,15232745472,5400417792,1,2805000,6263012,1234567,2345678,3456789,4567890\r\n");
        tester.getAvailablePhysicalMemorySize();
        Assert.assertEquals((long)6400417792L, (long)tester.getAvailablePhysicalMemorySize());
        Assert.assertEquals((double)-1.0, (double)tester.getCpuUsagePercentage(), (double)0.0);
        Assert.assertEquals((double)-1.0, (double)tester.getNumVCoresUsed(), (double)0.0);
        tester.advance(1001L);
        Assert.assertEquals((long)5400417792L, (long)tester.getAvailablePhysicalMemorySize());
        Assert.assertEquals((double)119.88011932373047, (double)tester.getCpuUsagePercentage(), (double)0.0);
        Assert.assertEquals((double)1.1988011598587036, (double)tester.getNumVCoresUsed(), (double)0.0);
    }

    @Test(timeout=10000L)
    public void refreshAndCpuUsageMulticore() throws InterruptedException {
        SysInfoWindowsMock tester = new SysInfoWindowsMock();
        tester.setSysinfoString("17177038848,8589467648,15232745472,6400417792,12,2805000,6261812,1234567,2345678,3456789,4567890\r\n");
        Assert.assertEquals((long)6400417792L, (long)tester.getAvailablePhysicalMemorySize());
        tester.setSysinfoString("17177038848,8589467648,15232745472,5400417792,12,2805000,6263012,1234567,2345678,3456789,4567890\r\n");
        Assert.assertEquals((long)6400417792L, (long)tester.getAvailablePhysicalMemorySize());
        tester.advance(1001L);
        Assert.assertEquals((long)5400417792L, (long)tester.getAvailablePhysicalMemorySize());
        Assert.assertEquals((double)9.99001f, (double)tester.getCpuUsagePercentage(), (double)0.0);
        Assert.assertEquals((double)1.1988011598587036, (double)tester.getNumVCoresUsed(), (double)0.0);
    }

    @Test(timeout=10000L)
    public void errorInGetSystemInfo() {
        SysInfoWindowsMock tester = new SysInfoWindowsMock();
        tester.setSysinfoString(null);
        tester.getAvailablePhysicalMemorySize();
        tester.setSysinfoString("");
        tester.getAvailablePhysicalMemorySize();
    }

    static class SysInfoWindowsMock
    extends SysInfoWindows {
        private long time = 1001L;
        private String infoStr = null;

        SysInfoWindowsMock() {
        }

        void setSysinfoString(String infoStr) {
            this.infoStr = infoStr;
        }

        void advance(long dur) {
            this.time += dur;
        }

        String getSystemInfoInfoFromShell() {
            return this.infoStr;
        }

        long now() {
            return this.time;
        }
    }
}

