/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util;

import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.test.AbstractHadoopTestBase;
import org.apache.hadoop.util.WeakReferenceMap;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.junit.Before;
import org.junit.Test;

public class TestWeakReferenceMap
extends AbstractHadoopTestBase {
    public static final String FACTORY_STRING = "recreated %d";
    private WeakReferenceMap<Integer, String> referenceMap;
    private List<Integer> lostReferences;

    @Before
    public void setup() {
        this.lostReferences = new ArrayList<Integer>();
        this.referenceMap = new WeakReferenceMap(this::factory, this::referenceLost);
    }

    private void referenceLost(Integer key) {
        this.lostReferences.add(key);
    }

    @Test
    public void testBasicOperationsWithValidReferences() {
        this.referenceMap.put((Object)1, (Object)"1");
        this.referenceMap.put((Object)2, (Object)"2");
        this.assertMapSize(2);
        this.assertMapContainsKey(1);
        this.assertMapEntryEquals(1, "1");
        this.assertMapEntryEquals(2, "2");
        this.referenceMap.put((Object)1, (Object)"3");
        this.assertMapEntryEquals(1, "3");
        this.referenceMap.remove((Object)1);
        this.assertMapDoesNotContainKey(1);
        this.assertMapSize(1);
        this.referenceMap.clear();
        this.assertMapSize(0);
    }

    @Test
    public void testPruneNullEntries() {
        this.referenceMap.put((Object)1, (Object)"1");
        this.assertPruned(0);
        this.referenceMap.put((Object)2, null);
        this.assertMapSize(2);
        this.assertPruned(1);
        this.assertMapSize(1);
        this.assertMapDoesNotContainKey(2);
        this.assertMapEntryEquals(1, "1");
        this.assertLostCount(1);
    }

    @Test
    public void testDemandCreateEntries() {
        this.assertMapEntryEquals(1, this.factory(1));
        this.assertMapSize(1);
        this.assertMapContainsKey(1);
        this.assertLostCount(0);
        this.referenceMap.put((Object)2, null);
        this.assertMapEntryEquals(2, this.factory(2));
        this.assertLostCount(1);
    }

    private void assertMapEntryEquals(int key, String val) {
        ((AbstractStringAssert)Assertions.assertThat((String)((String)this.referenceMap.get((Object)key))).describedAs("map enty of key %d", new Object[]{key})).isEqualTo((Object)val);
    }

    private void assertMapContainsKey(int key) {
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.referenceMap.containsKey((Object)key)).describedAs("map enty of key %d should be present", new Object[]{key})).isTrue();
    }

    private void assertMapDoesNotContainKey(int key) {
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.referenceMap.containsKey((Object)key)).describedAs("map enty of key %d should be absent", new Object[]{key})).isFalse();
    }

    private void assertMapSize(int size) {
        ((AbstractIntegerAssert)Assertions.assertThat((int)this.referenceMap.size()).describedAs("size of map %s", new Object[]{this.referenceMap})).isEqualTo(size);
    }

    private void assertPruned(int count) {
        ((AbstractIntegerAssert)Assertions.assertThat((int)this.referenceMap.prune()).describedAs("number of entries pruned from map %s", new Object[]{this.referenceMap})).isEqualTo(count);
    }

    private void assertLostCount(int count) {
        ((ListAssert)Assertions.assertThat(this.lostReferences).describedAs("number of entries lost from map %s", new Object[]{this.referenceMap})).hasSize(count);
    }

    private String factory(Integer key) {
        return String.format(FACTORY_STRING, key);
    }
}

