/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util;

import java.lang.reflect.Array;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class GenericsUtil {
    private static final String SLF4J_LOG4J_ADAPTER_CLASS = "org.slf4j.impl.Log4jLoggerAdapter";
    private static final AtomicBoolean IS_LOG4J_LOGGER = new AtomicBoolean(true);

    public static <T> Class<T> getClass(T t) {
        Class<?> clazz = t.getClass();
        return clazz;
    }

    public static <T> T[] toArray(Class<T> c, List<T> list) {
        Object[] ta = (Object[])Array.newInstance(c, list.size());
        for (int i = 0; i < list.size(); ++i) {
            ta[i] = list.get(i);
        }
        return ta;
    }

    public static <T> T[] toArray(List<T> list) {
        return GenericsUtil.toArray(GenericsUtil.getClass(list.get(0)), list);
    }

    public static boolean isLog4jLogger(Class<?> clazz) {
        if (clazz == null) {
            return false;
        }
        return GenericsUtil.isLog4jLogger(clazz.getName());
    }

    public static boolean isLog4jLogger(String logger) {
        if (logger == null || !IS_LOG4J_LOGGER.get()) {
            return false;
        }
        Logger log = LoggerFactory.getLogger((String)logger);
        try {
            Class<?> log4jClass = Class.forName(SLF4J_LOG4J_ADAPTER_CLASS);
            return log4jClass.isInstance(log);
        }
        catch (ClassNotFoundException e) {
            IS_LOG4J_LOGGER.set(false);
            return false;
        }
    }
}

