/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.util.EnumSet;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hadoop.HadoopIllegalArgumentException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.crypto.CryptoProtocolVersion;
import org.apache.hadoop.fs.CanSetDropBehind;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.FSOutputSummer;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.FileEncryptionInfo;
import org.apache.hadoop.fs.ParentNotDirectoryException;
import org.apache.hadoop.fs.StreamCapabilities;
import org.apache.hadoop.fs.Syncable;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.AddBlockFlag;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.DFSPacket;
import org.apache.hadoop.hdfs.DFSStripedOutputStream;
import org.apache.hadoop.hdfs.DataStreamer;
import org.apache.hadoop.hdfs.UnknownCryptoProtocolVersionException;
import org.apache.hadoop.hdfs.client.HdfsDataOutputStream;
import org.apache.hadoop.hdfs.client.impl.DfsClientConf;
import org.apache.hadoop.hdfs.protocol.DSQuotaExceededException;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.protocol.HdfsFileStatus;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.NSQuotaExceededException;
import org.apache.hadoop.hdfs.protocol.QuotaByStorageTypeExceededException;
import org.apache.hadoop.hdfs.protocol.SnapshotAccessControlException;
import org.apache.hadoop.hdfs.protocol.UnresolvedPathException;
import org.apache.hadoop.hdfs.protocol.datatransfer.PacketHeader;
import org.apache.hadoop.hdfs.security.token.block.BlockTokenIdentifier;
import org.apache.hadoop.hdfs.server.datanode.CachingStrategy;
import org.apache.hadoop.hdfs.server.namenode.NotReplicatedYetException;
import org.apache.hadoop.hdfs.server.namenode.RetryStartFileException;
import org.apache.hadoop.hdfs.server.namenode.SafeModeException;
import org.apache.hadoop.hdfs.util.ByteArrayManager;
import org.apache.hadoop.io.EnumSetWritable;
import org.apache.hadoop.io.MultipleIOException;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.util.DataChecksum;
import org.apache.hadoop.util.Progressable;
import org.apache.hadoop.util.Time;
import org.apache.htrace.core.TraceScope;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class DFSOutputStream
extends FSOutputSummer
implements Syncable,
CanSetDropBehind,
StreamCapabilities {
    static final Logger LOG = LoggerFactory.getLogger(DFSOutputStream.class);
    @VisibleForTesting
    static final int CREATE_RETRY_COUNT = 10;
    @VisibleForTesting
    static CryptoProtocolVersion[] SUPPORTED_CRYPTO_VERSIONS = CryptoProtocolVersion.supported();
    protected final DFSClient dfsClient;
    protected final ByteArrayManager byteArrayManager;
    protected volatile boolean closed = false;
    protected final String src;
    protected final long fileId;
    protected final long blockSize;
    protected final int bytesPerChecksum;
    protected DFSPacket currentPacket = null;
    protected DataStreamer streamer;
    protected int packetSize = 0;
    protected int chunksPerPacket = 0;
    protected long lastFlushOffset = 0L;
    private long initialFileSize = 0L;
    private final short blockReplication;
    protected boolean shouldSyncBlock = false;
    private final EnumSet<AddBlockFlag> addBlockFlags;
    protected final AtomicReference<CachingStrategy> cachingStrategy;
    private FileEncryptionInfo fileEncryptionInfo;
    private int writePacketSize;

    protected DFSPacket createPacket(int packetSize, int chunksPerPkt, long offsetInBlock, long seqno, boolean lastPacketInBlock) throws InterruptedIOException {
        byte[] buf;
        int bufferSize = PacketHeader.PKT_MAX_HEADER_LEN + packetSize;
        try {
            buf = this.byteArrayManager.newByteArray(bufferSize);
        }
        catch (InterruptedException ie) {
            InterruptedIOException iioe = new InterruptedIOException("seqno=" + seqno);
            iioe.initCause(ie);
            throw iioe;
        }
        return new DFSPacket(buf, chunksPerPkt, offsetInBlock, seqno, this.getChecksumSize(), lastPacketInBlock);
    }

    protected void checkClosed() throws IOException {
        if (this.isClosed()) {
            this.getStreamer().getLastException().throwException4Close();
        }
    }

    @VisibleForTesting
    public synchronized DatanodeInfo[] getPipeline() {
        if (this.getStreamer().streamerClosed()) {
            return null;
        }
        DatanodeInfo[] currentNodes = this.getStreamer().getNodes();
        if (currentNodes == null) {
            return null;
        }
        DatanodeInfo[] value = new DatanodeInfo[currentNodes.length];
        System.arraycopy(currentNodes, 0, value, 0, currentNodes.length);
        return value;
    }

    private static DataChecksum getChecksum4Compute(DataChecksum checksum, HdfsFileStatus stat) {
        if (DataStreamer.isLazyPersist(stat) && stat.getReplication() == 1) {
            return DataChecksum.newDataChecksum((DataChecksum.Type)DataChecksum.Type.NULL, (int)checksum.getBytesPerChecksum());
        }
        return checksum;
    }

    private DFSOutputStream(DFSClient dfsClient, String src, EnumSet<CreateFlag> flag, Progressable progress, HdfsFileStatus stat, DataChecksum checksum) {
        super(DFSOutputStream.getChecksum4Compute(checksum, stat));
        this.dfsClient = dfsClient;
        this.src = src;
        this.fileId = stat.getFileId();
        this.blockSize = stat.getBlockSize();
        this.blockReplication = stat.getReplication();
        this.fileEncryptionInfo = stat.getFileEncryptionInfo();
        this.cachingStrategy = new AtomicReference<CachingStrategy>(dfsClient.getDefaultWriteCachingStrategy());
        this.addBlockFlags = EnumSet.noneOf(AddBlockFlag.class);
        if (flag.contains(CreateFlag.NO_LOCAL_WRITE)) {
            this.addBlockFlags.add(AddBlockFlag.NO_LOCAL_WRITE);
        }
        if (progress != null) {
            DFSClient.LOG.debug("Set non-null progress callback on DFSOutputStream {}", (Object)src);
        }
        this.initWritePacketSize();
        this.bytesPerChecksum = checksum.getBytesPerChecksum();
        if (this.bytesPerChecksum <= 0) {
            throw new HadoopIllegalArgumentException("Invalid value: bytesPerChecksum = " + this.bytesPerChecksum + " <= 0");
        }
        if (this.blockSize % (long)this.bytesPerChecksum != 0L) {
            throw new HadoopIllegalArgumentException("Invalid values: dfs.bytes-per-checksum (=" + this.bytesPerChecksum + ") must divide block size (=" + this.blockSize + ").");
        }
        this.byteArrayManager = dfsClient.getClientContext().getByteArrayManager();
    }

    private void initWritePacketSize() {
        this.writePacketSize = this.dfsClient.getConf().getWritePacketSize();
        if (this.writePacketSize > 0x1000000) {
            LOG.warn("Configured write packet exceeds {} bytes as max, using {} bytes.", (Object)0x1000000, (Object)0x1000000);
            this.writePacketSize = 0x1000000;
        }
    }

    protected DFSOutputStream(DFSClient dfsClient, String src, HdfsFileStatus stat, EnumSet<CreateFlag> flag, Progressable progress, DataChecksum checksum, String[] favoredNodes, boolean createStreamer) {
        this(dfsClient, src, flag, progress, stat, checksum);
        this.shouldSyncBlock = flag.contains(CreateFlag.SYNC_BLOCK);
        this.computePacketChunkSize(dfsClient.getConf().getWritePacketSize(), this.bytesPerChecksum);
        if (createStreamer) {
            this.streamer = new DataStreamer(stat, null, dfsClient, src, progress, checksum, this.cachingStrategy, this.byteArrayManager, favoredNodes, this.addBlockFlags);
        }
    }

    static DFSOutputStream newStreamForCreate(DFSClient dfsClient, String src, FsPermission masked, EnumSet<CreateFlag> flag, boolean createParent, short replication, long blockSize, Progressable progress, DataChecksum checksum, String[] favoredNodes, String ecPolicyName) throws IOException {
        try (TraceScope ignored = dfsClient.newPathTraceScope("newStreamForCreate", src);){
            HdfsFileStatus stat = null;
            boolean shouldRetry = true;
            int retryCount = 10;
            while (shouldRetry) {
                shouldRetry = false;
                try {
                    stat = dfsClient.namenode.create(src, masked, dfsClient.clientName, (EnumSetWritable<CreateFlag>)new EnumSetWritable(flag), createParent, replication, blockSize, SUPPORTED_CRYPTO_VERSIONS, ecPolicyName);
                    break;
                }
                catch (RemoteException re) {
                    IOException e = re.unwrapRemoteException(new Class[]{AccessControlException.class, DSQuotaExceededException.class, QuotaByStorageTypeExceededException.class, FileAlreadyExistsException.class, FileNotFoundException.class, ParentNotDirectoryException.class, NSQuotaExceededException.class, RetryStartFileException.class, SafeModeException.class, UnresolvedPathException.class, SnapshotAccessControlException.class, UnknownCryptoProtocolVersionException.class});
                    if (e instanceof RetryStartFileException) {
                        if (retryCount > 0) {
                            shouldRetry = true;
                            --retryCount;
                            continue;
                        }
                        throw new IOException("Too many retries because of encryption zone operations", e);
                    }
                    throw e;
                }
            }
            Preconditions.checkNotNull(stat, (Object)"HdfsFileStatus should not be null!");
            DFSOutputStream out = stat.getErasureCodingPolicy() != null ? new DFSStripedOutputStream(dfsClient, src, stat, flag, progress, checksum, favoredNodes) : new DFSOutputStream(dfsClient, src, stat, flag, progress, checksum, favoredNodes, true);
            out.start();
            DFSOutputStream dFSOutputStream = out;
            return dFSOutputStream;
        }
    }

    private DFSOutputStream(DFSClient dfsClient, String src, EnumSet<CreateFlag> flags, Progressable progress, LocatedBlock lastBlock, HdfsFileStatus stat, DataChecksum checksum, String[] favoredNodes) throws IOException {
        this(dfsClient, src, flags, progress, stat, checksum);
        this.initialFileSize = stat.getLen();
        this.shouldSyncBlock = flags.contains(CreateFlag.SYNC_BLOCK);
        boolean toNewBlock = flags.contains(CreateFlag.NEW_BLOCK);
        this.fileEncryptionInfo = stat.getFileEncryptionInfo();
        if (!toNewBlock && lastBlock != null) {
            this.streamer = new DataStreamer(lastBlock, stat, dfsClient, src, progress, checksum, this.cachingStrategy, this.byteArrayManager);
            this.getStreamer().setBytesCurBlock(lastBlock.getBlockSize());
            this.adjustPacketChunkSize(stat);
            this.getStreamer().setPipelineInConstruction(lastBlock);
        } else {
            this.computePacketChunkSize(dfsClient.getConf().getWritePacketSize(), this.bytesPerChecksum);
            this.streamer = new DataStreamer(stat, lastBlock != null ? lastBlock.getBlock() : null, dfsClient, src, progress, checksum, this.cachingStrategy, this.byteArrayManager, favoredNodes, this.addBlockFlags);
        }
    }

    private void adjustPacketChunkSize(HdfsFileStatus stat) throws IOException {
        long usedInLastBlock = stat.getLen() % this.blockSize;
        int freeInLastBlock = (int)(this.blockSize - usedInLastBlock);
        int usedInCksum = (int)(stat.getLen() % (long)this.bytesPerChecksum);
        int freeInCksum = this.bytesPerChecksum - usedInCksum;
        if ((long)freeInLastBlock == this.blockSize) {
            throw new IOException("The last block for file " + this.src + " is full.");
        }
        if (usedInCksum > 0 && freeInCksum > 0) {
            this.computePacketChunkSize(0, freeInCksum);
            this.setChecksumBufSize(freeInCksum);
            this.getStreamer().setAppendChunk(true);
        } else {
            this.computePacketChunkSize(Math.min(this.dfsClient.getConf().getWritePacketSize(), freeInLastBlock), this.bytesPerChecksum);
        }
    }

    static DFSOutputStream newStreamForAppend(DFSClient dfsClient, String src, EnumSet<CreateFlag> flags, Progressable progress, LocatedBlock lastBlock, HdfsFileStatus stat, DataChecksum checksum, String[] favoredNodes) throws IOException {
        if (stat.getErasureCodingPolicy() != null) {
            throw new IOException("Not support appending to a striping layout file yet.");
        }
        try (TraceScope ignored = dfsClient.newPathTraceScope("newStreamForAppend", src);){
            DFSOutputStream out = new DFSOutputStream(dfsClient, src, flags, progress, lastBlock, stat, checksum, favoredNodes);
            out.start();
            DFSOutputStream dFSOutputStream = out;
            return dFSOutputStream;
        }
    }

    protected void computePacketChunkSize(int psize, int csize) {
        int bodySize = psize - PacketHeader.PKT_MAX_HEADER_LEN;
        int chunkSize = csize + this.getChecksumSize();
        this.chunksPerPacket = Math.max(bodySize / chunkSize, 1);
        this.packetSize = chunkSize * this.chunksPerPacket;
        DFSClient.LOG.debug("computePacketChunkSize: src={}, chunkSize={}, chunksPerPacket={}, packetSize={}", new Object[]{this.src, chunkSize, this.chunksPerPacket, this.packetSize});
    }

    protected TraceScope createWriteTraceScope() {
        return this.dfsClient.newPathTraceScope("DFSOutputStream#write", this.src);
    }

    protected synchronized void writeChunk(byte[] b, int offset, int len, byte[] checksum, int ckoff, int cklen) throws IOException {
        this.writeChunkPrepare(len, ckoff, cklen);
        this.currentPacket.writeChecksum(checksum, ckoff, cklen);
        this.currentPacket.writeData(b, offset, len);
        this.currentPacket.incNumChunks();
        this.getStreamer().incBytesCurBlock(len);
        if (this.currentPacket.getNumChunks() == this.currentPacket.getMaxChunks() || this.getStreamer().getBytesCurBlock() == this.blockSize) {
            this.enqueueCurrentPacketFull();
        }
    }

    protected synchronized void writeChunk(ByteBuffer buffer, int len, byte[] checksum, int ckoff, int cklen) throws IOException {
        this.writeChunkPrepare(len, ckoff, cklen);
        this.currentPacket.writeChecksum(checksum, ckoff, cklen);
        this.currentPacket.writeData(buffer, len);
        this.currentPacket.incNumChunks();
        this.getStreamer().incBytesCurBlock(len);
        if (this.currentPacket.getNumChunks() == this.currentPacket.getMaxChunks() || this.getStreamer().getBytesCurBlock() == this.blockSize) {
            this.enqueueCurrentPacketFull();
        }
    }

    private synchronized void writeChunkPrepare(int buflen, int ckoff, int cklen) throws IOException {
        this.dfsClient.checkOpen();
        this.checkClosed();
        if (buflen > this.bytesPerChecksum) {
            throw new IOException("writeChunk() buffer size is " + buflen + " is larger than supported  bytesPerChecksum " + this.bytesPerChecksum);
        }
        if (cklen != 0 && cklen != this.getChecksumSize()) {
            throw new IOException("writeChunk() checksum size is supposed to be " + this.getChecksumSize() + " but found to be " + cklen);
        }
        if (this.currentPacket == null) {
            this.currentPacket = this.createPacket(this.packetSize, this.chunksPerPacket, this.getStreamer().getBytesCurBlock(), this.getStreamer().getAndIncCurrentSeqno(), false);
            DFSClient.LOG.debug("WriteChunk allocating new packet seqno={}, src={}, packetSize={}, chunksPerPacket={}, bytesCurBlock={}", new Object[]{this.currentPacket.getSeqno(), this.src, this.packetSize, this.chunksPerPacket, this.getStreamer().getBytesCurBlock() + ", " + (Object)((Object)this)});
        }
    }

    void enqueueCurrentPacket() throws IOException {
        this.getStreamer().waitAndQueuePacket(this.currentPacket);
        this.currentPacket = null;
    }

    synchronized void enqueueCurrentPacketFull() throws IOException {
        LOG.debug("enqueue full {}, src={}, bytesCurBlock={}, blockSize={}, appendChunk={}, {}", new Object[]{this.currentPacket, this.src, this.getStreamer().getBytesCurBlock(), this.blockSize, this.getStreamer().getAppendChunk(), this.getStreamer()});
        this.enqueueCurrentPacket();
        this.adjustChunkBoundary();
        this.endBlock();
    }

    void setCurrentPacketToEmpty() throws InterruptedIOException {
        this.currentPacket = this.createPacket(0, 0, this.getStreamer().getBytesCurBlock(), this.getStreamer().getAndIncCurrentSeqno(), true);
        this.currentPacket.setSyncBlock(this.shouldSyncBlock);
    }

    protected void adjustChunkBoundary() {
        if (this.getStreamer().getAppendChunk() && this.getStreamer().getBytesCurBlock() % (long)this.bytesPerChecksum == 0L) {
            this.getStreamer().setAppendChunk(false);
            this.resetChecksumBufSize();
        }
        if (!this.getStreamer().getAppendChunk()) {
            int psize = (int)Math.min(this.blockSize - this.getStreamer().getBytesCurBlock(), (long)this.writePacketSize);
            this.computePacketChunkSize(psize, this.bytesPerChecksum);
        }
    }

    @VisibleForTesting
    void setAppendChunk(boolean appendChunk) {
        this.getStreamer().setAppendChunk(appendChunk);
    }

    @VisibleForTesting
    void setBytesCurBlock(long bytesCurBlock) {
        this.getStreamer().setBytesCurBlock(bytesCurBlock);
    }

    void endBlock() throws IOException {
        if (this.getStreamer().getBytesCurBlock() == this.blockSize) {
            this.setCurrentPacketToEmpty();
            this.enqueueCurrentPacket();
            this.getStreamer().setBytesCurBlock(0L);
            this.lastFlushOffset = 0L;
        }
    }

    public boolean hasCapability(String capability) {
        return capability.equalsIgnoreCase(StreamCapabilities.StreamCapability.HSYNC.getValue()) || capability.equalsIgnoreCase(StreamCapabilities.StreamCapability.HFLUSH.getValue());
    }

    public void hflush() throws IOException {
        try (TraceScope ignored = this.dfsClient.newPathTraceScope("hflush", this.src);){
            this.flushOrSync(false, EnumSet.noneOf(HdfsDataOutputStream.SyncFlag.class));
        }
    }

    public void hsync() throws IOException {
        try (TraceScope ignored = this.dfsClient.newPathTraceScope("hsync", this.src);){
            this.flushOrSync(true, EnumSet.noneOf(HdfsDataOutputStream.SyncFlag.class));
        }
    }

    public void hsync(EnumSet<HdfsDataOutputStream.SyncFlag> syncFlags) throws IOException {
        try (TraceScope ignored = this.dfsClient.newPathTraceScope("hsync", this.src);){
            this.flushOrSync(true, syncFlags);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushOrSync(boolean isSync, EnumSet<HdfsDataOutputStream.SyncFlag> syncFlags) throws IOException {
        this.dfsClient.checkOpen();
        this.checkClosed();
        try {
            long toWaitFor;
            long lastBlockLength = -1L;
            boolean updateLength = syncFlags.contains((Object)HdfsDataOutputStream.SyncFlag.UPDATE_LENGTH);
            boolean endBlock = syncFlags.contains((Object)HdfsDataOutputStream.SyncFlag.END_BLOCK);
            DFSOutputStream dFSOutputStream = this;
            synchronized (dFSOutputStream) {
                int numKept = this.flushBuffer(!endBlock, true);
                DFSClient.LOG.debug("DFSClient flush():  bytesCurBlock={}, lastFlushOffset={}, createNewBlock={}", new Object[]{this.getStreamer().getBytesCurBlock(), this.lastFlushOffset, endBlock});
                if (this.lastFlushOffset != this.getStreamer().getBytesCurBlock()) {
                    assert (this.getStreamer().getBytesCurBlock() > this.lastFlushOffset);
                    this.lastFlushOffset = this.getStreamer().getBytesCurBlock();
                    if (isSync && this.currentPacket == null && !endBlock) {
                        this.currentPacket = this.createPacket(this.packetSize, this.chunksPerPacket, this.getStreamer().getBytesCurBlock(), this.getStreamer().getAndIncCurrentSeqno(), false);
                    }
                } else if (isSync && this.getStreamer().getBytesCurBlock() > 0L && !endBlock) {
                    this.currentPacket = this.createPacket(this.packetSize, this.chunksPerPacket, this.getStreamer().getBytesCurBlock(), this.getStreamer().getAndIncCurrentSeqno(), false);
                } else if (this.currentPacket != null) {
                    this.currentPacket.releaseBuffer(this.byteArrayManager);
                    this.currentPacket = null;
                }
                if (this.currentPacket != null) {
                    this.currentPacket.setSyncBlock(isSync);
                    this.enqueueCurrentPacket();
                }
                if (endBlock && this.getStreamer().getBytesCurBlock() > 0L) {
                    this.currentPacket = this.createPacket(0, 0, this.getStreamer().getBytesCurBlock(), this.getStreamer().getAndIncCurrentSeqno(), true);
                    this.currentPacket.setSyncBlock(this.shouldSyncBlock || isSync);
                    this.enqueueCurrentPacket();
                    this.getStreamer().setBytesCurBlock(0L);
                    this.lastFlushOffset = 0L;
                } else {
                    this.getStreamer().setBytesCurBlock(this.getStreamer().getBytesCurBlock() - (long)numKept);
                }
                toWaitFor = this.getStreamer().getLastQueuedSeqno();
            }
            this.getStreamer().waitForAckedSeqno(toWaitFor);
            if (updateLength || this.getStreamer().getPersistBlocks().get()) {
                dFSOutputStream = this;
                synchronized (dFSOutputStream) {
                    if (!this.getStreamer().streamerClosed() && this.getStreamer().getBlock() != null) {
                        lastBlockLength = this.getStreamer().getBlock().getNumBytes();
                    }
                }
            }
            if (this.getStreamer().getPersistBlocks().getAndSet(false) || updateLength) {
                try {
                    this.dfsClient.namenode.fsync(this.src, this.fileId, this.dfsClient.clientName, lastBlockLength);
                }
                catch (IOException ioe) {
                    DFSClient.LOG.warn("Unable to persist blocks in hflush for " + this.src, (Throwable)ioe);
                    this.checkClosed();
                    throw ioe;
                }
            }
            dFSOutputStream = this;
            synchronized (dFSOutputStream) {
                if (!this.getStreamer().streamerClosed()) {
                    this.getStreamer().setHflush();
                }
            }
        }
        catch (InterruptedIOException interrupt) {
            throw interrupt;
        }
        catch (IOException e) {
            DFSClient.LOG.warn("Error while syncing", (Throwable)e);
            DFSOutputStream dFSOutputStream = this;
            synchronized (dFSOutputStream) {
                if (!this.isClosed()) {
                    this.getStreamer().getLastException().set(e);
                    this.closeThreads(true);
                }
            }
            throw e;
        }
    }

    @Deprecated
    public synchronized int getNumCurrentReplicas() throws IOException {
        return this.getCurrentBlockReplication();
    }

    public synchronized int getCurrentBlockReplication() throws IOException {
        this.dfsClient.checkOpen();
        this.checkClosed();
        if (this.getStreamer().streamerClosed()) {
            return this.blockReplication;
        }
        DatanodeInfo[] currentNodes = this.getStreamer().getNodes();
        if (currentNodes == null) {
            return this.blockReplication;
        }
        return currentNodes.length;
    }

    protected void flushInternal() throws IOException {
        long toWaitFor = this.flushInternalWithoutWaitingAck();
        this.getStreamer().waitForAckedSeqno(toWaitFor);
    }

    protected synchronized void start() {
        this.getStreamer().start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void abort() throws IOException {
        MultipleIOException.Builder b = new MultipleIOException.Builder();
        DFSOutputStream dFSOutputStream = this;
        synchronized (dFSOutputStream) {
            if (this.isClosed()) {
                return;
            }
            this.getStreamer().getLastException().set(new IOException("Lease timeout of " + this.dfsClient.getConf().getHdfsTimeout() / 1000 + " seconds expired."));
            try {
                this.closeThreads(true);
            }
            catch (IOException e) {
                b.add((Throwable)e);
            }
        }
        IOException ioe = b.build();
        if (ioe != null) {
            throw ioe;
        }
    }

    boolean isClosed() {
        return this.closed || this.getStreamer().streamerClosed();
    }

    void setClosed() {
        this.closed = true;
        this.dfsClient.endFileLease(this.fileId);
        this.getStreamer().release();
    }

    protected void closeThreads(boolean force) throws IOException {
        try {
            this.getStreamer().close(force);
            this.getStreamer().join();
            this.getStreamer().closeSocket();
        }
        catch (InterruptedException e) {
            throw new IOException("Failed to shutdown streamer");
        }
        finally {
            this.getStreamer().setSocketToNull();
            this.setClosed();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        MultipleIOException.Builder b = new MultipleIOException.Builder();
        DFSOutputStream dFSOutputStream = this;
        synchronized (dFSOutputStream) {
            try (TraceScope ignored = this.dfsClient.newPathTraceScope("DFSOutputStream#close", this.src);){
                this.closeImpl();
            }
            catch (IOException e) {
                b.add((Throwable)e);
            }
        }
        IOException ioe = b.build();
        if (ioe != null) {
            throw ioe;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void closeImpl() throws IOException {
        if (this.isClosed()) {
            this.getStreamer().getLastException().check(true);
            return;
        }
        try {
            this.flushBuffer();
            if (this.currentPacket != null) {
                this.enqueueCurrentPacket();
            }
            if (this.getStreamer().getBytesCurBlock() != 0L) {
                this.setCurrentPacketToEmpty();
            }
            this.flushInternal();
            ExtendedBlock lastBlock = this.getStreamer().getBlock();
            try (TraceScope ignored = this.dfsClient.getTracer().newScope("completeFile");){
                this.completeFile(lastBlock);
            }
        }
        catch (ClosedChannelException closedChannelException) {
        }
        finally {
            this.closeThreads(true);
        }
    }

    protected void completeFile(ExtendedBlock last) throws IOException {
        long localstart = Time.monotonicNow();
        DfsClientConf conf = this.dfsClient.getConf();
        long sleeptime = conf.getBlockWriteLocateFollowingInitialDelayMs();
        boolean fileComplete = false;
        int retries = conf.getNumBlockWriteLocateFollowingRetry();
        while (!fileComplete) {
            fileComplete = this.dfsClient.namenode.complete(this.src, this.dfsClient.clientName, last, this.fileId);
            if (fileComplete) continue;
            int hdfsTimeout = conf.getHdfsTimeout();
            if (!this.dfsClient.clientRunning || hdfsTimeout > 0 && localstart + (long)hdfsTimeout < Time.monotonicNow()) {
                String msg = "Unable to close file because dfsclient  was unable to contact the HDFS servers. clientRunning " + this.dfsClient.clientRunning + " hdfsTimeout " + hdfsTimeout;
                DFSClient.LOG.info(msg);
                throw new IOException(msg);
            }
            try {
                if (retries == 0) {
                    throw new IOException("Unable to close file because the last block" + last + " does not have enough number of replicas.");
                }
                --retries;
                Thread.sleep(sleeptime);
                sleeptime *= 2L;
                if (Time.monotonicNow() - localstart <= 5000L) continue;
                DFSClient.LOG.info("Could not complete " + this.src + " retrying...");
            }
            catch (InterruptedException ie) {
                DFSClient.LOG.warn("Caught exception ", (Throwable)ie);
            }
        }
    }

    @VisibleForTesting
    public void setArtificialSlowdown(long period) {
        this.getStreamer().setArtificialSlowdown(period);
    }

    @VisibleForTesting
    public synchronized void setChunksPerPacket(int value) {
        this.chunksPerPacket = Math.min(this.chunksPerPacket, value);
        this.packetSize = (this.bytesPerChecksum + this.getChecksumSize()) * this.chunksPerPacket;
    }

    public long getInitialLen() {
        return this.initialFileSize;
    }

    protected EnumSet<AddBlockFlag> getAddBlockFlags() {
        return this.addBlockFlags;
    }

    public FileEncryptionInfo getFileEncryptionInfo() {
        return this.fileEncryptionInfo;
    }

    synchronized Token<BlockTokenIdentifier> getBlockToken() {
        return this.getStreamer().getBlockToken();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long flushInternalWithoutWaitingAck() throws IOException {
        long toWaitFor;
        DFSOutputStream dFSOutputStream = this;
        synchronized (dFSOutputStream) {
            this.dfsClient.checkOpen();
            this.checkClosed();
            this.getStreamer().queuePacket(this.currentPacket);
            this.currentPacket = null;
            toWaitFor = this.getStreamer().getLastQueuedSeqno();
        }
        return toWaitFor;
    }

    public void setDropBehind(Boolean dropBehind) throws IOException {
        CachingStrategy nextStrategy;
        CachingStrategy prevStrategy;
        while (!this.cachingStrategy.compareAndSet(prevStrategy = this.cachingStrategy.get(), nextStrategy = new CachingStrategy.Builder(prevStrategy).setDropBehind(dropBehind).build())) {
        }
    }

    @VisibleForTesting
    ExtendedBlock getBlock() {
        return this.getStreamer().getBlock();
    }

    @VisibleForTesting
    public long getFileId() {
        return this.fileId;
    }

    String getSrc() {
        return this.src;
    }

    protected DataStreamer getStreamer() {
        return this.streamer;
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + ":" + (Object)((Object)this.streamer);
    }

    static LocatedBlock addBlock(DatanodeInfo[] excludedNodes, DFSClient dfsClient, String src, ExtendedBlock prevBlock, long fileId, String[] favoredNodes, EnumSet<AddBlockFlag> allocFlags) throws IOException {
        DfsClientConf conf = dfsClient.getConf();
        int retries = conf.getNumBlockWriteLocateFollowingRetry();
        long sleeptime = conf.getBlockWriteLocateFollowingInitialDelayMs();
        long localstart = Time.monotonicNow();
        while (true) {
            try {
                return dfsClient.namenode.addBlock(src, dfsClient.clientName, prevBlock, excludedNodes, fileId, favoredNodes, allocFlags);
            }
            catch (RemoteException e) {
                IOException ue = e.unwrapRemoteException(new Class[]{FileNotFoundException.class, AccessControlException.class, NSQuotaExceededException.class, DSQuotaExceededException.class, QuotaByStorageTypeExceededException.class, UnresolvedPathException.class});
                if (ue != e) {
                    throw ue;
                }
                if (NotReplicatedYetException.class.getName().equals(e.getClassName())) {
                    if (retries == 0) {
                        throw e;
                    }
                    --retries;
                    LOG.info("Exception while adding a block", (Throwable)e);
                    long elapsed = Time.monotonicNow() - localstart;
                    if (elapsed > 5000L) {
                        LOG.info("Waiting for replication for " + elapsed / 1000L + " seconds");
                    }
                    try {
                        LOG.warn("NotReplicatedYetException sleeping " + src + " retries left " + retries);
                        Thread.sleep(sleeptime);
                        sleeptime *= 2L;
                    }
                    catch (InterruptedException ie) {
                        LOG.warn("Caught exception", (Throwable)ie);
                    }
                    continue;
                }
                throw e;
            }
            break;
        }
    }
}

