/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.net.SocketFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.DFSUtilClient;
import org.apache.hadoop.hdfs.HAUtilClient;
import org.apache.hadoop.hdfs.client.impl.DfsClientConf;
import org.apache.hadoop.hdfs.protocol.ClientProtocol;
import org.apache.hadoop.hdfs.protocolPB.ClientNamenodeProtocolPB;
import org.apache.hadoop.hdfs.protocolPB.ClientNamenodeProtocolTranslatorPB;
import org.apache.hadoop.hdfs.server.namenode.SafeModeException;
import org.apache.hadoop.hdfs.server.namenode.ha.AbstractNNFailoverProxyProvider;
import org.apache.hadoop.hdfs.server.namenode.ha.ClientHAProxyFactory;
import org.apache.hadoop.hdfs.server.namenode.ha.HAProxyFactory;
import org.apache.hadoop.hdfs.server.namenode.ha.WrappedFailoverProxyProvider;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.retry.DefaultFailoverProxyProvider;
import org.apache.hadoop.io.retry.FailoverProxyProvider;
import org.apache.hadoop.io.retry.LossyRetryInvocationHandler;
import org.apache.hadoop.io.retry.RetryPolicies;
import org.apache.hadoop.io.retry.RetryPolicy;
import org.apache.hadoop.io.retry.RetryProxy;
import org.apache.hadoop.io.retry.RetryUtils;
import org.apache.hadoop.ipc.AlignmentContext;
import org.apache.hadoop.ipc.Client;
import org.apache.hadoop.ipc.ProtobufRpcEngine2;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.thirdparty.com.google.common.base.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class NameNodeProxiesClient {
    private static final Logger LOG = LoggerFactory.getLogger(NameNodeProxiesClient.class);

    public static ProxyAndInfo<ClientProtocol> createProxyWithClientProtocol(Configuration conf, URI nameNodeUri, AtomicBoolean fallbackToSimpleAuth) throws IOException {
        AbstractNNFailoverProxyProvider<ClientProtocol> failoverProxyProvider = NameNodeProxiesClient.createFailoverProxyProvider(conf, nameNodeUri, ClientProtocol.class, true, fallbackToSimpleAuth);
        if (failoverProxyProvider == null) {
            InetSocketAddress nnAddr = DFSUtilClient.getNNAddress(nameNodeUri);
            Text dtService = SecurityUtil.buildTokenService((InetSocketAddress)nnAddr);
            ClientProtocol proxy = NameNodeProxiesClient.createNonHAProxyWithClientProtocol(nnAddr, conf, UserGroupInformation.getCurrentUser(), true, fallbackToSimpleAuth);
            return new ProxyAndInfo<ClientProtocol>(proxy, dtService, nnAddr);
        }
        return NameNodeProxiesClient.createHAProxy(conf, nameNodeUri, ClientProtocol.class, failoverProxyProvider);
    }

    public static <T> ProxyAndInfo<T> createProxyWithLossyRetryHandler(Configuration config, URI nameNodeUri, Class<T> xface, int numResponseToDrop, AtomicBoolean fallbackToSimpleAuth) throws IOException {
        Preconditions.checkArgument((numResponseToDrop > 0 ? 1 : 0) != 0);
        AbstractNNFailoverProxyProvider<T> failoverProxyProvider = NameNodeProxiesClient.createFailoverProxyProvider(config, nameNodeUri, xface, true, fallbackToSimpleAuth);
        if (failoverProxyProvider != null) {
            int delay = config.getInt("dfs.client.failover.sleep.base.millis", 500);
            int maxCap = config.getInt("dfs.client.failover.sleep.max.millis", 15000);
            int maxFailoverAttempts = config.getInt("dfs.client.failover.max.attempts", 15);
            int maxRetryAttempts = config.getInt("dfs.client.retry.max.attempts", 10);
            LossyRetryInvocationHandler dummyHandler = new LossyRetryInvocationHandler(numResponseToDrop, failoverProxyProvider, RetryPolicies.failoverOnNetworkException((RetryPolicy)RetryPolicies.TRY_ONCE_THEN_FAIL, (int)maxFailoverAttempts, (int)Math.max(numResponseToDrop + 1, maxRetryAttempts), (long)delay, (long)maxCap));
            Object proxy = Proxy.newProxyInstance(failoverProxyProvider.getInterface().getClassLoader(), new Class[]{xface}, (InvocationHandler)dummyHandler);
            Text dtService = failoverProxyProvider.useLogicalURI() ? HAUtilClient.buildTokenServiceForLogicalUri(nameNodeUri, "hdfs") : SecurityUtil.buildTokenService((InetSocketAddress)DFSUtilClient.getNNAddress(nameNodeUri));
            return new ProxyAndInfo<Object>(proxy, dtService, DFSUtilClient.getNNAddress(nameNodeUri));
        }
        LOG.warn("Currently creating proxy using LossyRetryInvocationHandler requires NN HA setup");
        return null;
    }

    @VisibleForTesting
    public static <T> AbstractNNFailoverProxyProvider<T> createFailoverProxyProvider(Configuration conf, URI nameNodeUri, Class<T> xface, boolean checkPort, AtomicBoolean fallbackToSimpleAuth) throws IOException {
        return NameNodeProxiesClient.createFailoverProxyProvider(conf, nameNodeUri, xface, checkPort, fallbackToSimpleAuth, new ClientHAProxyFactory());
    }

    protected static <T> AbstractNNFailoverProxyProvider<T> createFailoverProxyProvider(Configuration conf, URI nameNodeUri, Class<T> xface, boolean checkPort, AtomicBoolean fallbackToSimpleAuth, HAProxyFactory<T> proxyFactory) throws IOException {
        int port;
        WrappedFailoverProxyProvider<T> providerNN;
        Class<FailoverProxyProvider<T>> failoverProxyProviderClass = null;
        try {
            failoverProxyProviderClass = NameNodeProxiesClient.getFailoverProxyProviderClass(conf, nameNodeUri);
            if (failoverProxyProviderClass == null) {
                return null;
            }
            Constructor<FailoverProxyProvider<T>> ctor = failoverProxyProviderClass.getConstructor(Configuration.class, URI.class, Class.class, HAProxyFactory.class);
            FailoverProxyProvider<T> provider = ctor.newInstance(conf, nameNodeUri, xface, proxyFactory);
            providerNN = !(provider instanceof AbstractNNFailoverProxyProvider) ? new WrappedFailoverProxyProvider<T>(provider) : (WrappedFailoverProxyProvider<T>)provider;
        }
        catch (Exception e) {
            String message = "Couldn't create proxy provider " + failoverProxyProviderClass;
            LOG.debug(message, (Throwable)e);
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw new IOException(message, e);
        }
        if (checkPort && ((AbstractNNFailoverProxyProvider)providerNN).useLogicalURI() && (port = nameNodeUri.getPort()) > 0 && port != 8020) {
            throw new IOException("Port " + port + " specified in URI " + nameNodeUri + " but host '" + nameNodeUri.getHost() + "' is a logical (HA) namenode and does not use port information.");
        }
        providerNN.setFallbackToSimpleAuth(fallbackToSimpleAuth);
        return providerNN;
    }

    @VisibleForTesting
    public static <T> Class<FailoverProxyProvider<T>> getFailoverProxyProviderClass(Configuration conf, URI nameNodeUri) throws IOException {
        if (nameNodeUri == null) {
            return null;
        }
        String host = nameNodeUri.getHost();
        String configKey = "dfs.client.failover.proxy.provider." + host;
        try {
            Class ret = conf.getClass(configKey, null, FailoverProxyProvider.class);
            return ret;
        }
        catch (RuntimeException e) {
            if (e.getCause() instanceof ClassNotFoundException) {
                throw new IOException("Could not load failover proxy provider class " + conf.get(configKey) + " which is configured for authority " + nameNodeUri, e);
            }
            throw e;
        }
    }

    public static <T> ProxyAndInfo<T> createHAProxy(Configuration conf, URI nameNodeUri, Class<T> xface, AbstractNNFailoverProxyProvider<T> failoverProxyProvider) {
        Preconditions.checkNotNull(failoverProxyProvider);
        DfsClientConf config = new DfsClientConf(conf);
        Object proxy = RetryProxy.create(xface, failoverProxyProvider, (RetryPolicy)RetryPolicies.failoverOnNetworkException((RetryPolicy)RetryPolicies.TRY_ONCE_THEN_FAIL, (int)config.getMaxFailoverAttempts(), (int)config.getMaxRetryAttempts(), (long)config.getFailoverSleepBaseMillis(), (long)config.getFailoverSleepMaxMillis()));
        Text dtService = failoverProxyProvider.useLogicalURI() ? HAUtilClient.buildTokenServiceForLogicalUri(nameNodeUri, "hdfs") : SecurityUtil.buildTokenService((InetSocketAddress)DFSUtilClient.getNNAddress(nameNodeUri));
        return new ProxyAndInfo<Object>(proxy, dtService, DFSUtilClient.getNNAddressCheckLogical(conf, nameNodeUri));
    }

    public static ClientProtocol createNonHAProxyWithClientProtocol(InetSocketAddress address, Configuration conf, UserGroupInformation ugi, boolean withRetries, AtomicBoolean fallbackToSimpleAuth) throws IOException {
        return NameNodeProxiesClient.createProxyWithAlignmentContext(address, conf, ugi, withRetries, fallbackToSimpleAuth, null);
    }

    public static ClientProtocol createProxyWithAlignmentContext(InetSocketAddress address, Configuration conf, UserGroupInformation ugi, boolean withRetries, AtomicBoolean fallbackToSimpleAuth, AlignmentContext alignmentContext) throws IOException {
        RPC.setProtocolEngine((Configuration)conf, ClientNamenodeProtocolPB.class, ProtobufRpcEngine2.class);
        RetryPolicy defaultPolicy = RetryUtils.getDefaultRetryPolicy((Configuration)conf, (String)"dfs.client.retry.policy.enabled", (boolean)false, (String)"dfs.client.retry.policy.spec", (String)"10000,6,60000,10", (String)SafeModeException.class.getName());
        long version = RPC.getProtocolVersion(ClientNamenodeProtocolPB.class);
        ClientNamenodeProtocolPB proxy = (ClientNamenodeProtocolPB)RPC.getProtocolProxy(ClientNamenodeProtocolPB.class, (long)version, (InetSocketAddress)address, (UserGroupInformation)ugi, (Configuration)conf, (SocketFactory)NetUtils.getDefaultSocketFactory((Configuration)conf), (int)Client.getTimeout((Configuration)conf), (RetryPolicy)defaultPolicy, (AtomicBoolean)fallbackToSimpleAuth, (AlignmentContext)alignmentContext).getProxy();
        if (withRetries) {
            HashMap methodNameToPolicyMap = new HashMap();
            ClientNamenodeProtocolTranslatorPB translatorProxy = new ClientNamenodeProtocolTranslatorPB(proxy);
            return (ClientProtocol)RetryProxy.create(ClientProtocol.class, (FailoverProxyProvider)new DefaultFailoverProxyProvider(ClientProtocol.class, (Object)translatorProxy), methodNameToPolicyMap, (RetryPolicy)defaultPolicy);
        }
        return new ClientNamenodeProtocolTranslatorPB(proxy);
    }

    public static class ProxyAndInfo<PROXYTYPE> {
        private final PROXYTYPE proxy;
        private final Text dtService;
        private final InetSocketAddress address;

        public ProxyAndInfo(PROXYTYPE proxy, Text dtService, InetSocketAddress address) {
            this.proxy = proxy;
            this.dtService = dtService;
            this.address = address;
        }

        public PROXYTYPE getProxy() {
            return this.proxy;
        }

        public Text getDelegationTokenService() {
            return this.dtService;
        }

        public InetSocketAddress getAddress() {
            return this.address;
        }
    }
}

