/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.ReadOption;
import org.apache.hadoop.hdfs.BlockReader;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.DFSClientFaultInjector;
import org.apache.hadoop.hdfs.DFSInputStream;
import org.apache.hadoop.hdfs.DFSUtilClient;
import org.apache.hadoop.hdfs.PositionStripeReader;
import org.apache.hadoop.hdfs.ReaderStrategy;
import org.apache.hadoop.hdfs.StatefulStripeReader;
import org.apache.hadoop.hdfs.StripeReader;
import org.apache.hadoop.hdfs.protocol.BlockType;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.DatanodeInfoWithStorage;
import org.apache.hadoop.hdfs.protocol.ErasureCodingPolicy;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;
import org.apache.hadoop.hdfs.protocol.LocatedStripedBlock;
import org.apache.hadoop.hdfs.protocol.datatransfer.InvalidEncryptionKeyException;
import org.apache.hadoop.hdfs.util.IOUtilsClient;
import org.apache.hadoop.hdfs.util.StripedBlockUtil;
import org.apache.hadoop.io.ByteBufferPool;
import org.apache.hadoop.io.ElasticByteBufferPool;
import org.apache.hadoop.io.erasurecode.CodecUtil;
import org.apache.hadoop.io.erasurecode.ErasureCoderOptions;
import org.apache.hadoop.io.erasurecode.rawcoder.RawErasureDecoder;

@InterfaceAudience.Private
public class DFSStripedInputStream
extends DFSInputStream {
    private static final ByteBufferPool BUFFER_POOL = new ElasticByteBufferPool();
    private final StripeReader.BlockReaderInfo[] blockReaders;
    private final int cellSize;
    private final short dataBlkNum;
    private final short parityBlkNum;
    private final int groupSize;
    private ByteBuffer curStripeBuf;
    @VisibleForTesting
    protected ByteBuffer parityBuf;
    private final ErasureCodingPolicy ecPolicy;
    private RawErasureDecoder decoder;
    private StripedBlockUtil.StripeRange curStripeRange;
    private final Set<String> warnedNodes = Collections.newSetFromMap(new ConcurrentHashMap());

    DFSStripedInputStream(DFSClient dfsClient, String src, boolean verifyChecksum, ErasureCodingPolicy ecPolicy, LocatedBlocks locatedBlocks) throws IOException {
        super(dfsClient, src, verifyChecksum, locatedBlocks);
        this.readStatistics.setBlockType(BlockType.STRIPED);
        assert (ecPolicy != null);
        this.ecPolicy = ecPolicy;
        this.cellSize = ecPolicy.getCellSize();
        this.dataBlkNum = (short)ecPolicy.getNumDataUnits();
        this.parityBlkNum = (short)ecPolicy.getNumParityUnits();
        this.groupSize = this.dataBlkNum + this.parityBlkNum;
        this.blockReaders = new StripeReader.BlockReaderInfo[this.groupSize];
        this.curStripeRange = new StripedBlockUtil.StripeRange(0L, 0L);
        ErasureCoderOptions coderOptions = new ErasureCoderOptions((int)this.dataBlkNum, (int)this.parityBlkNum);
        this.decoder = CodecUtil.createRawDecoder((Configuration)dfsClient.getConfiguration(), (String)ecPolicy.getCodecName(), (ErasureCoderOptions)coderOptions);
        DFSClient.LOG.debug("Creating an striped input stream for file {}", (Object)src);
    }

    private boolean useDirectBuffer() {
        return this.decoder.preferDirectBuffer();
    }

    private void resetCurStripeBuffer(boolean shouldAllocateBuf) {
        if (shouldAllocateBuf && this.curStripeBuf == null) {
            this.curStripeBuf = BUFFER_POOL.getBuffer(this.useDirectBuffer(), this.cellSize * this.dataBlkNum);
        }
        if (this.curStripeBuf != null) {
            this.curStripeBuf.clear();
        }
        this.curStripeRange = new StripedBlockUtil.StripeRange(0L, 0L);
    }

    protected synchronized ByteBuffer getParityBuffer() {
        if (this.parityBuf == null) {
            this.parityBuf = BUFFER_POOL.getBuffer(this.useDirectBuffer(), this.cellSize * this.parityBlkNum);
        }
        this.parityBuf.clear();
        return this.parityBuf;
    }

    protected ByteBuffer getCurStripeBuf() {
        return this.curStripeBuf;
    }

    protected ByteBufferPool getBufferPool() {
        return BUFFER_POOL;
    }

    protected ThreadPoolExecutor getStripedReadsThreadPool() {
        return this.dfsClient.getStripedReadsThreadPool();
    }

    @VisibleForTesting
    synchronized void blockSeekTo(long target) throws IOException {
        if (target >= this.getFileLength()) {
            throw new IOException("Attempted to read past end of file");
        }
        this.maybeRegisterBlockRefresh();
        this.closeCurrentBlockReaders();
        LocatedStripedBlock targetBlockGroup = this.getBlockGroupAt(target);
        this.pos = target;
        this.blockEnd = targetBlockGroup.getStartOffset() + targetBlockGroup.getBlockSize() - 1L;
        this.currentLocatedBlock = targetBlockGroup;
    }

    @Override
    public synchronized void close() throws IOException {
        try {
            super.close();
        }
        finally {
            if (this.curStripeBuf != null) {
                BUFFER_POOL.putBuffer(this.curStripeBuf);
                this.curStripeBuf = null;
            }
            if (this.parityBuf != null) {
                BUFFER_POOL.putBuffer(this.parityBuf);
                this.parityBuf = null;
            }
            if (this.decoder != null) {
                this.decoder.release();
                this.decoder = null;
            }
        }
    }

    @Override
    protected void closeCurrentBlockReaders() {
        this.resetCurStripeBuffer(false);
        if (this.blockReaders == null || this.blockReaders.length == 0) {
            return;
        }
        for (int i = 0; i < this.groupSize; ++i) {
            this.closeReader(this.blockReaders[i]);
            this.blockReaders[i] = null;
        }
        this.blockEnd = -1L;
    }

    protected void closeReader(StripeReader.BlockReaderInfo readerInfo) {
        if (readerInfo != null) {
            if (readerInfo.reader != null) {
                try {
                    readerInfo.reader.close();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            readerInfo.skip();
        }
    }

    private long getOffsetInBlockGroup() {
        return this.getOffsetInBlockGroup(this.pos);
    }

    private long getOffsetInBlockGroup(long pos) {
        return pos - this.currentLocatedBlock.getStartOffset();
    }

    boolean createBlockReader(LocatedBlock block, long offsetInBlock, LocatedBlock[] targetBlocks, StripeReader.BlockReaderInfo[] readerInfos, int chunkIndex, long readTo) throws IOException {
        block7: {
            BlockReader reader = null;
            StripeReader.ReaderRetryPolicy retry = new StripeReader.ReaderRetryPolicy();
            DFSInputStream.DNAddrPair dnInfo = new DFSInputStream.DNAddrPair(null, null, null, null);
            do {
                try {
                    targetBlocks[chunkIndex] = block = this.refreshLocatedBlock(block);
                    dnInfo = this.getBestNodeDNAddrPair(block, null);
                    if (dnInfo != null) {
                        if (readTo < 0L || readTo > block.getBlockSize()) {
                            readTo = block.getBlockSize();
                        }
                        reader = this.getBlockReader(block, offsetInBlock, readTo - offsetInBlock, dnInfo.addr, dnInfo.storageType, dnInfo.info);
                        DFSClientFaultInjector.get().onCreateBlockReader(block, chunkIndex, offsetInBlock, readTo - offsetInBlock);
                        continue;
                    }
                    break block7;
                }
                catch (IOException e) {
                    if (e instanceof InvalidEncryptionKeyException && retry.shouldRefetchEncryptionKey()) {
                        DFSClient.LOG.info("Will fetch a new encryption key and retry, encryption key was invalid when connecting to " + dnInfo.addr + " : " + e);
                        this.dfsClient.clearDataEncryptionKey();
                        retry.refetchEncryptionKey();
                        continue;
                    }
                    if (retry.shouldRefetchToken() && DFSStripedInputStream.tokenRefetchNeeded(e, dnInfo.addr)) {
                        this.fetchBlockAt(block.getStartOffset());
                        retry.refetchToken();
                        continue;
                    }
                    DFSClient.LOG.warn("Failed to connect to " + dnInfo.addr + " for block" + block.getBlock(), (Throwable)e);
                    this.fetchBlockAt(block.getStartOffset());
                    this.addToLocalDeadNodes(dnInfo.info);
                }
            } while (reader == null);
            readerInfos[chunkIndex] = new StripeReader.BlockReaderInfo(reader, dnInfo.info, offsetInBlock);
            return true;
        }
        return false;
    }

    private void readOneStripe(DFSUtilClient.CorruptedBlocks corruptedBlocks) throws IOException {
        this.resetCurStripeBuffer(true);
        long offsetInBlockGroup = this.getOffsetInBlockGroup();
        long stripeLen = this.cellSize * this.dataBlkNum;
        int stripeIndex = (int)(offsetInBlockGroup / stripeLen);
        int stripeBufOffset = (int)(offsetInBlockGroup % stripeLen);
        int stripeLimit = (int)Math.min(this.currentLocatedBlock.getBlockSize() - (long)stripeIndex * stripeLen, stripeLen);
        StripedBlockUtil.StripeRange stripeRange = new StripedBlockUtil.StripeRange(offsetInBlockGroup, stripeLimit - stripeBufOffset);
        LocatedStripedBlock blockGroup = (LocatedStripedBlock)this.currentLocatedBlock;
        StripedBlockUtil.AlignedStripe[] stripes = StripedBlockUtil.divideOneStripe(this.ecPolicy, this.cellSize, blockGroup, offsetInBlockGroup, offsetInBlockGroup + stripeRange.getLength() - 1L, this.curStripeBuf);
        LocatedBlock[] blks = StripedBlockUtil.parseStripedBlockGroup(blockGroup, this.cellSize, this.dataBlkNum, this.parityBlkNum);
        for (StripedBlockUtil.AlignedStripe stripe : stripes) {
            StatefulStripeReader sreader = new StatefulStripeReader(stripe, this.ecPolicy, blks, this.blockReaders, corruptedBlocks, this.decoder, this);
            sreader.readStripe();
        }
        this.curStripeBuf.position(stripeBufOffset);
        this.curStripeBuf.limit(stripeLimit);
        this.curStripeRange = stripeRange;
    }

    void updateReadStats(StripedBlockUtil.BlockReadStats stats) {
        if (stats == null) {
            return;
        }
        IOUtilsClient.updateReadStatistics(this.readStatistics, stats.getBytesRead(), stats.isShortCircuit(), stats.getNetworkDistance());
        this.dfsClient.updateFileSystemReadStats(stats.getNetworkDistance(), stats.getBytesRead());
        assert (this.readStatistics.getBlockType() == BlockType.STRIPED);
        this.dfsClient.updateFileSystemECReadStats(stats.getBytesRead());
    }

    @Override
    public synchronized void seek(long targetPos) throws IOException {
        long targetOffsetInBlk;
        if (targetPos > this.getFileLength()) {
            throw new EOFException("Cannot seek after EOF");
        }
        if (targetPos < 0L) {
            throw new EOFException("Cannot seek to negative offset");
        }
        if (this.closed.get()) {
            throw new IOException("Stream is closed!");
        }
        if (targetPos <= this.blockEnd && this.curStripeRange.include(targetOffsetInBlk = this.getOffsetInBlockGroup(targetPos))) {
            int bufOffset = this.getStripedBufOffset(targetOffsetInBlk);
            this.curStripeBuf.position(bufOffset);
            this.pos = targetPos;
            return;
        }
        this.pos = targetPos;
        this.blockEnd = -1L;
    }

    private int getStripedBufOffset(long offsetInBlockGroup) {
        long stripeLen = this.cellSize * this.dataBlkNum;
        return (int)(offsetInBlockGroup % stripeLen);
    }

    @Override
    public synchronized boolean seekToNewSource(long targetPos) throws IOException {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected synchronized int readWithStrategy(ReaderStrategy strategy) throws IOException {
        this.dfsClient.checkOpen();
        if (this.closed.get()) {
            throw new IOException("Stream closed");
        }
        int len = strategy.getTargetLength();
        DFSUtilClient.CorruptedBlocks corruptedBlocks = new DFSUtilClient.CorruptedBlocks();
        if (this.pos < this.getFileLength()) {
            try {
                if (this.pos > this.blockEnd) {
                    this.blockSeekTo(this.pos);
                }
                int realLen = (int)Math.min((long)len, this.blockEnd - this.pos + 1L);
                Object object = this.infoLock;
                synchronized (object) {
                    if (this.locatedBlocks.isLastBlockComplete()) {
                        realLen = (int)Math.min((long)realLen, this.locatedBlocks.getFileLength() - this.pos);
                    }
                }
                int result = 0;
                while (result < realLen) {
                    if (!this.curStripeRange.include(this.getOffsetInBlockGroup())) {
                        this.readOneStripe(corruptedBlocks);
                    }
                    int ret = this.copyToTargetBuf(strategy, realLen - result);
                    result += ret;
                    this.pos += (long)ret;
                }
                int n = result;
                return n;
            }
            finally {
                this.reportCheckSumFailure(corruptedBlocks, this.getCurrentBlockLocationsLength(), true);
            }
        }
        return -1;
    }

    private int copyToTargetBuf(ReaderStrategy strategy, int length) {
        long offsetInBlk = this.getOffsetInBlockGroup();
        int bufOffset = this.getStripedBufOffset(offsetInBlk);
        this.curStripeBuf.position(bufOffset);
        return strategy.readFromBuffer(this.curStripeBuf, Math.min(length, this.curStripeBuf.remaining()));
    }

    @Override
    protected LocatedBlock refreshLocatedBlock(LocatedBlock block) throws IOException {
        int i;
        LocatedStripedBlock lb;
        int idx = StripedBlockUtil.getBlockIndex(block.getBlock().getLocalBlock());
        LocatedStripedBlock lsb = lb = this.getBlockGroupAt(block.getStartOffset());
        for (i = 0; i < lsb.getBlockIndices().length && lsb.getBlockIndices()[i] != idx; ++i) {
        }
        DFSClient.LOG.debug("refreshLocatedBlock for striped blocks, offset={}. Obtained block {}, idx={}", new Object[]{block.getStartOffset(), lb, idx});
        return StripedBlockUtil.constructInternalBlock(lsb, i, this.cellSize, this.dataBlkNum, idx);
    }

    private LocatedStripedBlock getBlockGroupAt(long offset) throws IOException {
        LocatedBlock lb = super.getBlockAt(offset);
        assert (lb instanceof LocatedStripedBlock) : "NameNode should return a LocatedStripedBlock for a striped file";
        return (LocatedStripedBlock)lb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void fetchBlockByteRange(LocatedBlock block, long start, long end, ByteBuffer buf, DFSUtilClient.CorruptedBlocks corruptedBlocks) throws IOException {
        LocatedStripedBlock blockGroup = this.getBlockGroupAt(block.getStartOffset());
        StripedBlockUtil.AlignedStripe[] stripes = StripedBlockUtil.divideByteRangeIntoStripes(this.ecPolicy, this.cellSize, blockGroup, start, end, buf);
        LocatedBlock[] blks = StripedBlockUtil.parseStripedBlockGroup(blockGroup, this.cellSize, this.dataBlkNum, this.parityBlkNum);
        StripeReader.BlockReaderInfo[] preaderInfos = new StripeReader.BlockReaderInfo[this.groupSize];
        long readTo = -1L;
        for (StripedBlockUtil.AlignedStripe stripe : stripes) {
            readTo = Math.max(readTo, stripe.getOffsetInBlock() + stripe.getSpanInBlock());
        }
        try {
            for (StripedBlockUtil.AlignedStripe stripe : stripes) {
                preader.setReadTo(readTo);
                try (PositionStripeReader preader = new PositionStripeReader(stripe, this.ecPolicy, blks, preaderInfos, corruptedBlocks, this.decoder, this);){
                    preader.readStripe();
                }
            }
            buf.position(buf.position() + (int)(end - start + 1L));
        }
        finally {
            for (StripeReader.BlockReaderInfo preaderInfo : preaderInfos) {
                this.closeReader(preaderInfo);
            }
        }
    }

    @Override
    protected void reportLostBlock(LocatedBlock lostBlock, Collection<DatanodeInfo> ignoredNodes) {
        Object[] nodes = lostBlock.getLocations();
        if (nodes != null && nodes.length > 0) {
            ArrayList<String> dnUUIDs = new ArrayList<String>();
            for (DatanodeInfoWithStorage datanodeInfoWithStorage : nodes) {
                dnUUIDs.add(datanodeInfoWithStorage.getDatanodeUuid());
            }
            if (!this.warnedNodes.containsAll(dnUUIDs)) {
                DFSClient.LOG.warn(Arrays.toString(nodes) + " are unavailable and all striping blocks on them are lost. IgnoredNodes = {}", ignoredNodes);
                this.warnedNodes.addAll(dnUUIDs);
            }
        } else {
            super.reportLostBlock(lostBlock, ignoredNodes);
        }
    }

    @Override
    public synchronized ByteBuffer read(ByteBufferPool bufferPool, int maxLength, EnumSet<ReadOption> opts) throws IOException, UnsupportedOperationException {
        throw new UnsupportedOperationException("Not support enhanced byte buffer access.");
    }

    @Override
    public synchronized void releaseBuffer(ByteBuffer buffer) {
        throw new UnsupportedOperationException("Not support enhanced byte buffer access.");
    }

    @Override
    public synchronized void unbuffer() {
        super.unbuffer();
        if (this.curStripeBuf != null) {
            BUFFER_POOL.putBuffer(this.curStripeBuf);
            this.curStripeBuf = null;
        }
        if (this.parityBuf != null) {
            BUFFER_POOL.putBuffer(this.parityBuf);
            this.parityBuf = null;
        }
    }
}

