/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode.fsdataset.impl;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;
import org.apache.hadoop.hdfs.server.datanode.DataNodeTestUtils;
import org.apache.hadoop.hdfs.server.datanode.DatanodeUtil;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.FsVolumeSpi;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.FsDatasetImpl;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.FsVolumeImpl;
import org.apache.hadoop.hdfs.tools.JMXGet;
import org.apache.hadoop.net.unix.TemporarySocketDirectory;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.log4j.Level;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.After;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.rules.Timeout;

public abstract class LazyPersistTestCase {
    protected static final int BLOCK_SIZE = 0x500000;
    protected static final int BUFFER_LENGTH = 4096;
    protected static final int EVICTION_LOW_WATERMARK = 1;
    private static final long HEARTBEAT_INTERVAL_SEC = 1L;
    private static final int HEARTBEAT_RECHECK_INTERVAL_MSEC = 500;
    private static final String JMX_RAM_DISK_METRICS_PATTERN = "^RamDisk";
    private static final String JMX_SERVICE_NAME = "DataNode";
    protected static final int LAZY_WRITE_FILE_SCRUBBER_INTERVAL_SEC = 3;
    protected static final int LAZY_WRITER_INTERVAL_SEC = 1;
    protected static final Log LOG;
    protected static final short REPL_FACTOR = 1;
    protected MiniDFSCluster cluster;
    protected DistributedFileSystem fs;
    protected DFSClient client;
    protected JMXGet jmx;
    protected TemporarySocketDirectory sockDir;
    @Rule
    public Timeout timeout = new Timeout(300000);

    @After
    public void shutDownCluster() throws Exception {
        this.printRamDiskJMXMetrics();
        if (this.fs != null) {
            this.fs.close();
            this.fs = null;
            this.client = null;
        }
        if (this.cluster != null) {
            this.cluster.shutdownDataNodes();
            this.cluster.shutdown();
            this.cluster = null;
        }
        if (this.jmx != null) {
            this.jmx = null;
        }
        IOUtils.closeQuietly((Closeable)this.sockDir);
        this.sockDir = null;
    }

    protected final LocatedBlocks ensureFileReplicasOnStorageType(Path path, StorageType storageType) throws IOException {
        LOG.info((Object)("Ensure path: " + path + " is on StorageType: " + storageType));
        Assert.assertThat((Object)this.fs.exists(path), (Matcher)Is.is((Object)true));
        long fileLength = this.client.getFileInfo(path.toString()).getLen();
        LocatedBlocks locatedBlocks = this.client.getLocatedBlocks(path.toString(), 0L, fileLength);
        for (LocatedBlock locatedBlock : locatedBlocks.getLocatedBlocks()) {
            Assert.assertThat((Object)locatedBlock.getStorageTypes()[0], (Matcher)Is.is((Object)storageType));
        }
        return locatedBlocks;
    }

    protected final void ensureLazyPersistBlocksAreSaved(LocatedBlocks locatedBlocks) throws IOException, InterruptedException {
        String bpid = this.cluster.getNamesystem().getBlockPoolId();
        List volumes = this.cluster.getDataNodes().get(0).getFSDataset().getVolumes();
        HashSet<Long> persistedBlockIds = new HashSet<Long>();
        while (persistedBlockIds.size() < locatedBlocks.getLocatedBlocks().size()) {
            Thread.sleep(1000L);
            for (LocatedBlock lb : locatedBlocks.getLocatedBlocks()) {
                for (FsVolumeSpi v : volumes) {
                    long blockId;
                    FsVolumeImpl volume;
                    File lazyPersistDir;
                    File targetDir;
                    File blockFile;
                    if (v.isTransientStorage() || !(blockFile = new File(targetDir = DatanodeUtil.idToBlockDir((File)(lazyPersistDir = (volume = (FsVolumeImpl)v).getBlockPoolSlice(bpid).getLazypersistDir()), (long)(blockId = lb.getBlock().getBlockId())), lb.getBlock().getBlockName())).exists()) continue;
                    persistedBlockIds.add(blockId);
                }
            }
        }
        Assert.assertThat((Object)persistedBlockIds.size(), (Matcher)Is.is((Object)locatedBlocks.getLocatedBlocks().size()));
    }

    protected final void makeRandomTestFile(Path path, long length, boolean isLazyPersist, long seed) throws IOException {
        DFSTestUtil.createFile((FileSystem)this.fs, path, isLazyPersist, 4096, length, 0x500000L, (short)1, seed, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void makeTestFile(Path path, long length, boolean isLazyPersist) throws IOException {
        EnumSet<CreateFlag> createFlags = EnumSet.of(CreateFlag.CREATE);
        if (isLazyPersist) {
            createFlags.add(CreateFlag.LAZY_PERSIST);
        }
        FSDataOutputStream fos = null;
        try {
            fos = this.fs.create(path, FsPermission.getFileDefault(), createFlags, 4096, (short)1, 0x500000L, null);
            byte[] buffer = new byte[4096];
            int bytesWritten = 0;
            while ((long)bytesWritten < length) {
                fos.write(buffer, 0, buffer.length);
                bytesWritten += buffer.length;
            }
            if (length > 0L) {
                fos.hsync();
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(fos);
            throw throwable;
        }
        IOUtils.closeQuietly((OutputStream)fos);
    }

    protected final void startUpCluster(boolean hasTransientStorage, int ramDiskReplicaCapacity, boolean useSCR, boolean useLegacyBlockReaderLocal) throws IOException {
        StorageType[] storageTypeArray;
        Configuration conf = new Configuration();
        conf.setLong("dfs.blocksize", 0x500000L);
        conf.setInt("dfs.namenode.lazypersist.file.scrub.interval.sec", 3);
        conf.setLong("dfs.heartbeat.interval", 1L);
        conf.setInt("dfs.namenode.heartbeat.recheck-interval", 500);
        conf.setInt("dfs.datanode.lazywriter.interval.sec", 1);
        conf.setInt("dfs.datanode.ram.disk.low.watermark.bytes", 0x500000);
        if (useSCR) {
            conf.setBoolean("dfs.client.read.shortcircuit", true);
            conf.set("dfs.client.context", UUID.randomUUID().toString());
            if (useLegacyBlockReaderLocal) {
                conf.setBoolean("dfs.client.use.legacy.blockreader.local", true);
                conf.set("dfs.block.local-path-access.user", UserGroupInformation.getCurrentUser().getShortUserName());
            } else {
                this.sockDir = new TemporarySocketDirectory();
                conf.set("dfs.domain.socket.path", new File(this.sockDir.getDir(), this.getClass().getSimpleName() + "._PORT.sock").getAbsolutePath());
            }
        }
        long[] capacities = null;
        if (hasTransientStorage && ramDiskReplicaCapacity >= 0) {
            long ramDiskStorageLimit = (long)ramDiskReplicaCapacity * 0x500000L + 0x4FFFFFL;
            capacities = new long[]{ramDiskStorageLimit, -1L};
        }
        MiniDFSCluster.Builder builder = new MiniDFSCluster.Builder(conf).numDataNodes(1).storageCapacities(capacities);
        if (hasTransientStorage) {
            StorageType[] storageTypeArray2 = new StorageType[2];
            storageTypeArray2[0] = StorageType.RAM_DISK;
            storageTypeArray = storageTypeArray2;
            storageTypeArray2[1] = StorageType.DEFAULT;
        } else {
            storageTypeArray = null;
        }
        this.cluster = builder.storageTypes(storageTypeArray).build();
        this.fs = this.cluster.getFileSystem();
        this.client = this.fs.getClient();
        try {
            this.jmx = this.initJMX();
        }
        catch (Exception e) {
            Assert.fail((String)("Failed initialize JMX for testing: " + e));
        }
        LOG.info((Object)"Cluster startup complete");
    }

    protected final void startUpCluster(int numDataNodes, StorageType[] storageTypes, long ramDiskStorageLimit, boolean useSCR) throws IOException {
        StorageType[] storageTypeArray;
        Configuration conf = new Configuration();
        conf.setLong("dfs.blocksize", 0x500000L);
        conf.setInt("dfs.namenode.lazypersist.file.scrub.interval.sec", 3);
        conf.setLong("dfs.heartbeat.interval", 1L);
        conf.setInt("dfs.namenode.heartbeat.recheck-interval", 500);
        conf.setInt("dfs.datanode.lazywriter.interval.sec", 1);
        if (useSCR) {
            conf.setBoolean("dfs.client.read.shortcircuit", useSCR);
            conf.set("dfs.client.context", UUID.randomUUID().toString());
            this.sockDir = new TemporarySocketDirectory();
            conf.set("dfs.domain.socket.path", new File(this.sockDir.getDir(), this.getClass().getSimpleName() + "._PORT.sock").getAbsolutePath());
            conf.set("dfs.block.local-path-access.user", UserGroupInformation.getCurrentUser().getShortUserName());
        }
        MiniDFSCluster.Builder builder = new MiniDFSCluster.Builder(conf).numDataNodes(numDataNodes);
        if (storageTypes != null) {
            storageTypeArray = storageTypes;
        } else {
            StorageType[] storageTypeArray2 = new StorageType[2];
            storageTypeArray2[0] = StorageType.DEFAULT;
            storageTypeArray = storageTypeArray2;
            storageTypeArray2[1] = StorageType.DEFAULT;
        }
        this.cluster = builder.storageTypes(storageTypeArray).build();
        this.fs = this.cluster.getFileSystem();
        this.client = this.fs.getClient();
        if (ramDiskStorageLimit >= 0L) {
            List volumes = this.cluster.getDataNodes().get(0).getFSDataset().getVolumes();
            for (FsVolumeSpi volume : volumes) {
                if (volume.getStorageType() != StorageType.RAM_DISK) continue;
                ((FsVolumeImpl)volume).setCapacityForTesting(ramDiskStorageLimit);
            }
        }
        LOG.info((Object)"Cluster startup complete");
    }

    protected final void startUpCluster(boolean hasTransientStorage, int ramDiskReplicaCapacity) throws IOException {
        this.startUpCluster(hasTransientStorage, ramDiskReplicaCapacity, false, false);
    }

    protected final void triggerBlockReport() throws IOException, InterruptedException {
        DataNodeTestUtils.triggerBlockReport(this.cluster.getDataNodes().get(0));
        Thread.sleep(10000L);
    }

    protected final boolean verifyBlockDeletedFromDir(File dir, LocatedBlocks locatedBlocks) {
        for (LocatedBlock lb : locatedBlocks.getLocatedBlocks()) {
            File targetDir = DatanodeUtil.idToBlockDir((File)dir, (long)lb.getBlock().getBlockId());
            File blockFile = new File(targetDir, lb.getBlock().getBlockName());
            if (blockFile.exists()) {
                LOG.warn((Object)("blockFile: " + blockFile.getAbsolutePath() + " exists after deletion."));
                return false;
            }
            File metaFile = new File(targetDir, DatanodeUtil.getMetaName((String)lb.getBlock().getBlockName(), (long)lb.getBlock().getGenerationStamp()));
            if (!metaFile.exists()) continue;
            LOG.warn((Object)("metaFile: " + metaFile.getAbsolutePath() + " exists after deletion."));
            return false;
        }
        return true;
    }

    protected final boolean verifyDeletedBlocks(LocatedBlocks locatedBlocks) throws IOException, InterruptedException {
        LOG.info((Object)"Verifying replica has no saved copy after deletion.");
        this.triggerBlockReport();
        while (DataNodeTestUtils.getPendingAsyncDeletions(this.cluster.getDataNodes().get(0)) > 0L) {
            Thread.sleep(1000L);
        }
        String bpid = this.cluster.getNamesystem().getBlockPoolId();
        List volumes = this.cluster.getDataNodes().get(0).getFSDataset().getVolumes();
        for (FsVolumeSpi v : volumes) {
            FsVolumeImpl volume = (FsVolumeImpl)v;
            File targetDir = v.isTransientStorage() ? volume.getBlockPoolSlice(bpid).getFinalizedDir() : volume.getBlockPoolSlice(bpid).getLazypersistDir();
            if (this.verifyBlockDeletedFromDir(targetDir, locatedBlocks)) continue;
            return false;
        }
        return true;
    }

    protected final void verifyRamDiskJMXMetric(String metricName, long expectedValue) throws Exception {
        Assert.assertEquals((long)expectedValue, (long)Integer.parseInt(this.jmx.getValue(metricName)));
    }

    protected final boolean verifyReadRandomFile(Path path, int fileLength, int seed) throws IOException {
        byte[] contents = DFSTestUtil.readFileBuffer((FileSystem)this.fs, path);
        byte[] expected = DFSTestUtil.calculateFileContentsFromSeed(seed, fileLength);
        return Arrays.equals(contents, expected);
    }

    private JMXGet initJMX() throws Exception {
        JMXGet jmx = new JMXGet();
        jmx.setService(JMX_SERVICE_NAME);
        jmx.init();
        return jmx;
    }

    private void printRamDiskJMXMetrics() {
        try {
            if (this.jmx != null) {
                this.jmx.printAllMatchedAttributes(JMX_RAM_DISK_METRICS_PATTERN);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static {
        DFSTestUtil.setNameNodeLogLevel(Level.ALL);
        GenericTestUtils.setLogLevel((Log)FsDatasetImpl.LOG, (Level)Level.ALL);
        LOG = LogFactory.getLog(LazyPersistTestCase.class);
    }
}

