/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import com.google.common.base.Charsets;
import com.google.common.base.Joiner;
import java.io.File;
import java.io.IOException;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.UpgradeUtilities;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.common.InconsistentFSStateException;
import org.apache.hadoop.hdfs.server.common.Storage;
import org.apache.hadoop.hdfs.server.common.StorageInfo;
import org.apache.hadoop.hdfs.server.namenode.NNStorage;
import org.apache.hadoop.hdfs.server.namenode.TestParallelImageWrite;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.util.StringUtils;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;

public class TestDFSUpgrade {
    private static final int EXPECTED_TXID = 61;
    private static final Log LOG = LogFactory.getLog((String)TestDFSUpgrade.class.getName());
    private Configuration conf;
    private int testCounter = 0;
    private MiniDFSCluster cluster = null;

    void log(String label, int numDirs) {
        LOG.info((Object)"============================================================");
        LOG.info((Object)("***TEST " + this.testCounter++ + "*** " + label + ":" + " numDirs=" + numDirs));
    }

    void checkNameNode(String[] baseDirs, long imageTxId) throws IOException {
        for (String baseDir : baseDirs) {
            LOG.info((Object)("Checking namenode directory " + baseDir));
            LOG.info((Object)("==== Contents ====:\n  " + Joiner.on((String)"  \n").join((Object[])new File(baseDir, "current").list())));
            LOG.info((Object)"==================");
            GenericTestUtils.assertExists((File)new File(baseDir, "current"));
            GenericTestUtils.assertExists((File)new File(baseDir, "current/VERSION"));
            GenericTestUtils.assertExists((File)new File(baseDir, "current/" + NNStorage.getInProgressEditsFileName((long)(imageTxId + 1L))));
            GenericTestUtils.assertExists((File)new File(baseDir, "current/" + NNStorage.getImageFileName((long)imageTxId)));
            GenericTestUtils.assertExists((File)new File(baseDir, "current/seen_txid"));
            File previous = new File(baseDir, "previous");
            GenericTestUtils.assertExists((File)previous);
            Assert.assertEquals((long)UpgradeUtilities.checksumContents(HdfsServerConstants.NodeType.NAME_NODE, previous, false), (long)UpgradeUtilities.checksumMasterNameNodeContents());
        }
    }

    void checkDataNode(String[] baseDirs, String bpid) throws IOException {
        for (int i = 0; i < baseDirs.length; ++i) {
            File current = new File(baseDirs[i], "current/" + bpid + "/current");
            Assert.assertEquals((long)UpgradeUtilities.checksumContents(HdfsServerConstants.NodeType.DATA_NODE, current, false), (long)UpgradeUtilities.checksumMasterDataNodeContents());
            File currentFinalized = MiniDFSCluster.getFinalizedDir(new File(baseDirs[i]), bpid);
            Assert.assertEquals((long)UpgradeUtilities.checksumContents(HdfsServerConstants.NodeType.DATA_NODE, currentFinalized, true), (long)UpgradeUtilities.checksumMasterBlockPoolFinalizedContents());
            File previous = new File(baseDirs[i], "current/" + bpid + "/previous");
            Assert.assertTrue((boolean)previous.isDirectory());
            Assert.assertEquals((long)UpgradeUtilities.checksumContents(HdfsServerConstants.NodeType.DATA_NODE, previous, false), (long)UpgradeUtilities.checksumMasterDataNodeContents());
            File previousFinalized = new File(baseDirs[i], "current/" + bpid + "/previous" + "/finalized");
            Assert.assertEquals((long)UpgradeUtilities.checksumContents(HdfsServerConstants.NodeType.DATA_NODE, previousFinalized, true), (long)UpgradeUtilities.checksumMasterBlockPoolFinalizedContents());
        }
    }

    void startNameNodeShouldFail(HdfsServerConstants.StartupOption operation) {
        this.startNameNodeShouldFail(operation, null, null);
    }

    void startNameNodeShouldFail(HdfsServerConstants.StartupOption operation, Class<? extends Exception> exceptionClass, Pattern messagePattern) {
        try {
            this.cluster = new MiniDFSCluster.Builder(this.conf).numDataNodes(0).startupOption(operation).format(false).manageDataDfsDirs(false).manageNameDfsDirs(false).build();
            Assert.fail((String)"NameNode should have failed to start");
        }
        catch (Exception e) {
            if (exceptionClass != null) {
                Assert.assertTrue((String)("Caught exception is not of expected class " + exceptionClass.getSimpleName() + ": " + StringUtils.stringifyException((Throwable)e)), (boolean)exceptionClass.isInstance(e));
            }
            if (messagePattern != null) {
                Assert.assertTrue((String)("Caught exception message string does not match expected pattern \"" + messagePattern.pattern() + "\" : " + StringUtils.stringifyException((Throwable)e)), (boolean)messagePattern.matcher(e.getMessage()).find());
            }
            LOG.info((Object)"Successfully detected expected NameNode startup failure.");
        }
    }

    void startBlockPoolShouldFail(HdfsServerConstants.StartupOption operation, String bpid) throws IOException {
        this.cluster.startDataNodes(this.conf, 1, false, operation, null);
        Assert.assertFalse((String)("Block pool " + bpid + " should have failed to start"), (boolean)this.cluster.getDataNodes().get(0).isBPServiceAlive(bpid));
    }

    private MiniDFSCluster createCluster() throws IOException {
        return new MiniDFSCluster.Builder(this.conf).numDataNodes(0).format(false).manageDataDfsDirs(false).manageNameDfsDirs(false).startupOption(HdfsServerConstants.StartupOption.UPGRADE).build();
    }

    @BeforeClass
    public static void initialize() throws Exception {
        UpgradeUtilities.initialize();
    }

    @Test(timeout=60000L)
    public void testUpgrade() throws Exception {
        String[] nameNodeDirs;
        int numDirs;
        StorageInfo storageInfo = null;
        for (numDirs = 1; numDirs <= 2; ++numDirs) {
            this.conf = new HdfsConfiguration();
            this.conf = UpgradeUtilities.initializeStorageStateConf(numDirs, this.conf);
            nameNodeDirs = this.conf.getStrings("dfs.namenode.name.dir");
            String[] dataNodeDirs = this.conf.getStrings("dfs.datanode.data.dir");
            this.conf.setBoolean("dfs.datanode.duplicate.replica.deletion", false);
            this.log("Normal NameNode upgrade", numDirs);
            UpgradeUtilities.createNameNodeStorageDirs(nameNodeDirs, "current");
            this.cluster = this.createCluster();
            try {
                DistributedFileSystem dfs = this.cluster.getFileSystem();
                dfs.setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_ENTER);
                dfs.rollingUpgrade(HdfsConstants.RollingUpgradeAction.PREPARE);
                Assert.fail();
            }
            catch (RemoteException re) {
                Assert.assertEquals((Object)InconsistentFSStateException.class.getName(), (Object)re.getClassName());
                LOG.info((Object)"The exception is expected.", (Throwable)re);
            }
            this.checkNameNode(nameNodeDirs, 61L);
            if (numDirs > 1) {
                TestParallelImageWrite.checkImages(this.cluster.getNamesystem(), numDirs);
            }
            this.cluster.shutdown();
            UpgradeUtilities.createEmptyDirs(nameNodeDirs);
            this.log("Normal DataNode upgrade", numDirs);
            UpgradeUtilities.createNameNodeStorageDirs(nameNodeDirs, "current");
            this.cluster = this.createCluster();
            UpgradeUtilities.createDataNodeStorageDirs(dataNodeDirs, "current");
            this.cluster.startDataNodes(this.conf, 1, false, HdfsServerConstants.StartupOption.REGULAR, null);
            this.checkDataNode(dataNodeDirs, UpgradeUtilities.getCurrentBlockPoolID(null));
            this.cluster.shutdown();
            UpgradeUtilities.createEmptyDirs(nameNodeDirs);
            UpgradeUtilities.createEmptyDirs(dataNodeDirs);
            this.log("NameNode upgrade with existing previous dir", numDirs);
            UpgradeUtilities.createNameNodeStorageDirs(nameNodeDirs, "current");
            UpgradeUtilities.createNameNodeStorageDirs(nameNodeDirs, "previous");
            this.startNameNodeShouldFail(HdfsServerConstants.StartupOption.UPGRADE);
            UpgradeUtilities.createEmptyDirs(nameNodeDirs);
            this.log("DataNode upgrade with existing previous dir", numDirs);
            UpgradeUtilities.createNameNodeStorageDirs(nameNodeDirs, "current");
            this.cluster = this.createCluster();
            UpgradeUtilities.createDataNodeStorageDirs(dataNodeDirs, "current");
            UpgradeUtilities.createDataNodeStorageDirs(dataNodeDirs, "previous");
            this.cluster.startDataNodes(this.conf, 1, false, HdfsServerConstants.StartupOption.REGULAR, null);
            this.checkDataNode(dataNodeDirs, UpgradeUtilities.getCurrentBlockPoolID(null));
            this.cluster.shutdown();
            UpgradeUtilities.createEmptyDirs(nameNodeDirs);
            UpgradeUtilities.createEmptyDirs(dataNodeDirs);
            this.log("DataNode upgrade with future stored layout version in current", numDirs);
            UpgradeUtilities.createNameNodeStorageDirs(nameNodeDirs, "current");
            this.cluster = this.createCluster();
            File[] baseDirs = UpgradeUtilities.createDataNodeStorageDirs(dataNodeDirs, "current");
            storageInfo = new StorageInfo(Integer.MIN_VALUE, UpgradeUtilities.getCurrentNamespaceID(this.cluster), UpgradeUtilities.getCurrentClusterID(this.cluster), UpgradeUtilities.getCurrentFsscTime(this.cluster), HdfsServerConstants.NodeType.DATA_NODE);
            UpgradeUtilities.createDataNodeVersionFile(baseDirs, storageInfo, UpgradeUtilities.getCurrentBlockPoolID(this.cluster));
            this.startBlockPoolShouldFail(HdfsServerConstants.StartupOption.REGULAR, UpgradeUtilities.getCurrentBlockPoolID(null));
            this.cluster.shutdown();
            UpgradeUtilities.createEmptyDirs(nameNodeDirs);
            UpgradeUtilities.createEmptyDirs(dataNodeDirs);
            this.log("DataNode upgrade with newer fsscTime in current", numDirs);
            UpgradeUtilities.createNameNodeStorageDirs(nameNodeDirs, "current");
            this.cluster = this.createCluster();
            baseDirs = UpgradeUtilities.createDataNodeStorageDirs(dataNodeDirs, "current");
            storageInfo = new StorageInfo(HdfsServerConstants.DATANODE_LAYOUT_VERSION, UpgradeUtilities.getCurrentNamespaceID(this.cluster), UpgradeUtilities.getCurrentClusterID(this.cluster), Long.MAX_VALUE, HdfsServerConstants.NodeType.DATA_NODE);
            UpgradeUtilities.createDataNodeVersionFile(baseDirs, storageInfo, UpgradeUtilities.getCurrentBlockPoolID(this.cluster));
            this.startBlockPoolShouldFail(HdfsServerConstants.StartupOption.REGULAR, UpgradeUtilities.getCurrentBlockPoolID(null));
            this.cluster.shutdown();
            UpgradeUtilities.createEmptyDirs(nameNodeDirs);
            UpgradeUtilities.createEmptyDirs(dataNodeDirs);
            this.log("NameNode upgrade with no edits file", numDirs);
            UpgradeUtilities.createNameNodeStorageDirs(nameNodeDirs, "current");
            this.deleteStorageFilesWithPrefix(nameNodeDirs, "edits_");
            this.startNameNodeShouldFail(HdfsServerConstants.StartupOption.UPGRADE);
            UpgradeUtilities.createEmptyDirs(nameNodeDirs);
            this.log("NameNode upgrade with no image file", numDirs);
            UpgradeUtilities.createNameNodeStorageDirs(nameNodeDirs, "current");
            this.deleteStorageFilesWithPrefix(nameNodeDirs, "fsimage_");
            this.startNameNodeShouldFail(HdfsServerConstants.StartupOption.UPGRADE);
            UpgradeUtilities.createEmptyDirs(nameNodeDirs);
            this.log("NameNode upgrade with corrupt version file", numDirs);
            for (File f : baseDirs = UpgradeUtilities.createNameNodeStorageDirs(nameNodeDirs, "current")) {
                UpgradeUtilities.corruptFile(new File(f, "VERSION"), "layoutVersion".getBytes(Charsets.UTF_8), "xxxxxxxxxxxxx".getBytes(Charsets.UTF_8));
            }
            this.startNameNodeShouldFail(HdfsServerConstants.StartupOption.UPGRADE);
            UpgradeUtilities.createEmptyDirs(nameNodeDirs);
            this.log("NameNode upgrade with old layout version in current", numDirs);
            baseDirs = UpgradeUtilities.createNameNodeStorageDirs(nameNodeDirs, "current");
            storageInfo = new StorageInfo(-15, UpgradeUtilities.getCurrentNamespaceID(null), UpgradeUtilities.getCurrentClusterID(null), UpgradeUtilities.getCurrentFsscTime(null), HdfsServerConstants.NodeType.NAME_NODE);
            UpgradeUtilities.createNameNodeVersionFile(this.conf, baseDirs, storageInfo, UpgradeUtilities.getCurrentBlockPoolID(this.cluster));
            this.startNameNodeShouldFail(HdfsServerConstants.StartupOption.UPGRADE);
            UpgradeUtilities.createEmptyDirs(nameNodeDirs);
            this.log("NameNode upgrade with future layout version in current", numDirs);
            baseDirs = UpgradeUtilities.createNameNodeStorageDirs(nameNodeDirs, "current");
            storageInfo = new StorageInfo(Integer.MIN_VALUE, UpgradeUtilities.getCurrentNamespaceID(null), UpgradeUtilities.getCurrentClusterID(null), UpgradeUtilities.getCurrentFsscTime(null), HdfsServerConstants.NodeType.NAME_NODE);
            UpgradeUtilities.createNameNodeVersionFile(this.conf, baseDirs, storageInfo, UpgradeUtilities.getCurrentBlockPoolID(this.cluster));
            this.startNameNodeShouldFail(HdfsServerConstants.StartupOption.UPGRADE);
            UpgradeUtilities.createEmptyDirs(nameNodeDirs);
        }
        numDirs = 4;
        this.conf = new HdfsConfiguration();
        this.conf.setInt("dfs.datanode.scan.period.hours", -1);
        this.conf.setBoolean("dfs.datanode.duplicate.replica.deletion", false);
        this.conf = UpgradeUtilities.initializeStorageStateConf(numDirs, this.conf);
        nameNodeDirs = this.conf.getStrings("dfs.namenode.name.dir");
        this.log("Normal NameNode upgrade", numDirs);
        UpgradeUtilities.createNameNodeStorageDirs(nameNodeDirs, "current");
        this.cluster = this.createCluster();
        try {
            DistributedFileSystem dfs = this.cluster.getFileSystem();
            dfs.setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_ENTER);
            dfs.rollingUpgrade(HdfsConstants.RollingUpgradeAction.PREPARE);
            Assert.fail();
        }
        catch (RemoteException re) {
            Assert.assertEquals((Object)InconsistentFSStateException.class.getName(), (Object)re.getClassName());
            LOG.info((Object)"The exception is expected.", (Throwable)re);
        }
        this.checkNameNode(nameNodeDirs, 61L);
        TestParallelImageWrite.checkImages(this.cluster.getNamesystem(), numDirs);
        this.cluster.shutdown();
        UpgradeUtilities.createEmptyDirs(nameNodeDirs);
    }

    @Ignore
    public void testUpgrade4() throws Exception {
        int numDirs = 4;
        this.conf = new HdfsConfiguration();
        this.conf.setInt("dfs.datanode.scan.period.hours", -1);
        this.conf.setBoolean("dfs.datanode.duplicate.replica.deletion", false);
        this.conf = UpgradeUtilities.initializeStorageStateConf(numDirs, this.conf);
        String[] nameNodeDirs = this.conf.getStrings("dfs.namenode.name.dir");
        this.log("NameNode upgrade with one bad storage dir", numDirs);
        UpgradeUtilities.createNameNodeStorageDirs(nameNodeDirs, "current");
        try {
            this.startNameNodeShouldFail(HdfsServerConstants.StartupOption.UPGRADE, IOException.class, Pattern.compile("failed in 1 storage"));
        }
        finally {
            UpgradeUtilities.createEmptyDirs(nameNodeDirs);
        }
    }

    private void deleteStorageFilesWithPrefix(String[] nameNodeDirs, String prefix) throws Exception {
        for (String baseDirStr : nameNodeDirs) {
            File baseDir = new File(baseDirStr);
            File currentDir = new File(baseDir, "current");
            for (File f : currentDir.listFiles()) {
                if (!f.getName().startsWith(prefix)) continue;
                Assert.assertTrue((String)("Deleting " + f), (boolean)f.delete());
            }
        }
    }

    @Test(expected=IOException.class)
    public void testUpgradeFromPreUpgradeLVFails() throws IOException {
        Storage.checkVersionUpgradable((int)-2);
        Assert.fail((String)"Expected IOException is not thrown");
    }

    @Ignore
    public void test203LayoutVersion() {
        for (int lv : Storage.LAYOUT_VERSIONS_203) {
            Assert.assertTrue((boolean)Storage.is203LayoutVersion((int)lv));
        }
    }

    public static void main(String[] args) throws Exception {
        TestDFSUpgrade t = new TestDFSUpgrade();
        TestDFSUpgrade.initialize();
        t.testUpgrade();
    }
}

