/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tracing;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.PrintStream;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.datatransfer.sasl.SaslDataTransferTestCase;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.net.unix.TemporarySocketDirectory;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.tracing.TraceAdmin;
import org.junit.Assert;
import org.junit.Test;

public class TestTraceAdmin
extends SaslDataTransferTestCase {
    private static final String NEWLINE = System.getProperty("line.separator");
    private static final int ONE_DATANODE = 1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String runTraceCommand(TraceAdmin trace, String ... cmd) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        PrintStream oldStdout = System.out;
        PrintStream oldStderr = System.err;
        System.setOut(ps);
        System.setErr(ps);
        int ret = -1;
        try {
            ret = trace.run(cmd);
        }
        finally {
            try {
                System.out.flush();
            }
            finally {
                System.setOut(oldStdout);
                System.setErr(oldStderr);
            }
        }
        return "ret:" + ret + ", " + baos.toString();
    }

    private String getHostPortForNN(MiniDFSCluster cluster) {
        return "127.0.0.1:" + cluster.getNameNodePort();
    }

    private String getHostPortForDN(MiniDFSCluster cluster, int index) {
        ArrayList<DataNode> dns = cluster.getDataNodes();
        Assert.assertTrue((index >= 0 && index < dns.size() ? 1 : 0) != 0);
        return "127.0.0.1:" + dns.get(index).getIpcPort();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCreateAndDestroySpanReceiver() throws Exception {
        Configuration conf = new Configuration();
        conf = new Configuration();
        conf.set("hadoop.htrace.span.receiver.classes", "");
        MiniDFSCluster cluster = new MiniDFSCluster.Builder(conf).numDataNodes(3).build();
        cluster.waitActive();
        TemporarySocketDirectory tempDir = new TemporarySocketDirectory();
        String tracePath = new File(tempDir.getDir(), "tracefile").getAbsolutePath();
        try {
            TraceAdmin trace = new TraceAdmin();
            trace.setConf(conf);
            Assert.assertEquals((Object)("ret:0, [no span receivers found]" + NEWLINE), (Object)this.runTraceCommand(trace, "-list", "-host", this.getHostPortForNN(cluster)));
            Assert.assertEquals((Object)("ret:0, Added trace span receiver 1 with configuration hadoop.htrace.local.file.span.receiver.path = " + tracePath + NEWLINE), (Object)this.runTraceCommand(trace, "-add", "-host", this.getHostPortForNN(cluster), "-class", "org.apache.htrace.core.LocalFileSpanReceiver", "-Chadoop.htrace.local.file.span.receiver.path=" + tracePath));
            String list = this.runTraceCommand(trace, "-list", "-host", this.getHostPortForNN(cluster));
            Assert.assertTrue((boolean)list.startsWith("ret:0"));
            Assert.assertTrue((boolean)list.contains("1   org.apache.htrace.core.LocalFileSpanReceiver"));
            Assert.assertEquals((Object)("ret:0, Removed trace span receiver 1" + NEWLINE), (Object)this.runTraceCommand(trace, "-remove", "1", "-host", this.getHostPortForNN(cluster)));
            Assert.assertEquals((Object)("ret:0, [no span receivers found]" + NEWLINE), (Object)this.runTraceCommand(trace, "-list", "-host", this.getHostPortForNN(cluster)));
            Assert.assertEquals((Object)("ret:0, Added trace span receiver 2 with configuration hadoop.htrace.local.file.span.receiver.path = " + tracePath + NEWLINE), (Object)this.runTraceCommand(trace, "-add", "-host", this.getHostPortForNN(cluster), "-class", "LocalFileSpanReceiver", "-Chadoop.htrace.local.file.span.receiver.path=" + tracePath));
            Assert.assertEquals((Object)("ret:0, Removed trace span receiver 2" + NEWLINE), (Object)this.runTraceCommand(trace, "-remove", "2", "-host", this.getHostPortForNN(cluster)));
        }
        finally {
            cluster.shutdown();
            tempDir.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testKerberizedTraceAdmin() throws Exception {
        MiniDFSCluster cluster = null;
        final HdfsConfiguration conf = this.createSecureConfig("authentication,privacy");
        try {
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).build();
            cluster.waitActive();
            final String nnHost = this.getHostPortForNN(cluster);
            final String dnHost = this.getHostPortForDN(cluster, 0);
            UserGroupInformation.loginUserFromKeytabAndReturnUGI((String)TestTraceAdmin.getHdfsPrincipal(), (String)TestTraceAdmin.getHdfsKeytab()).doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    TraceAdmin trace = new TraceAdmin();
                    trace.setConf((Configuration)conf);
                    String[] nnTraceCmd = new String[]{"-list", "-host", nnHost, "-principal", conf.get("dfs.namenode.kerberos.principal")};
                    int ret = trace.run(nnTraceCmd);
                    Assert.assertEquals((long)0L, (long)ret);
                    String[] dnTraceCmd = new String[]{"-list", "-host", dnHost, "-principal", conf.get("dfs.datanode.kerberos.principal")};
                    ret = trace.run(dnTraceCmd);
                    Assert.assertEquals((long)0L, (long)ret);
                    return null;
                }
            });
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }
}

