/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.tools;

import com.google.common.base.Charsets;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.HAUtil;
import org.apache.hadoop.hdfs.qjournal.MiniQJMHACluster;
import org.apache.hadoop.hdfs.tools.DFSAdmin;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class TestDFSAdminWithHA {
    private final ByteArrayOutputStream out = new ByteArrayOutputStream();
    private final ByteArrayOutputStream err = new ByteArrayOutputStream();
    private MiniQJMHACluster cluster;
    private Configuration conf;
    private DFSAdmin admin;
    private static final PrintStream oldOut = System.out;
    private static final PrintStream oldErr = System.err;
    private static final String NSID = "ns1";
    private static String newLine = System.getProperty("line.separator");

    private void assertOutputMatches(String string) {
        String errOutput = new String(this.out.toByteArray(), Charsets.UTF_8);
        String output = new String(this.out.toByteArray(), Charsets.UTF_8);
        if (!errOutput.matches(string) && !output.matches(string)) {
            Assert.fail((String)("Expected output to match '" + string + "' but err_output was:\n" + errOutput + "\n and output was: \n" + output));
        }
        this.out.reset();
        this.err.reset();
    }

    private void setHAConf(Configuration conf, String nn1Addr, String nn2Addr) {
        conf.set("fs.defaultFS", "hdfs://ns1");
        conf.set("dfs.nameservices", NSID);
        conf.set("dfs.nameservice.id", NSID);
        conf.set(DFSUtil.addKeySuffixes((String)"dfs.ha.namenodes", (String[])new String[]{NSID}), "nn1,nn2");
        conf.set("dfs.ha.namenode.id", "nn1");
        conf.set(DFSUtil.addKeySuffixes((String)"dfs.namenode.rpc-address", (String[])new String[]{NSID, "nn1"}), nn1Addr);
        conf.set(DFSUtil.addKeySuffixes((String)"dfs.namenode.rpc-address", (String[])new String[]{NSID, "nn2"}), nn2Addr);
    }

    private void setUpHaCluster(boolean security) throws Exception {
        this.conf = new Configuration();
        this.conf.setBoolean("hadoop.security.authorization", security);
        this.cluster = new MiniQJMHACluster.Builder(this.conf).build();
        this.setHAConf(this.conf, this.cluster.getDfsCluster().getNameNode(0).getHostAndPort(), this.cluster.getDfsCluster().getNameNode(1).getHostAndPort());
        this.cluster.getDfsCluster().getNameNode(0).getHostAndPort();
        this.admin = new DFSAdmin();
        this.admin.setConf(this.conf);
        Assert.assertTrue((boolean)HAUtil.isHAEnabled((Configuration)this.conf, (String)NSID));
        System.setOut(new PrintStream(this.out));
        System.setErr(new PrintStream(this.err));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @After
    public void tearDown() throws Exception {
        try {
            System.out.flush();
            System.err.flush();
        }
        finally {
            System.setOut(oldOut);
            System.setErr(oldErr);
        }
        if (this.admin != null) {
            this.admin.close();
        }
        if (this.cluster != null) {
            this.cluster.shutdown();
        }
        this.out.reset();
        this.err.reset();
    }

    @Test(timeout=30000L)
    public void testSetSafeMode() throws Exception {
        this.setUpHaCluster(false);
        int exitCode = this.admin.run(new String[]{"-safemode", "enter"});
        Assert.assertEquals((String)this.err.toString().trim(), (long)0L, (long)exitCode);
        String message = "Safe mode is ON in.*";
        this.assertOutputMatches(message + newLine + message + newLine);
        exitCode = this.admin.run(new String[]{"-safemode", "get"});
        Assert.assertEquals((String)this.err.toString().trim(), (long)0L, (long)exitCode);
        message = "Safe mode is ON in.*";
        this.assertOutputMatches(message + newLine + message + newLine);
        exitCode = this.admin.run(new String[]{"-safemode", "leave"});
        Assert.assertEquals((String)this.err.toString().trim(), (long)0L, (long)exitCode);
        message = "Safe mode is OFF in.*";
        this.assertOutputMatches(message + newLine + message + newLine);
        exitCode = this.admin.run(new String[]{"-safemode", "get"});
        Assert.assertEquals((String)this.err.toString().trim(), (long)0L, (long)exitCode);
        message = "Safe mode is OFF in.*";
        this.assertOutputMatches(message + newLine + message + newLine);
    }

    @Test(timeout=30000L)
    public void testSaveNamespace() throws Exception {
        this.setUpHaCluster(false);
        int exitCode = this.admin.run(new String[]{"-safemode", "enter"});
        Assert.assertEquals((String)this.err.toString().trim(), (long)0L, (long)exitCode);
        String message = "Safe mode is ON in.*";
        this.assertOutputMatches(message + newLine + message + newLine);
        exitCode = this.admin.run(new String[]{"-saveNamespace"});
        Assert.assertEquals((String)this.err.toString().trim(), (long)0L, (long)exitCode);
        message = "Save namespace successful for.*";
        this.assertOutputMatches(message + newLine + message + newLine);
    }

    @Test(timeout=30000L)
    public void testRestoreFailedStorage() throws Exception {
        this.setUpHaCluster(false);
        int exitCode = this.admin.run(new String[]{"-restoreFailedStorage", "check"});
        Assert.assertEquals((String)this.err.toString().trim(), (long)0L, (long)exitCode);
        String message = "restoreFailedStorage is set to false for.*";
        this.assertOutputMatches(message + newLine + message + newLine);
        exitCode = this.admin.run(new String[]{"-restoreFailedStorage", "true"});
        Assert.assertEquals((String)this.err.toString().trim(), (long)0L, (long)exitCode);
        message = "restoreFailedStorage is set to true for.*";
        this.assertOutputMatches(message + newLine + message + newLine);
        exitCode = this.admin.run(new String[]{"-restoreFailedStorage", "false"});
        Assert.assertEquals((String)this.err.toString().trim(), (long)0L, (long)exitCode);
        message = "restoreFailedStorage is set to false for.*";
        this.assertOutputMatches(message + newLine + message + newLine);
    }

    @Test(timeout=30000L)
    public void testRefreshNodes() throws Exception {
        this.setUpHaCluster(false);
        int exitCode = this.admin.run(new String[]{"-refreshNodes"});
        Assert.assertEquals((String)this.err.toString().trim(), (long)0L, (long)exitCode);
        String message = "Refresh nodes successful for.*";
        this.assertOutputMatches(message + newLine + message + newLine);
    }

    @Test(timeout=30000L)
    public void testSetBalancerBandwidth() throws Exception {
        this.setUpHaCluster(false);
        int exitCode = this.admin.run(new String[]{"-setBalancerBandwidth", "10"});
        Assert.assertEquals((String)this.err.toString().trim(), (long)0L, (long)exitCode);
        String message = "Balancer bandwidth is set to 10 for.*";
        this.assertOutputMatches(message + newLine + message + newLine);
    }

    @Test(timeout=30000L)
    public void testSetNegativeBalancerBandwidth() throws Exception {
        this.setUpHaCluster(false);
        int exitCode = this.admin.run(new String[]{"-setBalancerBandwidth", "-10"});
        Assert.assertEquals((String)"Negative bandwidth value must fail the command", (long)-1L, (long)exitCode);
    }

    @Test(timeout=30000L)
    public void testMetaSave() throws Exception {
        this.setUpHaCluster(false);
        int exitCode = this.admin.run(new String[]{"-metasave", "dfs.meta"});
        Assert.assertEquals((String)this.err.toString().trim(), (long)0L, (long)exitCode);
        String message = "Created metasave file dfs.meta in the log directory of namenode.*";
        this.assertOutputMatches(message + newLine + message + newLine);
    }

    @Test(timeout=30000L)
    public void testRefreshServiceAcl() throws Exception {
        this.setUpHaCluster(true);
        int exitCode = this.admin.run(new String[]{"-refreshServiceAcl"});
        Assert.assertEquals((String)this.err.toString().trim(), (long)0L, (long)exitCode);
        String message = "Refresh service acl successful for.*";
        this.assertOutputMatches(message + newLine + message + newLine);
    }

    @Test(timeout=30000L)
    public void testRefreshUserToGroupsMappings() throws Exception {
        this.setUpHaCluster(false);
        int exitCode = this.admin.run(new String[]{"-refreshUserToGroupsMappings"});
        Assert.assertEquals((String)this.err.toString().trim(), (long)0L, (long)exitCode);
        String message = "Refresh user to groups mapping successful for.*";
        this.assertOutputMatches(message + newLine + message + newLine);
    }

    @Test(timeout=30000L)
    public void testRefreshSuperUserGroupsConfiguration() throws Exception {
        this.setUpHaCluster(false);
        int exitCode = this.admin.run(new String[]{"-refreshSuperUserGroupsConfiguration"});
        Assert.assertEquals((String)this.err.toString().trim(), (long)0L, (long)exitCode);
        String message = "Refresh super user groups configuration successful for.*";
        this.assertOutputMatches(message + newLine + message + newLine);
    }

    @Test(timeout=30000L)
    public void testRefreshCallQueue() throws Exception {
        this.setUpHaCluster(false);
        int exitCode = this.admin.run(new String[]{"-refreshCallQueue"});
        Assert.assertEquals((String)this.err.toString().trim(), (long)0L, (long)exitCode);
        String message = "Refresh call queue successful for.*";
        this.assertOutputMatches(message + newLine + message + newLine);
    }
}

