/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode.erasurecode;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hdfs.server.datanode.erasurecode.ErasureCodingWorker;
import org.apache.hadoop.hdfs.server.datanode.erasurecode.StripedReconstructionInfo;
import org.apache.hadoop.hdfs.server.datanode.erasurecode.StripedReconstructor;
import org.apache.hadoop.hdfs.server.datanode.erasurecode.StripedWriter;
import org.apache.hadoop.hdfs.server.datanode.metrics.DataNodeMetrics;

@InterfaceAudience.Private
class StripedBlockReconstructor
extends StripedReconstructor
implements Runnable {
    private StripedWriter stripedWriter;

    StripedBlockReconstructor(ErasureCodingWorker worker, StripedReconstructionInfo stripedReconInfo) {
        super(worker, stripedReconInfo);
        this.stripedWriter = new StripedWriter(this, this.getDatanode(), this.getConf(), stripedReconInfo);
    }

    boolean hasValidTargets() {
        return this.stripedWriter.hasValidTargets();
    }

    @Override
    public void run() {
        try {
            this.initDecoderIfNecessary();
            this.getStripedReader().init();
            this.stripedWriter.init();
            this.reconstruct();
            this.stripedWriter.endTargetBlocks();
        }
        catch (Throwable e) {
            LOG.warn("Failed to reconstruct striped block: {}", (Object)this.getBlockGroup(), (Object)e);
            this.getDatanode().getMetrics().incrECFailedReconstructionTasks();
        }
        finally {
            this.getDatanode().decrementXmitsInProgress(this.getXmits());
            DataNodeMetrics metrics = this.getDatanode().getMetrics();
            metrics.incrECReconstructionTasks();
            metrics.incrECReconstructionBytesRead(this.getBytesRead());
            metrics.incrECReconstructionRemoteBytesRead(this.getRemoteBytesRead());
            metrics.incrECReconstructionBytesWritten(this.getBytesWritten());
            this.getStripedReader().close();
            this.stripedWriter.close();
            this.cleanup();
        }
    }

    @Override
    void reconstruct() throws IOException {
        while (this.getPositionInBlock() < this.getMaxTargetLength()) {
            long remaining = this.getMaxTargetLength() - this.getPositionInBlock();
            int toReconstructLen = (int)Math.min((long)this.getStripedReader().getBufferSize(), remaining);
            this.getStripedReader().readMinimumSources(toReconstructLen);
            this.reconstructTargets(toReconstructLen);
            if (this.stripedWriter.transferData2Targets() == 0) {
                String error = "Transfer failed for all targets.";
                throw new IOException(error);
            }
            this.updatePositionInBlock(toReconstructLen);
            this.clearBuffers();
        }
    }

    private void reconstructTargets(int toReconstructLen) {
        ByteBuffer[] inputs = this.getStripedReader().getInputBuffers(toReconstructLen);
        int[] erasedIndices = this.stripedWriter.getRealTargetIndices();
        ByteBuffer[] outputs = this.stripedWriter.getRealTargetBuffers(toReconstructLen);
        long start = System.nanoTime();
        this.getDecoder().decode(inputs, erasedIndices, outputs);
        long end = System.nanoTime();
        this.getDatanode().getMetrics().incrECDecodingTime(end - start);
        this.stripedWriter.updateRealTargetBuffers(toReconstructLen);
    }

    private void clearBuffers() {
        this.getStripedReader().clearBuffers();
        this.stripedWriter.clearBuffers();
    }
}

