/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode;

import com.google.common.annotations.VisibleForTesting;
import java.net.BindException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.nio.channels.ServerSocketChannel;
import org.apache.commons.daemon.Daemon;
import org.apache.commons.daemon.DaemonContext;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.http.HttpConfig;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;

public class SecureDataNodeStarter
implements Daemon {
    private String[] args;
    private SecureResources resources;

    public void init(DaemonContext context) throws Exception {
        System.err.println("Initializing secure datanode resources");
        HdfsConfiguration conf = new HdfsConfiguration();
        this.args = context.getArguments();
        this.resources = SecureDataNodeStarter.getSecureResources((Configuration)conf);
    }

    public void start() throws Exception {
        System.err.println("Starting regular datanode initialization");
        DataNode.secureMain(this.args, this.resources);
    }

    public void destroy() {
    }

    public void stop() throws Exception {
    }

    @VisibleForTesting
    public static SecureResources getSecureResources(Configuration conf) throws Exception {
        ServerSocketChannel httpChannel;
        HttpConfig.Policy policy = DFSUtil.getHttpPolicy(conf);
        boolean isSecure = UserGroupInformation.isSecurityEnabled();
        InetSocketAddress streamingAddr = DataNode.getStreamingAddr(conf);
        int socketWriteTimeout = conf.getInt("dfs.datanode.socket.write.timeout", 480000);
        int backlogLength = conf.getInt("ipc.server.listen.queue.size", 128);
        ServerSocket ss = socketWriteTimeout > 0 ? ServerSocketChannel.open().socket() : new ServerSocket();
        try {
            ss.bind(streamingAddr, backlogLength);
        }
        catch (BindException e) {
            BindException newBe = SecureDataNodeStarter.appendMessageToBindException(e, streamingAddr.toString());
            throw newBe;
        }
        if (ss.getLocalPort() != streamingAddr.getPort()) {
            throw new RuntimeException("Unable to bind on specified streaming port in secure context. Needed " + streamingAddr.getPort() + ", got " + ss.getLocalPort());
        }
        if (!SecurityUtil.isPrivilegedPort((int)ss.getLocalPort()) && isSecure) {
            throw new RuntimeException("Cannot start secure datanode with unprivileged RPC ports");
        }
        System.err.println("Opened streaming server at " + streamingAddr);
        if (policy.isHttpEnabled()) {
            httpChannel = ServerSocketChannel.open();
            InetSocketAddress infoSocAddr = DataNode.getInfoAddr(conf);
            try {
                httpChannel.socket().bind(infoSocAddr);
            }
            catch (BindException e) {
                BindException newBe = SecureDataNodeStarter.appendMessageToBindException(e, infoSocAddr.toString());
                throw newBe;
            }
            InetSocketAddress localAddr = (InetSocketAddress)httpChannel.socket().getLocalSocketAddress();
            if (localAddr.getPort() != infoSocAddr.getPort()) {
                throw new RuntimeException("Unable to bind on specified info port in secure context. Needed " + infoSocAddr.getPort() + ", got " + ss.getLocalPort());
            }
            System.err.println("Successfully obtained privileged resources (streaming port = " + ss + " ) (http listener port = " + localAddr.getPort() + ")");
            if (localAddr.getPort() > 1023 && isSecure) {
                throw new RuntimeException("Cannot start secure datanode with unprivileged HTTP ports");
            }
            System.err.println("Opened info server at " + infoSocAddr);
        } else {
            httpChannel = null;
        }
        return new SecureResources(ss, httpChannel);
    }

    private static BindException appendMessageToBindException(BindException e, String msg) {
        BindException newBe = new BindException(e.getMessage() + " " + msg);
        newBe.initCause(e.getCause());
        newBe.setStackTrace(e.getStackTrace());
        return newBe;
    }

    public static class SecureResources {
        private final ServerSocket streamingSocket;
        private final ServerSocketChannel httpServerSocket;

        public SecureResources(ServerSocket streamingSocket, ServerSocketChannel httpServerSocket) {
            this.streamingSocket = streamingSocket;
            this.httpServerSocket = httpServerSocket;
        }

        public ServerSocket getStreamingSocket() {
            return this.streamingSocket;
        }

        public ServerSocketChannel getHttpServerChannel() {
            return this.httpServerSocket;
        }
    }
}

