/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.store.records;

import java.io.IOException;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.server.federation.resolver.RemoteLocation;
import org.apache.hadoop.hdfs.server.federation.resolver.order.DestinationOrder;
import org.apache.hadoop.hdfs.server.federation.store.driver.StateStoreSerializer;
import org.apache.hadoop.hdfs.server.federation.store.records.BaseRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MountTable
extends BaseRecord {
    private static final Logger LOG = LoggerFactory.getLogger(MountTable.class);
    public static final Comparator<String> PATH_COMPARATOR = new Comparator<String>(){

        @Override
        public int compare(String o1, String o2) {
            String s1 = o1.replace('/', ' ');
            String s2 = o2.replace('/', ' ');
            return s1.compareTo(s2);
        }
    };
    public static final Comparator<MountTable> SOURCE_COMPARATOR = new Comparator<MountTable>(){

        @Override
        public int compare(MountTable m1, MountTable m2) {
            String src1 = m1.getSourcePath();
            String src2 = m2.getSourcePath();
            return PATH_COMPARATOR.compare(src1, src2);
        }
    };

    public static MountTable newInstance() {
        MountTable record = StateStoreSerializer.newRecord(MountTable.class);
        record.init();
        return record;
    }

    public static MountTable newInstance(String src, Map<String, String> destinations, long dateCreated, long dateModified) throws IOException {
        MountTable record = MountTable.newInstance(src, destinations);
        record.setDateCreated(dateCreated);
        record.setDateModified(dateModified);
        return record;
    }

    public static MountTable newInstance(String src, Map<String, String> destinations) throws IOException {
        MountTable record = MountTable.newInstance();
        record.setSourcePath(MountTable.normalizeFileSystemPath(src));
        LinkedList<RemoteLocation> locations = new LinkedList<RemoteLocation>();
        for (Map.Entry<String, String> entry : destinations.entrySet()) {
            String nsId = entry.getKey();
            String path = MountTable.normalizeFileSystemPath(entry.getValue());
            RemoteLocation location = new RemoteLocation(nsId, path);
            locations.add(location);
        }
        record.setDestinations(locations);
        record.validate();
        return record;
    }

    public abstract String getSourcePath();

    public abstract void setSourcePath(String var1);

    public abstract List<RemoteLocation> getDestinations();

    public abstract void setDestinations(List<RemoteLocation> var1);

    public abstract boolean addDestination(String var1, String var2);

    public abstract boolean isReadOnly();

    public abstract void setReadOnly(boolean var1);

    public abstract DestinationOrder getDestOrder();

    public abstract void setDestOrder(DestinationOrder var1);

    public RemoteLocation getDefaultLocation() {
        List<RemoteLocation> dests = this.getDestinations();
        if (dests == null || dests.isEmpty()) {
            return null;
        }
        return dests.get(0);
    }

    @Override
    public boolean like(BaseRecord o) {
        if (o instanceof MountTable) {
            MountTable other = (MountTable)o;
            if (this.getSourcePath() != null && !this.getSourcePath().equals(other.getSourcePath())) {
                return false;
            }
            return this.getDestinations() == null || this.getDestinations().equals(other.getDestinations());
        }
        return false;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getSourcePath());
        sb.append("->");
        List<RemoteLocation> destinations = this.getDestinations();
        sb.append(destinations);
        if (destinations != null && destinations.size() > 1) {
            sb.append("[" + (Object)((Object)this.getDestOrder()) + "]");
        }
        if (this.isReadOnly()) {
            sb.append("[RO]");
        }
        return sb.toString();
    }

    public SortedMap<String, String> getPrimaryKeys() {
        TreeMap<String, String> map = new TreeMap<String, String>();
        map.put("sourcePath", this.getSourcePath());
        return map;
    }

    @Override
    public boolean validate() {
        boolean ret = super.validate();
        if (this.getSourcePath() == null || this.getSourcePath().length() == 0) {
            LOG.error("Invalid entry, no source path specified ", (Object)this);
            ret = false;
        }
        if (!this.getSourcePath().startsWith("/")) {
            LOG.error("Invalid entry, all mount points must start with / ", (Object)this);
            ret = false;
        }
        if (this.getDestinations() == null || this.getDestinations().size() == 0) {
            LOG.error("Invalid entry, no destination paths specified ", (Object)this);
            ret = false;
        }
        for (RemoteLocation loc : this.getDestinations()) {
            String nsId = loc.getNameserviceId();
            if (nsId == null || nsId.length() == 0) {
                LOG.error("Invalid entry, invalid destination nameservice ", (Object)this);
                ret = false;
            }
            if (loc.getDest() == null || loc.getDest().length() == 0) {
                LOG.error("Invalid entry, invalid destination path ", (Object)this);
                ret = false;
            }
            if (loc.getDest().startsWith("/")) continue;
            LOG.error("Invalid entry, all destination must start with / ", (Object)this);
            ret = false;
        }
        return ret;
    }

    @Override
    public long getExpirationMs() {
        return 0L;
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder(17, 31).append((Object)this.getSourcePath()).append(this.getDestinations()).append(this.isReadOnly()).append((Object)this.getDestOrder()).toHashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof MountTable) {
            MountTable other = (MountTable)obj;
            if (!this.getSourcePath().equals(other.getSourcePath())) {
                return false;
            }
            if (!this.getDestinations().equals(other.getDestinations())) {
                return false;
            }
            if (this.isReadOnly() != other.isReadOnly()) {
                return false;
            }
            return this.getDestOrder().equals((Object)other.getDestOrder());
        }
        return false;
    }

    private static String normalizeFileSystemPath(String path) {
        Path normalizedPath = new Path(path);
        return normalizedPath.toString();
    }
}

