/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.blockmanagement;

import java.util.ArrayDeque;
import java.util.Queue;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManager;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeAdminManager;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeAdminMonitorInterface;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.namenode.Namesystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DatanodeAdminMonitorBase
implements DatanodeAdminMonitorInterface,
Configurable {
    protected BlockManager blockManager;
    protected Namesystem namesystem;
    protected DatanodeAdminManager dnAdmin;
    protected Configuration conf;
    protected final Queue<DatanodeDescriptor> pendingNodes = new ArrayDeque<DatanodeDescriptor>();
    protected int maxConcurrentTrackedNodes;
    private static final Logger LOG = LoggerFactory.getLogger(DatanodeAdminMonitorBase.class);

    @Override
    public void setNameSystem(Namesystem ns) {
        this.namesystem = ns;
    }

    @Override
    public void setBlockManager(BlockManager bm) {
        this.blockManager = bm;
    }

    @Override
    public void setDatanodeAdminManager(DatanodeAdminManager admin) {
        this.dnAdmin = admin;
    }

    public void setConf(Configuration conf) {
        this.conf = conf;
        this.maxConcurrentTrackedNodes = conf.getInt("dfs.namenode.decommission.max.concurrent.tracked.nodes", 100);
        if (this.maxConcurrentTrackedNodes < 0) {
            LOG.error("{} is set to an invalid value, it must be zero or greater. Defaulting to {}", (Object)"dfs.namenode.decommission.max.concurrent.tracked.nodes", (Object)100);
            this.maxConcurrentTrackedNodes = 100;
        }
        this.processConf();
    }

    public Configuration getConf() {
        return this.conf;
    }

    protected abstract void processConf();

    @Override
    public void startTrackingNode(DatanodeDescriptor dn) {
        this.pendingNodes.add(dn);
    }

    @Override
    public int getPendingNodeCount() {
        return this.pendingNodes.size();
    }

    @Override
    public Queue<DatanodeDescriptor> getPendingNodes() {
        return this.pendingNodes;
    }
}

