/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.balancer;

import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FsServerDefaults;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.StreamCapabilities;
import org.apache.hadoop.ha.HAServiceProtocol;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HAUtil;
import org.apache.hadoop.hdfs.NameNodeProxies;
import org.apache.hadoop.hdfs.protocol.AlreadyBeingCreatedException;
import org.apache.hadoop.hdfs.protocol.ClientProtocol;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.protocol.RollingUpgradeInfo;
import org.apache.hadoop.hdfs.server.balancer.KeyManager;
import org.apache.hadoop.hdfs.server.protocol.BalancerProtocols;
import org.apache.hadoop.hdfs.server.protocol.BlocksWithLocations;
import org.apache.hadoop.hdfs.server.protocol.DatanodeStorageReport;
import org.apache.hadoop.hdfs.server.protocol.NamenodeProtocol;
import org.apache.hadoop.hdfs.server.protocol.NamespaceInfo;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.thirdparty.com.google.common.base.Preconditions;
import org.apache.hadoop.thirdparty.com.google.common.util.concurrent.RateLimiter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class NameNodeConnector
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(NameNodeConnector.class);
    public static final int DEFAULT_MAX_IDLE_ITERATIONS = 5;
    private static boolean write2IdFile = true;
    private static boolean checkOtherInstanceRunning = true;
    private final URI nameNodeUri;
    private final String blockpoolID;
    private final BalancerProtocols namenode;
    private boolean requestToStandby;
    private String nsId;
    private Configuration config;
    private final KeyManager keyManager;
    final AtomicBoolean fallbackToSimpleAuth = new AtomicBoolean(false);
    private final DistributedFileSystem fs;
    private final Path idPath;
    private OutputStream out;
    private final List<Path> targetPaths;
    private final AtomicLong bytesMoved = new AtomicLong();
    private final AtomicLong blocksMoved = new AtomicLong();
    private final AtomicLong blocksFailed = new AtomicLong();
    private final int maxNotChangedIterations;
    private int notChangedIterations = 0;
    private final RateLimiter getBlocksRateLimiter;

    public static List<NameNodeConnector> newNameNodeConnectors(Collection<URI> namenodes, String name, Path idPath, Configuration conf, int maxIdleIterations) throws IOException {
        ArrayList<NameNodeConnector> connectors = new ArrayList<NameNodeConnector>(namenodes.size());
        for (URI uri : namenodes) {
            NameNodeConnector nnc = new NameNodeConnector(name, uri, idPath, null, conf, maxIdleIterations);
            nnc.getKeyManager().startBlockKeyUpdater();
            connectors.add(nnc);
        }
        return connectors;
    }

    public static List<NameNodeConnector> newNameNodeConnectors(Map<URI, List<Path>> namenodes, String name, Path idPath, Configuration conf, int maxIdleIterations) throws IOException {
        ArrayList<NameNodeConnector> connectors = new ArrayList<NameNodeConnector>(namenodes.size());
        for (Map.Entry<URI, List<Path>> entry : namenodes.entrySet()) {
            NameNodeConnector nnc = new NameNodeConnector(name, entry.getKey(), idPath, entry.getValue(), conf, maxIdleIterations);
            nnc.getKeyManager().startBlockKeyUpdater();
            connectors.add(nnc);
        }
        return connectors;
    }

    public static List<NameNodeConnector> newNameNodeConnectors(Collection<URI> namenodes, Collection<String> nsIds, String name, Path idPath, Configuration conf, int maxIdleIterations) throws IOException {
        ArrayList<NameNodeConnector> connectors = new ArrayList<NameNodeConnector>(namenodes.size());
        HashMap<URI, String> uriToNsId = new HashMap<URI, String>();
        if (nsIds != null) {
            for (URI uri : namenodes) {
                for (String nsId : nsIds) {
                    if (!uri.getAuthority().equals(nsId)) continue;
                    uriToNsId.put(uri, nsId);
                }
            }
        }
        for (URI uri : namenodes) {
            String nsId = (String)uriToNsId.get(uri);
            NameNodeConnector nnc = new NameNodeConnector(name, uri, nsId, idPath, null, conf, maxIdleIterations);
            nnc.getKeyManager().startBlockKeyUpdater();
            connectors.add(nnc);
        }
        return connectors;
    }

    @VisibleForTesting
    public static void setWrite2IdFile(boolean write2IdFile) {
        NameNodeConnector.write2IdFile = write2IdFile;
    }

    @VisibleForTesting
    public static void checkOtherInstanceRunning(boolean toCheck) {
        checkOtherInstanceRunning = toCheck;
    }

    public NameNodeConnector(String name, URI nameNodeUri, Path idPath, List<Path> targetPaths, Configuration conf, int maxNotChangedIterations) throws IOException {
        this.nameNodeUri = nameNodeUri;
        this.idPath = idPath;
        this.targetPaths = targetPaths == null || targetPaths.isEmpty() ? Arrays.asList(new Path("/")) : targetPaths;
        this.maxNotChangedIterations = maxNotChangedIterations;
        int getBlocksMaxQps = conf.getInt("dfs.namenode.get-blocks.max-qps", 20);
        if (getBlocksMaxQps > 0) {
            LOG.info("getBlocks calls for {} will be rate-limited to {} per second", (Object)nameNodeUri, (Object)getBlocksMaxQps);
            this.getBlocksRateLimiter = RateLimiter.create((double)getBlocksMaxQps);
        } else {
            this.getBlocksRateLimiter = null;
        }
        this.namenode = (BalancerProtocols)NameNodeProxies.createProxy(conf, nameNodeUri, BalancerProtocols.class, this.fallbackToSimpleAuth).getProxy();
        this.requestToStandby = conf.getBoolean("dfs.ha.allow.stale.reads", false);
        this.config = conf;
        this.fs = (DistributedFileSystem)FileSystem.get((URI)nameNodeUri, (Configuration)conf);
        NamespaceInfo namespaceinfo = this.namenode.versionRequest();
        this.blockpoolID = namespaceinfo.getBlockPoolID();
        FsServerDefaults defaults = this.fs.getServerDefaults(new Path("/"));
        this.keyManager = new KeyManager(this.blockpoolID, this.namenode, defaults.getEncryptDataTransfer(), conf);
        if (checkOtherInstanceRunning) {
            this.out = this.checkAndMarkRunning();
            if (this.out == null) {
                throw new IOException("Another " + name + " is running.");
            }
        }
    }

    public NameNodeConnector(String name, URI nameNodeUri, String nsId, Path idPath, List<Path> targetPaths, Configuration conf, int maxNotChangedIterations) throws IOException {
        this(name, nameNodeUri, idPath, targetPaths, conf, maxNotChangedIterations);
        this.nsId = nsId;
    }

    public DistributedFileSystem getDistributedFileSystem() {
        return this.fs;
    }

    public String getBlockpoolID() {
        return this.blockpoolID;
    }

    public AtomicLong getBytesMoved() {
        return this.bytesMoved;
    }

    public AtomicLong getBlocksMoved() {
        return this.blocksMoved;
    }

    public AtomicLong getBlocksFailed() {
        return this.blocksFailed;
    }

    public void addBytesMoved(long numBytes) {
        this.bytesMoved.addAndGet(numBytes);
        this.blocksMoved.incrementAndGet();
    }

    public URI getNameNodeUri() {
        return this.nameNodeUri;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BlocksWithLocations getBlocks(DatanodeInfo datanode, long size, long minBlockSize, long timeInterval) throws IOException {
        if (this.getBlocksRateLimiter != null) {
            this.getBlocksRateLimiter.acquire();
        }
        boolean isRequestStandby = false;
        NamenodeProtocol nnProxy = null;
        try {
            ProxyPair proxyPair = this.getProxy();
            isRequestStandby = proxyPair.isRequestStandby;
            ClientProtocol proxy = proxyPair.clientProtocol;
            nnProxy = isRequestStandby ? (NamenodeProtocol)NameNodeProxies.createNonHAProxy(this.config, RPC.getServerAddress((Object)proxy), NamenodeProtocol.class, UserGroupInformation.getCurrentUser(), false).getProxy() : this.namenode;
            BlocksWithLocations blocksWithLocations = nnProxy.getBlocks(datanode, size, minBlockSize, timeInterval);
            return blocksWithLocations;
        }
        finally {
            if (isRequestStandby) {
                LOG.info("Request #getBlocks to Standby NameNode success.");
            }
        }
    }

    public boolean isUpgrading() throws IOException {
        boolean isUpgrade = !this.namenode.isUpgradeFinalized();
        RollingUpgradeInfo info = this.fs.rollingUpgrade(HdfsConstants.RollingUpgradeAction.QUERY);
        boolean isRollingUpgrade = info != null && !info.isFinalized();
        return isUpgrade || isRollingUpgrade;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DatanodeStorageReport[] getLiveDatanodeStorageReport() throws IOException {
        boolean isRequestStandby = false;
        try {
            ProxyPair proxyPair = this.getProxy();
            isRequestStandby = proxyPair.isRequestStandby;
            ClientProtocol proxy = proxyPair.clientProtocol;
            DatanodeStorageReport[] datanodeStorageReportArray = proxy.getDatanodeStorageReport(HdfsConstants.DatanodeReportType.LIVE);
            return datanodeStorageReportArray;
        }
        finally {
            if (isRequestStandby) {
                LOG.info("Request #getLiveDatanodeStorageReport to Standby NameNode success.");
            }
        }
    }

    private ProxyPair getProxy() throws IOException {
        boolean isRequestStandby = false;
        BalancerProtocols clientProtocol = null;
        if (this.requestToStandby && this.nsId != null && HAUtil.isHAEnabled(this.config, this.nsId)) {
            List<ClientProtocol> namenodes = HAUtil.getProxiesForAllNameNodesInNameservice(this.config, this.nsId);
            for (ClientProtocol proxy : namenodes) {
                try {
                    if (!proxy.getHAServiceState().equals((Object)HAServiceProtocol.HAServiceState.STANDBY)) continue;
                    clientProtocol = proxy;
                    isRequestStandby = true;
                    break;
                }
                catch (Exception e) {
                    LOG.debug("Error while connecting to namenode", (Throwable)e);
                }
            }
            if (clientProtocol == null) {
                LOG.warn("Request to Standby NameNode but meet exception, will fallback to normal way.");
                clientProtocol = this.namenode;
            }
        } else {
            clientProtocol = this.namenode;
        }
        return new ProxyPair(clientProtocol, isRequestStandby);
    }

    public KeyManager getKeyManager() {
        return this.keyManager;
    }

    public List<Path> getTargetPaths() {
        return this.targetPaths;
    }

    public boolean shouldContinue(long dispatchBlockMoveBytes) {
        if (dispatchBlockMoveBytes > 0L) {
            this.notChangedIterations = 0;
        } else {
            ++this.notChangedIterations;
            if (LOG.isDebugEnabled()) {
                LOG.debug("No block has been moved for " + this.notChangedIterations + " iterations, maximum notChangedIterations before exit is: " + (this.maxNotChangedIterations >= 0 ? Integer.valueOf(this.maxNotChangedIterations) : "Infinite"));
            }
            if (this.maxNotChangedIterations >= 0 && this.notChangedIterations >= this.maxNotChangedIterations) {
                System.out.println("No block has been moved for " + this.notChangedIterations + " iterations. Exiting...");
                return false;
            }
        }
        return true;
    }

    private OutputStream checkAndMarkRunning() throws IOException {
        try {
            FSDataOutputStream fsout;
            if (this.fs.exists(this.idPath)) {
                IOUtils.closeStream((Closeable)this.fs.append(this.idPath));
                this.fs.delete(this.idPath, true);
            }
            Preconditions.checkState(((fsout = ((DistributedFileSystem.HdfsDataOutputStreamBuilder)this.fs.createFile(this.idPath).replicate().recursive()).build()).hasCapability(StreamCapabilities.StreamCapability.HFLUSH.getValue()) && fsout.hasCapability(StreamCapabilities.StreamCapability.HSYNC.getValue()) ? 1 : 0) != 0, (Object)"Id lock file should support hflush and hsync");
            this.fs.deleteOnExit(this.idPath);
            if (write2IdFile) {
                fsout.writeBytes(InetAddress.getLocalHost().getHostName());
                fsout.hflush();
            }
            return fsout;
        }
        catch (RemoteException e) {
            if (AlreadyBeingCreatedException.class.getName().equals(e.getClassName())) {
                return null;
            }
            throw e;
        }
    }

    public AtomicBoolean getFallbackToSimpleAuth() {
        return this.fallbackToSimpleAuth;
    }

    @Override
    public void close() {
        this.keyManager.close();
        IOUtils.closeStream((Closeable)this.out);
        if (this.fs != null) {
            try {
                if (checkOtherInstanceRunning) {
                    this.fs.delete(this.idPath, true);
                }
            }
            catch (IOException ioe) {
                LOG.warn("Failed to delete " + this.idPath, (Throwable)ioe);
            }
        }
    }

    public NamenodeProtocol getNNProtocolConnection() {
        return this.namenode;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[namenodeUri=" + this.nameNodeUri + ", bpid=" + this.blockpoolID + "]";
    }

    private static class ProxyPair {
        private final ClientProtocol clientProtocol;
        private final boolean isRequestStandby;

        ProxyPair(ClientProtocol clientProtocol, boolean isRequestStandby) {
            this.clientProtocol = clientProtocol;
            this.isRequestStandby = isRequestStandby;
        }
    }
}

