/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.blockmanagement;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import javax.management.ObjectName;
import org.apache.hadoop.HadoopIllegalArgumentException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileEncryptionInfo;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.hdfs.AddBlockFlag;
import org.apache.hadoop.hdfs.DFSConfigKeys;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.DFSUtilClient;
import org.apache.hadoop.hdfs.HAUtil;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.BlockListAsLongs;
import org.apache.hadoop.hdfs.protocol.BlockStoragePolicy;
import org.apache.hadoop.hdfs.protocol.BlockType;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.ErasureCodingPolicy;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;
import org.apache.hadoop.hdfs.protocol.LocatedStripedBlock;
import org.apache.hadoop.hdfs.protocol.UnregisteredNodeException;
import org.apache.hadoop.hdfs.security.token.block.BlockTokenIdentifier;
import org.apache.hadoop.hdfs.security.token.block.BlockTokenSecretManager;
import org.apache.hadoop.hdfs.security.token.block.DataEncryptionKey;
import org.apache.hadoop.hdfs.security.token.block.ExportedBlockKeys;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockCollection;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockIdManager;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfo;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfoContiguous;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfoStriped;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManagerFaultInjector;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManagerSafeMode;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockPlacementPolicies;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockPlacementPolicy;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockPlacementStatus;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockReconstructionWork;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockReportLeaseManager;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockStatsMXBean;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockStoragePolicySuite;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockToMarkCorrupt;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockUnderConstructionFeature;
import org.apache.hadoop.hdfs.server.blockmanagement.BlocksMap;
import org.apache.hadoop.hdfs.server.blockmanagement.CorruptReplicasMap;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeManager;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeStorageInfo;
import org.apache.hadoop.hdfs.server.blockmanagement.ErasureCodingWork;
import org.apache.hadoop.hdfs.server.blockmanagement.ExcessRedundancyMap;
import org.apache.hadoop.hdfs.server.blockmanagement.HeartbeatManager;
import org.apache.hadoop.hdfs.server.blockmanagement.InvalidateBlocks;
import org.apache.hadoop.hdfs.server.blockmanagement.LocatedBlockBuilder;
import org.apache.hadoop.hdfs.server.blockmanagement.LowRedundancyBlocks;
import org.apache.hadoop.hdfs.server.blockmanagement.NumberReplicas;
import org.apache.hadoop.hdfs.server.blockmanagement.PendingDataNodeMessages;
import org.apache.hadoop.hdfs.server.blockmanagement.PendingReconstructionBlocks;
import org.apache.hadoop.hdfs.server.blockmanagement.PendingRecoveryBlocks;
import org.apache.hadoop.hdfs.server.blockmanagement.ProvidedStorageMap;
import org.apache.hadoop.hdfs.server.blockmanagement.ReplicaUnderConstruction;
import org.apache.hadoop.hdfs.server.blockmanagement.ReplicationWork;
import org.apache.hadoop.hdfs.server.blockmanagement.StorageTypeStats;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.namenode.CacheManager;
import org.apache.hadoop.hdfs.server.namenode.CachedBlock;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.hadoop.hdfs.server.namenode.INodeFile;
import org.apache.hadoop.hdfs.server.namenode.INodesInPath;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.Namesystem;
import org.apache.hadoop.hdfs.server.namenode.ha.HAContext;
import org.apache.hadoop.hdfs.server.namenode.metrics.NameNodeMetrics;
import org.apache.hadoop.hdfs.server.namenode.sps.StoragePolicySatisfyManager;
import org.apache.hadoop.hdfs.server.protocol.BlockReportContext;
import org.apache.hadoop.hdfs.server.protocol.BlocksWithLocations;
import org.apache.hadoop.hdfs.server.protocol.DatanodeCommand;
import org.apache.hadoop.hdfs.server.protocol.DatanodeRegistration;
import org.apache.hadoop.hdfs.server.protocol.DatanodeStorage;
import org.apache.hadoop.hdfs.server.protocol.KeyUpdateCommand;
import org.apache.hadoop.hdfs.server.protocol.ReceivedDeletedBlockInfo;
import org.apache.hadoop.hdfs.server.protocol.StorageReceivedDeletedBlocks;
import org.apache.hadoop.hdfs.server.protocol.StorageReport;
import org.apache.hadoop.hdfs.server.protocol.VolumeFailureSummary;
import org.apache.hadoop.hdfs.util.StripedBlockUtil;
import org.apache.hadoop.metrics2.util.MBeans;
import org.apache.hadoop.net.Node;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.thirdparty.com.google.common.base.Preconditions;
import org.apache.hadoop.util.Daemon;
import org.apache.hadoop.util.ExitUtil;
import org.apache.hadoop.util.LightWeightGSet;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.util.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class BlockManager
implements BlockStatsMXBean {
    public static final Logger LOG = LoggerFactory.getLogger(BlockManager.class);
    public static final Logger blockLog = NameNode.blockStateChangeLog;
    private static final String QUEUE_REASON_CORRUPT_STATE = "it has the wrong state or generation stamp";
    private static final String QUEUE_REASON_FUTURE_GENSTAMP = "generation stamp is in the future";
    private static final long BLOCK_RECOVERY_TIMEOUT_MULTIPLIER = 30L;
    private final Namesystem namesystem;
    private final BlockManagerSafeMode bmSafeMode;
    private final DatanodeManager datanodeManager;
    private final HeartbeatManager heartbeatManager;
    private final BlockTokenSecretManager blockTokenSecretManager;
    private String blockPoolId;
    private final PendingDataNodeMessages pendingDNMessages = new PendingDataNodeMessages();
    private volatile long pendingReconstructionBlocksCount = 0L;
    private volatile long corruptReplicaBlocksCount = 0L;
    private volatile long lowRedundancyBlocksCount = 0L;
    private volatile long scheduledReplicationBlocksCount = 0L;
    private boolean initializedReplQueues;
    private final long startupDelayBlockDeletionInMs;
    private final BlockReportLeaseManager blockReportLeaseManager;
    private ObjectName mxBeanName;
    private final long redundancyRecheckIntervalMs;
    private int replQueueResetToHeadThreshold;
    private int replQueueCallsSinceReset = 0;
    final BlocksMap blocksMap;
    private final Daemon redundancyThread = new Daemon((Runnable)new RedundancyMonitor());
    private final AtomicLong lastRedundancyCycleTS = new AtomicLong(-1L);
    private final BlockReportProcessingThread blockReportThread;
    final CorruptReplicasMap corruptReplicas = new CorruptReplicasMap();
    private final InvalidateBlocks invalidateBlocks;
    private final Set<Block> postponedMisreplicatedBlocks = new LinkedHashSet<Block>();
    private final int blocksPerPostpondedRescan;
    private final ArrayList<Block> rescannedMisreplicatedBlocks;
    private final ExcessRedundancyMap excessRedundancyMap = new ExcessRedundancyMap();
    public final LowRedundancyBlocks neededReconstruction = new LowRedundancyBlocks();
    @VisibleForTesting
    final PendingReconstructionBlocks pendingReconstruction;
    private final PendingRecoveryBlocks pendingRecoveryBlocks;
    public final short maxReplication;
    int maxReplicationStreams;
    int replicationStreamsHardLimit;
    public final short minReplication;
    public final int defaultReplication;
    final int maxCorruptFilesReturned;
    final float blocksInvalidateWorkPct;
    private int blocksReplWorkMultiplier;
    final boolean encryptDataTransfer;
    private final long maxNumBlocksToLog;
    private final long maxLockHoldTime;
    private boolean shouldPostponeBlocksFromFuture = false;
    private Daemon reconstructionQueuesInitializer = null;
    private int numBlocksPerIteration;
    private double reconstructionQueuesInitProgress = 0.0;
    private volatile BlockPlacementPolicies placementPolicies;
    private final BlockStoragePolicySuite storagePolicySuite;
    private boolean checkNSRunning = true;
    private boolean hasNonEcBlockUsingStripedID = false;
    private final BlockIdManager blockIdManager;
    private StoragePolicySatisfyManager spsManager;
    private final short minReplicationToBeInMaintenance;
    private final boolean deleteCorruptReplicaImmediately;
    private final ProvidedStorageMap providedStorageMap;

    public long getPendingReconstructionBlocksCount() {
        return this.pendingReconstructionBlocksCount;
    }

    public long getLowRedundancyBlocksCount() {
        return this.lowRedundancyBlocksCount;
    }

    public long getCorruptReplicaBlocksCount() {
        return this.corruptReplicaBlocksCount;
    }

    public long getScheduledReplicationBlocksCount() {
        return this.scheduledReplicationBlocksCount;
    }

    public long getPendingDeletionBlocksCount() {
        return this.invalidateBlocks.numBlocks();
    }

    public long getStartupDelayBlockDeletionInMs() {
        return this.startupDelayBlockDeletionInMs;
    }

    public long getExcessBlocksCount() {
        return this.excessRedundancyMap.size();
    }

    public long getPostponedMisreplicatedBlocksCount() {
        return this.postponedMisreplicatedBlocks.size();
    }

    public int getPendingDataNodeMessageCount() {
        return this.pendingDNMessages.count();
    }

    public long getNumTimedOutPendingReconstructions() {
        return this.pendingReconstruction.getNumTimedOuts();
    }

    public long getLowRedundancyBlocks() {
        return this.neededReconstruction.getLowRedundancyBlocks();
    }

    public long getCorruptBlocks() {
        return this.corruptReplicas.getCorruptBlocks();
    }

    public long getMissingBlocks() {
        return this.neededReconstruction.getCorruptBlocks();
    }

    public long getMissingReplicationOneBlocks() {
        return this.neededReconstruction.getCorruptReplicationOneBlocks();
    }

    public long getPendingDeletionReplicatedBlocks() {
        return this.invalidateBlocks.getBlocks();
    }

    public long getTotalReplicatedBlocks() {
        return this.blocksMap.getReplicatedBlocks();
    }

    public long getLowRedundancyECBlockGroups() {
        return this.neededReconstruction.getLowRedundancyECBlockGroups();
    }

    public long getCorruptECBlockGroups() {
        return this.corruptReplicas.getCorruptECBlockGroups();
    }

    public long getMissingECBlockGroups() {
        return this.neededReconstruction.getCorruptECBlockGroups();
    }

    public long getPendingDeletionECBlocks() {
        return this.invalidateBlocks.getECBlocks();
    }

    public long getTotalECBlockGroups() {
        return this.blocksMap.getECBlockGroups();
    }

    public BlockManager(Namesystem namesystem, boolean haEnabled, Configuration conf) throws IOException {
        this.namesystem = namesystem;
        this.datanodeManager = new DatanodeManager(this, namesystem, conf);
        this.heartbeatManager = this.datanodeManager.getHeartbeatManager();
        this.blockIdManager = new BlockIdManager(this);
        this.blocksPerPostpondedRescan = (int)Math.min(Integer.MAX_VALUE, this.datanodeManager.getBlocksPerPostponedMisreplicatedBlocksRescan());
        this.rescannedMisreplicatedBlocks = new ArrayList(this.blocksPerPostpondedRescan);
        this.startupDelayBlockDeletionInMs = conf.getLong("dfs.namenode.startup.delay.block.deletion.sec", 0L) * 1000L;
        this.invalidateBlocks = new InvalidateBlocks(this.datanodeManager.getBlockInvalidateLimit(), this.startupDelayBlockDeletionInMs, this.blockIdManager);
        this.blocksMap = new BlocksMap(LightWeightGSet.computeCapacity((double)2.0, (String)"BlocksMap"));
        this.placementPolicies = new BlockPlacementPolicies(conf, this.datanodeManager.getFSClusterStats(), this.datanodeManager.getNetworkTopology(), this.datanodeManager.getHost2DatanodeMap());
        this.storagePolicySuite = BlockStoragePolicySuite.createDefaultSuite(conf);
        this.pendingReconstruction = new PendingReconstructionBlocks((long)conf.getInt("dfs.namenode.reconstruction.pending.timeout-sec", 300) * 1000L);
        this.createSPSManager(conf);
        this.blockTokenSecretManager = BlockManager.createBlockTokenSecretManager(conf);
        this.providedStorageMap = new ProvidedStorageMap(namesystem, this, conf);
        this.maxCorruptFilesReturned = conf.getInt("dfs.corruptfilesreturned.max", 500);
        this.defaultReplication = conf.getInt("dfs.replication", 3);
        int maxR = conf.getInt("dfs.replication.max", 512);
        int minR = conf.getInt("dfs.namenode.replication.min", 1);
        if (minR <= 0) {
            throw new IOException("Unexpected configuration parameters: dfs.namenode.replication.min = " + minR + " <= 0");
        }
        if (maxR > Short.MAX_VALUE) {
            throw new IOException("Unexpected configuration parameters: dfs.replication.max = " + maxR + " > " + Short.MAX_VALUE);
        }
        if (minR > maxR) {
            throw new IOException("Unexpected configuration parameters: dfs.namenode.replication.min = " + minR + " > " + "dfs.replication.max" + " = " + maxR);
        }
        this.minReplication = (short)minR;
        this.maxReplication = (short)maxR;
        this.maxReplicationStreams = conf.getInt("dfs.namenode.replication.max-streams", 2);
        this.replicationStreamsHardLimit = conf.getInt("dfs.namenode.replication.max-streams-hard-limit", 4);
        this.blocksInvalidateWorkPct = DFSUtil.getInvalidateWorkPctPerIteration(conf);
        this.blocksReplWorkMultiplier = DFSUtil.getReplWorkMultiplier(conf);
        this.redundancyRecheckIntervalMs = conf.getTimeDuration("dfs.namenode.redundancy.interval.seconds", 3L, TimeUnit.SECONDS, TimeUnit.MILLISECONDS);
        this.encryptDataTransfer = conf.getBoolean("dfs.encrypt.data.transfer", false);
        this.maxNumBlocksToLog = conf.getLong("dfs.namenode.max-num-blocks-to-log", 1000L);
        this.maxLockHoldTime = conf.getTimeDuration("dfs.namenode.blockreport.max.lock.hold.time", 4L, TimeUnit.MILLISECONDS);
        this.numBlocksPerIteration = conf.getInt("dfs.block.misreplication.processing.limit", 10000);
        int minMaintenanceR = conf.getInt("dfs.namenode.maintenance.replication.min", 1);
        if (minMaintenanceR < 0) {
            throw new IOException("Unexpected configuration parameters: dfs.namenode.maintenance.replication.min = " + minMaintenanceR + " < 0");
        }
        if (minMaintenanceR > this.defaultReplication) {
            throw new IOException("Unexpected configuration parameters: dfs.namenode.maintenance.replication.min = " + minMaintenanceR + " > " + "dfs.replication" + " = " + this.defaultReplication);
        }
        this.minReplicationToBeInMaintenance = (short)minMaintenanceR;
        this.replQueueResetToHeadThreshold = conf.getInt("dfs.namenode.redundancy.queue.restart.iterations", 2400);
        if (this.replQueueResetToHeadThreshold < 0) {
            LOG.warn("{} is set to {} and it must be >= 0. Resetting to default {}", new Object[]{"dfs.namenode.redundancy.queue.restart.iterations", this.replQueueResetToHeadThreshold, 2400});
            this.replQueueResetToHeadThreshold = 2400;
        }
        long heartbeatIntervalSecs = conf.getTimeDuration("dfs.heartbeat.interval", 3L, TimeUnit.SECONDS);
        long blockRecoveryTimeout = BlockManager.getBlockRecoveryTimeout(heartbeatIntervalSecs);
        this.pendingRecoveryBlocks = new PendingRecoveryBlocks(blockRecoveryTimeout);
        this.blockReportLeaseManager = new BlockReportLeaseManager(conf);
        this.bmSafeMode = new BlockManagerSafeMode(this, namesystem, haEnabled, conf);
        int queueSize = conf.getInt("dfs.namenode.blockreport.queue.size", 1024);
        this.blockReportThread = new BlockReportProcessingThread(queueSize);
        this.deleteCorruptReplicaImmediately = conf.getBoolean("dfs.namenode.corrupt.block.delete.immediately.enabled", true);
        LOG.info("defaultReplication         = {}", (Object)this.defaultReplication);
        LOG.info("maxReplication             = {}", (Object)this.maxReplication);
        LOG.info("minReplication             = {}", (Object)this.minReplication);
        LOG.info("maxReplicationStreams      = {}", (Object)this.maxReplicationStreams);
        LOG.info("redundancyRecheckInterval  = {}ms", (Object)this.redundancyRecheckIntervalMs);
        LOG.info("encryptDataTransfer        = {}", (Object)this.encryptDataTransfer);
        LOG.info("maxNumBlocksToLog          = {}", (Object)this.maxNumBlocksToLog);
    }

    private static BlockTokenSecretManager createBlockTokenSecretManager(Configuration conf) throws IOException {
        boolean isEnabled = conf.getBoolean("dfs.block.access.token.enable", false);
        LOG.info("{} = {}", (Object)"dfs.block.access.token.enable", (Object)isEnabled);
        if (!isEnabled) {
            if (UserGroupInformation.isSecurityEnabled()) {
                String errMessage = "Security is enabled but block access tokens (via dfs.block.access.token.enable) aren't enabled. This may cause issues when clients attempt to connect to a DataNode. Aborting NameNode";
                throw new IOException(errMessage);
            }
            return null;
        }
        long updateMin = conf.getLong("dfs.block.access.key.update.interval", 600L);
        long lifetimeMin = conf.getLong("dfs.block.access.token.lifetime", 600L);
        String encryptionAlgorithm = conf.get("dfs.encrypt.data.transfer.algorithm");
        LOG.info("{}={} min(s), {}={} min(s), {}={}", new Object[]{"dfs.block.access.key.update.interval", updateMin, "dfs.block.access.token.lifetime", lifetimeMin, "dfs.encrypt.data.transfer.algorithm", encryptionAlgorithm});
        String nsId = DFSUtil.getNamenodeNameServiceId(conf);
        boolean isHaEnabled = HAUtil.isHAEnabled(conf, nsId);
        boolean shouldWriteProtobufToken = conf.getBoolean("dfs.block.access.token.protobuf.enable", false);
        boolean shouldWrapQOP = conf.getBoolean("dfs.namenode.send.qop.enabled", false);
        if (isHaEnabled) {
            String id;
            Collection nnIds = DFSUtilClient.getNameNodeIds((Configuration)conf, (String)nsId);
            String nnId = HAUtil.getNameNodeId(conf, nsId);
            int nnIndex = 0;
            Iterator iterator = nnIds.iterator();
            while (iterator.hasNext() && !(id = (String)iterator.next()).equals(nnId)) {
                ++nnIndex;
            }
            return new BlockTokenSecretManager(updateMin * 60L * 1000L, lifetimeMin * 60L * 1000L, nnIndex, nnIds.size(), null, encryptionAlgorithm, shouldWriteProtobufToken, shouldWrapQOP);
        }
        return new BlockTokenSecretManager(updateMin * 60L * 1000L, lifetimeMin * 60L * 1000L, 0, 1, null, encryptionAlgorithm, shouldWriteProtobufToken, shouldWrapQOP);
    }

    public BlockStoragePolicy getStoragePolicy(String policyName) {
        return this.storagePolicySuite.getPolicy(policyName);
    }

    public BlockStoragePolicy getStoragePolicy(byte policyId) {
        return this.storagePolicySuite.getPolicy(policyId);
    }

    public BlockStoragePolicy[] getStoragePolicies() {
        return this.storagePolicySuite.getAllPolicies();
    }

    public void setBlockPoolId(String blockPoolId) {
        this.blockPoolId = blockPoolId;
        if (this.isBlockTokenEnabled()) {
            this.blockTokenSecretManager.setBlockPoolId(blockPoolId);
        }
    }

    public String getBlockPoolId() {
        return this.blockPoolId;
    }

    public BlockStoragePolicySuite getStoragePolicySuite() {
        return this.storagePolicySuite;
    }

    @VisibleForTesting
    public BlockTokenSecretManager getBlockTokenSecretManager() {
        return this.blockTokenSecretManager;
    }

    @VisibleForTesting
    void enableRMTerminationForTesting() {
        this.checkNSRunning = false;
    }

    private boolean isBlockTokenEnabled() {
        return this.blockTokenSecretManager != null;
    }

    boolean shouldUpdateBlockKey(long updateTime) throws IOException {
        return this.isBlockTokenEnabled() && this.blockTokenSecretManager.updateKeys(updateTime);
    }

    public void activate(Configuration conf, long blockTotal) {
        this.pendingReconstruction.start();
        this.datanodeManager.activate(conf);
        this.redundancyThread.setName("RedundancyMonitor");
        this.redundancyThread.start();
        this.blockReportThread.start();
        this.mxBeanName = MBeans.register((String)"NameNode", (String)"BlockStats", (Object)this);
        this.bmSafeMode.activate(blockTotal);
    }

    public void close() {
        if (this.getSPSManager() != null) {
            this.getSPSManager().stop();
        }
        this.bmSafeMode.close();
        try {
            this.redundancyThread.interrupt();
            this.blockReportThread.interrupt();
            this.redundancyThread.join(3000L);
            this.blockReportThread.join(3000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.datanodeManager.close();
        this.pendingReconstruction.stop();
        this.blocksMap.close();
    }

    public DatanodeManager getDatanodeManager() {
        return this.datanodeManager;
    }

    @VisibleForTesting
    public BlockPlacementPolicy getBlockPlacementPolicy() {
        return this.placementPolicies.getPolicy(BlockType.CONTIGUOUS);
    }

    public void refreshBlockPlacementPolicy(Configuration conf) {
        BlockPlacementPolicies bpp;
        this.placementPolicies = bpp = new BlockPlacementPolicies(conf, this.datanodeManager.getFSClusterStats(), this.datanodeManager.getNetworkTopology(), this.datanodeManager.getHost2DatanodeMap());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void metaSave(PrintWriter out) {
        assert (this.namesystem.hasReadLock());
        ArrayList<DatanodeDescriptor> live = new ArrayList<DatanodeDescriptor>();
        ArrayList<DatanodeDescriptor> dead = new ArrayList<DatanodeDescriptor>();
        this.datanodeManager.fetchDatanodes(live, dead, false);
        out.println("Live Datanodes: " + live.size());
        out.println("Dead Datanodes: " + dead.size());
        LowRedundancyBlocks lowRedundancyBlocks = this.neededReconstruction;
        synchronized (lowRedundancyBlocks) {
            out.println("Metasave: Blocks waiting for reconstruction: " + this.neededReconstruction.getLowRedundancyBlockCount());
            int i = 0;
            while (true) {
                if (i >= 5) break;
                if (i != 4) {
                    Iterator<BlockInfo> it = this.neededReconstruction.iterator(i);
                    while (it.hasNext()) {
                        Block block = it.next();
                        this.dumpBlockMeta(block, out);
                    }
                }
                ++i;
            }
            out.println("Metasave: Blocks currently missing: " + this.neededReconstruction.getCorruptBlockSize());
            Iterator<BlockInfo> it = this.neededReconstruction.iterator(4);
            while (it.hasNext()) {
                Block block = it.next();
                this.dumpBlockMeta(block, out);
            }
        }
        out.println("Mis-replicated blocks that have been postponed:");
        for (Block block : this.postponedMisreplicatedBlocks) {
            this.dumpBlockMeta(block, out);
        }
        this.pendingReconstruction.metaSave(out);
        this.invalidateBlocks.dump(out);
        Set<Block> corruptBlocks = this.corruptReplicas.getCorruptBlocksSet();
        out.println("Corrupt Blocks:");
        for (Block block : corruptBlocks) {
            Collection<DatanodeDescriptor> corruptNodes = this.corruptReplicas.getNodes(block);
            if (corruptNodes == null) {
                LOG.warn("{} is corrupt but has no associated node.", (Object)block.getBlockId());
                continue;
            }
            int numNodesToFind = corruptNodes.size();
            for (DatanodeStorageInfo storage : this.blocksMap.getStorages(block)) {
                DatanodeDescriptor node = storage.getDatanodeDescriptor();
                if (!corruptNodes.contains((Object)node)) continue;
                String storageId = storage.getStorageID();
                DatanodeStorageInfo storageInfo = node.getStorageInfo(storageId);
                DatanodeStorage.State state = storageInfo == null ? null : storageInfo.getState();
                out.println("Block=" + block.toString() + "\tSize=" + block.getNumBytes() + "\tNode=" + node.getName() + "\tStorageID=" + storageId + "\tStorageState=" + state + "\tTotalReplicas=" + this.blocksMap.numNodes(block) + "\tReason=" + this.corruptReplicas.getCorruptReason(block, node));
                if (--numNodesToFind != 0) continue;
                break;
            }
            if (numNodesToFind <= 0) continue;
            String[] corruptNodesList = new String[corruptNodes.size()];
            int i = 0;
            for (DatanodeDescriptor d : corruptNodes) {
                corruptNodesList[i] = d.getHostName();
                ++i;
            }
            out.println(block.getBlockId() + " corrupt on " + StringUtils.join((CharSequence)",", (String[])corruptNodesList) + " but not all nodes arefound in its block locations");
        }
        this.getDatanodeManager().datanodeDump(out);
    }

    private void dumpBlockMeta(Block block, PrintWriter out) {
        ArrayList<DatanodeDescriptor> containingNodes = new ArrayList<DatanodeDescriptor>();
        ArrayList<DatanodeStorageInfo> containingLiveReplicasNodes = new ArrayList<DatanodeStorageInfo>();
        NumberReplicas numReplicas = new NumberReplicas();
        BlockInfo blockInfo = this.getStoredBlock(block);
        if (blockInfo == null) {
            out.println("Block " + block + " is Null");
            return;
        }
        this.chooseSourceDatanodes(blockInfo, containingNodes, containingLiveReplicasNodes, numReplicas, new ArrayList<Byte>(), new ArrayList<Byte>(), 5);
        assert (containingLiveReplicasNodes.size() >= numReplicas.liveReplicas());
        int usableReplicas = numReplicas.liveReplicas() + numReplicas.decommissionedAndDecommissioning();
        if (block instanceof BlockInfo) {
            BlockCollection bc = this.getBlockCollection((BlockInfo)block);
            String fileName = bc == null ? "[orphaned]" : bc.getName();
            out.print(fileName + ": ");
        }
        out.print(block + (usableReplicas > 0 ? "" : " MISSING") + " (replicas: live: " + numReplicas.liveReplicas() + " decommissioning and decommissioned: " + numReplicas.decommissionedAndDecommissioning() + " corrupt: " + numReplicas.corruptReplicas() + " in excess: " + numReplicas.excessReplicas() + " maintenance mode: " + numReplicas.maintenanceReplicas() + ") ");
        Collection<DatanodeDescriptor> corruptNodes = this.corruptReplicas.getNodes(block);
        for (DatanodeStorageInfo storage : this.blocksMap.getStorages(block)) {
            DatanodeDescriptor node = storage.getDatanodeDescriptor();
            String state = "";
            if (corruptNodes != null && corruptNodes.contains((Object)node)) {
                state = "(corrupt)";
            } else if (node.isDecommissioned() || node.isDecommissionInProgress()) {
                state = "(decommissioned)";
            } else if (node.isMaintenance() || node.isInMaintenance()) {
                state = "(maintenance)";
            }
            if (storage.areBlockContentsStale()) {
                state = state + " (block deletions maybe out of date)";
            }
            out.print(" " + (Object)((Object)node) + state + " : ");
        }
        out.println("");
    }

    public int getMaxReplicationStreams() {
        return this.maxReplicationStreams;
    }

    private static void ensurePositiveInt(int val, String key) {
        Preconditions.checkArgument((val > 0 ? 1 : 0) != 0, (Object)(key + " = '" + val + "' is invalid. It should be a positive, non-zero integer value."));
    }

    public void setMaxReplicationStreams(int newVal) {
        BlockManager.ensurePositiveInt(newVal, "dfs.namenode.replication.max-streams");
        this.maxReplicationStreams = newVal;
    }

    public int getReplicationStreamsHardLimit() {
        return this.replicationStreamsHardLimit;
    }

    public void setReplicationStreamsHardLimit(int newVal) {
        BlockManager.ensurePositiveInt(newVal, "dfs.namenode.replication.max-streams-hard-limit");
        this.replicationStreamsHardLimit = newVal;
    }

    public int getBlocksReplWorkMultiplier() {
        return this.blocksReplWorkMultiplier;
    }

    public void setBlocksReplWorkMultiplier(int newVal) {
        BlockManager.ensurePositiveInt(newVal, "dfs.namenode.replication.work.multiplier.per.iteration");
        this.blocksReplWorkMultiplier = newVal;
    }

    public int getDefaultStorageNum(BlockInfo block) {
        switch (block.getBlockType()) {
            case STRIPED: {
                return ((BlockInfoStriped)block).getRealTotalBlockNum();
            }
            case CONTIGUOUS: {
                return this.defaultReplication;
            }
        }
        throw new IllegalArgumentException("getDefaultStorageNum called with unknown BlockType: " + block.getBlockType());
    }

    public short getMinReplication() {
        return this.minReplication;
    }

    public short getMinStorageNum(BlockInfo block) {
        switch (block.getBlockType()) {
            case STRIPED: {
                return ((BlockInfoStriped)block).getRealDataBlockNum();
            }
            case CONTIGUOUS: {
                return this.minReplication;
            }
        }
        throw new IllegalArgumentException("getMinStorageNum called with unknown BlockType: " + block.getBlockType());
    }

    public short getMinReplicationToBeInMaintenance() {
        return this.minReplicationToBeInMaintenance;
    }

    private short getMinMaintenanceStorageNum(BlockInfo block) {
        if (block.isStriped()) {
            return ((BlockInfoStriped)block).getRealDataBlockNum();
        }
        return (short)Math.min(this.minReplicationToBeInMaintenance, block.getReplication());
    }

    public boolean hasMinStorage(BlockInfo block) {
        return this.countNodes(block).liveReplicas() >= this.getMinStorageNum(block);
    }

    public boolean hasMinStorage(BlockInfo block, int liveNum) {
        return liveNum >= this.getMinStorageNum(block);
    }

    private boolean commitBlock(BlockInfo block, Block commitBlock) throws IOException {
        if (block.getBlockUCState() == HdfsServerConstants.BlockUCState.COMMITTED) {
            return false;
        }
        assert (block.getNumBytes() <= commitBlock.getNumBytes()) : "commitBlock length is less than the stored one " + commitBlock.getNumBytes() + " vs. " + block.getNumBytes();
        if (block.getGenerationStamp() != commitBlock.getGenerationStamp()) {
            throw new IOException("Commit block with mismatching GS. NN has " + (Object)((Object)block) + ", client submits " + commitBlock);
        }
        List<ReplicaUnderConstruction> staleReplicas = block.commitBlock(commitBlock);
        this.removeStaleReplicas(staleReplicas, block);
        return true;
    }

    public boolean commitOrCompleteLastBlock(BlockCollection bc, Block commitBlock, INodesInPath iip) throws IOException {
        NumberReplicas numReplicas;
        int numUsableReplicas;
        if (commitBlock == null) {
            return false;
        }
        BlockInfo lastBlock = bc.getLastBlock();
        if (lastBlock == null) {
            return false;
        }
        if (lastBlock.isComplete()) {
            return false;
        }
        if (lastBlock.isUnderRecovery()) {
            throw new IOException("Commit or complete block " + commitBlock + ", whereas it is under recovery.");
        }
        boolean committed = this.commitBlock(lastBlock, commitBlock);
        if (committed && lastBlock.isStriped()) {
            lastBlock.getUnderConstructionFeature().updateStorageScheduledSize((BlockInfoStriped)lastBlock);
        }
        if (this.hasMinStorage(lastBlock, numUsableReplicas = (numReplicas = this.countNodes(lastBlock)).liveReplicas() + numReplicas.decommissioning() + numReplicas.liveEnteringMaintenanceReplicas())) {
            if (committed) {
                this.addExpectedReplicasToPending(lastBlock);
            }
            this.completeBlock(lastBlock, iip, false);
        } else if (this.pendingRecoveryBlocks.isUnderRecovery(lastBlock)) {
            this.completeBlock(lastBlock, iip, true);
            this.updateNeededReconstructions(lastBlock, 1, 0);
        }
        return committed;
    }

    public void addExpectedReplicasToPending(BlockInfo blk) {
        boolean addForStriped = false;
        DatanodeStorageInfo[] expectedStorages = blk.getUnderConstructionFeature().getExpectedStorageLocations();
        if (blk.isStriped()) {
            BlockInfoStriped blkStriped = (BlockInfoStriped)blk;
            boolean bl = addForStriped = blkStriped.getRealTotalBlockNum() == expectedStorages.length;
        }
        if ((!blk.isStriped() || addForStriped) && expectedStorages.length - blk.numNodes() > 0) {
            ArrayList<DatanodeStorageInfo> pendingNodes = new ArrayList<DatanodeStorageInfo>();
            for (DatanodeStorageInfo storage : expectedStorages) {
                DatanodeDescriptor dnd = storage.getDatanodeDescriptor();
                if (blk.findStorageInfo(dnd) != null) continue;
                pendingNodes.add(storage);
            }
            this.pendingReconstruction.increment(blk, pendingNodes.toArray(new DatanodeStorageInfo[pendingNodes.size()]));
        }
    }

    private void completeBlock(BlockInfo curBlock, INodesInPath iip, boolean force) throws IOException {
        if (curBlock.isComplete()) {
            return;
        }
        int numNodes = curBlock.numNodes();
        if (!force && !this.hasMinStorage(curBlock, numNodes)) {
            throw new IOException("Cannot complete block: block does not satisfy minimal replication requirement.");
        }
        if (!force && curBlock.getBlockUCState() != HdfsServerConstants.BlockUCState.COMMITTED) {
            throw new IOException("Cannot complete block: block has not been COMMITTED by the client");
        }
        this.convertToCompleteBlock(curBlock, iip);
        this.bmSafeMode.adjustBlockTotals(0, 1);
        short minStorage = curBlock.isStriped() ? ((BlockInfoStriped)curBlock).getRealDataBlockNum() : this.minReplication;
        this.bmSafeMode.incrementSafeBlockCount(Math.min(numNodes, minStorage), curBlock);
    }

    private void convertToCompleteBlock(BlockInfo curBlock, INodesInPath iip) throws IOException {
        curBlock.convertToCompleteBlock();
        this.namesystem.getFSDirectory().updateSpaceForCompleteBlock(curBlock, iip);
    }

    public void forceCompleteBlock(BlockInfo block) throws IOException {
        List<ReplicaUnderConstruction> staleReplicas = block.commitBlock(block);
        this.removeStaleReplicas(staleReplicas, block);
        this.completeBlock(block, null, true);
    }

    public LocatedBlock convertLastBlockToUnderConstruction(BlockCollection bc, long bytesToRemove) throws IOException {
        BlockInfo lastBlock = bc.getLastBlock();
        if (lastBlock == null || bc.getPreferredBlockSize() == lastBlock.getNumBytes() - bytesToRemove) {
            return null;
        }
        assert (lastBlock == this.getStoredBlock(lastBlock)) : "last block of the file is not in blocksMap";
        DatanodeStorageInfo[] targets = this.getStorages(lastBlock);
        bc.convertLastBlockToUC(lastBlock, targets);
        NumberReplicas replicas = this.countNodes(lastBlock);
        this.neededReconstruction.remove(lastBlock, replicas.liveReplicas(), replicas.readOnlyReplicas(), replicas.outOfServiceReplicas(), this.getExpectedRedundancyNum(lastBlock));
        PendingReconstructionBlocks.PendingBlockInfo remove = this.pendingReconstruction.remove(lastBlock);
        if (remove != null) {
            List<DatanodeStorageInfo> locations = remove.getTargets();
            DatanodeStorageInfo[] removedBlockTargets = new DatanodeStorageInfo[locations.size()];
            locations.toArray(removedBlockTargets);
            DatanodeStorageInfo.decrementBlocksScheduled(removedBlockTargets);
        }
        for (DatanodeStorageInfo storage : targets) {
            Block b = this.getBlockOnStorage(lastBlock, storage);
            if (b == null) continue;
            this.invalidateBlocks.remove(storage.getDatanodeDescriptor(), b);
        }
        this.bmSafeMode.adjustBlockTotals(this.hasMinStorage(lastBlock, targets.length) ? -1 : 0, -1);
        long fileLength = bc.computeContentSummary(this.getStoragePolicySuite()).getLength();
        long pos = fileLength - lastBlock.getNumBytes();
        return this.createLocatedBlock(null, lastBlock, pos, BlockTokenIdentifier.AccessMode.WRITE);
    }

    private List<DatanodeStorageInfo> getValidLocations(BlockInfo block) {
        ArrayList<DatanodeStorageInfo> locations = new ArrayList<DatanodeStorageInfo>(this.blocksMap.numNodes(block));
        for (DatanodeStorageInfo storage : this.blocksMap.getStorages(block)) {
            Block b = this.getBlockOnStorage(block, storage);
            if (b == null || this.invalidateBlocks.contains(storage.getDatanodeDescriptor(), b)) continue;
            locations.add(storage);
        }
        return locations;
    }

    private void createLocatedBlockList(LocatedBlockBuilder locatedBlocks, BlockInfo[] blocks, long offset, long length, BlockTokenIdentifier.AccessMode mode) throws IOException {
        int curBlk;
        long curPos = 0L;
        long blkSize = 0L;
        int nrBlocks = blocks[0].getNumBytes() == 0L ? 0 : blocks.length;
        for (curBlk = 0; curBlk < nrBlocks; ++curBlk) {
            blkSize = blocks[curBlk].getNumBytes();
            assert (blkSize > 0L) : "Block of size 0";
            if (curPos + blkSize > offset) break;
            curPos += blkSize;
        }
        if (nrBlocks > 0 && curBlk == nrBlocks) {
            return;
        }
        long endOff = offset + length;
        do {
            locatedBlocks.addBlock(this.createLocatedBlock(locatedBlocks, blocks[curBlk], curPos, mode));
        } while ((curPos += blocks[++curBlk].getNumBytes()) < endOff && curBlk < blocks.length && !locatedBlocks.isBlockMax());
    }

    private LocatedBlock createLocatedBlock(LocatedBlockBuilder locatedBlocks, BlockInfo[] blocks, long endPos, BlockTokenIdentifier.AccessMode mode) throws IOException {
        long blkSize;
        int curBlk;
        long curPos = 0L;
        int nrBlocks = blocks[0].getNumBytes() == 0L ? 0 : blocks.length;
        for (curBlk = 0; curBlk < nrBlocks && curPos + (blkSize = blocks[curBlk].getNumBytes()) < endPos; ++curBlk) {
            curPos += blkSize;
        }
        return this.createLocatedBlock(locatedBlocks, blocks[curBlk], curPos, mode);
    }

    private LocatedBlock createLocatedBlock(LocatedBlockBuilder locatedBlocks, BlockInfo blk, long pos, BlockTokenIdentifier.AccessMode mode) throws IOException {
        LocatedBlock lb = this.createLocatedBlock(locatedBlocks, blk, pos);
        if (mode != null) {
            this.setBlockToken(lb, mode);
        }
        return lb;
    }

    private LocatedBlock createLocatedBlock(LocatedBlockBuilder locatedBlocks, BlockInfo blk, long pos) throws IOException {
        boolean isCorrupt;
        int numCorruptReplicas;
        if (!blk.isComplete()) {
            BlockUnderConstructionFeature uc = blk.getUnderConstructionFeature();
            if (blk.isStriped()) {
                DatanodeStorageInfo[] storages = uc.getExpectedStorageLocations();
                ExtendedBlock eb = new ExtendedBlock(this.getBlockPoolId(), (Block)blk);
                return BlockManager.newLocatedStripedBlock(eb, storages, uc.getBlockIndices(), pos, false);
            }
            DatanodeStorageInfo[] storages = uc.getExpectedStorageLocations();
            ExtendedBlock eb = new ExtendedBlock(this.getBlockPoolId(), (Block)blk);
            return null == locatedBlocks ? BlockManager.newLocatedBlock(eb, storages, pos, false) : locatedBlocks.newLocatedBlock(eb, storages, pos, false);
        }
        NumberReplicas numReplicas = this.countNodes(blk);
        int numCorruptNodes = numReplicas.corruptReplicas();
        if (numCorruptNodes != (numCorruptReplicas = this.corruptReplicas.numCorruptReplicas(blk))) {
            LOG.warn("Inconsistent number of corrupt replicas for {} blockMap has {} but corrupt replicas map has {}", new Object[]{blk, numCorruptNodes, numCorruptReplicas});
        }
        int numNodes = this.blocksMap.numNodes(blk);
        if (blk.isStriped()) {
            BlockInfoStriped sblk = (BlockInfoStriped)blk;
            isCorrupt = numCorruptReplicas != 0 && numReplicas.liveReplicas() < sblk.getRealDataBlockNum();
        } else {
            isCorrupt = numCorruptReplicas != 0 && numCorruptReplicas == numNodes;
        }
        int numMachines = isCorrupt ? numNodes : numNodes - numCorruptReplicas;
        DatanodeStorageInfo[] machines = new DatanodeStorageInfo[numMachines -= numReplicas.maintenanceNotForReadReplicas()];
        byte[] blockIndices = blk.isStriped() ? new byte[numMachines] : null;
        int j = 0;
        int i = 0;
        if (numMachines > 0) {
            boolean noCorrupt = numCorruptReplicas == 0;
            for (DatanodeStorageInfo storage : this.blocksMap.getStorages(blk)) {
                DatanodeDescriptor d;
                if (storage.getState() == DatanodeStorage.State.FAILED || (d = storage.getDatanodeDescriptor()).isInMaintenance() || d.isEnteringMaintenance() && !d.isAlive()) continue;
                if (noCorrupt) {
                    machines[j++] = storage;
                    i = this.setBlockIndices(blk, blockIndices, i, storage);
                    continue;
                }
                boolean replicaCorrupt = this.isReplicaCorrupt(blk, d);
                if (!isCorrupt && replicaCorrupt) continue;
                machines[j++] = storage;
                i = this.setBlockIndices(blk, blockIndices, i, storage);
            }
        }
        if (j < machines.length) {
            machines = Arrays.copyOf(machines, j);
        }
        assert (j == machines.length) : "isCorrupt: " + isCorrupt + " numMachines: " + numMachines + " numNodes: " + numNodes + " numCorrupt: " + numCorruptNodes + " numCorruptRepls: " + numCorruptReplicas;
        ExtendedBlock eb = new ExtendedBlock(this.getBlockPoolId(), (Block)blk);
        return blockIndices == null ? (null == locatedBlocks ? BlockManager.newLocatedBlock(eb, machines, pos, isCorrupt) : locatedBlocks.newLocatedBlock(eb, machines, pos, isCorrupt)) : BlockManager.newLocatedStripedBlock(eb, machines, blockIndices, pos, isCorrupt);
    }

    public LocatedBlocks createLocatedBlocks(BlockInfo[] blocks, long fileSizeExcludeBlocksUnderConstruction, boolean isFileUnderConstruction, long offset, long length, boolean needBlockToken, boolean inSnapshot, FileEncryptionInfo feInfo, ErasureCodingPolicy ecPolicy) throws IOException {
        assert (this.namesystem.hasReadLock());
        if (blocks == null) {
            return null;
        }
        if (blocks.length == 0) {
            return new LocatedBlocks(0L, isFileUnderConstruction, Collections.emptyList(), null, false, feInfo, ecPolicy);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("blocks = {}", Arrays.asList(blocks));
        }
        BlockTokenIdentifier.AccessMode mode = needBlockToken ? BlockTokenIdentifier.AccessMode.READ : null;
        LocatedBlockBuilder locatedBlocks = this.providedStorageMap.newLocatedBlocks(Integer.MAX_VALUE).fileLength(fileSizeExcludeBlocksUnderConstruction).lastUC(isFileUnderConstruction).encryption(feInfo).erasureCoding(ecPolicy);
        this.createLocatedBlockList(locatedBlocks, blocks, offset, length, mode);
        if (!inSnapshot) {
            BlockInfo last = blocks[blocks.length - 1];
            long lastPos = last.isComplete() ? fileSizeExcludeBlocksUnderConstruction - last.getNumBytes() : fileSizeExcludeBlocksUnderConstruction;
            locatedBlocks.lastBlock(this.createLocatedBlock(locatedBlocks, last, lastPos, mode)).lastComplete(last.isComplete());
        } else {
            locatedBlocks.lastBlock(this.createLocatedBlock(locatedBlocks, blocks, fileSizeExcludeBlocksUnderConstruction, mode)).lastComplete(true);
        }
        LocatedBlocks locations = locatedBlocks.build();
        CacheManager cm = this.namesystem.getCacheManager();
        if (cm != null) {
            cm.setCachedLocations(locations);
        }
        return locations;
    }

    public ExportedBlockKeys getBlockKeys() {
        return this.isBlockTokenEnabled() ? this.blockTokenSecretManager.exportKeys() : ExportedBlockKeys.DUMMY_KEYS;
    }

    public void setBlockToken(LocatedBlock b, BlockTokenIdentifier.AccessMode mode) throws IOException {
        if (this.isBlockTokenEnabled()) {
            if (b.isStriped()) {
                Preconditions.checkState((boolean)(b instanceof LocatedStripedBlock));
                LocatedStripedBlock sb = (LocatedStripedBlock)b;
                byte[] indices = sb.getBlockIndices();
                Token[] blockTokens = new Token[indices.length];
                ExtendedBlock internalBlock = new ExtendedBlock(b.getBlock());
                for (int i = 0; i < indices.length; ++i) {
                    internalBlock.setBlockId(b.getBlock().getBlockId() + (long)indices[i]);
                    blockTokens[i] = this.blockTokenSecretManager.generateToken(NameNode.getRemoteUser().getShortUserName(), internalBlock, EnumSet.of(mode), b.getStorageTypes(), b.getStorageIDs());
                }
                sb.setBlockTokens(blockTokens);
            }
            b.setBlockToken(this.blockTokenSecretManager.generateToken(NameNode.getRemoteUser().getShortUserName(), b.getBlock(), EnumSet.of(mode), b.getStorageTypes(), b.getStorageIDs()));
        }
    }

    void addKeyUpdateCommand(List<DatanodeCommand> cmds, DatanodeDescriptor nodeinfo) {
        if (this.isBlockTokenEnabled() && nodeinfo.needKeyUpdate()) {
            cmds.add(new KeyUpdateCommand(this.blockTokenSecretManager.exportKeys()));
            nodeinfo.setNeedKeyUpdate(false);
        }
    }

    public DataEncryptionKey generateDataEncryptionKey() {
        if (this.isBlockTokenEnabled() && this.encryptDataTransfer) {
            return this.blockTokenSecretManager.generateDataEncryptionKey();
        }
        return null;
    }

    public short adjustReplication(short replication) {
        return replication < this.minReplication ? this.minReplication : (replication > this.maxReplication ? this.maxReplication : replication);
    }

    public void verifyReplication(String src, short replication, String clientName) throws IOException {
        String err = null;
        if (replication > this.maxReplication) {
            err = " exceeds maximum of " + this.maxReplication;
        } else if (replication < this.minReplication) {
            err = " is less than the required minimum of " + this.minReplication;
        }
        if (err != null) {
            throw new IOException("Requested replication factor of " + replication + err + " for " + src + (clientName == null ? "" : ", clientName=" + clientName));
        }
    }

    public boolean isSufficientlyReplicated(BlockInfo b) {
        int liveReplicas = this.countNodes(b).liveReplicas();
        if (liveReplicas >= this.minReplication) {
            return true;
        }
        return liveReplicas >= this.getDatanodeManager().getNumLiveDataNodes();
    }

    private boolean isHotBlock(BlockInfo blockInfo, long time) {
        INodeFile iFile = (INodeFile)this.getBlockCollection(blockInfo);
        if (iFile == null) {
            return false;
        }
        if (iFile.isUnderConstruction()) {
            return true;
        }
        return iFile.getAccessTime() > time || iFile.getModificationTime() > time;
    }

    public BlocksWithLocations getBlocksWithLocations(DatanodeID datanode, long size, long minBlockSize, long timeInterval) throws UnregisteredNodeException {
        int i;
        BlockInfo curBlock;
        DatanodeDescriptor node = this.getDatanodeManager().getDatanode(datanode);
        if (node == null) {
            blockLog.warn("BLOCK* getBlocks: Asking for blocks from an unrecorded node {}", (Object)datanode);
            throw new HadoopIllegalArgumentException("Datanode " + datanode + " not found.");
        }
        int numBlocks = node.numBlocks();
        if (numBlocks == 0) {
            return new BlocksWithLocations(new BlocksWithLocations.BlockWithLocations[0]);
        }
        int startBlock = ThreadLocalRandom.current().nextInt(numBlocks);
        Iterator<BlockInfo> iter = node.getBlockIterator(startBlock);
        ArrayList<BlocksWithLocations.BlockWithLocations> results = new ArrayList<BlocksWithLocations.BlockWithLocations>();
        ArrayList<BlockInfo> pending = new ArrayList<BlockInfo>();
        long totalSize = 0L;
        long hotTimePos = Time.now() - timeInterval;
        while (totalSize < size && iter.hasNext()) {
            curBlock = iter.next();
            if (!curBlock.isComplete() || curBlock.getNumBytes() < minBlockSize) continue;
            if (timeInterval > 0L && this.isHotBlock(curBlock, hotTimePos)) {
                pending.add(curBlock);
                continue;
            }
            totalSize += this.addBlock(curBlock, results);
        }
        if (totalSize < size) {
            iter = node.getBlockIterator();
            for (i = 0; i < startBlock && totalSize < size; ++i) {
                curBlock = iter.next();
                if (!curBlock.isComplete() || curBlock.getNumBytes() < minBlockSize) continue;
                if (timeInterval > 0L && this.isHotBlock(curBlock, hotTimePos)) {
                    pending.add(curBlock);
                    continue;
                }
                totalSize += this.addBlock(curBlock, results);
            }
        }
        for (i = 0; i < pending.size() && totalSize < size; totalSize += this.addBlock(curBlock, results), ++i) {
            curBlock = (BlockInfo)((Object)pending.get(i));
        }
        return new BlocksWithLocations(results.toArray(new BlocksWithLocations.BlockWithLocations[results.size()]));
    }

    void removeBlocksAssociatedTo(DatanodeDescriptor node) {
        this.providedStorageMap.removeDatanode(node);
        Iterator<BlockInfo> it = node.getBlockIterator();
        while (it.hasNext()) {
            this.removeStoredBlock(it.next(), node);
        }
        this.pendingDNMessages.removeAllMessagesForDatanode(node);
        node.resetBlocks();
        this.invalidateBlocks.remove(node);
    }

    void removeBlocksAssociatedTo(DatanodeStorageInfo storageInfo) {
        assert (this.namesystem.hasWriteLock());
        Iterator<BlockInfo> it = storageInfo.getBlockIterator();
        DatanodeDescriptor node = storageInfo.getDatanodeDescriptor();
        while (it.hasNext()) {
            BlockInfo block = it.next();
            this.removeStoredBlock(block, node);
            Block b = this.getBlockOnStorage(block, storageInfo);
            if (b == null) continue;
            this.invalidateBlocks.remove(node, b);
        }
        this.checkSafeMode();
        LOG.info("Removed blocks associated with storage {} from DataNode {}", (Object)storageInfo, (Object)node);
    }

    void addToInvalidates(Block block, DatanodeInfo datanode) {
        if (!this.isPopulatingReplQueues()) {
            return;
        }
        this.invalidateBlocks.add(block, datanode, true);
    }

    private void addToInvalidates(BlockInfo storedBlock) {
        if (!this.isPopulatingReplQueues()) {
            return;
        }
        StringBuilder datanodes = blockLog.isDebugEnabled() ? new StringBuilder() : null;
        for (DatanodeStorageInfo storage : this.blocksMap.getStorages(storedBlock)) {
            if (storage.getState() != DatanodeStorage.State.NORMAL) continue;
            DatanodeDescriptor node = storage.getDatanodeDescriptor();
            Block b = this.getBlockOnStorage(storedBlock, storage);
            if (b == null) continue;
            this.invalidateBlocks.add(b, node, false);
            if (datanodes == null) continue;
            datanodes.append((Object)node).append(" ");
        }
        if (datanodes != null && datanodes.length() != 0) {
            blockLog.debug("BLOCK* addToInvalidates: {} {}", (Object)storedBlock, (Object)datanodes);
        }
    }

    private Block getBlockOnStorage(BlockInfo storedBlock, DatanodeStorageInfo storage) {
        return storedBlock.isStriped() ? ((BlockInfoStriped)storedBlock).getBlockOnStorage(storage) : storedBlock;
    }

    public void findAndMarkBlockAsCorrupt(ExtendedBlock blk, DatanodeInfo dn, String storageID, String reason) throws IOException {
        assert (this.namesystem.hasWriteLock());
        Block reportedBlock = blk.getLocalBlock();
        BlockInfo storedBlock = this.getStoredBlock(reportedBlock);
        if (storedBlock == null) {
            blockLog.debug("BLOCK* findAndMarkBlockAsCorrupt: {} not found", (Object)blk);
            return;
        }
        DatanodeDescriptor node = this.getDatanodeManager().getDatanode((DatanodeID)dn);
        if (node == null) {
            throw new IOException("Cannot mark " + blk + " as corrupt because datanode " + dn + " (" + dn.getDatanodeUuid() + ") does not exist");
        }
        DatanodeStorageInfo storage = null;
        if (storageID != null) {
            storage = node.getStorageInfo(storageID);
        }
        if (storage == null) {
            storage = storedBlock.findStorageInfo(node);
        }
        if (storage == null) {
            blockLog.debug("BLOCK* findAndMarkBlockAsCorrupt: {} not found on {}", (Object)blk, (Object)dn);
            return;
        }
        this.markBlockAsCorrupt(new BlockToMarkCorrupt(reportedBlock, storedBlock, blk.getGenerationStamp(), reason, CorruptReplicasMap.Reason.CORRUPTION_REPORTED), storage, node);
    }

    private void markBlockAsCorrupt(BlockToMarkCorrupt b, DatanodeStorageInfo storageInfo, DatanodeDescriptor node) throws IOException {
        boolean corruptedDuringWrite;
        if (b.getStored().isDeleted()) {
            blockLog.debug("BLOCK markBlockAsCorrupt: {} cannot be marked as corrupt as it does not belong to any file", (Object)b);
            this.addToInvalidates(b.getCorrupted(), node);
            return;
        }
        short expectedRedundancies = this.getExpectedRedundancyNum(b.getStored());
        if (storageInfo != null) {
            storageInfo.addBlock(b.getStored(), b.getCorrupted());
        }
        Block corrupted = new Block(b.getCorrupted());
        if (b.getStored().isStriped()) {
            corrupted.setBlockId(b.getStored().getBlockId());
        }
        this.corruptReplicas.addToCorruptReplicasMap(corrupted, node, b.getReason(), b.getReasonCode(), b.getStored().isStriped());
        NumberReplicas numberOfReplicas = this.countNodes(b.getStored());
        boolean hasEnoughLiveReplicas = numberOfReplicas.liveReplicas() >= expectedRedundancies;
        boolean minReplicationSatisfied = this.hasMinStorage(b.getStored(), numberOfReplicas.liveReplicas());
        boolean hasMoreCorruptReplicas = minReplicationSatisfied && numberOfReplicas.liveReplicas() + numberOfReplicas.corruptReplicas() > expectedRedundancies;
        boolean bl = corruptedDuringWrite = minReplicationSatisfied && b.isCorruptedDuringWrite();
        if (hasEnoughLiveReplicas || hasMoreCorruptReplicas || corruptedDuringWrite) {
            if (b.getStored().isStriped()) {
                this.corruptReplicas.removeFromCorruptReplicasMap(b.getStored(), node);
                BlockInfoStriped blk = (BlockInfoStriped)this.getStoredBlock(b.getStored());
                storageInfo.removeBlock(blk);
            }
            this.invalidateBlock(b, node, numberOfReplicas);
        } else if (this.isPopulatingReplQueues()) {
            this.updateNeededReconstructions(b.getStored(), -1, 0);
        }
    }

    private boolean invalidateBlock(BlockToMarkCorrupt b, DatanodeInfo dn, NumberReplicas nr) throws IOException {
        blockLog.debug("BLOCK* invalidateBlock: {} on {}", (Object)b, (Object)dn);
        DatanodeDescriptor node = this.getDatanodeManager().getDatanode((DatanodeID)dn);
        if (node == null) {
            throw new IOException("Cannot invalidate " + b + " because datanode " + dn + " does not exist.");
        }
        if (nr.replicasOnStaleNodes() > 0 && !this.deleteCorruptReplicaImmediately) {
            blockLog.debug("BLOCK* invalidateBlocks: postponing invalidation of {} on {} because {} replica(s) are located on nodes with potentially out-of-date block reports", new Object[]{b, dn, nr.replicasOnStaleNodes()});
            this.postponeBlock(b.getCorrupted());
            return false;
        }
        this.addToInvalidates(b.getCorrupted(), dn);
        this.removeStoredBlock(b.getStored(), node);
        blockLog.debug("BLOCK* invalidateBlocks: {} on {} listed for deletion.", (Object)b, (Object)dn);
        return true;
    }

    public void setPostponeBlocksFromFuture(boolean postpone) {
        this.shouldPostponeBlocksFromFuture = postpone;
    }

    @VisibleForTesting
    void postponeBlock(Block blk) {
        this.postponedMisreplicatedBlocks.add(blk);
    }

    void updateState() {
        this.pendingReconstructionBlocksCount = this.pendingReconstruction.size();
        this.lowRedundancyBlocksCount = this.neededReconstruction.size();
        this.corruptReplicaBlocksCount = this.corruptReplicas.size();
    }

    public int getUnderReplicatedNotMissingBlocks() {
        return this.neededReconstruction.getLowRedundancyBlockCount();
    }

    int computeInvalidateWork(int nodesToProcess) {
        List<DatanodeInfo> nodes = this.invalidateBlocks.getDatanodes();
        Collections.shuffle(nodes);
        nodesToProcess = Math.min(nodes.size(), nodesToProcess);
        int blockCnt = 0;
        for (DatanodeInfo dnInfo : nodes) {
            int blocks = this.invalidateWorkForOneNode(dnInfo);
            if (blocks <= 0) continue;
            blockCnt += blocks;
            if (--nodesToProcess != 0) continue;
            break;
        }
        return blockCnt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int computeBlockReconstructionWork(int blocksToProcess) {
        List<List<BlockInfo>> blocksToReconstruct = null;
        this.namesystem.writeLock();
        try {
            boolean reset = false;
            if (this.replQueueResetToHeadThreshold > 0) {
                if (this.replQueueCallsSinceReset >= this.replQueueResetToHeadThreshold) {
                    reset = true;
                    this.replQueueCallsSinceReset = 0;
                } else {
                    ++this.replQueueCallsSinceReset;
                }
            }
            blocksToReconstruct = this.neededReconstruction.chooseLowRedundancyBlocks(blocksToProcess, reset);
        }
        finally {
            this.namesystem.writeUnlock();
        }
        return this.computeReconstructionWorkForBlocks(blocksToReconstruct);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @VisibleForTesting
    int computeReconstructionWorkForBlocks(List<List<BlockInfo>> blocksToReconstruct) {
        DatanodeStorageInfo[] targets;
        Iterable<DatanodeStorageInfo> targets2;
        int scheduledWork = 0;
        ArrayList<BlockReconstructionWork> reconWork = new ArrayList<BlockReconstructionWork>();
        this.namesystem.writeLock();
        try {
            Iterator iterator = this.neededReconstruction;
            synchronized (iterator) {
                for (int priority = 0; priority < blocksToReconstruct.size(); ++priority) {
                    for (BlockInfo block : blocksToReconstruct.get(priority)) {
                        BlockReconstructionWork rw = this.scheduleReconstruction(block, priority);
                        if (rw == null) continue;
                        reconWork.add(rw);
                    }
                }
            }
        }
        finally {
            this.namesystem.writeUnlock();
        }
        for (BlockReconstructionWork rw : reconWork) {
            HashSet<DatanodeDescriptor> excludedNodes = new HashSet<DatanodeDescriptor>(rw.getContainingNodes());
            targets2 = this.pendingReconstruction.getTargets(rw.getBlock());
            if (targets2 != null) {
                for (DatanodeStorageInfo dn : targets2) {
                    excludedNodes.add(dn.getDatanodeDescriptor());
                }
            }
            BlockPlacementPolicy placementPolicy = this.placementPolicies.getPolicy(rw.getBlock().getBlockType());
            rw.chooseTargets(placementPolicy, this.storagePolicySuite, excludedNodes);
        }
        this.namesystem.writeLock();
        try {
            for (BlockReconstructionWork rw : reconWork) {
                targets = rw.getTargets();
                if (targets == null || targets.length == 0) {
                    rw.resetTargets();
                    continue;
                }
                targets2 = this.neededReconstruction;
                synchronized (targets2) {
                    if (this.validateReconstructionWork(rw)) {
                        ++scheduledWork;
                    }
                }
            }
        }
        finally {
            this.namesystem.writeUnlock();
        }
        if (blockLog.isDebugEnabled()) {
            for (BlockReconstructionWork rw : reconWork) {
                targets = rw.getTargets();
                if (targets == null || targets.length == 0) continue;
                StringBuilder targetList = new StringBuilder("datanode(s)");
                for (DatanodeStorageInfo target : targets) {
                    targetList.append(' ').append((Object)target.getDatanodeDescriptor());
                }
                blockLog.debug("BLOCK* ask {} to replicate {} to {}", new Object[]{rw.getSrcNodes(), rw.getBlock(), targetList});
            }
            blockLog.debug("BLOCK* neededReconstruction = {} pendingReconstruction = {}", (Object)this.neededReconstruction.size(), (Object)this.pendingReconstruction.size());
        }
        return scheduledWork;
    }

    boolean hasEnoughEffectiveReplicas(BlockInfo block, NumberReplicas numReplicas, int pendingReplicaNum) {
        short required = this.getExpectedLiveRedundancyNum(block, numReplicas);
        int numEffectiveReplicas = numReplicas.liveReplicas() + pendingReplicaNum;
        return numEffectiveReplicas >= required && (pendingReplicaNum > 0 || this.isPlacementPolicySatisfied(block));
    }

    @VisibleForTesting
    BlockReconstructionWork scheduleReconstruction(BlockInfo block, int priority) {
        int additionalReplRequired;
        if (block.isDeleted() || !block.isCompleteOrCommitted()) {
            this.neededReconstruction.remove(block, priority);
            return null;
        }
        ArrayList<DatanodeDescriptor> containingNodes = new ArrayList<DatanodeDescriptor>();
        ArrayList<DatanodeStorageInfo> liveReplicaNodes = new ArrayList<DatanodeStorageInfo>();
        NumberReplicas numReplicas = new NumberReplicas();
        ArrayList<Byte> liveBlockIndices = new ArrayList<Byte>();
        ArrayList<Byte> liveBusyBlockIndices = new ArrayList<Byte>();
        DatanodeDescriptor[] srcNodes = this.chooseSourceDatanodes(block, containingNodes, liveReplicaNodes, numReplicas, liveBlockIndices, liveBusyBlockIndices, priority);
        short requiredRedundancy = this.getExpectedLiveRedundancyNum(block, numReplicas);
        if (srcNodes == null || srcNodes.length == 0) {
            LOG.debug("Block {} cannot be reconstructed from any node", (Object)block);
            NameNode.getNameNodeMetrics().incNumTimesReReplicationNotScheduled();
            return null;
        }
        assert (liveReplicaNodes.size() >= numReplicas.liveReplicas());
        int pendingNum = this.pendingReconstruction.getNumReplicas(block);
        if (this.hasEnoughEffectiveReplicas(block, numReplicas, pendingNum)) {
            this.neededReconstruction.remove(block, priority);
            blockLog.debug("BLOCK* Removing {} from neededReconstruction as it has enough replicas", (Object)block);
            NameNode.getNameNodeMetrics().incNumTimesReReplicationNotScheduled();
            return null;
        }
        if (numReplicas.liveReplicas() < requiredRedundancy) {
            additionalReplRequired = requiredRedundancy - numReplicas.liveReplicas() - pendingNum;
        } else {
            BlockPlacementStatus placementStatus = this.getBlockPlacementStatus(block);
            additionalReplRequired = placementStatus.getAdditionalReplicasRequired();
        }
        BlockCollection bc = this.getBlockCollection(block);
        if (block.isStriped()) {
            if (pendingNum > 0) {
                NameNode.getNameNodeMetrics().incNumTimesReReplicationNotScheduled();
                return null;
            }
            if (additionalReplRequired - numReplicas.decommissioning() - numReplicas.liveEnteringMaintenanceReplicas() > 0) {
                additionalReplRequired = additionalReplRequired - numReplicas.decommissioning() - numReplicas.liveEnteringMaintenanceReplicas();
            }
            DatanodeDescriptor[] newSrcNodes = new DatanodeDescriptor[srcNodes.length];
            byte[] newIndices = new byte[liveBlockIndices.size()];
            this.adjustSrcNodesAndIndices((BlockInfoStriped)block, srcNodes, liveBlockIndices, newSrcNodes, newIndices);
            byte[] busyIndices = new byte[liveBusyBlockIndices.size()];
            for (int i = 0; i < liveBusyBlockIndices.size(); ++i) {
                busyIndices[i] = (Byte)liveBusyBlockIndices.get(i);
            }
            return new ErasureCodingWork(this.getBlockPoolId(), block, bc, newSrcNodes, containingNodes, liveReplicaNodes, additionalReplRequired, priority, newIndices, busyIndices);
        }
        return new ReplicationWork(block, bc, srcNodes, containingNodes, liveReplicaNodes, additionalReplRequired, priority);
    }

    private void adjustSrcNodesAndIndices(BlockInfoStriped block, DatanodeDescriptor[] srcNodes, List<Byte> indices, DatanodeDescriptor[] newSrcNodes, byte[] newIndices) {
        int i;
        BitSet bitSet = new BitSet(block.getRealTotalBlockNum());
        ArrayList<Integer> skipIndexList = new ArrayList<Integer>();
        int j = 0;
        for (i = 0; i < srcNodes.length; ++i) {
            if (!bitSet.get(indices.get(i).byteValue())) {
                bitSet.set(indices.get(i).byteValue());
                newSrcNodes[j] = srcNodes[i];
                newIndices[j++] = indices.get(i);
                continue;
            }
            skipIndexList.add(i);
        }
        i = srcNodes.length - skipIndexList.size();
        j = 0;
        while (i < srcNodes.length) {
            newSrcNodes[i] = srcNodes[(Integer)skipIndexList.get(j)];
            newIndices[i] = indices.get((Integer)skipIndexList.get(j));
            ++i;
            ++j;
        }
    }

    @VisibleForTesting
    boolean validateReconstructionWork(BlockReconstructionWork rw) {
        BlockInfo block = rw.getBlock();
        int priority = rw.getPriority();
        if (block.isDeleted() || !block.isCompleteOrCommitted()) {
            this.neededReconstruction.remove(block, priority);
            rw.resetTargets();
            return false;
        }
        NumberReplicas numReplicas = this.countNodes(block);
        short requiredRedundancy = this.getExpectedLiveRedundancyNum(block, numReplicas);
        int pendingNum = this.pendingReconstruction.getNumReplicas(block);
        if (this.hasEnoughEffectiveReplicas(block, numReplicas, pendingNum)) {
            this.neededReconstruction.remove(block, priority);
            rw.resetTargets();
            blockLog.debug("BLOCK* Removing {} from neededReconstruction as it has enough replicas", (Object)block);
            return false;
        }
        DatanodeStorageInfo[] targets = rw.getTargets();
        BlockPlacementStatus placementStatus = this.getBlockPlacementStatus(block);
        if (numReplicas.liveReplicas() >= requiredRedundancy && !placementStatus.isPlacementPolicySatisfied()) {
            BlockPlacementStatus newPlacementStatus = this.getBlockPlacementStatus(block, targets);
            if (!newPlacementStatus.isPlacementPolicySatisfied() && newPlacementStatus.getAdditionalReplicasRequired() >= placementStatus.getAdditionalReplicasRequired()) {
                rw.resetTargets();
                return false;
            }
            rw.setNotEnoughRack();
        }
        rw.addTaskToDatanode(numReplicas);
        DatanodeStorageInfo.incrementBlocksScheduled(targets);
        this.pendingReconstruction.increment(block, targets);
        blockLog.debug("BLOCK* block {} is moved from neededReconstruction to pendingReconstruction", (Object)block);
        int numEffectiveReplicas = numReplicas.liveReplicas() + pendingNum;
        if (numEffectiveReplicas + targets.length >= requiredRedundancy) {
            this.neededReconstruction.remove(block, priority);
        }
        return true;
    }

    public DatanodeStorageInfo[] chooseTarget4WebHDFS(String src, DatanodeDescriptor clientnode, Set<Node> excludes, long blocksize) {
        return this.placementPolicies.getPolicy(BlockType.CONTIGUOUS).chooseTarget(src, 1, (Node)clientnode, Collections.emptyList(), false, excludes, blocksize, this.storagePolicySuite.getDefaultPolicy(), null);
    }

    public DatanodeStorageInfo[] chooseTarget4AdditionalDatanode(String src, int numAdditionalNodes, Node clientnode, List<DatanodeStorageInfo> chosen, Set<Node> excludes, long blocksize, byte storagePolicyID, BlockType blockType) {
        BlockStoragePolicy storagePolicy = this.storagePolicySuite.getPolicy(storagePolicyID);
        BlockPlacementPolicy blockplacement = this.placementPolicies.getPolicy(blockType);
        return blockplacement.chooseTarget(src, numAdditionalNodes, clientnode, chosen, true, excludes, blocksize, storagePolicy, null);
    }

    public DatanodeStorageInfo[] chooseTarget4NewBlock(String src, int numOfReplicas, Node client, Set<Node> excludedNodes, long blocksize, List<String> favoredNodes, byte storagePolicyID, BlockType blockType, ErasureCodingPolicy ecPolicy, EnumSet<AddBlockFlag> flags) throws IOException {
        List<DatanodeDescriptor> favoredDatanodeDescriptors = this.getDatanodeDescriptors(favoredNodes);
        BlockStoragePolicy storagePolicy = this.storagePolicySuite.getPolicy(storagePolicyID);
        BlockPlacementPolicy blockplacement = this.placementPolicies.getPolicy(blockType);
        DatanodeStorageInfo[] targets = blockplacement.chooseTarget(src, numOfReplicas, client, excludedNodes, blocksize, favoredDatanodeDescriptors, storagePolicy, flags);
        String errorMessage = "File %s could only be written to %d of the %d %s. There are %d datanode(s) running and %s node(s) are excluded in this operation.";
        if (blockType == BlockType.CONTIGUOUS && targets.length < this.minReplication) {
            throw new IOException(String.format("File %s could only be written to %d of the %d %s. There are %d datanode(s) running and %s node(s) are excluded in this operation.", src, targets.length, this.minReplication, "minReplication nodes", this.getDatanodeManager().getNetworkTopology().getNumOfLeaves(), excludedNodes == null ? "no" : Integer.valueOf(excludedNodes.size())));
        }
        if (blockType == BlockType.STRIPED && targets.length < ecPolicy.getNumDataUnits()) {
            throw new IOException(String.format("File %s could only be written to %d of the %d %s. There are %d datanode(s) running and %s node(s) are excluded in this operation.", src, targets.length, ecPolicy.getNumDataUnits(), String.format("required nodes for %s", ecPolicy.getName()), this.getDatanodeManager().getNetworkTopology().getNumOfLeaves(), excludedNodes == null ? "no" : Integer.valueOf(excludedNodes.size())));
        }
        return targets;
    }

    List<DatanodeDescriptor> getDatanodeDescriptors(List<String> nodes) {
        ArrayList<DatanodeDescriptor> datanodeDescriptors = null;
        if (nodes != null) {
            datanodeDescriptors = new ArrayList<DatanodeDescriptor>(nodes.size());
            for (int i = 0; i < nodes.size(); ++i) {
                DatanodeDescriptor node = this.datanodeManager.getDatanodeDescriptor(nodes.get(i));
                if (node == null) continue;
                datanodeDescriptors.add(node);
            }
        }
        return datanodeDescriptors;
    }

    private DatanodeDescriptor getDatanodeDescriptorFromStorage(DatanodeStorageInfo storage) {
        if (storage.getStorageType() == StorageType.PROVIDED) {
            return this.providedStorageMap.chooseProvidedDatanode();
        }
        return storage.getDatanodeDescriptor();
    }

    @VisibleForTesting
    DatanodeDescriptor[] chooseSourceDatanodes(BlockInfo block, List<DatanodeDescriptor> containingNodes, List<DatanodeStorageInfo> nodesContainingLiveReplicas, NumberReplicas numReplicas, List<Byte> liveBlockIndices, List<Byte> liveBusyBlockIndices, int priority) {
        containingNodes.clear();
        nodesContainingLiveReplicas.clear();
        ArrayList<DatanodeDescriptor> srcNodes = new ArrayList<DatanodeDescriptor>();
        liveBlockIndices.clear();
        boolean isStriped = block.isStriped();
        DatanodeDescriptor decommissionedSrc = null;
        BitSet liveBitSet = null;
        BitSet decommissioningBitSet = null;
        if (isStriped) {
            short blockNum = ((BlockInfoStriped)block).getTotalBlockNum();
            liveBitSet = new BitSet(blockNum);
            decommissioningBitSet = new BitSet(blockNum);
        }
        for (DatanodeStorageInfo storage : this.blocksMap.getStorages(block)) {
            DatanodeDescriptor node = this.getDatanodeDescriptorFromStorage(storage);
            NumberReplicas.StoredReplicaState state = this.checkReplicaOnStorage(numReplicas, block, storage, this.corruptReplicas.getNodes(block), false);
            if (state == NumberReplicas.StoredReplicaState.LIVE) {
                if (storage.getStorageType() == StorageType.PROVIDED) {
                    storage = new DatanodeStorageInfo(node, storage.getStorageID(), storage.getStorageType(), storage.getState());
                }
                nodesContainingLiveReplicas.add(storage);
            }
            containingNodes.add(node);
            if (state == NumberReplicas.StoredReplicaState.CORRUPT || state == NumberReplicas.StoredReplicaState.EXCESS || state == null || state == NumberReplicas.StoredReplicaState.MAINTENANCE_NOT_FOR_READ) continue;
            if (state == NumberReplicas.StoredReplicaState.DECOMMISSIONED) {
                if (decommissionedSrc != null && !ThreadLocalRandom.current().nextBoolean()) continue;
                decommissionedSrc = node;
                continue;
            }
            byte blockIndex = -1;
            if (isStriped) {
                blockIndex = ((BlockInfoStriped)block).getStorageBlockIndex(storage);
                this.countLiveAndDecommissioningReplicas(numReplicas, state, liveBitSet, decommissioningBitSet, blockIndex);
            }
            if (priority != 0 && !node.isDecommissionInProgress() && !node.isEnteringMaintenance() && node.getNumberOfBlocksToBeReplicated() >= this.maxReplicationStreams) {
                if (!isStriped || state != NumberReplicas.StoredReplicaState.LIVE && state != NumberReplicas.StoredReplicaState.DECOMMISSIONING) continue;
                liveBusyBlockIndices.add(blockIndex);
                continue;
            }
            if (node.getNumberOfBlocksToBeReplicated() >= this.replicationStreamsHardLimit) {
                if (!isStriped || state != NumberReplicas.StoredReplicaState.LIVE && state != NumberReplicas.StoredReplicaState.DECOMMISSIONING) continue;
                liveBusyBlockIndices.add(blockIndex);
                continue;
            }
            if (isStriped || srcNodes.isEmpty()) {
                srcNodes.add(node);
                if (!isStriped) continue;
                liveBlockIndices.add(blockIndex);
                continue;
            }
            if (!ThreadLocalRandom.current().nextBoolean()) continue;
            srcNodes.set(0, node);
        }
        if (!isStriped && nodesContainingLiveReplicas.isEmpty() && srcNodes.isEmpty() && decommissionedSrc != null) {
            srcNodes.add(decommissionedSrc);
        }
        return srcNodes.toArray(new DatanodeDescriptor[srcNodes.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processPendingReconstructions() {
        BlockInfo[] timedOutItems = this.pendingReconstruction.getTimedOutBlocks();
        if (timedOutItems != null) {
            this.namesystem.writeLock();
            try {
                for (int i = 0; i < timedOutItems.length; ++i) {
                    NumberReplicas num;
                    BlockInfo bi = this.blocksMap.getStoredBlock(timedOutItems[i]);
                    if (bi == null || bi.isDeleted() || !this.isNeededReconstruction(bi, num = this.countNodes(timedOutItems[i]))) continue;
                    this.neededReconstruction.add(bi, num.liveReplicas(), num.readOnlyReplicas(), num.outOfServiceReplicas(), this.getExpectedRedundancyNum(bi));
                }
            }
            finally {
                this.namesystem.writeUnlock();
            }
        }
    }

    public long requestBlockReportLeaseId(DatanodeRegistration nodeReg) {
        assert (this.namesystem.hasReadLock());
        DatanodeDescriptor node = null;
        try {
            node = this.datanodeManager.getDatanode(nodeReg);
        }
        catch (UnregisteredNodeException e) {
            LOG.warn("Unregistered datanode {}", (Object)nodeReg);
            return 0L;
        }
        if (node == null) {
            LOG.warn("Failed to find datanode {}", (Object)nodeReg);
            return 0L;
        }
        long leaseId = this.blockReportLeaseManager.requestLease(node);
        BlockManagerFaultInjector.getInstance().requestBlockReportLease(node, leaseId);
        return leaseId;
    }

    public void registerDatanode(DatanodeRegistration nodeReg) throws IOException {
        assert (this.namesystem.hasWriteLock());
        this.datanodeManager.registerDatanode(nodeReg);
        this.bmSafeMode.checkSafeMode();
    }

    public void setBlockTotal(long total) {
        if (this.bmSafeMode.isInSafeMode()) {
            this.bmSafeMode.setBlockTotal(total);
            this.bmSafeMode.checkSafeMode();
        }
    }

    public boolean isInSafeMode() {
        return this.bmSafeMode.isInSafeMode();
    }

    public String getSafeModeTip() {
        return this.bmSafeMode.getSafeModeTip();
    }

    public boolean leaveSafeMode(boolean force) {
        return this.bmSafeMode.leaveSafeMode(force);
    }

    public void checkSafeMode() {
        this.bmSafeMode.checkSafeMode();
    }

    public long getBytesInFuture() {
        return this.bmSafeMode.getBytesInFuture();
    }

    public long getBytesInFutureReplicatedBlocks() {
        return this.bmSafeMode.getBytesInFutureBlocks();
    }

    public long getBytesInFutureECBlockGroups() {
        return this.bmSafeMode.getBytesInFutureECBlockGroups();
    }

    public void removeBlocksAndUpdateSafemodeTotal(INode.BlocksMapUpdateInfo blocks) {
        assert (this.namesystem.hasWriteLock());
        boolean trackBlockCounts = this.bmSafeMode.isSafeModeTrackingBlocks();
        int numRemovedComplete = 0;
        int numRemovedSafe = 0;
        for (BlockInfo b : blocks.getToDeleteList()) {
            if (trackBlockCounts && b.isComplete()) {
                ++numRemovedComplete;
                if (this.hasMinStorage(b, b.numNodes())) {
                    ++numRemovedSafe;
                }
            }
            this.removeBlock(b);
        }
        if (trackBlockCounts) {
            LOG.debug("Adjusting safe-mode totals for deletion.decreasing safeBlocks by {}, totalBlocks by {}", (Object)numRemovedSafe, (Object)numRemovedComplete);
            this.bmSafeMode.adjustBlockTotals(-numRemovedSafe, -numRemovedComplete);
        }
    }

    public long getProvidedCapacity() {
        return this.providedStorageMap.getCapacity();
    }

    void updateHeartbeat(DatanodeDescriptor node, StorageReport[] reports, long cacheCapacity, long cacheUsed, int xceiverCount, int failedVolumes, VolumeFailureSummary volumeFailureSummary) {
        for (StorageReport report : reports) {
            this.providedStorageMap.updateStorage(node, report.getStorage());
        }
        node.updateHeartbeat(reports, cacheCapacity, cacheUsed, xceiverCount, failedVolumes, volumeFailureSummary);
    }

    void updateHeartbeatState(DatanodeDescriptor node, StorageReport[] reports, long cacheCapacity, long cacheUsed, int xceiverCount, int failedVolumes, VolumeFailureSummary volumeFailureSummary) {
        for (StorageReport report : reports) {
            this.providedStorageMap.updateStorage(node, report.getStorage());
        }
        node.updateHeartbeatState(reports, cacheCapacity, cacheUsed, xceiverCount, failedVolumes, volumeFailureSummary);
    }

    public boolean checkBlockReportLease(BlockReportContext context, DatanodeID nodeID) throws UnregisteredNodeException {
        if (context == null) {
            return true;
        }
        DatanodeDescriptor node = this.datanodeManager.getDatanode(nodeID);
        long startTime = Time.monotonicNow();
        return this.blockReportLeaseManager.checkLease(node, startTime, context.getLeaseId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean processReport(DatanodeID nodeID, DatanodeStorage storage, BlockListAsLongs newReport, BlockReportContext context) throws IOException {
        long endTime;
        NameNodeMetrics metrics;
        DatanodeDescriptor node;
        this.namesystem.writeLock();
        long startTime = Time.monotonicNow();
        Collection<Object> invalidatedBlocks = Collections.emptyList();
        String strBlockReportId = context != null ? Long.toHexString(context.getReportId()) : "";
        try {
            node = this.datanodeManager.getDatanode(nodeID);
            if (node == null || !node.isRegistered()) {
                throw new IOException("ProcessReport from dead or unregistered node: " + nodeID);
            }
            Object storageInfo = this.providedStorageMap.getStorage(node, storage);
            if (storageInfo == null) {
                storageInfo = node.updateStorage(storage);
            }
            if (this.namesystem.isInStartupSafeMode() && !StorageType.PROVIDED.equals((Object)((DatanodeStorageInfo)storageInfo).getStorageType()) && ((DatanodeStorageInfo)storageInfo).getBlockReportCount() > 0) {
                blockLog.info("BLOCK* processReport 0x{}: discarded non-initial block report from {} because namenode still in startup phase", (Object)strBlockReportId, (Object)nodeID);
                this.blockReportLeaseManager.removeLease(node);
                boolean bl = !node.hasStaleStorages();
                return bl;
            }
            if (((DatanodeStorageInfo)storageInfo).getBlockReportCount() == 0) {
                blockLog.info("BLOCK* processReport 0x{}: Processing first storage report for {} from datanode {}", new Object[]{strBlockReportId, ((DatanodeStorageInfo)storageInfo).getStorageID(), nodeID.getDatanodeUuid()});
                this.processFirstBlockReport((DatanodeStorageInfo)storageInfo, newReport);
            } else if (!StorageType.PROVIDED.equals((Object)((DatanodeStorageInfo)storageInfo).getStorageType())) {
                invalidatedBlocks = this.processReport((DatanodeStorageInfo)storageInfo, newReport);
            }
            ((DatanodeStorageInfo)storageInfo).receivedBlockReport();
        }
        finally {
            long endTime2 = Time.monotonicNow();
            this.namesystem.writeUnlock();
        }
        if (blockLog.isDebugEnabled()) {
            for (Block block : invalidatedBlocks) {
                blockLog.debug("BLOCK* processReport 0x{}: {} on node {} size {} does not belong to any file.", new Object[]{strBlockReportId, block, node, block.getNumBytes()});
            }
        }
        if ((metrics = NameNode.getNameNodeMetrics()) != null) {
            metrics.addStorageBlockReport((int)(endTime - startTime));
        }
        blockLog.info("BLOCK* processReport 0x{}: from storage {} node {}, blocks: {}, hasStaleStorage: {}, processing time: {} msecs, invalidatedBlocks: {}", new Object[]{strBlockReportId, storage.getStorageID(), nodeID, newReport.getNumberOfBlocks(), node.hasStaleStorages(), endTime - startTime, invalidatedBlocks.size()});
        return !node.hasStaleStorages();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeBRLeaseIfNeeded(DatanodeID nodeID, BlockReportContext context) throws IOException {
        this.namesystem.writeLock();
        try {
            DatanodeDescriptor node = this.datanodeManager.getDatanode(nodeID);
            if (context != null) {
                if (context.getTotalRpcs() == context.getCurRpc() + 1) {
                    long leaseId = this.getBlockReportLeaseManager().removeLease(node);
                    BlockManagerFaultInjector.getInstance().removeBlockReportLease(node, leaseId);
                    node.setLastBlockReportTime(Time.now());
                    node.setLastBlockReportMonotonic(Time.monotonicNow());
                }
                LOG.debug("Processing RPC with index {} out of total {} RPCs in processReport 0x{}", new Object[]{context.getCurRpc(), context.getTotalRpcs(), Long.toHexString(context.getReportId())});
            }
        }
        finally {
            this.namesystem.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void rescanPostponedMisreplicatedBlocks() {
        if (this.getPostponedMisreplicatedBlocksCount() == 0L) {
            return;
        }
        this.namesystem.writeLock();
        long startTime = Time.monotonicNow();
        long startSize = this.postponedMisreplicatedBlocks.size();
        try {
            Iterator<Block> it = this.postponedMisreplicatedBlocks.iterator();
            for (int i = 0; i < this.blocksPerPostpondedRescan && it.hasNext(); ++i) {
                Block b = it.next();
                it.remove();
                BlockInfo bi = this.getStoredBlock(b);
                if (bi == null) {
                    LOG.debug("BLOCK* rescanPostponedMisreplicatedBlocks: Postponed mis-replicated block {} no longer found in block map.", (Object)b);
                    continue;
                }
                MisReplicationResult res = this.processMisReplicatedBlock(bi);
                LOG.debug("BLOCK* rescanPostponedMisreplicatedBlocks: Re-scanned block {}, result is {}", (Object)b, (Object)res);
                if (res != MisReplicationResult.POSTPONE) continue;
                this.rescannedMisreplicatedBlocks.add(b);
            }
            this.postponedMisreplicatedBlocks.addAll(this.rescannedMisreplicatedBlocks);
        }
        catch (Throwable throwable) {
            this.postponedMisreplicatedBlocks.addAll(this.rescannedMisreplicatedBlocks);
            this.rescannedMisreplicatedBlocks.clear();
            long endSize = this.postponedMisreplicatedBlocks.size();
            this.namesystem.writeUnlock();
            LOG.info("Rescan of postponedMisreplicatedBlocks completed in {} msecs. {} blocks are left. {} blocks were removed.", new Object[]{Time.monotonicNow() - startTime, endSize, startSize - endSize});
            throw throwable;
        }
        this.rescannedMisreplicatedBlocks.clear();
        long endSize = this.postponedMisreplicatedBlocks.size();
        this.namesystem.writeUnlock();
        LOG.info("Rescan of postponedMisreplicatedBlocks completed in {} msecs. {} blocks are left. {} blocks were removed.", new Object[]{Time.monotonicNow() - startTime, endSize, startSize - endSize});
    }

    Collection<Block> processReport(DatanodeStorageInfo storageInfo, BlockListAsLongs report) throws IOException {
        ArrayList<BlockInfoToAdd> toAdd = new ArrayList<BlockInfoToAdd>();
        HashSet<BlockInfo> toRemove = new HashSet<BlockInfo>();
        ArrayList<Block> toInvalidate = new ArrayList<Block>();
        ArrayList<BlockToMarkCorrupt> toCorrupt = new ArrayList<BlockToMarkCorrupt>();
        ArrayList<StatefulBlockInfo> toUC = new ArrayList<StatefulBlockInfo>();
        this.reportDiff(storageInfo, report, toAdd, toRemove, toInvalidate, toCorrupt, toUC);
        DatanodeDescriptor node = storageInfo.getDatanodeDescriptor();
        for (StatefulBlockInfo statefulBlockInfo : toUC) {
            this.addStoredBlockUnderConstruction(statefulBlockInfo, storageInfo);
        }
        for (BlockInfo blockInfo : toRemove) {
            this.removeStoredBlock(blockInfo, node);
        }
        int numBlocksLogged = 0;
        for (BlockInfoToAdd blockInfoToAdd : toAdd) {
            this.addStoredBlock(blockInfoToAdd.stored, blockInfoToAdd.reported, storageInfo, null, (long)numBlocksLogged < this.maxNumBlocksToLog);
            ++numBlocksLogged;
        }
        if ((long)numBlocksLogged > this.maxNumBlocksToLog) {
            blockLog.info("BLOCK* processReport: logged info for {} of {} reported.", (Object)this.maxNumBlocksToLog, (Object)numBlocksLogged);
        }
        for (Block block : toInvalidate) {
            this.addToInvalidates(block, node);
        }
        for (BlockToMarkCorrupt blockToMarkCorrupt : toCorrupt) {
            this.markBlockAsCorrupt(blockToMarkCorrupt, storageInfo, node);
        }
        return toInvalidate;
    }

    public void markBlockReplicasAsCorrupt(Block oldBlock, BlockInfo block, long oldGenerationStamp, long oldNumBytes, DatanodeStorageInfo[] newStorages) throws IOException {
        assert (this.namesystem.hasWriteLock());
        BlockToMarkCorrupt b = null;
        if (block.getGenerationStamp() != oldGenerationStamp) {
            b = new BlockToMarkCorrupt(oldBlock, block, oldGenerationStamp, "genstamp does not match " + oldGenerationStamp + " : " + block.getGenerationStamp(), CorruptReplicasMap.Reason.GENSTAMP_MISMATCH);
        } else if (block.getNumBytes() != oldNumBytes) {
            b = new BlockToMarkCorrupt(oldBlock, block, "length does not match " + oldNumBytes + " : " + block.getNumBytes(), CorruptReplicasMap.Reason.SIZE_MISMATCH);
        } else {
            return;
        }
        for (DatanodeStorageInfo storage : this.getStorages(block)) {
            boolean isCorrupt = true;
            if (newStorages != null) {
                for (DatanodeStorageInfo newStorage : newStorages) {
                    if (newStorage == null || !storage.equals(newStorage)) continue;
                    isCorrupt = false;
                    break;
                }
            }
            if (!isCorrupt) continue;
            blockLog.debug("BLOCK* markBlockReplicasAsCorrupt: mark block replica {} on {} as corrupt because the dn is not in the new committed storage list.", (Object)b, (Object)storage.getDatanodeDescriptor());
            this.markBlockAsCorrupt(b, storage, storage.getDatanodeDescriptor());
        }
    }

    void processFirstBlockReport(DatanodeStorageInfo storageInfo, BlockListAsLongs report) throws IOException {
        if (report == null) {
            return;
        }
        assert (this.namesystem.hasWriteLock());
        assert (storageInfo.getBlockReportCount() == 0);
        for (BlockListAsLongs.BlockReportReplica iblk : report) {
            HdfsServerConstants.ReplicaState reportedState = iblk.getState();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Initial report of block {} on {} size {} replicaState = {}", new Object[]{iblk.getBlockName(), storageInfo.getDatanodeDescriptor(), iblk.getNumBytes(), reportedState});
            }
            if (this.shouldPostponeBlocksFromFuture && this.isGenStampInFuture(iblk)) {
                this.queueReportedBlock(storageInfo, iblk, reportedState, QUEUE_REASON_FUTURE_GENSTAMP);
                continue;
            }
            BlockInfo storedBlock = this.getStoredBlock(iblk);
            if (storedBlock == null) {
                this.bmSafeMode.checkBlocksWithFutureGS(iblk);
                continue;
            }
            HdfsServerConstants.BlockUCState ucState = storedBlock.getBlockUCState();
            BlockToMarkCorrupt c = this.checkReplicaCorrupt(iblk, reportedState, storedBlock, ucState, storageInfo.getDatanodeDescriptor());
            if (c != null) {
                if (this.shouldPostponeBlocksFromFuture) {
                    this.queueReportedBlock(storageInfo, iblk, reportedState, QUEUE_REASON_CORRUPT_STATE);
                    continue;
                }
                this.markBlockAsCorrupt(c, storageInfo, storageInfo.getDatanodeDescriptor());
                continue;
            }
            if (this.isBlockUnderConstruction(storedBlock, ucState, reportedState)) {
                storedBlock.getUnderConstructionFeature().addReplicaIfNotPresent(storageInfo, iblk, reportedState);
                if (this.namesystem.isInSnapshot(storedBlock.getBlockCollectionId())) {
                    int numOfReplicas = storedBlock.getUnderConstructionFeature().getNumExpectedLocations();
                    this.bmSafeMode.incrementSafeBlockCount(numOfReplicas, storedBlock);
                }
            }
            if (reportedState != HdfsServerConstants.ReplicaState.FINALIZED) continue;
            this.addStoredBlockImmediate(storedBlock, iblk, storageInfo);
        }
    }

    private void reportDiff(DatanodeStorageInfo storageInfo, BlockListAsLongs newReport, Collection<BlockInfoToAdd> toAdd, Collection<BlockInfo> toRemove, Collection<Block> toInvalidate, Collection<BlockToMarkCorrupt> toCorrupt, Collection<StatefulBlockInfo> toUC) {
        DatanodeDescriptor dn = storageInfo.getDatanodeDescriptor();
        Block delimiterBlock = new Block();
        BlockInfoContiguous delimiter = new BlockInfoContiguous(delimiterBlock, 1);
        DatanodeStorageInfo.AddBlockResult result = storageInfo.addBlock(delimiter, delimiterBlock);
        assert (result == DatanodeStorageInfo.AddBlockResult.ADDED) : "Delimiting block cannot be present in the node";
        int headIndex = 0;
        if (newReport == null) {
            newReport = BlockListAsLongs.EMPTY;
        }
        for (BlockListAsLongs.BlockReportReplica iblk : newReport) {
            int curIndex;
            HdfsServerConstants.ReplicaState iState = iblk.getState();
            LOG.debug("Reported block {} on {} size {} replicaState = {}", new Object[]{iblk, dn, iblk.getNumBytes(), iState});
            BlockInfo storedBlock = this.processReportedBlock(storageInfo, iblk, iState, toAdd, toInvalidate, toCorrupt, toUC);
            if (storedBlock == null || (curIndex = storedBlock.findStorageInfo(storageInfo)) < 0) continue;
            headIndex = storageInfo.moveBlockToHead(storedBlock, curIndex, headIndex);
        }
        DatanodeStorageInfo datanodeStorageInfo = storageInfo;
        datanodeStorageInfo.getClass();
        DatanodeStorageInfo.BlockIterator it = datanodeStorageInfo.new DatanodeStorageInfo.BlockIterator(delimiter.getNext(0));
        while (it.hasNext()) {
            toRemove.add((BlockInfo)((Object)it.next()));
        }
        storageInfo.removeBlock(delimiter);
    }

    private BlockInfo processReportedBlock(DatanodeStorageInfo storageInfo, Block block, HdfsServerConstants.ReplicaState reportedState, Collection<BlockInfoToAdd> toAdd, Collection<Block> toInvalidate, Collection<BlockToMarkCorrupt> toCorrupt, Collection<StatefulBlockInfo> toUC) {
        DatanodeDescriptor dn = storageInfo.getDatanodeDescriptor();
        LOG.debug("Reported block {} on {} size {} replicaState = {}", new Object[]{block, dn, block.getNumBytes(), reportedState});
        if (this.shouldPostponeBlocksFromFuture && this.isGenStampInFuture(block)) {
            this.queueReportedBlock(storageInfo, block, reportedState, QUEUE_REASON_FUTURE_GENSTAMP);
            return null;
        }
        BlockInfo storedBlock = this.getStoredBlock(block);
        if (storedBlock == null) {
            toInvalidate.add(new Block(block));
            return null;
        }
        HdfsServerConstants.BlockUCState ucState = storedBlock.getBlockUCState();
        LOG.debug("In memory blockUCState = {}", (Object)ucState);
        if (this.invalidateBlocks.contains(dn, block)) {
            return storedBlock;
        }
        BlockToMarkCorrupt c = this.checkReplicaCorrupt(block, reportedState, storedBlock, ucState, dn);
        if (c != null) {
            if (this.shouldPostponeBlocksFromFuture) {
                this.queueReportedBlock(storageInfo, block, reportedState, QUEUE_REASON_CORRUPT_STATE);
            } else {
                toCorrupt.add(c);
            }
            return storedBlock;
        }
        if (this.isBlockUnderConstruction(storedBlock, ucState, reportedState)) {
            toUC.add(new StatefulBlockInfo(storedBlock, new Block(block), reportedState));
            return storedBlock;
        }
        if (reportedState == HdfsServerConstants.ReplicaState.FINALIZED && (storedBlock.findStorageInfo(storageInfo) == -1 || this.corruptReplicas.isReplicaCorrupt(storedBlock, dn))) {
            toAdd.add(new BlockInfoToAdd(storedBlock, new Block(block)));
        }
        return storedBlock;
    }

    private void queueReportedBlock(DatanodeStorageInfo storageInfo, Block block, HdfsServerConstants.ReplicaState reportedState, String reason) {
        assert (this.shouldPostponeBlocksFromFuture);
        LOG.debug("Queueing reported block {} in state {} from datanode {} for later processing because {}.", new Object[]{block, reportedState, storageInfo.getDatanodeDescriptor(), reason});
        this.pendingDNMessages.enqueueReportedBlock(storageInfo, block, reportedState);
    }

    public void processQueuedMessagesForBlock(Block b) throws IOException {
        Queue<PendingDataNodeMessages.ReportedBlockInfo> queue = this.pendingDNMessages.takeBlockQueue(b);
        if (queue == null) {
            return;
        }
        this.processQueuedMessages(queue);
    }

    private void processQueuedMessages(Iterable<PendingDataNodeMessages.ReportedBlockInfo> rbis) throws IOException {
        boolean isPreviousMessageProcessed = true;
        for (PendingDataNodeMessages.ReportedBlockInfo rbi : rbis) {
            LOG.debug("Processing previouly queued message {}", (Object)rbi);
            if (rbi.getReportedState() == null) {
                DatanodeStorageInfo storageInfo = rbi.getStorageInfo();
                this.removeStoredBlock(this.getStoredBlock(rbi.getBlock()), storageInfo.getDatanodeDescriptor());
                continue;
            }
            if (!isPreviousMessageProcessed) {
                this.queueReportedBlock(rbi.getStorageInfo(), rbi.getBlock(), rbi.getReportedState(), QUEUE_REASON_FUTURE_GENSTAMP);
                continue;
            }
            isPreviousMessageProcessed = this.processAndHandleReportedBlock(rbi.getStorageInfo(), rbi.getBlock(), rbi.getReportedState(), null);
        }
    }

    public void processAllPendingDNMessages() throws IOException {
        assert (!this.shouldPostponeBlocksFromFuture) : "processAllPendingDNMessages() should be called after disabling block postponement.";
        int count = this.pendingDNMessages.count();
        if (count > 0) {
            LOG.info("Processing {} messages from DataNodes that were previously queued during standby state", (Object)count);
        }
        this.processQueuedMessages(this.pendingDNMessages.takeAll());
        assert (this.pendingDNMessages.count() == 0);
    }

    private BlockToMarkCorrupt checkReplicaCorrupt(Block reported, HdfsServerConstants.ReplicaState reportedState, BlockInfo storedBlock, HdfsServerConstants.BlockUCState ucState, DatanodeDescriptor dn) {
        switch (reportedState) {
            case FINALIZED: {
                switch (ucState) {
                    case COMPLETE: 
                    case COMMITTED: {
                        boolean wrongSize;
                        long blockMapSize;
                        if (storedBlock.getGenerationStamp() != reported.getGenerationStamp()) {
                            long reportedGS = reported.getGenerationStamp();
                            return new BlockToMarkCorrupt(new Block(reported), storedBlock, reportedGS, "block is " + (Object)((Object)ucState) + " and reported genstamp " + reportedGS + " does not match genstamp in block map " + storedBlock.getGenerationStamp(), CorruptReplicasMap.Reason.GENSTAMP_MISMATCH);
                        }
                        if (storedBlock.isStriped()) {
                            assert (BlockIdManager.isStripedBlockID(reported.getBlockId()));
                            assert (storedBlock.getBlockId() == BlockIdManager.convertToStripedID(reported.getBlockId()));
                            BlockInfoStriped stripedBlock = (BlockInfoStriped)storedBlock;
                            byte reportedBlkIdx = BlockIdManager.getBlockIndex(reported);
                            blockMapSize = StripedBlockUtil.getInternalBlockLength((long)stripedBlock.getNumBytes(), (int)stripedBlock.getCellSize(), (int)stripedBlock.getDataBlockNum(), (int)reportedBlkIdx);
                            wrongSize = reported.getNumBytes() != blockMapSize;
                        } else {
                            blockMapSize = storedBlock.getNumBytes();
                            boolean bl = wrongSize = blockMapSize != reported.getNumBytes();
                        }
                        if (wrongSize) {
                            return new BlockToMarkCorrupt(new Block(reported), storedBlock, "block is " + (Object)((Object)ucState) + " and reported length " + reported.getNumBytes() + " does not match length in block map " + blockMapSize, CorruptReplicasMap.Reason.SIZE_MISMATCH);
                        }
                        return null;
                    }
                    case UNDER_CONSTRUCTION: {
                        if (storedBlock.getGenerationStamp() > reported.getGenerationStamp()) {
                            long reportedGS = reported.getGenerationStamp();
                            return new BlockToMarkCorrupt(new Block(reported), storedBlock, reportedGS, "block is " + (Object)((Object)ucState) + " and reported state " + (Object)((Object)reportedState) + ", But reported genstamp " + reportedGS + " does not match genstamp in block map " + storedBlock.getGenerationStamp(), CorruptReplicasMap.Reason.GENSTAMP_MISMATCH);
                        }
                        return null;
                    }
                }
                return null;
            }
            case RBW: 
            case RWR: {
                long reportedGS = reported.getGenerationStamp();
                if (!storedBlock.isComplete()) {
                    if (storedBlock.getGenerationStamp() > reported.getGenerationStamp()) {
                        return new BlockToMarkCorrupt(new Block(reported), storedBlock, reportedGS, "reported " + (Object)((Object)reportedState) + " replica with genstamp " + reportedGS + " does not match Stored block's genstamp in block map " + storedBlock.getGenerationStamp(), CorruptReplicasMap.Reason.GENSTAMP_MISMATCH);
                    }
                    return null;
                }
                if (storedBlock.getGenerationStamp() != reported.getGenerationStamp()) {
                    return new BlockToMarkCorrupt(new Block(reported), storedBlock, reportedGS, "reported " + (Object)((Object)reportedState) + " replica with genstamp " + reportedGS + " does not match COMPLETE block's genstamp in block map " + storedBlock.getGenerationStamp(), CorruptReplicasMap.Reason.GENSTAMP_MISMATCH);
                }
                if (reportedState == HdfsServerConstants.ReplicaState.RBW) {
                    LOG.info("Received an RBW replica for {} on {}: ignoring it, since it is complete with the same genstamp", (Object)storedBlock, (Object)dn);
                    return null;
                }
                return new BlockToMarkCorrupt(new Block(reported), storedBlock, "reported replica has invalid state " + (Object)((Object)reportedState), CorruptReplicasMap.Reason.INVALID_STATE);
            }
        }
        String msg = "Unexpected replica state " + (Object)((Object)reportedState) + " for block: " + (Object)((Object)storedBlock) + " on " + (Object)((Object)dn) + " size " + storedBlock.getNumBytes();
        LOG.warn("{}", (Object)msg);
        return new BlockToMarkCorrupt(new Block(reported), storedBlock, msg, CorruptReplicasMap.Reason.INVALID_STATE);
    }

    private boolean isBlockUnderConstruction(BlockInfo storedBlock, HdfsServerConstants.BlockUCState ucState, HdfsServerConstants.ReplicaState reportedState) {
        switch (reportedState) {
            case FINALIZED: {
                switch (ucState) {
                    case UNDER_CONSTRUCTION: 
                    case UNDER_RECOVERY: {
                        return true;
                    }
                }
                return false;
            }
            case RBW: 
            case RWR: {
                return !storedBlock.isComplete();
            }
        }
        return false;
    }

    void addStoredBlockUnderConstruction(StatefulBlockInfo ucBlock, DatanodeStorageInfo storageInfo) throws IOException {
        BlockInfo block = ucBlock.storedBlock;
        block.getUnderConstructionFeature().addReplicaIfNotPresent(storageInfo, ucBlock.reportedBlock, ucBlock.reportedState);
        if (ucBlock.reportedState == HdfsServerConstants.ReplicaState.FINALIZED && block.findStorageInfo(storageInfo) < 0 || this.corruptReplicas.isReplicaCorrupt(block, storageInfo.getDatanodeDescriptor())) {
            this.addStoredBlock(block, ucBlock.reportedBlock, storageInfo, null, true);
        }
    }

    private void addStoredBlockImmediate(BlockInfo storedBlock, Block reported, DatanodeStorageInfo storageInfo) throws IOException {
        assert (storedBlock != null && this.namesystem.hasWriteLock());
        if (!this.namesystem.isInStartupSafeMode() || this.isPopulatingReplQueues()) {
            this.addStoredBlock(storedBlock, reported, storageInfo, null, false);
            return;
        }
        DatanodeStorageInfo.AddBlockResult result = storageInfo.addBlock(storedBlock, reported);
        int numCurrentReplica = this.countLiveNodes(storedBlock);
        if (storedBlock.getBlockUCState() == HdfsServerConstants.BlockUCState.COMMITTED && this.hasMinStorage(storedBlock, numCurrentReplica)) {
            this.completeBlock(storedBlock, null, false);
        } else if (storedBlock.isComplete() && result == DatanodeStorageInfo.AddBlockResult.ADDED) {
            this.bmSafeMode.incrementSafeBlockCount(numCurrentReplica, storedBlock);
        }
    }

    private Block addStoredBlock(BlockInfo block, Block reportedBlock, DatanodeStorageInfo storageInfo, DatanodeDescriptor delNodeHint, boolean logEveryBlock) throws IOException {
        int curReplicaDelta;
        assert (block != null && this.namesystem.hasWriteLock());
        DatanodeDescriptor node = storageInfo.getDatanodeDescriptor();
        BlockInfo storedBlock = !block.isComplete() ? this.getStoredBlock(block) : block;
        if (storedBlock == null || storedBlock.isDeleted()) {
            blockLog.debug("BLOCK* addStoredBlock: {} on {} size {} but it does not belong to any file", new Object[]{block, node, block.getNumBytes()});
            return block;
        }
        DatanodeStorageInfo.AddBlockResult result = storageInfo.addBlock(storedBlock, reportedBlock);
        if (result == DatanodeStorageInfo.AddBlockResult.ADDED) {
            int n = curReplicaDelta = node.isDecommissioned() || node.isDecommissionInProgress() ? 0 : 1;
            if (logEveryBlock) {
                blockLog.debug("BLOCK* addStoredBlock: {} is added to {} (size={})", new Object[]{node, storedBlock, storedBlock.getNumBytes()});
            }
        } else if (result == DatanodeStorageInfo.AddBlockResult.REPLACED) {
            curReplicaDelta = 0;
            blockLog.warn("BLOCK* addStoredBlock: block {} moved to storageType {} on node {}", new Object[]{storedBlock, storageInfo.getStorageType(), node});
        } else {
            this.corruptReplicas.removeFromCorruptReplicasMap(block, node, CorruptReplicasMap.Reason.GENSTAMP_MISMATCH);
            curReplicaDelta = 0;
            blockLog.debug("BLOCK* addStoredBlock: Redundant addStoredBlock request received for {} on node {} size {}", new Object[]{storedBlock, node, storedBlock.getNumBytes()});
        }
        NumberReplicas num = this.countNodes(storedBlock);
        int numLiveReplicas = num.liveReplicas();
        int pendingNum = this.pendingReconstruction.getNumReplicas(storedBlock);
        int numCurrentReplica = numLiveReplicas + pendingNum;
        int numUsableReplicas = num.liveReplicas() + num.decommissioning() + num.liveEnteringMaintenanceReplicas();
        if (storedBlock.getBlockUCState() == HdfsServerConstants.BlockUCState.COMMITTED && this.hasMinStorage(storedBlock, numUsableReplicas)) {
            this.addExpectedReplicasToPending(storedBlock);
            this.completeBlock(storedBlock, null, false);
        } else if (storedBlock.isComplete() && result == DatanodeStorageInfo.AddBlockResult.ADDED) {
            this.bmSafeMode.incrementSafeBlockCount(numCurrentReplica, storedBlock);
        }
        if (!storedBlock.isCompleteOrCommitted()) {
            return storedBlock;
        }
        if (!this.isPopulatingReplQueues()) {
            return storedBlock;
        }
        short fileRedundancy = this.getExpectedRedundancyNum(storedBlock);
        if (!this.isNeededReconstruction(storedBlock, num, pendingNum)) {
            this.neededReconstruction.remove(storedBlock, numCurrentReplica, num.readOnlyReplicas(), num.outOfServiceReplicas(), fileRedundancy);
        } else {
            this.updateNeededReconstructions(storedBlock, curReplicaDelta, 0);
        }
        if (this.shouldProcessExtraRedundancy(num, fileRedundancy)) {
            this.processExtraRedundancyBlock(storedBlock, fileRedundancy, node, delNodeHint);
        }
        int corruptReplicasCount = this.corruptReplicas.numCorruptReplicas(storedBlock);
        int numCorruptNodes = num.corruptReplicas();
        if (numCorruptNodes != corruptReplicasCount) {
            LOG.warn("Inconsistent number of corrupt replicas for {}. blockMap has {} but corrupt replicas map has {}", new Object[]{storedBlock, numCorruptNodes, corruptReplicasCount});
        }
        if (corruptReplicasCount > 0 && numLiveReplicas >= fileRedundancy) {
            this.invalidateCorruptReplicas(storedBlock, reportedBlock, num);
        }
        return storedBlock;
    }

    private boolean shouldProcessExtraRedundancy(NumberReplicas num, int expectedNum) {
        int numCurrent = num.liveReplicas();
        return numCurrent > expectedNum || num.redundantInternalBlocks() > 0;
    }

    private void invalidateCorruptReplicas(BlockInfo blk, Block reported, NumberReplicas numberReplicas) {
        DatanodeDescriptor[] nodesCopy;
        Collection<DatanodeDescriptor> nodes = this.corruptReplicas.getNodes(blk);
        boolean removedFromBlocksMap = true;
        if (nodes == null) {
            return;
        }
        for (DatanodeDescriptor node : nodesCopy = nodes.toArray(new DatanodeDescriptor[nodes.size()])) {
            try {
                if (this.invalidateBlock(new BlockToMarkCorrupt(reported, blk, null, CorruptReplicasMap.Reason.ANY), node, numberReplicas)) continue;
                removedFromBlocksMap = false;
            }
            catch (IOException e) {
                blockLog.debug("invalidateCorruptReplicas error in deleting bad block {} on {}", new Object[]{blk, node, e});
                removedFromBlocksMap = false;
            }
        }
        if (removedFromBlocksMap) {
            this.corruptReplicas.removeFromCorruptReplicasMap(blk);
        }
    }

    public void processMisReplicatedBlocks() {
        assert (this.namesystem.hasWriteLock());
        this.stopReconstructionInitializer();
        this.neededReconstruction.clear();
        this.reconstructionQueuesInitializer = new Daemon(){

            public void run() {
                try {
                    BlockManager.this.processMisReplicatesAsync();
                }
                catch (InterruptedException ie) {
                    LOG.info("Interrupted while processing reconstruction queues.");
                }
                catch (Exception e) {
                    LOG.error("Error while processing reconstruction queues async", (Throwable)e);
                }
            }
        };
        this.reconstructionQueuesInitializer.setName("Reconstruction Queue Initializer");
        this.reconstructionQueuesInitializer.start();
    }

    private void stopReconstructionInitializer() {
        if (this.reconstructionQueuesInitializer != null) {
            this.reconstructionQueuesInitializer.interrupt();
            try {
                this.reconstructionQueuesInitializer.join();
            }
            catch (InterruptedException e) {
                LOG.warn("Interrupted while waiting for reconstructionQueueInitializer. Returning..");
                return;
            }
            finally {
                this.reconstructionQueuesInitializer = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processMisReplicatesAsync() throws InterruptedException {
        long nrInvalid = 0L;
        long nrOverReplicated = 0L;
        long nrUnderReplicated = 0L;
        long nrPostponed = 0L;
        long nrUnderConstruction = 0L;
        long startTimeMisReplicatedScan = Time.monotonicNow();
        Iterator<BlockInfo> blocksItr = this.blocksMap.getBlocks().iterator();
        long totalBlocks = this.blocksMap.size();
        this.reconstructionQueuesInitProgress = 0.0;
        long totalProcessed = 0L;
        long sleepDuration = Math.max(1, Math.min(this.numBlocksPerIteration / 1000, 10000));
        while (this.namesystem.isRunning() && !Thread.currentThread().isInterrupted()) {
            this.namesystem.writeLockInterruptibly();
            try {
                int processed;
                block12: for (processed = 0; processed < this.numBlocksPerIteration && blocksItr.hasNext(); ++processed) {
                    BlockInfo block = blocksItr.next();
                    MisReplicationResult res = this.processMisReplicatedBlock(block);
                    switch (res) {
                        case UNDER_REPLICATED: {
                            LOG.trace("under replicated block {}: {}", (Object)block, (Object)res);
                            ++nrUnderReplicated;
                            continue block12;
                        }
                        case OVER_REPLICATED: {
                            LOG.trace("over replicated block {}: {}", (Object)block, (Object)res);
                            ++nrOverReplicated;
                            continue block12;
                        }
                        case INVALID: {
                            LOG.trace("invalid block {}: {}", (Object)block, (Object)res);
                            ++nrInvalid;
                            continue block12;
                        }
                        case POSTPONE: {
                            LOG.trace("postpone block {}: {}", (Object)block, (Object)res);
                            ++nrPostponed;
                            this.postponeBlock(block);
                            continue block12;
                        }
                        case UNDER_CONSTRUCTION: {
                            LOG.trace("under construction block {}: {}", (Object)block, (Object)res);
                            ++nrUnderConstruction;
                            continue block12;
                        }
                        case OK: {
                            continue block12;
                        }
                        default: {
                            throw new AssertionError((Object)("Invalid enum value: " + (Object)((Object)res)));
                        }
                    }
                }
                this.reconstructionQueuesInitProgress = Math.min((double)(totalProcessed += (long)processed) / (double)totalBlocks, 1.0);
                if (blocksItr.hasNext()) continue;
                LOG.info("Total number of blocks            = {}", (Object)this.blocksMap.size());
                LOG.info("Number of invalid blocks          = {}", (Object)nrInvalid);
                LOG.info("Number of under-replicated blocks = {}", (Object)nrUnderReplicated);
                LOG.info("Number of  over-replicated blocks = {}{}", (Object)nrOverReplicated, (Object)(nrPostponed > 0L ? " (" + nrPostponed + " postponed)" : ""));
                LOG.info("Number of blocks being written    = {}", (Object)nrUnderConstruction);
                NameNode.stateChangeLog.info("STATE* Replication Queue initialization scan for invalid, over- and under-replicated blocks completed in " + (Time.monotonicNow() - startTimeMisReplicatedScan) + " msec");
                break;
            }
            finally {
                this.namesystem.writeUnlock();
                Thread.sleep(sleepDuration);
            }
        }
        if (Thread.currentThread().isInterrupted()) {
            LOG.info("Interrupted while processing replication queues.");
        }
    }

    public double getReconstructionQueuesInitProgress() {
        return this.reconstructionQueuesInitProgress;
    }

    public boolean hasNonEcBlockUsingStripedID() {
        return this.hasNonEcBlockUsingStripedID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int processMisReplicatedBlocks(List<BlockInfo> blocks) {
        int processed = 0;
        Iterator<BlockInfo> iter = blocks.iterator();
        try {
            while (this.isPopulatingReplQueues() && this.namesystem.isRunning() && !Thread.currentThread().isInterrupted() && iter.hasNext()) {
                int limit = processed + this.numBlocksPerIteration;
                this.namesystem.writeLockInterruptibly();
                try {
                    while (iter.hasNext() && processed < limit) {
                        BlockInfo blk = iter.next();
                        MisReplicationResult r = this.processMisReplicatedBlock(blk);
                        ++processed;
                        LOG.debug("BLOCK* processMisReplicatedBlocks: Re-scanned block {}, result is {}", (Object)blk, (Object)r);
                    }
                }
                finally {
                    this.namesystem.writeUnlock();
                }
            }
        }
        catch (InterruptedException ex) {
            LOG.info("Caught InterruptedException while scheduling replication work for mis-replicated blocks");
            Thread.currentThread().interrupt();
        }
        return processed;
    }

    private MisReplicationResult processMisReplicatedBlock(BlockInfo block) {
        if (block.isDeleted()) {
            this.addToInvalidates(block);
            return MisReplicationResult.INVALID;
        }
        if (!block.isComplete()) {
            return MisReplicationResult.UNDER_CONSTRUCTION;
        }
        short expectedRedundancy = this.getExpectedRedundancyNum(block);
        NumberReplicas num = this.countNodes(block);
        int numCurrentReplica = num.liveReplicas();
        if (this.isNeededReconstruction(block, num) && this.neededReconstruction.add(block, numCurrentReplica, num.readOnlyReplicas(), num.outOfServiceReplicas(), expectedRedundancy)) {
            return MisReplicationResult.UNDER_REPLICATED;
        }
        if (this.shouldProcessExtraRedundancy(num, expectedRedundancy)) {
            if (num.replicasOnStaleNodes() > 0) {
                return MisReplicationResult.POSTPONE;
            }
            this.processExtraRedundancyBlock(block, expectedRedundancy, null, null);
            return MisReplicationResult.OVER_REPLICATED;
        }
        return MisReplicationResult.OK;
    }

    public void setReplication(short oldRepl, short newRepl, BlockInfo b) {
        if (newRepl == oldRepl) {
            return;
        }
        b.setReplication(newRepl);
        NumberReplicas num = this.countNodes(b);
        this.updateNeededReconstructions(b, 0, newRepl - oldRepl);
        if (this.shouldProcessExtraRedundancy(num, newRepl)) {
            this.processExtraRedundancyBlock(b, newRepl, null, null);
        }
    }

    private void processExtraRedundancyBlock(BlockInfo block, short replication, DatanodeDescriptor addedNode, DatanodeDescriptor delNodeHint) {
        assert (this.namesystem.hasWriteLock());
        if (addedNode == delNodeHint) {
            delNodeHint = null;
        }
        ArrayList<DatanodeStorageInfo> nonExcess = new ArrayList<DatanodeStorageInfo>();
        Collection<DatanodeDescriptor> corruptNodes = this.corruptReplicas.getNodes(block);
        for (DatanodeStorageInfo storage : this.blocksMap.getStorages(block)) {
            if (storage.getState() != DatanodeStorage.State.NORMAL) continue;
            DatanodeDescriptor cur = storage.getDatanodeDescriptor();
            if (storage.areBlockContentsStale()) {
                LOG.trace("BLOCK* processExtraRedundancyBlock: Postponing {} since storage {} does not yet have up-to-date information.", (Object)block, (Object)storage);
                this.postponeBlock(block);
                return;
            }
            if (this.isExcess(cur, block) || !cur.isInService() || corruptNodes != null && corruptNodes.contains((Object)cur)) continue;
            nonExcess.add(storage);
        }
        this.chooseExcessRedundancies(nonExcess, block, replication, addedNode, delNodeHint);
    }

    private void chooseExcessRedundancies(Collection<DatanodeStorageInfo> nonExcess, BlockInfo storedBlock, short replication, DatanodeDescriptor addedNode, DatanodeDescriptor delNodeHint) {
        assert (this.namesystem.hasWriteLock());
        BlockCollection bc = this.getBlockCollection(storedBlock);
        if (storedBlock.isStriped()) {
            this.chooseExcessRedundancyStriped(bc, nonExcess, storedBlock, delNodeHint);
        } else {
            BlockStoragePolicy storagePolicy = this.storagePolicySuite.getPolicy(bc.getStoragePolicyID());
            List excessTypes = storagePolicy.chooseExcess(replication, DatanodeStorageInfo.toStorageTypes(nonExcess));
            this.chooseExcessRedundancyContiguous(nonExcess, storedBlock, replication, addedNode, delNodeHint, excessTypes);
        }
    }

    private void chooseExcessRedundancyContiguous(Collection<DatanodeStorageInfo> nonExcess, BlockInfo storedBlock, short replication, DatanodeDescriptor addedNode, DatanodeDescriptor delNodeHint, List<StorageType> excessTypes) {
        BlockPlacementPolicy replicator = this.placementPolicies.getPolicy(BlockType.CONTIGUOUS);
        List<DatanodeStorageInfo> replicasToDelete = replicator.chooseReplicasToDelete(nonExcess, nonExcess, replication, excessTypes, addedNode, delNodeHint);
        for (DatanodeStorageInfo chosenReplica : replicasToDelete) {
            this.processChosenExcessRedundancy(nonExcess, chosenReplica, storedBlock);
        }
    }

    private void chooseExcessRedundancyStriped(BlockCollection bc, Collection<DatanodeStorageInfo> nonExcess, BlockInfo storedBlock, DatanodeDescriptor delNodeHint) {
        Integer index;
        assert (storedBlock instanceof BlockInfoStriped);
        BlockInfoStriped sblk = (BlockInfoStriped)storedBlock;
        short groupSize = sblk.getTotalBlockNum();
        BitSet found = new BitSet(groupSize);
        BitSet duplicated = new BitSet(groupSize);
        HashMap<DatanodeStorageInfo, Integer> storage2index = new HashMap<DatanodeStorageInfo, Integer>();
        for (DatanodeStorageInfo storage : nonExcess) {
            byte index2 = sblk.getStorageBlockIndex(storage);
            assert (index2 >= 0);
            if (found.get(index2)) {
                duplicated.set(index2);
            }
            found.set(index2);
            storage2index.put(storage, Integer.valueOf(index2));
        }
        DatanodeStorageInfo delStorageHint = DatanodeStorageInfo.getDatanodeStorageInfo(nonExcess, delNodeHint);
        if (delStorageHint != null && (index = (Integer)storage2index.get(delStorageHint)) != null && duplicated.get(index)) {
            this.processChosenExcessRedundancy(nonExcess, delStorageHint, storedBlock);
        }
        int numOfTarget = found.cardinality();
        BlockStoragePolicy storagePolicy = this.storagePolicySuite.getPolicy(bc.getStoragePolicyID());
        List excessTypes = storagePolicy.chooseExcess((short)numOfTarget, DatanodeStorageInfo.toStorageTypes(nonExcess));
        if (excessTypes.isEmpty()) {
            LOG.warn("excess types chosen for block {} among storages {} is empty", (Object)storedBlock, nonExcess);
            return;
        }
        BlockPlacementPolicy placementPolicy = this.placementPolicies.getPolicy(BlockType.STRIPED);
        int targetIndex = duplicated.nextSetBit(0);
        while (targetIndex >= 0) {
            ArrayList<DatanodeStorageInfo> candidates = new ArrayList<DatanodeStorageInfo>();
            for (DatanodeStorageInfo storage : nonExcess) {
                int index3 = (Integer)storage2index.get(storage);
                if (index3 != targetIndex) continue;
                candidates.add(storage);
            }
            if (candidates.size() > 1) {
                List<DatanodeStorageInfo> replicasToDelete = placementPolicy.chooseReplicasToDelete(nonExcess, candidates, 1, excessTypes, null, null);
                for (DatanodeStorageInfo chosen : replicasToDelete) {
                    this.processChosenExcessRedundancy(nonExcess, chosen, storedBlock);
                    candidates.remove(chosen);
                }
            }
            duplicated.clear(targetIndex);
            targetIndex = duplicated.nextSetBit(targetIndex + 1);
        }
    }

    private void processChosenExcessRedundancy(Collection<DatanodeStorageInfo> nonExcess, DatanodeStorageInfo chosen, BlockInfo storedBlock) {
        nonExcess.remove(chosen);
        this.excessRedundancyMap.add(chosen.getDatanodeDescriptor(), storedBlock);
        Block blockToInvalidate = this.getBlockOnStorage(storedBlock, chosen);
        this.addToInvalidates(blockToInvalidate, chosen.getDatanodeDescriptor());
        blockLog.debug("BLOCK* chooseExcessRedundancies: ({}, {}) is added to invalidated blocks set", (Object)chosen, (Object)storedBlock);
    }

    private void removeStoredBlock(DatanodeStorageInfo storageInfo, Block block, DatanodeDescriptor node) {
        if (this.shouldPostponeBlocksFromFuture && this.isGenStampInFuture(block)) {
            this.queueReportedBlock(storageInfo, block, null, QUEUE_REASON_FUTURE_GENSTAMP);
            return;
        }
        this.removeStoredBlock(this.getStoredBlock(block), node);
    }

    public void removeStoredBlock(BlockInfo storedBlock, DatanodeDescriptor node) {
        blockLog.debug("BLOCK* removeStoredBlock: {} from {}", (Object)storedBlock, (Object)node);
        assert (this.namesystem.hasWriteLock());
        if (storedBlock == null || !this.blocksMap.removeNode(storedBlock, node)) {
            blockLog.debug("BLOCK* removeStoredBlock: {} has already been removed from node {}", (Object)storedBlock, (Object)node);
            return;
        }
        CachedBlock cblock = (CachedBlock)this.namesystem.getCacheManager().getCachedBlocks().get((Object)new CachedBlock(storedBlock.getBlockId(), 0, false));
        if (cblock != null) {
            boolean removed = false;
            removed |= node.getPendingCached().remove(cblock);
            removed |= node.getCached().remove(cblock);
            if (removed |= node.getPendingUncached().remove(cblock)) {
                blockLog.debug("BLOCK* removeStoredBlock: {} removed from caching related lists on node {}", (Object)storedBlock, (Object)node);
            }
        }
        if (!storedBlock.isDeleted()) {
            this.bmSafeMode.decrementSafeBlockCount(storedBlock);
            this.updateNeededReconstructions(storedBlock, -1, 0);
        }
        this.excessRedundancyMap.remove(node, storedBlock);
        this.corruptReplicas.removeFromCorruptReplicasMap(storedBlock, node);
    }

    private void removeStaleReplicas(List<ReplicaUnderConstruction> staleReplicas, BlockInfo block) {
        for (ReplicaUnderConstruction r : staleReplicas) {
            this.removeStoredBlock(block, r.getExpectedStorageLocation().getDatanodeDescriptor());
            NameNode.blockStateChangeLog.debug("BLOCK* Removing stale replica {} of {}", (Object)r, (Object)Block.toString((Block)r));
        }
    }

    private long addBlock(BlockInfo block, List<BlocksWithLocations.BlockWithLocations> results) {
        List<DatanodeStorageInfo> locations = this.getValidLocations(block);
        if (locations.size() == 0) {
            return 0L;
        }
        String[] datanodeUuids = new String[locations.size()];
        String[] storageIDs = new String[datanodeUuids.length];
        StorageType[] storageTypes = new StorageType[datanodeUuids.length];
        for (int i = 0; i < locations.size(); ++i) {
            DatanodeStorageInfo s = locations.get(i);
            datanodeUuids[i] = s.getDatanodeDescriptor().getDatanodeUuid();
            storageIDs[i] = s.getStorageID();
            storageTypes[i] = s.getStorageType();
        }
        BlocksWithLocations.BlockWithLocations blkWithLocs = new BlocksWithLocations.BlockWithLocations(block, datanodeUuids, storageIDs, storageTypes);
        if (block.isStriped()) {
            BlockInfoStriped blockStriped = (BlockInfoStriped)block;
            byte[] indices = new byte[locations.size()];
            for (int i = 0; i < locations.size(); ++i) {
                indices[i] = blockStriped.getStorageBlockIndex(locations.get(i));
            }
            results.add(new BlocksWithLocations.StripedBlockWithLocations(blkWithLocs, indices, blockStriped.getDataBlockNum(), blockStriped.getCellSize()));
            return block.getNumBytes() / (long)blockStriped.getDataBlockNum();
        }
        results.add(blkWithLocs);
        return block.getNumBytes();
    }

    @VisibleForTesting
    public void addBlock(DatanodeStorageInfo storageInfo, Block block, String delHint) throws IOException {
        BlockInfo storedBlock;
        DatanodeDescriptor node = storageInfo.getDatanodeDescriptor();
        node.decrementBlocksScheduled(storageInfo.getStorageType());
        DatanodeDescriptor delHintNode = null;
        if (delHint != null && delHint.length() != 0 && (delHintNode = this.datanodeManager.getDatanode(delHint)) == null) {
            blockLog.warn("BLOCK* blockReceived: {} is expected to be removed from an unrecorded node {}", (Object)block, (Object)delHint);
        }
        if ((storedBlock = this.getStoredBlock(block)) != null && block.getGenerationStamp() == storedBlock.getGenerationStamp() && this.pendingReconstruction.decrement(storedBlock, storageInfo)) {
            NameNode.getNameNodeMetrics().incSuccessfulReReplications();
        }
        this.processAndHandleReportedBlock(storageInfo, block, HdfsServerConstants.ReplicaState.FINALIZED, delHintNode);
    }

    private boolean processAndHandleReportedBlock(DatanodeStorageInfo storageInfo, Block block, HdfsServerConstants.ReplicaState reportedState, DatanodeDescriptor delHintNode) throws IOException {
        LinkedList<BlockInfoToAdd> toAdd = new LinkedList<BlockInfoToAdd>();
        LinkedList<Block> toInvalidate = new LinkedList<Block>();
        LinkedList<BlockToMarkCorrupt> toCorrupt = new LinkedList<BlockToMarkCorrupt>();
        LinkedList<StatefulBlockInfo> toUC = new LinkedList<StatefulBlockInfo>();
        DatanodeDescriptor node = storageInfo.getDatanodeDescriptor();
        LOG.debug("Reported block {} on {} size {} replicaState = {}", new Object[]{block, node, block.getNumBytes(), reportedState});
        if (this.shouldPostponeBlocksFromFuture && this.isGenStampInFuture(block)) {
            this.queueReportedBlock(storageInfo, block, reportedState, QUEUE_REASON_FUTURE_GENSTAMP);
            return false;
        }
        this.processReportedBlock(storageInfo, block, reportedState, toAdd, toInvalidate, toCorrupt, toUC);
        assert (toUC.size() + toAdd.size() + toInvalidate.size() + toCorrupt.size() <= 1) : "The block should be only in one of the lists.";
        for (StatefulBlockInfo b : toUC) {
            this.addStoredBlockUnderConstruction(b, storageInfo);
        }
        long numBlocksLogged = 0L;
        for (BlockInfoToAdd blockInfoToAdd : toAdd) {
            this.addStoredBlock(blockInfoToAdd.stored, blockInfoToAdd.reported, storageInfo, delHintNode, numBlocksLogged < this.maxNumBlocksToLog);
            ++numBlocksLogged;
        }
        if (numBlocksLogged > this.maxNumBlocksToLog) {
            blockLog.debug("BLOCK* addBlock: logged info for {} of {} reported.", (Object)this.maxNumBlocksToLog, (Object)numBlocksLogged);
        }
        for (Block block2 : toInvalidate) {
            blockLog.debug("BLOCK* addBlock: block {} on node {} size {} does not belong to any file", new Object[]{block2, node, block2.getNumBytes()});
            this.addToInvalidates(block2, node);
        }
        for (BlockToMarkCorrupt blockToMarkCorrupt : toCorrupt) {
            this.markBlockAsCorrupt(blockToMarkCorrupt, storageInfo, node);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processIncrementalBlockReport(DatanodeID nodeID, StorageReceivedDeletedBlocks srdb) throws IOException {
        assert (this.namesystem.hasWriteLock());
        DatanodeDescriptor node = this.datanodeManager.getDatanode(nodeID);
        if (node == null || !node.isRegistered()) {
            blockLog.warn("BLOCK* processIncrementalBlockReport is received from dead or unregistered node {}", (Object)nodeID);
            throw new IOException("Got incremental block report from unregistered or dead node");
        }
        boolean successful = false;
        try {
            this.processIncrementalBlockReport(node, srdb);
            successful = true;
        }
        finally {
            if (!successful) {
                node.setForceRegistration(true);
            }
        }
    }

    private void processIncrementalBlockReport(DatanodeDescriptor node, StorageReceivedDeletedBlocks srdb) throws IOException {
        DatanodeStorageInfo storageInfo = node.getStorageInfo(srdb.getStorage().getStorageID());
        if (storageInfo == null) {
            storageInfo = node.updateStorage(srdb.getStorage());
        }
        int received = 0;
        int deleted = 0;
        int receiving = 0;
        for (ReceivedDeletedBlockInfo rdbi : srdb.getBlocks()) {
            switch (rdbi.getStatus()) {
                case DELETED_BLOCK: {
                    this.removeStoredBlock(storageInfo, rdbi.getBlock(), node);
                    ++deleted;
                    break;
                }
                case RECEIVED_BLOCK: {
                    this.addBlock(storageInfo, rdbi.getBlock(), rdbi.getDelHints());
                    ++received;
                    break;
                }
                case RECEIVING_BLOCK: {
                    ++receiving;
                    this.processAndHandleReportedBlock(storageInfo, rdbi.getBlock(), HdfsServerConstants.ReplicaState.RBW, null);
                    break;
                }
                default: {
                    String msg = "Unknown block status code reported by " + (Object)((Object)node) + ": " + rdbi;
                    blockLog.warn(msg);
                    assert (false) : msg;
                    break;
                }
            }
            blockLog.debug("BLOCK* block {}: {} is received from {}", new Object[]{rdbi.getStatus(), rdbi.getBlock(), node});
        }
        blockLog.debug("*BLOCK* NameNode.processIncrementalBlockReport: from {} receiving: {}, received: {}, deleted: {}", new Object[]{node, receiving, received, deleted});
    }

    public NumberReplicas countNodes(BlockInfo b) {
        return this.countNodes(b, false);
    }

    NumberReplicas countNodes(BlockInfo b, boolean inStartupSafeMode) {
        NumberReplicas numberReplicas = new NumberReplicas();
        Collection<DatanodeDescriptor> nodesCorrupt = this.corruptReplicas.getNodes(b);
        if (b.isStriped()) {
            this.countReplicasForStripedBlock(numberReplicas, (BlockInfoStriped)b, nodesCorrupt, inStartupSafeMode);
        } else {
            for (DatanodeStorageInfo storage : this.blocksMap.getStorages(b)) {
                this.checkReplicaOnStorage(numberReplicas, b, storage, nodesCorrupt, inStartupSafeMode);
            }
        }
        return numberReplicas;
    }

    private NumberReplicas.StoredReplicaState checkReplicaOnStorage(NumberReplicas counters, BlockInfo b, DatanodeStorageInfo storage, Collection<DatanodeDescriptor> nodesCorrupt, boolean inStartupSafeMode) {
        NumberReplicas.StoredReplicaState s;
        if (storage.getState() == DatanodeStorage.State.NORMAL) {
            DatanodeDescriptor node = storage.getDatanodeDescriptor();
            if (nodesCorrupt != null && nodesCorrupt.contains((Object)node)) {
                s = NumberReplicas.StoredReplicaState.CORRUPT;
            } else {
                if (inStartupSafeMode) {
                    NumberReplicas.StoredReplicaState s2 = NumberReplicas.StoredReplicaState.LIVE;
                    counters.add(s2, 1L);
                    return s2;
                }
                s = node.isDecommissionInProgress() ? NumberReplicas.StoredReplicaState.DECOMMISSIONING : (node.isDecommissioned() ? NumberReplicas.StoredReplicaState.DECOMMISSIONED : (node.isMaintenance() ? (node.isInMaintenance() || !node.isAlive() ? NumberReplicas.StoredReplicaState.MAINTENANCE_NOT_FOR_READ : NumberReplicas.StoredReplicaState.MAINTENANCE_FOR_READ) : (this.isExcess(node, b) ? NumberReplicas.StoredReplicaState.EXCESS : NumberReplicas.StoredReplicaState.LIVE)));
            }
            counters.add(s, 1L);
            if (storage.areBlockContentsStale()) {
                counters.add(NumberReplicas.StoredReplicaState.STALESTORAGE, 1L);
            }
        } else if (!inStartupSafeMode && storage.getState() == DatanodeStorage.State.READ_ONLY_SHARED) {
            s = NumberReplicas.StoredReplicaState.READONLY;
            counters.add(s, 1L);
        } else {
            s = null;
        }
        return s;
    }

    private void countReplicasForStripedBlock(NumberReplicas counters, BlockInfoStriped block, Collection<DatanodeDescriptor> nodesCorrupt, boolean inStartupSafeMode) {
        BitSet liveBitSet = new BitSet(block.getTotalBlockNum());
        BitSet decommissioningBitSet = new BitSet(block.getTotalBlockNum());
        for (BlockInfoStriped.StorageAndBlockIndex si : block.getStorageAndIndexInfos()) {
            NumberReplicas.StoredReplicaState state = this.checkReplicaOnStorage(counters, block, si.getStorage(), nodesCorrupt, inStartupSafeMode);
            this.countLiveAndDecommissioningReplicas(counters, state, liveBitSet, decommissioningBitSet, si.getBlockIndex());
        }
    }

    private void countLiveAndDecommissioningReplicas(NumberReplicas counters, NumberReplicas.StoredReplicaState state, BitSet liveBitSet, BitSet decommissioningBitSet, byte blockIndex) {
        if (state == NumberReplicas.StoredReplicaState.LIVE) {
            if (!liveBitSet.get(blockIndex)) {
                liveBitSet.set(blockIndex);
                if (decommissioningBitSet.get(blockIndex)) {
                    counters.subtract(NumberReplicas.StoredReplicaState.DECOMMISSIONING, 1L);
                }
            } else {
                counters.subtract(NumberReplicas.StoredReplicaState.LIVE, 1L);
                counters.add(NumberReplicas.StoredReplicaState.REDUNDANT, 1L);
            }
        } else if (state == NumberReplicas.StoredReplicaState.DECOMMISSIONING) {
            if (liveBitSet.get(blockIndex) || decommissioningBitSet.get(blockIndex)) {
                counters.subtract(NumberReplicas.StoredReplicaState.DECOMMISSIONING, 1L);
            } else {
                decommissioningBitSet.set(blockIndex);
            }
        }
    }

    @VisibleForTesting
    int getExcessSize4Testing(String dnUuid) {
        return this.excessRedundancyMap.getSize4Testing(dnUuid);
    }

    public boolean isExcess(DatanodeDescriptor dn, BlockInfo blk) {
        return this.excessRedundancyMap.contains(dn, blk);
    }

    int countLiveNodes(BlockInfo b) {
        boolean inStartupSafeMode = this.namesystem.isInStartupSafeMode();
        return this.countNodes(b, inStartupSafeMode).liveReplicas();
    }

    void processExtraRedundancyBlocksOnInService(DatanodeDescriptor srcNode) {
        if (!this.isPopulatingReplQueues()) {
            return;
        }
        int numExtraRedundancy = 0;
        for (DatanodeStorageInfo datanodeStorageInfo : srcNode.getStorageInfos()) {
            if (srcNode.getStorageInfo(datanodeStorageInfo.getStorageID()) == null) continue;
            Iterator<BlockInfo> it = datanodeStorageInfo.getBlockIterator();
            while (it.hasNext()) {
                BlockInfo block = it.next();
                if (block.isDeleted()) continue;
                short expectedReplication = this.getExpectedRedundancyNum(block);
                NumberReplicas num = this.countNodes(block);
                if (!this.shouldProcessExtraRedundancy(num, expectedReplication)) continue;
                this.processExtraRedundancyBlock(block, expectedReplication, null, null);
                ++numExtraRedundancy;
            }
            if (!this.namesystem.hasWriteLock()) continue;
            this.namesystem.writeUnlock();
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            this.namesystem.writeLock();
        }
        LOG.info("Invalidated {} extra redundancy blocks on {} after it is in service", (Object)numExtraRedundancy, (Object)srcNode);
    }

    boolean isNodeHealthyForDecommissionOrMaintenance(DatanodeDescriptor node) {
        if (!node.checkBlockReportReceived()) {
            LOG.info("Node {} hasn't sent its first block report.", (Object)node);
            return false;
        }
        if (node.isAlive()) {
            return true;
        }
        this.updateState();
        if (this.pendingReconstructionBlocksCount == 0L && this.lowRedundancyBlocksCount == 0L) {
            LOG.info("Node {} is dead and there are no low redundancy blocks or blocks pending reconstruction. Safe to decommission or", (Object)" put in maintenance.", (Object)node);
            return true;
        }
        LOG.warn("Node {} is dead while in {}. Cannot be safely decommissioned or be in maintenance since there is risk of reduced data durability or data loss. Either restart the failed node or force decommissioning or maintenance by removing, calling refreshNodes, then re-adding to the excludes or host config files.", (Object)node, (Object)node.getAdminState());
        return false;
    }

    public int getActiveBlockCount() {
        return this.blocksMap.size();
    }

    public DatanodeStorageInfo[] getStorages(BlockInfo block) {
        DatanodeStorageInfo[] storages = new DatanodeStorageInfo[block.numNodes()];
        int i = 0;
        for (DatanodeStorageInfo s : this.blocksMap.getStorages(block)) {
            storages[i++] = s;
        }
        return storages;
    }

    public Iterable<DatanodeStorageInfo> getStorages(Block block) {
        return this.blocksMap.getStorages(block);
    }

    public int getTotalBlocks() {
        return this.blocksMap.size();
    }

    public void removeBlock(BlockInfo block) {
        assert (this.namesystem.hasWriteLock());
        block.setNumBytes(Long.MAX_VALUE);
        this.addToInvalidates(block);
        this.removeBlockFromMap(block);
        PendingReconstructionBlocks.PendingBlockInfo remove = this.pendingReconstruction.remove(block);
        if (remove != null) {
            DatanodeStorageInfo.decrementBlocksScheduled(remove.getTargets().toArray(new DatanodeStorageInfo[remove.getTargets().size()]));
        }
        this.neededReconstruction.remove(block, 5);
        this.postponedMisreplicatedBlocks.remove((Object)block);
    }

    public BlockInfo getStoredBlock(Block block) {
        if (!BlockIdManager.isStripedBlockID(block.getBlockId())) {
            return this.blocksMap.getStoredBlock(block);
        }
        if (!this.hasNonEcBlockUsingStripedID) {
            return this.blocksMap.getStoredBlock(new Block(BlockIdManager.convertToStripedID(block.getBlockId())));
        }
        BlockInfo info = this.blocksMap.getStoredBlock(block);
        if (info != null) {
            return info;
        }
        return this.blocksMap.getStoredBlock(new Block(BlockIdManager.convertToStripedID(block.getBlockId())));
    }

    public void updateLastBlock(BlockInfo lastBlock, ExtendedBlock newBlock) {
        lastBlock.setNumBytes(newBlock.getNumBytes());
        List<ReplicaUnderConstruction> staleReplicas = lastBlock.setGenerationStampAndVerifyReplicas(newBlock.getGenerationStamp());
        this.removeStaleReplicas(staleReplicas, lastBlock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateNeededReconstructions(BlockInfo block, int curReplicasDelta, int expectedReplicasDelta) {
        this.namesystem.writeLock();
        try {
            if (!this.isPopulatingReplQueues() || !block.isComplete()) {
                return;
            }
            NumberReplicas repl = this.countNodes(block);
            int pendingNum = this.pendingReconstruction.getNumReplicas(block);
            short curExpectedReplicas = this.getExpectedRedundancyNum(block);
            if (!this.hasEnoughEffectiveReplicas(block, repl, pendingNum)) {
                this.neededReconstruction.update(block, repl.liveReplicas() + pendingNum, repl.readOnlyReplicas(), repl.outOfServiceReplicas(), curExpectedReplicas, curReplicasDelta, expectedReplicasDelta);
            } else {
                int oldReplicas = repl.liveReplicas() + pendingNum - curReplicasDelta;
                int oldExpectedReplicas = curExpectedReplicas - expectedReplicasDelta;
                this.neededReconstruction.remove(block, oldReplicas, repl.readOnlyReplicas(), repl.outOfServiceReplicas(), oldExpectedReplicas);
            }
        }
        finally {
            this.namesystem.writeUnlock();
        }
    }

    public void checkRedundancy(BlockCollection bc) {
        for (BlockInfo block : bc.getBlocks()) {
            int pending;
            short expected = this.getExpectedRedundancyNum(block);
            NumberReplicas n = this.countNodes(block);
            if (!this.hasEnoughEffectiveReplicas(block, n, pending = this.pendingReconstruction.getNumReplicas(block))) {
                this.neededReconstruction.add(block, n.liveReplicas() + pending, n.readOnlyReplicas(), n.outOfServiceReplicas(), expected);
                continue;
            }
            if (!this.shouldProcessExtraRedundancy(n, expected)) continue;
            this.processExtraRedundancyBlock(block, expected, null, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int invalidateWorkForOneNode(DatanodeInfo dn) {
        List<Block> toInvalidate;
        this.namesystem.writeLock();
        try {
            if (this.namesystem.isInSafeMode()) {
                LOG.debug("In safemode, not computing reconstruction work");
                int n = 0;
                return n;
            }
            DatanodeDescriptor dnDescriptor = this.datanodeManager.getDatanode((DatanodeID)dn);
            if (dnDescriptor == null) {
                LOG.warn("DataNode {} cannot be found with UUID {}, removing block invalidation work.", (Object)dn, (Object)dn.getDatanodeUuid());
                this.invalidateBlocks.remove(dn);
                int n = 0;
                return n;
            }
            toInvalidate = this.invalidateBlocks.invalidateWork(dnDescriptor);
            if (toInvalidate == null) {
                int n = 0;
                return n;
            }
        }
        finally {
            this.namesystem.writeUnlock();
        }
        blockLog.debug("BLOCK* {}: ask {} to delete {}", new Object[]{this.getClass().getSimpleName(), dn, toInvalidate});
        return toInvalidate.size();
    }

    @VisibleForTesting
    public boolean containsInvalidateBlock(DatanodeInfo dn, Block block) {
        return this.invalidateBlocks.contains(dn, block);
    }

    boolean isPlacementPolicySatisfied(BlockInfo storedBlock) {
        return this.getBlockPlacementStatus(storedBlock, null).isPlacementPolicySatisfied();
    }

    BlockPlacementStatus getBlockPlacementStatus(BlockInfo storedBlock) {
        return this.getBlockPlacementStatus(storedBlock, null);
    }

    BlockPlacementStatus getBlockPlacementStatus(BlockInfo storedBlock, DatanodeStorageInfo[] additionalStorage) {
        ArrayList<DatanodeDescriptor> liveNodes = new ArrayList<DatanodeDescriptor>();
        if (additionalStorage != null) {
            for (DatanodeStorageInfo s : additionalStorage) {
                liveNodes.add(this.getDatanodeDescriptorFromStorage(s));
            }
        }
        Collection<DatanodeDescriptor> corruptNodes = this.corruptReplicas.getNodes(storedBlock);
        for (DatanodeStorageInfo storage : this.blocksMap.getStorages(storedBlock)) {
            if (storage.getStorageType() == StorageType.PROVIDED && storage.getState() == DatanodeStorage.State.NORMAL) {
                return new BlockPlacementStatus(){

                    @Override
                    public boolean isPlacementPolicySatisfied() {
                        return true;
                    }

                    @Override
                    public String getErrorDescription() {
                        return null;
                    }

                    @Override
                    public int getAdditionalReplicasRequired() {
                        return 0;
                    }
                };
            }
            DatanodeDescriptor cur = this.getDatanodeDescriptorFromStorage(storage);
            if (cur.isDecommissionInProgress() || cur.isDecommissioned() || corruptNodes != null && corruptNodes.contains((Object)cur)) continue;
            liveNodes.add(cur);
        }
        DatanodeInfo[] locs = liveNodes.toArray(new DatanodeInfo[liveNodes.size()]);
        BlockType blockType = storedBlock.getBlockType();
        BlockPlacementPolicy placementPolicy = this.placementPolicies.getPolicy(blockType);
        short numReplicas = blockType == BlockType.STRIPED ? ((BlockInfoStriped)storedBlock).getRealTotalBlockNum() : storedBlock.getReplication();
        return placementPolicy.verifyBlockPlacement(locs, numReplicas);
    }

    boolean isNeededReconstructionForMaintenance(BlockInfo storedBlock, NumberReplicas numberReplicas) {
        return storedBlock.isComplete() && (numberReplicas.liveReplicas() < this.getMinMaintenanceStorageNum(storedBlock) || !this.isPlacementPolicySatisfied(storedBlock));
    }

    boolean isNeededReconstruction(BlockInfo storedBlock, NumberReplicas numberReplicas) {
        return this.isNeededReconstruction(storedBlock, numberReplicas, 0);
    }

    boolean isNeededReconstruction(BlockInfo storedBlock, NumberReplicas numberReplicas, int pending) {
        return storedBlock.isComplete() && !this.hasEnoughEffectiveReplicas(storedBlock, numberReplicas, pending);
    }

    public short getExpectedLiveRedundancyNum(BlockInfo block, NumberReplicas numberReplicas) {
        short expectedRedundancy = this.getExpectedRedundancyNum(block);
        return (short)Math.max(expectedRedundancy - numberReplicas.maintenanceReplicas(), this.getMinMaintenanceStorageNum(block));
    }

    public short getExpectedRedundancyNum(BlockInfo block) {
        return block.isStriped() ? ((BlockInfoStriped)block).getRealTotalBlockNum() : block.getReplication();
    }

    public long getMissingBlocksCount() {
        return this.neededReconstruction.getCorruptBlockSize();
    }

    public long getMissingReplOneBlocksCount() {
        return this.neededReconstruction.getCorruptReplicationOneBlockSize();
    }

    public long getHighestPriorityReplicatedBlockCount() {
        return this.neededReconstruction.getHighestPriorityReplicatedBlockCount();
    }

    public long getHighestPriorityECBlockCount() {
        return this.neededReconstruction.getHighestPriorityECBlockCount();
    }

    public BlockInfo addBlockCollection(BlockInfo block, BlockCollection bc) {
        BlockInfo blockInfo = this.blocksMap.addBlockCollection(block, bc);
        this.blockIdManager.setGenerationStampIfGreater(block.getGenerationStamp());
        return blockInfo;
    }

    public BlockInfo addBlockCollectionWithCheck(BlockInfo block, BlockCollection bc) {
        if (!this.hasNonEcBlockUsingStripedID && !block.isStriped() && BlockIdManager.isStripedBlockID(block.getBlockId())) {
            this.hasNonEcBlockUsingStripedID = true;
        }
        return this.addBlockCollection(block, bc);
    }

    BlockCollection getBlockCollection(BlockInfo b) {
        return this.namesystem.getBlockCollection(b.getBlockCollectionId());
    }

    public int numCorruptReplicas(Block block) {
        return this.corruptReplicas.numCorruptReplicas(block);
    }

    public void removeBlockFromMap(BlockInfo block) {
        for (DatanodeStorageInfo info : this.blocksMap.getStorages(block)) {
            this.excessRedundancyMap.remove(info.getDatanodeDescriptor(), block);
        }
        this.blocksMap.removeBlock(block);
        this.corruptReplicas.removeFromCorruptReplicasMap(block);
    }

    public int getCapacity() {
        return this.blocksMap.getCapacity();
    }

    public Iterator<BlockInfo> getCorruptReplicaBlockIterator() {
        return this.neededReconstruction.iterator(4);
    }

    public Collection<DatanodeDescriptor> getCorruptReplicas(Block block) {
        return this.corruptReplicas.getNodes(block);
    }

    public String getCorruptReason(Block block, DatanodeDescriptor node) {
        return this.corruptReplicas.getCorruptReason(block, node);
    }

    public int numOfUnderReplicatedBlocks() {
        return this.neededReconstruction.size();
    }

    @VisibleForTesting
    public long getLastRedundancyMonitorTS() {
        return this.lastRedundancyCycleTS.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int computeDatanodeWork() {
        if (this.namesystem.isInSafeMode()) {
            return 0;
        }
        int numlive = this.heartbeatManager.getLiveDatanodeCount();
        int blocksToProcess = numlive * this.blocksReplWorkMultiplier;
        int nodesToProcess = (int)Math.ceil((float)numlive * this.blocksInvalidateWorkPct);
        int workFound = this.computeBlockReconstructionWork(blocksToProcess);
        this.namesystem.writeLock();
        try {
            this.updateState();
            this.scheduledReplicationBlocksCount = workFound;
        }
        finally {
            this.namesystem.writeUnlock();
        }
        return workFound += this.computeInvalidateWork(nodesToProcess);
    }

    public void clearQueues() {
        this.neededReconstruction.clear();
        this.pendingReconstruction.clear();
        this.excessRedundancyMap.clear();
        this.invalidateBlocks.clear();
        this.datanodeManager.clearPendingQueues();
        this.postponedMisreplicatedBlocks.clear();
    }

    public static LocatedBlock newLocatedBlock(ExtendedBlock b, DatanodeStorageInfo[] storages, long startOffset, boolean corrupt) {
        return new LocatedBlock(b, DatanodeStorageInfo.toDatanodeInfos(storages), DatanodeStorageInfo.toStorageIDs(storages), DatanodeStorageInfo.toStorageTypes(storages), startOffset, corrupt, null);
    }

    public static LocatedStripedBlock newLocatedStripedBlock(ExtendedBlock b, DatanodeStorageInfo[] storages, byte[] indices, long startOffset, boolean corrupt) {
        return new LocatedStripedBlock(b, DatanodeStorageInfo.toDatanodeInfos(storages), DatanodeStorageInfo.toStorageIDs(storages), DatanodeStorageInfo.toStorageTypes(storages), indices, startOffset, corrupt, null);
    }

    public static LocatedBlock newLocatedBlock(ExtendedBlock eb, BlockInfo info, DatanodeStorageInfo[] locs, long offset) throws IOException {
        Object lb = info.isStriped() ? BlockManager.newLocatedStripedBlock(eb, locs, info.getUnderConstructionFeature().getBlockIndices(), offset, false) : BlockManager.newLocatedBlock(eb, locs, offset, false);
        return lb;
    }

    public void shutdown() {
        this.stopReconstructionInitializer();
        this.blocksMap.close();
        MBeans.unregister((ObjectName)this.mxBeanName);
        this.mxBeanName = null;
    }

    public void clear() {
        this.blockIdManager.clear();
        this.clearQueues();
        this.blocksMap.clear();
    }

    public BlockReportLeaseManager getBlockReportLeaseManager() {
        return this.blockReportLeaseManager;
    }

    @Override
    public Map<StorageType, StorageTypeStats> getStorageTypeStats() {
        return this.datanodeManager.getDatanodeStatistics().getStorageTypeStats();
    }

    public void initializeReplQueues() {
        LOG.info("initializing replication queues");
        this.processMisReplicatedBlocks();
        this.initializedReplQueues = true;
    }

    public boolean isPopulatingReplQueues() {
        if (!this.shouldPopulateReplQueues()) {
            return false;
        }
        return this.initializedReplQueues;
    }

    public void setInitializedReplQueues(boolean v) {
        this.initializedReplQueues = v;
    }

    public boolean shouldPopulateReplQueues() {
        HAContext haContext = this.namesystem.getHAContext();
        if (haContext == null || haContext.getState() == null) {
            return false;
        }
        return haContext.getState().shouldPopulateReplQueues();
    }

    boolean getShouldPostponeBlocksFromFuture() {
        return this.shouldPostponeBlocksFromFuture;
    }

    public void enqueueBlockOp(Runnable action) throws IOException {
        try {
            this.blockReportThread.enqueue(action);
        }
        catch (InterruptedException ie) {
            throw new IOException(ie);
        }
    }

    public <T> T runBlockOp(Callable<T> action) throws IOException {
        FutureTask<T> future = new FutureTask<T>(action);
        this.enqueueBlockOp(future);
        try {
            return future.get();
        }
        catch (ExecutionException ee) {
            Throwable cause = ee.getCause();
            if (cause == null) {
                cause = ee;
            }
            if (!(cause instanceof IOException)) {
                cause = new IOException(cause);
            }
            throw (IOException)cause;
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            throw new IOException(ie);
        }
    }

    public void successfulBlockRecovery(BlockInfo block) {
        this.pendingRecoveryBlocks.remove(block);
    }

    public boolean addBlockRecoveryAttempt(BlockInfo b) {
        return this.pendingRecoveryBlocks.add(b);
    }

    @VisibleForTesting
    public void flushBlockOps() throws IOException {
        this.runBlockOp(new Callable<Void>(){

            @Override
            public Void call() {
                return null;
            }
        });
    }

    public int getBlockOpQueueLength() {
        return this.blockReportThread.queue.size();
    }

    @VisibleForTesting
    Daemon getRedundancyThread() {
        return this.redundancyThread;
    }

    public BlockIdManager getBlockIdManager() {
        return this.blockIdManager;
    }

    public long nextGenerationStamp(boolean legacyBlock) throws IOException {
        return this.blockIdManager.nextGenerationStamp(legacyBlock);
    }

    public boolean isLegacyBlock(Block block) {
        return this.blockIdManager.isLegacyBlock(block);
    }

    public long nextBlockId(BlockType blockType) {
        return this.blockIdManager.nextBlockId(blockType);
    }

    boolean isGenStampInFuture(Block block) {
        return this.blockIdManager.isGenStampInFuture(block);
    }

    boolean isReplicaCorrupt(BlockInfo blk, DatanodeDescriptor d) {
        return this.corruptReplicas.isReplicaCorrupt(blk, d);
    }

    private int setBlockIndices(BlockInfo blk, byte[] blockIndices, int i, DatanodeStorageInfo storage) {
        if (blockIndices != null) {
            byte index = ((BlockInfoStriped)blk).getStorageBlockIndex(storage);
            assert (index >= 0);
            blockIndices[i++] = index;
        }
        return i;
    }

    private static long getBlockRecoveryTimeout(long heartbeatIntervalSecs) {
        return TimeUnit.SECONDS.toMillis(heartbeatIntervalSecs * 30L);
    }

    @VisibleForTesting
    public void setBlockRecoveryTimeout(long blockRecoveryTimeout) {
        this.pendingRecoveryBlocks.setRecoveryTimeoutInterval(blockRecoveryTimeout);
    }

    @VisibleForTesting
    public ProvidedStorageMap getProvidedStorageMap() {
        return this.providedStorageMap;
    }

    private boolean createSPSManager(Configuration conf) {
        return this.createSPSManager(conf, null);
    }

    public boolean createSPSManager(Configuration conf, String spsMode) {
        boolean storagePolicyEnabled = conf.getBoolean("dfs.storage.policy.enabled", true);
        String modeVal = spsMode;
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)modeVal)) {
            modeVal = conf.get("dfs.storage.policy.satisfier.mode", DFSConfigKeys.DFS_STORAGE_POLICY_SATISFIER_MODE_DEFAULT);
        }
        HdfsConstants.StoragePolicySatisfierMode mode = HdfsConstants.StoragePolicySatisfierMode.fromString((String)modeVal);
        if (!storagePolicyEnabled || mode == HdfsConstants.StoragePolicySatisfierMode.NONE) {
            LOG.info("Storage policy satisfier is disabled");
            return false;
        }
        this.spsManager = new StoragePolicySatisfyManager(conf, this.namesystem);
        return true;
    }

    public void disableSPS() {
        this.spsManager = null;
    }

    public StoragePolicySatisfyManager getSPSManager() {
        return this.spsManager;
    }

    private class BlockReportProcessingThread
    extends Thread {
        private long lastFull;
        private final BlockingQueue<Runnable> queue;

        BlockReportProcessingThread(int size) {
            super("Block report processor");
            this.lastFull = 0L;
            this.queue = new ArrayBlockingQueue<Runnable>(size);
            this.setDaemon(true);
        }

        @Override
        public void run() {
            try {
                this.processQueue();
            }
            catch (Throwable t) {
                ExitUtil.terminate((int)1, (String)(this.getName() + " encountered fatal exception: " + t));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void processQueue() {
            while (BlockManager.this.namesystem.isRunning()) {
                NameNodeMetrics metrics = NameNode.getNameNodeMetrics();
                try {
                    Runnable action = this.queue.take();
                    int processed = 0;
                    BlockManager.this.namesystem.writeLock();
                    metrics.setBlockOpsQueued(this.queue.size() + 1);
                    try {
                        long start = Time.monotonicNow();
                        do {
                            ++processed;
                            action.run();
                        } while (Time.monotonicNow() - start <= BlockManager.this.maxLockHoldTime && (action = (Runnable)this.queue.poll()) != null);
                    }
                    finally {
                        BlockManager.this.namesystem.writeUnlock();
                        metrics.addBlockOpsBatched(processed - 1);
                    }
                }
                catch (InterruptedException e) {
                    if (!Thread.interrupted()) continue;
                    break;
                }
            }
            this.queue.clear();
        }

        void enqueue(Runnable action) throws InterruptedException {
            if (!this.queue.offer(action)) {
                long now;
                if (!this.isAlive() && BlockManager.this.namesystem.isRunning()) {
                    ExitUtil.terminate((int)1, (String)(this.getName() + " is not running"));
                }
                if ((now = Time.monotonicNow()) - this.lastFull > 4000L) {
                    this.lastFull = now;
                    LOG.info("Block report queue is full");
                }
                this.queue.put(action);
            }
        }
    }

    static enum MisReplicationResult {
        INVALID,
        UNDER_REPLICATED,
        OVER_REPLICATED,
        POSTPONE,
        UNDER_CONSTRUCTION,
        OK;

    }

    private class RedundancyMonitor
    implements Runnable {
        private RedundancyMonitor() {
        }

        @Override
        public void run() {
            while (BlockManager.this.namesystem.isRunning()) {
                try {
                    if (BlockManager.this.isPopulatingReplQueues()) {
                        BlockManager.this.computeDatanodeWork();
                        BlockManager.this.processPendingReconstructions();
                        BlockManager.this.rescanPostponedMisreplicatedBlocks();
                        BlockManager.this.lastRedundancyCycleTS.set(Time.monotonicNow());
                    }
                    TimeUnit.MILLISECONDS.sleep(BlockManager.this.redundancyRecheckIntervalMs);
                }
                catch (Throwable t) {
                    if (!BlockManager.this.namesystem.isRunning()) {
                        LOG.info("Stopping RedundancyMonitor.");
                        if (t instanceof InterruptedException) break;
                        LOG.info("RedundancyMonitor received an exception while shutting down.", t);
                        break;
                    }
                    if (!BlockManager.this.checkNSRunning && t instanceof InterruptedException) {
                        LOG.info("Stopping RedundancyMonitor for testing.");
                        break;
                    }
                    LOG.error("RedundancyMonitor thread received Runtime exception. ", t);
                    ExitUtil.terminate((int)1, (Throwable)t);
                }
            }
        }
    }

    private static class BlockInfoToAdd {
        final BlockInfo stored;
        final Block reported;

        BlockInfoToAdd(BlockInfo stored, Block reported) {
            this.stored = stored;
            this.reported = reported;
        }
    }

    static class StatefulBlockInfo {
        final BlockInfo storedBlock;
        final Block reportedBlock;
        final HdfsServerConstants.ReplicaState reportedState;

        StatefulBlockInfo(BlockInfo storedBlock, Block reportedBlock, HdfsServerConstants.ReplicaState reportedState) {
            Preconditions.checkArgument((!storedBlock.isComplete() ? 1 : 0) != 0);
            this.storedBlock = storedBlock;
            this.reportedBlock = reportedBlock;
            this.reportedState = reportedState;
        }
    }
}

