/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode.fsdataset.impl;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hdfs.ExtendedBlockId;
import org.apache.hadoop.hdfs.server.datanode.BlockMetadataHeader;
import org.apache.hadoop.hdfs.server.datanode.DNConf;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.CacheStats;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.FsDatasetUtil;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.MappableBlock;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.NativePmemMappedBlock;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.PmemMappableBlockLoader;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.PmemVolumeManager;
import org.apache.hadoop.io.nativeio.NativeIO;
import org.apache.hadoop.thirdparty.com.google.common.base.Preconditions;
import org.apache.hadoop.util.DataChecksum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class NativePmemMappableBlockLoader
extends PmemMappableBlockLoader {
    private static final Logger LOG = LoggerFactory.getLogger(NativePmemMappableBlockLoader.class);

    @Override
    CacheStats initialize(DNConf dnConf) throws IOException {
        return super.initialize(dnConf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MappableBlock load(long length, FileInputStream blockIn, FileInputStream metaIn, String blockFileName, ExtendedBlockId key) throws IOException {
        NativePmemMappedBlock mappableBlock = null;
        NativeIO.POSIX.PmemMappedRegion region = null;
        String filePath = null;
        try (FileChannel blockChannel = blockIn.getChannel();){
            if (blockChannel == null) {
                throw new IOException("Block InputStream has no FileChannel.");
            }
            assert (NativeIO.isAvailable());
            filePath = PmemVolumeManager.getInstance().getCachePath(key);
            region = NativeIO.POSIX.Pmem.mapBlock((String)filePath, (long)length, (boolean)false);
            if (region == null) {
                throw new IOException("Failed to map the block " + blockFileName + " to persistent storage.");
            }
            this.verifyChecksumAndMapBlock(region, length, metaIn, blockChannel, blockFileName);
            mappableBlock = new NativePmemMappedBlock(region.getAddress(), region.getLength(), key);
            LOG.info("Successfully cached one replica:{} into persistent memory, [cached path={}, address={}, length={}]", new Object[]{key, filePath, region.getAddress(), length});
        }
        finally {
            if (mappableBlock == null && region != null) {
                NativeIO.POSIX.Pmem.unmapBlock((long)region.getAddress(), (long)region.getLength());
                FsDatasetUtil.deleteMappedFile(filePath);
            }
        }
        return mappableBlock;
    }

    private void verifyChecksumAndMapBlock(NativeIO.POSIX.PmemMappedRegion region, long length, FileInputStream metaIn, FileChannel blockChannel, String blockFileName) throws IOException {
        BlockMetadataHeader header = BlockMetadataHeader.readHeader((DataInputStream)new DataInputStream(new BufferedInputStream(metaIn, BlockMetadataHeader.getHeaderSize())));
        try (FileChannel metaChannel = metaIn.getChannel();){
            if (metaChannel == null) {
                throw new IOException("Cannot get FileChannel from Block InputStream meta file.");
            }
            DataChecksum checksum = header.getChecksum();
            int bytesPerChecksum = checksum.getBytesPerChecksum();
            int checksumSize = checksum.getChecksumSize();
            int numChunks = 0x800000 / bytesPerChecksum;
            ByteBuffer blockBuf = ByteBuffer.allocate(numChunks * bytesPerChecksum);
            ByteBuffer checksumBuf = ByteBuffer.allocate(numChunks * checksumSize);
            int bytesVerified = 0;
            long mappedAddress = -1L;
            if (region != null) {
                mappedAddress = region.getAddress();
            }
            while ((long)bytesVerified < length) {
                Preconditions.checkState((bytesVerified % bytesPerChecksum == 0 ? 1 : 0) != 0, (Object)"Unexpected partial chunk before EOF.");
                assert (bytesVerified % bytesPerChecksum == 0);
                int bytesRead = this.fillBuffer(blockChannel, blockBuf);
                if (bytesRead == -1) {
                    throw new IOException("Checksum verification failed for the block " + blockFileName + ": premature EOF");
                }
                blockBuf.flip();
                int chunks = (bytesRead + bytesPerChecksum - 1) / bytesPerChecksum;
                checksumBuf.limit(chunks * checksumSize);
                this.fillBuffer(metaChannel, checksumBuf);
                checksumBuf.flip();
                checksum.verifyChunkedSums(blockBuf, checksumBuf, blockFileName, (long)bytesVerified);
                bytesVerified += bytesRead;
                NativeIO.POSIX.Pmem.memCopy((byte[])blockBuf.array(), (long)mappedAddress, (boolean)region.isPmem(), (long)bytesRead);
                mappedAddress += (long)bytesRead;
                blockBuf.clear();
                checksumBuf.clear();
            }
            if (region != null) {
                NativeIO.POSIX.Pmem.memSync((NativeIO.POSIX.PmemMappedRegion)region);
            }
        }
    }

    @Override
    public boolean isNativeLoader() {
        return true;
    }

    @Override
    public MappableBlock getRecoveredMappableBlock(File cacheFile, String bpid, byte volumeIndex) throws IOException {
        NativeIO.POSIX.PmemMappedRegion region = NativeIO.POSIX.Pmem.mapBlock((String)cacheFile.getAbsolutePath(), (long)cacheFile.length(), (boolean)true);
        if (region == null) {
            throw new IOException("Failed to recover the block " + cacheFile.getName() + " in persistent storage.");
        }
        ExtendedBlockId key = new ExtendedBlockId(super.getBlockId(cacheFile), bpid);
        NativePmemMappedBlock mappableBlock = new NativePmemMappedBlock(region.getAddress(), region.getLength(), key);
        PmemVolumeManager.getInstance().recoverBlockKeyToVolume(key, volumeIndex);
        String path = PmemVolumeManager.getInstance().getCachePath(key);
        long addr = mappableBlock.getAddress();
        long length = mappableBlock.getLength();
        LOG.info("Recovering persistent memory cache for block {}, path = {}, address = {}, length = {}", new Object[]{key, path, addr, length});
        return mappableBlock;
    }
}

