/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.hadoop.hdfs.server.namenode.INodeAttributes;
import org.apache.hadoop.ipc.CallerContext;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.thirdparty.com.google.common.annotations.VisibleForTesting;

@InterfaceAudience.Public
@InterfaceStability.Unstable
public abstract class INodeAttributeProvider {
    public abstract void start();

    public abstract void stop();

    @Deprecated
    String[] getPathElements(String path) {
        if ((path = path.trim()).charAt(0) != '/') {
            throw new IllegalArgumentException("It must be an absolute path: " + path);
        }
        int numOfElements = StringUtils.countMatches((CharSequence)path, (CharSequence)"/");
        if (path.length() > 1 && path.endsWith("/")) {
            --numOfElements;
        }
        String[] pathElements = new String[numOfElements];
        int elementIdx = 0;
        int idx = 0;
        int found = path.indexOf(47, idx);
        while (found > -1) {
            if (found > idx) {
                pathElements[elementIdx++] = path.substring(idx, found);
            }
            idx = found + 1;
            found = path.indexOf(47, idx);
        }
        if (idx < path.length()) {
            pathElements[elementIdx] = path.substring(idx);
        }
        return pathElements;
    }

    @Deprecated
    public INodeAttributes getAttributes(String fullPath, INodeAttributes inode) {
        return this.getAttributes(this.getPathElements(fullPath), inode);
    }

    public abstract INodeAttributes getAttributes(String[] var1, INodeAttributes var2);

    public INodeAttributes getAttributes(byte[][] components, INodeAttributes inode) {
        String[] elements = new String[components.length];
        for (int i = 0; i < elements.length; ++i) {
            elements[i] = DFSUtil.bytes2String(components[i]);
        }
        return this.getAttributes(elements, inode);
    }

    public AccessControlEnforcer getExternalAccessControlEnforcer(AccessControlEnforcer defaultEnforcer) {
        return defaultEnforcer;
    }

    public static interface AccessControlEnforcer {
        public void checkPermission(String var1, String var2, UserGroupInformation var3, INodeAttributes[] var4, INode[] var5, byte[][] var6, int var7, String var8, int var9, boolean var10, FsAction var11, FsAction var12, FsAction var13, FsAction var14, boolean var15) throws AccessControlException;

        default public void checkPermissionWithContext(AuthorizationContext authzContext) throws AccessControlException {
            throw new AccessControlException("The authorization provider does not implement the checkPermissionWithContext(AuthorizationContext) API.");
        }

        default public void checkSuperUserPermissionWithContext(AuthorizationContext authzContext) throws AccessControlException {
            boolean isSuperUser;
            UserGroupInformation callerUgi = authzContext.getCallerUgi();
            boolean bl = isSuperUser = callerUgi.getShortUserName().equals(authzContext.getFsOwner()) || callerUgi.getGroupsSet().contains(authzContext.getSupergroup());
            if (!isSuperUser) {
                throw new AccessControlException("Access denied for user " + callerUgi.getShortUserName() + ". Superuser privilege is required for operation " + authzContext.getOperationName());
            }
        }

        default public void denyUserAccess(AuthorizationContext authzContext, String errorMessage) throws AccessControlException {
            throw new AccessControlException(errorMessage);
        }
    }

    public static class AuthorizationContext {
        private String fsOwner;
        private String supergroup;
        private UserGroupInformation callerUgi;
        private INodeAttributes[] inodeAttrs;
        private INode[] inodes;
        private byte[][] pathByNameArr;
        private int snapshotId;
        private String path;
        private int ancestorIndex;
        private boolean doCheckOwner;
        private FsAction ancestorAccess;
        private FsAction parentAccess;
        private FsAction access;
        private FsAction subAccess;
        private boolean ignoreEmptyDir;
        private String operationName;
        private CallerContext callerContext;

        public String getFsOwner() {
            return this.fsOwner;
        }

        public void setFsOwner(String fsOwner) {
            this.fsOwner = fsOwner;
        }

        public String getSupergroup() {
            return this.supergroup;
        }

        public void setSupergroup(String supergroup) {
            this.supergroup = supergroup;
        }

        public UserGroupInformation getCallerUgi() {
            return this.callerUgi;
        }

        public void setCallerUgi(UserGroupInformation callerUgi) {
            this.callerUgi = callerUgi;
        }

        public INodeAttributes[] getInodeAttrs() {
            return this.inodeAttrs;
        }

        public void setInodeAttrs(INodeAttributes[] inodeAttrs) {
            this.inodeAttrs = inodeAttrs;
        }

        public INode[] getInodes() {
            return this.inodes;
        }

        public void setInodes(INode[] inodes) {
            this.inodes = inodes;
        }

        public byte[][] getPathByNameArr() {
            return this.pathByNameArr;
        }

        public void setPathByNameArr(byte[][] pathByNameArr) {
            this.pathByNameArr = pathByNameArr;
        }

        public int getSnapshotId() {
            return this.snapshotId;
        }

        public void setSnapshotId(int snapshotId) {
            this.snapshotId = snapshotId;
        }

        public String getPath() {
            return this.path;
        }

        public void setPath(String path) {
            this.path = path;
        }

        public int getAncestorIndex() {
            return this.ancestorIndex;
        }

        public void setAncestorIndex(int ancestorIndex) {
            this.ancestorIndex = ancestorIndex;
        }

        public boolean isDoCheckOwner() {
            return this.doCheckOwner;
        }

        public void setDoCheckOwner(boolean doCheckOwner) {
            this.doCheckOwner = doCheckOwner;
        }

        public FsAction getAncestorAccess() {
            return this.ancestorAccess;
        }

        public void setAncestorAccess(FsAction ancestorAccess) {
            this.ancestorAccess = ancestorAccess;
        }

        public FsAction getParentAccess() {
            return this.parentAccess;
        }

        public void setParentAccess(FsAction parentAccess) {
            this.parentAccess = parentAccess;
        }

        public FsAction getAccess() {
            return this.access;
        }

        public void setAccess(FsAction access) {
            this.access = access;
        }

        public FsAction getSubAccess() {
            return this.subAccess;
        }

        public void setSubAccess(FsAction subAccess) {
            this.subAccess = subAccess;
        }

        public boolean isIgnoreEmptyDir() {
            return this.ignoreEmptyDir;
        }

        public void setIgnoreEmptyDir(boolean ignoreEmptyDir) {
            this.ignoreEmptyDir = ignoreEmptyDir;
        }

        public String getOperationName() {
            return this.operationName;
        }

        public void setOperationName(String operationName) {
            this.operationName = operationName;
        }

        public CallerContext getCallerContext() {
            return this.callerContext;
        }

        public void setCallerContext(CallerContext callerContext) {
            this.callerContext = callerContext;
        }

        public AuthorizationContext(Builder builder) {
            this.setFsOwner(builder.fsOwner);
            this.setSupergroup(builder.supergroup);
            this.setCallerUgi(builder.callerUgi);
            this.setInodeAttrs(builder.inodeAttrs);
            this.setInodes(builder.inodes);
            this.setPathByNameArr(builder.pathByNameArr);
            this.setSnapshotId(builder.snapshotId);
            this.setPath(builder.path);
            this.setAncestorIndex(builder.ancestorIndex);
            this.setDoCheckOwner(builder.doCheckOwner);
            this.setAncestorAccess(builder.ancestorAccess);
            this.setParentAccess(builder.parentAccess);
            this.setAccess(builder.access);
            this.setSubAccess(builder.subAccess);
            this.setIgnoreEmptyDir(builder.ignoreEmptyDir);
            this.setOperationName(builder.operationName);
            this.setCallerContext(builder.callerContext);
        }

        @VisibleForTesting
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            AuthorizationContext other = (AuthorizationContext)obj;
            return this.getFsOwner().equals(other.getFsOwner()) && this.getSupergroup().equals(other.getSupergroup()) && this.getCallerUgi().equals((Object)other.getCallerUgi()) && Arrays.deepEquals(this.getInodeAttrs(), other.getInodeAttrs()) && Arrays.deepEquals(this.getInodes(), other.getInodes()) && Arrays.deepEquals((Object[])this.getPathByNameArr(), (Object[])other.getPathByNameArr()) && this.getSnapshotId() == other.getSnapshotId() && this.getPath().equals(other.getPath()) && this.getAncestorIndex() == other.getAncestorIndex() && this.isDoCheckOwner() == other.isDoCheckOwner() && this.getAncestorAccess() == other.getAncestorAccess() && this.getParentAccess() == other.getParentAccess() && this.getAccess() == other.getAccess() && this.getSubAccess() == other.getSubAccess() && this.isIgnoreEmptyDir() == other.isIgnoreEmptyDir();
        }

        public int hashCode() {
            assert (false) : "hashCode not designed";
            return 42;
        }

        public static class Builder {
            private String fsOwner;
            private String supergroup;
            private UserGroupInformation callerUgi;
            private INodeAttributes[] inodeAttrs;
            private INode[] inodes;
            private byte[][] pathByNameArr;
            private int snapshotId;
            private String path;
            private int ancestorIndex;
            private boolean doCheckOwner;
            private FsAction ancestorAccess;
            private FsAction parentAccess;
            private FsAction access;
            private FsAction subAccess;
            private boolean ignoreEmptyDir;
            private String operationName;
            private CallerContext callerContext;

            public AuthorizationContext build() {
                return new AuthorizationContext(this);
            }

            public Builder fsOwner(String val) {
                this.fsOwner = val;
                return this;
            }

            public Builder supergroup(String val) {
                this.supergroup = val;
                return this;
            }

            public Builder callerUgi(UserGroupInformation val) {
                this.callerUgi = val;
                return this;
            }

            public Builder inodeAttrs(INodeAttributes[] val) {
                this.inodeAttrs = val;
                return this;
            }

            public Builder inodes(INode[] val) {
                this.inodes = val;
                return this;
            }

            public Builder pathByNameArr(byte[][] val) {
                this.pathByNameArr = val;
                return this;
            }

            public Builder snapshotId(int val) {
                this.snapshotId = val;
                return this;
            }

            public Builder path(String val) {
                this.path = val;
                return this;
            }

            public Builder ancestorIndex(int val) {
                this.ancestorIndex = val;
                return this;
            }

            public Builder doCheckOwner(boolean val) {
                this.doCheckOwner = val;
                return this;
            }

            public Builder ancestorAccess(FsAction val) {
                this.ancestorAccess = val;
                return this;
            }

            public Builder parentAccess(FsAction val) {
                this.parentAccess = val;
                return this;
            }

            public Builder access(FsAction val) {
                this.access = val;
                return this;
            }

            public Builder subAccess(FsAction val) {
                this.subAccess = val;
                return this;
            }

            public Builder ignoreEmptyDir(boolean val) {
                this.ignoreEmptyDir = val;
                return this;
            }

            public Builder operationName(String val) {
                this.operationName = val;
                return this;
            }

            public Builder callerContext(CallerContext val) {
                this.callerContext = val;
                return this;
            }
        }
    }
}

