/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.fs.permission.PermissionStatus;
import org.apache.hadoop.hdfs.server.namenode.AclFeature;
import org.apache.hadoop.hdfs.server.namenode.AclStorage;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.hadoop.hdfs.server.namenode.SerialNumberManager;
import org.apache.hadoop.hdfs.server.namenode.XAttrFeature;
import org.apache.hadoop.hdfs.util.LongBitFormat;
import org.apache.hadoop.thirdparty.com.google.common.base.Preconditions;
import org.apache.hadoop.util.LightWeightGSet;

@InterfaceAudience.Private
public abstract class INodeWithAdditionalFields
extends INode
implements LightWeightGSet.LinkedElement {
    private final long id;
    private byte[] name = null;
    private long permission = 0L;
    private long modificationTime = 0L;
    private long accessTime = 0L;
    private LightWeightGSet.LinkedElement next = null;
    private static final INode.Feature[] EMPTY_FEATURE = new INode.Feature[0];
    protected INode.Feature[] features = EMPTY_FEATURE;

    private INodeWithAdditionalFields(INode parent, long id, byte[] name, long permission, long modificationTime, long accessTime) {
        super(parent);
        this.id = id;
        this.name = name;
        this.permission = permission;
        this.modificationTime = modificationTime;
        this.accessTime = accessTime;
    }

    INodeWithAdditionalFields(long id, byte[] name, PermissionStatus permissions, long modificationTime, long accessTime) {
        this(null, id, name, PermissionStatusFormat.toLong(permissions), modificationTime, accessTime);
    }

    INodeWithAdditionalFields(INodeWithAdditionalFields other) {
        this(other.getParentReference() != null ? other.getParentReference() : other.getParent(), other.getId(), other.getLocalNameBytes(), other.permission, other.modificationTime, other.accessTime);
    }

    public void setNext(LightWeightGSet.LinkedElement next) {
        this.next = next;
    }

    public LightWeightGSet.LinkedElement getNext() {
        return this.next;
    }

    @Override
    public final long getId() {
        return this.id;
    }

    @Override
    public final byte[] getLocalNameBytes() {
        return this.name;
    }

    @Override
    public final void setLocalName(byte[] name) {
        this.name = name;
    }

    final void clonePermissionStatus(INodeWithAdditionalFields that) {
        this.permission = that.permission;
    }

    @Override
    public final PermissionStatus getPermissionStatus(int snapshotId) {
        return new PermissionStatus(this.getUserName(snapshotId), this.getGroupName(snapshotId), this.getFsPermission(snapshotId));
    }

    private final void updatePermissionStatus(PermissionStatusFormat f, long n) {
        this.permission = f.BITS.combine(n, this.permission);
    }

    @Override
    final String getUserName(int snapshotId) {
        if (snapshotId != 0x7FFFFFFE) {
            return this.getSnapshotINode(snapshotId).getUserName();
        }
        return PermissionStatusFormat.getUser(this.permission);
    }

    @Override
    final void setUser(String user) {
        int n = SerialNumberManager.USER.getSerialNumber(user);
        this.updatePermissionStatus(PermissionStatusFormat.USER, n);
    }

    @Override
    final String getGroupName(int snapshotId) {
        if (snapshotId != 0x7FFFFFFE) {
            return this.getSnapshotINode(snapshotId).getGroupName();
        }
        return PermissionStatusFormat.getGroup(this.permission);
    }

    @Override
    final void setGroup(String group) {
        int n = SerialNumberManager.GROUP.getSerialNumber(group);
        this.updatePermissionStatus(PermissionStatusFormat.GROUP, n);
    }

    @Override
    final FsPermission getFsPermission(int snapshotId) {
        if (snapshotId != 0x7FFFFFFE) {
            return this.getSnapshotINode(snapshotId).getFsPermission();
        }
        return new FsPermission(this.getFsPermissionShort());
    }

    @Override
    public final short getFsPermissionShort() {
        return PermissionStatusFormat.getMode(this.permission);
    }

    @Override
    void setPermission(FsPermission permission) {
        short mode = permission.toShort();
        this.updatePermissionStatus(PermissionStatusFormat.MODE, mode);
    }

    @Override
    public long getPermissionLong() {
        return this.permission;
    }

    @Override
    public final AclFeature getAclFeature(int snapshotId) {
        if (snapshotId != 0x7FFFFFFE) {
            return this.getSnapshotINode(snapshotId).getAclFeature();
        }
        return (AclFeature)this.getFeature(AclFeature.class);
    }

    @Override
    final long getModificationTime(int snapshotId) {
        if (snapshotId != 0x7FFFFFFE) {
            return this.getSnapshotINode(snapshotId).getModificationTime();
        }
        return this.modificationTime;
    }

    @Override
    public final INode updateModificationTime(long mtime, int latestSnapshotId) {
        Preconditions.checkState((boolean)this.isDirectory());
        if (mtime <= this.modificationTime) {
            return this;
        }
        return this.setModificationTime(mtime, latestSnapshotId);
    }

    final void cloneModificationTime(INodeWithAdditionalFields that) {
        this.modificationTime = that.modificationTime;
    }

    @Override
    public final void setModificationTime(long modificationTime) {
        this.modificationTime = modificationTime;
    }

    @Override
    final long getAccessTime(int snapshotId) {
        if (snapshotId != 0x7FFFFFFE) {
            return this.getSnapshotINode(snapshotId).getAccessTime();
        }
        return this.accessTime;
    }

    @Override
    public final void setAccessTime(long accessTime) {
        this.accessTime = accessTime;
    }

    protected void addFeature(INode.Feature f) {
        int size = this.features.length;
        INode.Feature[] arr = new INode.Feature[size + 1];
        if (size != 0) {
            System.arraycopy(this.features, 0, arr, 0, size);
        }
        arr[size] = f;
        this.features = arr;
    }

    protected void removeFeature(INode.Feature f) {
        int size = this.features.length;
        if (size == 0) {
            this.throwFeatureNotFoundException(f);
        }
        if (size == 1) {
            if (this.features[0] != f) {
                this.throwFeatureNotFoundException(f);
            }
            this.features = EMPTY_FEATURE;
            return;
        }
        INode.Feature[] arr = new INode.Feature[size - 1];
        int j = 0;
        boolean overflow = false;
        for (INode.Feature f1 : this.features) {
            if (f1 == f) continue;
            if (j == size - 1) {
                overflow = true;
                break;
            }
            arr[j++] = f1;
        }
        if (overflow || j != size - 1) {
            this.throwFeatureNotFoundException(f);
        }
        this.features = arr;
    }

    private void throwFeatureNotFoundException(INode.Feature f) {
        throw new IllegalStateException("Feature " + f.getClass().getSimpleName() + " not found.");
    }

    protected <T extends INode.Feature> T getFeature(Class<? extends INode.Feature> clazz) {
        Preconditions.checkArgument((clazz != null ? 1 : 0) != 0);
        for (INode.Feature f : this.features) {
            if (!clazz.isAssignableFrom(f.getClass())) continue;
            INode.Feature ret = f;
            return (T)ret;
        }
        return null;
    }

    @Override
    public void removeAclFeature() {
        AclFeature f = this.getAclFeature();
        Preconditions.checkNotNull((Object)f);
        this.removeFeature(f);
        AclStorage.removeAclFeature(f);
    }

    @Override
    public void addAclFeature(AclFeature f) {
        AclFeature f1 = this.getAclFeature();
        if (f1 != null) {
            throw new IllegalStateException("Duplicated ACLFeature");
        }
        this.addFeature(AclStorage.addAclFeature(f));
    }

    @Override
    XAttrFeature getXAttrFeature(int snapshotId) {
        if (snapshotId != 0x7FFFFFFE) {
            return this.getSnapshotINode(snapshotId).getXAttrFeature();
        }
        return (XAttrFeature)this.getFeature(XAttrFeature.class);
    }

    @Override
    public void removeXAttrFeature() {
        XAttrFeature f = this.getXAttrFeature();
        Preconditions.checkNotNull((Object)f);
        this.removeFeature(f);
    }

    @Override
    public void addXAttrFeature(XAttrFeature f) {
        XAttrFeature f1 = this.getXAttrFeature();
        Preconditions.checkState((f1 == null ? 1 : 0) != 0, (Object)"Duplicated XAttrFeature");
        this.addFeature(f);
    }

    public final INode.Feature[] getFeatures() {
        return this.features;
    }

    static final class PermissionStatusFormat
    extends Enum<PermissionStatusFormat>
    implements LongBitFormat.Enum {
        public static final /* enum */ PermissionStatusFormat MODE = new PermissionStatusFormat(null, 16);
        public static final /* enum */ PermissionStatusFormat GROUP = new PermissionStatusFormat(PermissionStatusFormat.MODE.BITS, 24);
        public static final /* enum */ PermissionStatusFormat USER = new PermissionStatusFormat(PermissionStatusFormat.GROUP.BITS, 24);
        final LongBitFormat BITS;
        private static final /* synthetic */ PermissionStatusFormat[] $VALUES;

        public static PermissionStatusFormat[] values() {
            return (PermissionStatusFormat[])$VALUES.clone();
        }

        public static PermissionStatusFormat valueOf(String name) {
            return Enum.valueOf(PermissionStatusFormat.class, name);
        }

        private PermissionStatusFormat(LongBitFormat previous, int length) {
            this.BITS = new LongBitFormat(this.name(), previous, length, 0L);
        }

        static String getUser(long permission) {
            int n = (int)PermissionStatusFormat.USER.BITS.retrieve(permission);
            String s = SerialNumberManager.USER.getString(n);
            assert (s != null);
            return s;
        }

        static String getGroup(long permission) {
            int n = (int)PermissionStatusFormat.GROUP.BITS.retrieve(permission);
            return SerialNumberManager.GROUP.getString(n);
        }

        static short getMode(long permission) {
            return (short)PermissionStatusFormat.MODE.BITS.retrieve(permission);
        }

        static long toLong(PermissionStatus ps) {
            long permission = 0L;
            int user = SerialNumberManager.USER.getSerialNumber(ps.getUserName());
            assert (user != 0);
            permission = PermissionStatusFormat.USER.BITS.combine((long)user, permission);
            int group = SerialNumberManager.GROUP.getSerialNumber(ps.getGroupName());
            permission = PermissionStatusFormat.GROUP.BITS.combine((long)group, permission);
            short mode = ps.getPermission().toShort();
            permission = PermissionStatusFormat.MODE.BITS.combine((long)mode, permission);
            return permission;
        }

        static PermissionStatus toPermissionStatus(long id, SerialNumberManager.StringTable stringTable) {
            int uid = (int)PermissionStatusFormat.USER.BITS.retrieve(id);
            int gid = (int)PermissionStatusFormat.GROUP.BITS.retrieve(id);
            return new PermissionStatus(SerialNumberManager.USER.getString(uid, stringTable), SerialNumberManager.GROUP.getString(gid, stringTable), new FsPermission(PermissionStatusFormat.getMode(id)));
        }

        public int getLength() {
            return this.BITS.getLength();
        }

        static {
            $VALUES = new PermissionStatusFormat[]{MODE, GROUP, USER};
        }
    }
}

