/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.server.aliasmap.InMemoryAliasMap;
import org.apache.hadoop.hdfs.server.common.HttpPutFailedException;
import org.apache.hadoop.hdfs.server.common.Storage;
import org.apache.hadoop.hdfs.server.common.Util;
import org.apache.hadoop.hdfs.server.namenode.CheckpointFaultInjector;
import org.apache.hadoop.hdfs.server.namenode.ImageServlet;
import org.apache.hadoop.hdfs.server.namenode.NNStorage;
import org.apache.hadoop.hdfs.server.namenode.SaveNamespaceCancelledException;
import org.apache.hadoop.hdfs.server.protocol.RemoteEditLog;
import org.apache.hadoop.hdfs.util.Canceler;
import org.apache.hadoop.hdfs.util.DataTransferThrottler;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.MD5Hash;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authentication.client.AuthenticationException;
import org.apache.hadoop.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.util.Lists;
import org.apache.hadoop.util.Time;
import org.apache.http.client.utils.URIBuilder;
import org.eclipse.jetty.io.EofException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class TransferFsImage {
    @VisibleForTesting
    static int timeout = 0;
    private static final Logger LOG = LoggerFactory.getLogger(TransferFsImage.class);

    public static void downloadMostRecentImageToDirectory(URL infoServer, File dir) throws IOException {
        String fileId = ImageServlet.getParamStringForMostRecentImage();
        TransferFsImage.getFileClient(infoServer, fileId, Lists.newArrayList((Object[])new File[]{dir}), null, false);
    }

    public static MD5Hash downloadImageToStorage(URL fsName, long imageTxId, Storage dstStorage, boolean needDigest, boolean isBootstrapStandby) throws IOException {
        String fileid = ImageServlet.getParamStringForImage(null, imageTxId, dstStorage, isBootstrapStandby);
        String fileName = NNStorage.getCheckpointImageFileName(imageTxId);
        List<File> dstFiles = dstStorage.getFiles(NNStorage.NameNodeDirType.IMAGE, fileName);
        if (dstFiles.isEmpty()) {
            throw new IOException("No targets in destination storage!");
        }
        MD5Hash hash = TransferFsImage.getFileClient(fsName, fileid, dstFiles, dstStorage, needDigest);
        LOG.info("Downloaded file " + dstFiles.get(0).getName() + " size " + dstFiles.get(0).length() + " bytes.");
        return hash;
    }

    static MD5Hash handleUploadImageRequest(HttpServletRequest request, long imageTxId, Storage dstStorage, InputStream stream, long advertisedSize, DataTransferThrottler throttler) throws IOException {
        String fileName = NNStorage.getCheckpointImageFileName(imageTxId);
        List<File> dstFiles = dstStorage.getFiles(NNStorage.NameNodeDirType.IMAGE, fileName);
        if (dstFiles.isEmpty()) {
            throw new IOException("No targets in destination storage!");
        }
        MD5Hash advertisedDigest = TransferFsImage.parseMD5Header(request);
        MD5Hash hash = Util.receiveFile(fileName, dstFiles, dstStorage, true, advertisedSize, advertisedDigest, fileName, stream, throttler);
        LOG.info("Downloaded file " + dstFiles.get(0).getName() + " size " + dstFiles.get(0).length() + " bytes.");
        return hash;
    }

    static void downloadEditsToStorage(URL fsName, RemoteEditLog log, NNStorage dstStorage) throws IOException {
        assert (log.getStartTxId() > 0L && log.getEndTxId() > 0L) : "bad log: " + log;
        String fileid = ImageServlet.getParamStringForLog(log, dstStorage);
        String finalFileName = NNStorage.getFinalizedEditsFileName(log.getStartTxId(), log.getEndTxId());
        List<File> finalFiles = dstStorage.getFiles(NNStorage.NameNodeDirType.EDITS, finalFileName);
        assert (!finalFiles.isEmpty()) : "No checkpoint targets.";
        for (File f : finalFiles) {
            if (f.exists() && FileUtil.canRead((File)f)) {
                LOG.info("Skipping download of remote edit log " + log + " since it already is stored locally at " + f);
                return;
            }
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug("Dest file: " + f);
        }
        long milliTime = Time.monotonicNow();
        String tmpFileName = NNStorage.getTemporaryEditsFileName(log.getStartTxId(), log.getEndTxId(), milliTime);
        List<File> tmpFiles = dstStorage.getFiles(NNStorage.NameNodeDirType.EDITS, tmpFileName);
        TransferFsImage.getFileClient(fsName, fileid, tmpFiles, dstStorage, false);
        LOG.info("Downloaded file " + tmpFiles.get(0).getName() + " size " + finalFiles.get(0).length() + " bytes.");
        CheckpointFaultInjector.getInstance().beforeEditsRename();
        for (Storage.StorageDirectory sd : dstStorage.dirIterable(NNStorage.NameNodeDirType.EDITS)) {
            boolean success;
            File tmpFile = NNStorage.getTemporaryEditsFile(sd, log.getStartTxId(), log.getEndTxId(), milliTime);
            File finalizedFile = NNStorage.getFinalizedEditsFile(sd, log.getStartTxId(), log.getEndTxId());
            if (LOG.isDebugEnabled()) {
                LOG.debug("Renaming " + tmpFile + " to " + finalizedFile);
            }
            if (success = tmpFile.renameTo(finalizedFile)) continue;
            LOG.warn("Unable to rename edits file from " + tmpFile + " to " + finalizedFile);
        }
    }

    public static void downloadAliasMap(URL fsName, File aliasMap, boolean isBootstrapStandby) throws IOException {
        String paramString = ImageServlet.getParamStringForAliasMap(isBootstrapStandby);
        TransferFsImage.getFileClient(fsName, paramString, Arrays.asList(aliasMap), null, false);
        LOG.info("Downloaded file " + aliasMap.getName() + " size " + aliasMap.length() + " bytes.");
        InMemoryAliasMap.completeBootstrapTransfer(aliasMap);
    }

    static TransferResult uploadImageFromStorage(URL fsName, Configuration conf, NNStorage storage, NNStorage.NameNodeFile nnf, long txid) throws IOException {
        return TransferFsImage.uploadImageFromStorage(fsName, conf, storage, nnf, txid, null);
    }

    public static TransferResult uploadImageFromStorage(URL fsName, Configuration conf, NNStorage storage, NNStorage.NameNodeFile nnf, long txid, Canceler canceler) throws IOException {
        URL url = new URL(fsName, "/imagetransfer");
        long startTime = Time.monotonicNow();
        try {
            TransferFsImage.uploadImage(url, conf, storage, nnf, txid, canceler);
        }
        catch (HttpPutFailedException e) {
            TransferResult result = TransferResult.getResultForCode(e.getResponseCode());
            if (result.shouldReThrowException) {
                throw e;
            }
            return result;
        }
        double xferSec = Math.max((double)(Time.monotonicNow() - startTime) / 1000.0, 0.001);
        LOG.info("Uploaded image with txid " + txid + " to namenode at " + fsName + " in " + xferSec + " seconds");
        return TransferResult.SUCCESS;
    }

    private static void uploadImage(URL url, Configuration conf, NNStorage storage, NNStorage.NameNodeFile nnf, long txId, Canceler canceler) throws IOException {
        File imageFile = storage.findImageFile(nnf, txId);
        if (imageFile == null) {
            throw new IOException("Could not find image with txid " + txId);
        }
        HttpURLConnection connection = null;
        try {
            URIBuilder uriBuilder = new URIBuilder(url.toURI());
            Map<String, String> params = ImageServlet.getParamsForPutImage(storage, txId, imageFile.length(), nnf);
            for (Map.Entry<String, String> entry : params.entrySet()) {
                uriBuilder.addParameter(entry.getKey(), entry.getValue());
            }
            URL urlWithParams = uriBuilder.build().toURL();
            connection = (HttpURLConnection)Util.connectionFactory.openConnection(urlWithParams, UserGroupInformation.isSecurityEnabled());
            connection.setRequestMethod("PUT");
            connection.setDoOutput(true);
            int chunkSize = (int)conf.getLongBytes("dfs.image.transfer.chunksize", 65536L);
            if (imageFile.length() > (long)chunkSize) {
                connection.setChunkedStreamingMode(chunkSize);
            }
            TransferFsImage.setTimeout(connection);
            ImageServlet.setVerificationHeadersForPut(connection, imageFile);
            TransferFsImage.writeFileToPutRequest(conf, connection, imageFile, canceler);
            int responseCode = connection.getResponseCode();
            if (responseCode != 200) {
                throw new HttpPutFailedException(String.format("Image uploading failed, status: %d, url: %s, message: %s", responseCode, urlWithParams, connection.getResponseMessage()), responseCode);
            }
        }
        catch (URISyntaxException | AuthenticationException e) {
            throw new IOException(e);
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeFileToPutRequest(Configuration conf, HttpURLConnection connection, File imageFile, Canceler canceler) throws IOException {
        connection.setRequestProperty("Content-Type", "application/octet-stream");
        connection.setRequestProperty("Content-Transfer-Encoding", "binary");
        OutputStream output = connection.getOutputStream();
        FileInputStream input = new FileInputStream(imageFile);
        try {
            TransferFsImage.copyFileToStream(output, imageFile, input, ImageServlet.getThrottler(conf), canceler);
        }
        finally {
            IOUtils.closeStream((Closeable)input);
            IOUtils.closeStream((Closeable)output);
        }
    }

    public static void copyFileToStream(OutputStream out, File localfile, FileInputStream infile, DataTransferThrottler throttler) throws IOException {
        TransferFsImage.copyFileToStream(out, localfile, infile, throttler, null);
    }

    private static void copyFileToStream(OutputStream out, File localfile, FileInputStream infile, DataTransferThrottler throttler, Canceler canceler) throws IOException {
        byte[] buf = new byte[Util.IO_FILE_BUFFER_SIZE];
        long total = 0L;
        int num = 1;
        Throwable ioe = null;
        String reportStr = "Sending fileName: " + localfile.getAbsolutePath() + ", fileSize: " + localfile.length() + ".";
        try {
            CheckpointFaultInjector.getInstance().aboutToSendFile(localfile);
            if (CheckpointFaultInjector.getInstance().shouldSendShortFile(localfile)) {
                long len = localfile.length();
                buf = new byte[(int)Math.min(len / 2L, (long)Util.IO_FILE_BUFFER_SIZE)];
                infile.read(buf);
            }
            while (num > 0) {
                if (canceler != null && canceler.isCancelled()) {
                    throw new SaveNamespaceCancelledException(canceler.getCancellationReason());
                }
                num = infile.read(buf);
                if (num <= 0) {
                    break;
                }
                if (CheckpointFaultInjector.getInstance().shouldCorruptAByte(localfile)) {
                    LOG.warn("SIMULATING A CORRUPT BYTE IN IMAGE TRANSFER!");
                    buf[0] = (byte)(buf[0] + 1);
                }
                out.write(buf, 0, num);
                total += (long)num;
                if (throttler == null) continue;
                throttler.throttle(num, canceler);
            }
        }
        catch (EofException e) {
            reportStr = reportStr + " Connection closed by client.";
            ioe = e;
            out = null;
        }
        catch (IOException ie) {
            ioe = ie;
            throw ie;
        }
        finally {
            reportStr = reportStr + " Sent total: " + total + " bytes. Size of last segment intended to send: " + num + " bytes.";
            if (ioe != null) {
                LOG.info(reportStr, ioe);
            } else {
                LOG.info(reportStr);
            }
            if (out != null) {
                out.close();
            }
        }
    }

    static MD5Hash getFileClient(URL infoServer, String queryString, List<File> localPaths, Storage dstStorage, boolean getChecksum) throws IOException {
        URL url = new URL(infoServer, "/imagetransfer?" + queryString);
        LOG.info("Opening connection to " + url);
        return TransferFsImage.doGetUrl(url, localPaths, dstStorage, getChecksum);
    }

    public static MD5Hash doGetUrl(URL url, List<File> localPaths, Storage dstStorage, boolean getChecksum) throws IOException {
        return Util.doGetUrl(url, localPaths, dstStorage, getChecksum, timeout, null);
    }

    private static MD5Hash parseMD5Header(HttpServletRequest request) {
        String header = request.getHeader("X-MD5-Digest");
        return header != null ? new MD5Hash(header) : null;
    }

    private static void setTimeout(HttpURLConnection connection) {
        if (timeout <= 0) {
            HdfsConfiguration conf = new HdfsConfiguration();
            timeout = conf.getInt("dfs.image.transfer.timeout", 60000);
            LOG.info("Image Transfer timeout configured to " + timeout + " milliseconds");
        }
        Util.setTimeout(connection, timeout);
    }

    public static enum TransferResult {
        SUCCESS(200, false),
        AUTHENTICATION_FAILURE(403, true),
        NOT_ACTIVE_NAMENODE_FAILURE(417, false),
        OLD_TRANSACTION_ID_FAILURE(409, false),
        UNEXPECTED_FAILURE(-1, true);

        private final int response;
        private final boolean shouldReThrowException;

        private TransferResult(int response, boolean rethrow) {
            this.response = response;
            this.shouldReThrowException = rethrow;
        }

        public static TransferResult getResultForCode(int code) {
            for (TransferResult result : TransferResult.values()) {
                if (result.response != code) continue;
                return result;
            }
            return UNEXPECTED_FAILURE;
        }
    }
}

