/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode.snapshot;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.fs.permission.PermissionStatus;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.proto.HdfsProtos;
import org.apache.hadoop.hdfs.protocolPB.PBHelperClient;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfo;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfoContiguous;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManager;
import org.apache.hadoop.hdfs.server.namenode.AclEntryStatusFormat;
import org.apache.hadoop.hdfs.server.namenode.AclFeature;
import org.apache.hadoop.hdfs.server.namenode.FSDirectory;
import org.apache.hadoop.hdfs.server.namenode.FSImage;
import org.apache.hadoop.hdfs.server.namenode.FSImageFormatPBINode;
import org.apache.hadoop.hdfs.server.namenode.FSImageFormatProtobuf;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.FsImageProto;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.hadoop.hdfs.server.namenode.INodeDirectory;
import org.apache.hadoop.hdfs.server.namenode.INodeDirectoryAttributes;
import org.apache.hadoop.hdfs.server.namenode.INodeFile;
import org.apache.hadoop.hdfs.server.namenode.INodeFileAttributes;
import org.apache.hadoop.hdfs.server.namenode.INodeMap;
import org.apache.hadoop.hdfs.server.namenode.INodeReference;
import org.apache.hadoop.hdfs.server.namenode.INodeWithAdditionalFields;
import org.apache.hadoop.hdfs.server.namenode.QuotaByStorageTypeEntry;
import org.apache.hadoop.hdfs.server.namenode.SaveNamespaceContext;
import org.apache.hadoop.hdfs.server.namenode.XAttrFeature;
import org.apache.hadoop.hdfs.server.namenode.snapshot.DiffList;
import org.apache.hadoop.hdfs.server.namenode.snapshot.DirectoryWithSnapshotFeature;
import org.apache.hadoop.hdfs.server.namenode.snapshot.FileDiff;
import org.apache.hadoop.hdfs.server.namenode.snapshot.FileDiffList;
import org.apache.hadoop.hdfs.server.namenode.snapshot.FileWithSnapshotFeature;
import org.apache.hadoop.hdfs.server.namenode.snapshot.Snapshot;
import org.apache.hadoop.hdfs.server.namenode.snapshot.SnapshotFSImageFormat;
import org.apache.hadoop.hdfs.server.namenode.snapshot.SnapshotManager;
import org.apache.hadoop.hdfs.util.EnumCounters;
import org.apache.hadoop.thirdparty.com.google.common.base.Preconditions;
import org.apache.hadoop.thirdparty.com.google.common.collect.ImmutableList;
import org.apache.hadoop.thirdparty.protobuf.ByteString;

@InterfaceAudience.Private
public class FSImageFormatPBSnapshot {
    private FSImageFormatPBSnapshot() {
    }

    public static final class Saver {
        private final FSNamesystem fsn;
        private final FsImageProto.FileSummary.Builder headers;
        private final FSImageFormatProtobuf.Saver parent;
        private final SaveNamespaceContext context;
        private long numImageErrors;

        public Saver(FSImageFormatProtobuf.Saver parent, FsImageProto.FileSummary.Builder headers, SaveNamespaceContext context, FSNamesystem fsn) {
            this.parent = parent;
            this.headers = headers;
            this.context = context;
            this.fsn = fsn;
            this.numImageErrors = 0L;
        }

        public void serializeSnapshotSection(OutputStream out) throws IOException {
            SnapshotManager sm = this.fsn.getSnapshotManager();
            FsImageProto.SnapshotSection.Builder b = FsImageProto.SnapshotSection.newBuilder().setSnapshotCounter(sm.getSnapshotCounter()).setNumSnapshots(sm.getNumSnapshots());
            List<INodeDirectory> snapshottables = sm.getSnapshottableDirs();
            for (INodeDirectory sdir : snapshottables) {
                b.addSnapshottableDir(sdir.getId());
            }
            b.build().writeDelimitedTo(out);
            int i = 0;
            for (INodeDirectory sdir : snapshottables) {
                for (Snapshot s : sdir.getDirectorySnapshottableFeature().getSnapshotList()) {
                    Snapshot.Root sroot = s.getRoot();
                    FsImageProto.SnapshotSection.Snapshot.Builder sb = FsImageProto.SnapshotSection.Snapshot.newBuilder().setSnapshotId(s.getId());
                    FsImageProto.INodeSection.INodeDirectory.Builder db = FSImageFormatPBINode.Saver.buildINodeDirectory(sroot, this.parent.getSaverContext());
                    FsImageProto.INodeSection.INode r = FsImageProto.INodeSection.INode.newBuilder().setId(sroot.getId()).setType(FsImageProto.INodeSection.INode.Type.DIRECTORY).setName(ByteString.copyFrom((byte[])sroot.getLocalNameBytes())).setDirectory(db).build();
                    sb.setRoot(r).build().writeDelimitedTo(out);
                    if (++i % 4096 != 0) continue;
                    this.context.checkCancelled();
                }
            }
            Preconditions.checkState((i == sm.getNumSnapshots() ? 1 : 0) != 0);
            this.parent.commitSection(this.headers, FSImageFormatProtobuf.SectionName.SNAPSHOT);
        }

        public void serializeINodeReferenceSection(OutputStream out) throws IOException {
            ArrayList<INodeReference> refList = this.parent.getSaverContext().getRefList();
            long i = 0L;
            for (INodeReference ref : refList) {
                FsImageProto.INodeReferenceSection.INodeReference.Builder rb = this.buildINodeReference(ref, i++);
                rb.build().writeDelimitedTo(out);
            }
            this.parent.commitSection(this.headers, FSImageFormatProtobuf.SectionName.INODE_REFERENCE);
        }

        private FsImageProto.INodeReferenceSection.INodeReference.Builder buildINodeReference(INodeReference ref, long refIndex) throws IOException {
            FsImageProto.INodeReferenceSection.INodeReference.Builder rb = FsImageProto.INodeReferenceSection.INodeReference.newBuilder().setReferredId(ref.getId());
            if (ref instanceof INodeReference.WithName) {
                rb.setLastSnapshotId(((INodeReference.WithName)ref).getLastSnapshotId()).setName(ByteString.copyFrom((byte[])ref.getLocalNameBytes()));
            } else if (ref instanceof INodeReference.DstReference) {
                rb.setDstSnapshotId(ref.getDstSnapshotId());
            }
            if (this.fsn.getFSDirectory().getInode(ref.getId()) == null) {
                FSImage.LOG.error("FSImageFormatPBSnapshot: Missing referred INodeId " + ref.getId() + " for INodeReference index " + refIndex + "; path=" + ref.getFullPathName() + "; parent=" + (ref.getParent() == null ? "null" : ref.getParent().getFullPathName()));
                ++this.numImageErrors;
            }
            return rb;
        }

        public void serializeSnapshotDiffSection(OutputStream out) throws IOException {
            INodeMap inodesMap = this.fsn.getFSDirectory().getINodeMap();
            ArrayList<INodeReference> refList = this.parent.getSaverContext().getRefList();
            int i = 0;
            Iterator<INodeWithAdditionalFields> iter = inodesMap.getMapIterator();
            while (iter.hasNext()) {
                INodeWithAdditionalFields inode = iter.next();
                if (inode.isFile()) {
                    this.serializeFileDiffList(inode.asFile(), out);
                } else if (inode.isDirectory()) {
                    this.serializeDirDiffList(inode.asDirectory(), refList, out);
                }
                if (++i % 4096 == 0) {
                    this.context.checkCancelled();
                }
                if (i % this.parent.getInodesPerSubSection() != 0) continue;
                this.parent.commitSubSection(this.headers, FSImageFormatProtobuf.SectionName.SNAPSHOT_DIFF_SUB);
            }
            this.parent.commitSectionAndSubSection(this.headers, FSImageFormatProtobuf.SectionName.SNAPSHOT_DIFF, FSImageFormatProtobuf.SectionName.SNAPSHOT_DIFF_SUB);
        }

        private void serializeFileDiffList(INodeFile file, OutputStream out) throws IOException {
            FileWithSnapshotFeature sf = file.getFileWithSnapshotFeature();
            if (sf != null) {
                DiffList diffList = sf.getDiffs().asList();
                FsImageProto.SnapshotDiffSection.DiffEntry entry = FsImageProto.SnapshotDiffSection.DiffEntry.newBuilder().setInodeId(file.getId()).setType(FsImageProto.SnapshotDiffSection.DiffEntry.Type.FILEDIFF).setNumOfDiff(diffList.size()).build();
                entry.writeDelimitedTo(out);
                for (int i = diffList.size() - 1; i >= 0; --i) {
                    INodeFileAttributes copy;
                    FileDiff diff = (FileDiff)diffList.get(i);
                    FsImageProto.SnapshotDiffSection.FileDiff.Builder fb = FsImageProto.SnapshotDiffSection.FileDiff.newBuilder().setSnapshotId(diff.getSnapshotId()).setFileSize(diff.getFileSize());
                    if (diff.getBlocks() != null) {
                        for (BlockInfo block : diff.getBlocks()) {
                            fb.addBlocks(PBHelperClient.convert((Block)block));
                        }
                    }
                    if ((copy = (INodeFileAttributes)diff.snapshotINode) != null) {
                        fb.setName(ByteString.copyFrom((byte[])copy.getLocalNameBytes())).setSnapshotCopy(FSImageFormatPBINode.Saver.buildINodeFile(copy, this.parent.getSaverContext()));
                    }
                    fb.build().writeDelimitedTo(out);
                }
            }
        }

        private void saveCreatedList(List<INode> created, OutputStream out) throws IOException {
            for (INode c : created) {
                FsImageProto.SnapshotDiffSection.CreatedListEntry.newBuilder().setName(ByteString.copyFrom((byte[])c.getLocalNameBytes())).build().writeDelimitedTo(out);
            }
        }

        private void serializeDirDiffList(INodeDirectory dir, List<INodeReference> refList, OutputStream out) throws IOException {
            DirectoryWithSnapshotFeature sf = dir.getDirectoryWithSnapshotFeature();
            if (sf != null) {
                DiffList diffList = sf.getDiffs().asList();
                FsImageProto.SnapshotDiffSection.DiffEntry entry = FsImageProto.SnapshotDiffSection.DiffEntry.newBuilder().setInodeId(dir.getId()).setType(FsImageProto.SnapshotDiffSection.DiffEntry.Type.DIRECTORYDIFF).setNumOfDiff(diffList.size()).build();
                entry.writeDelimitedTo(out);
                for (int i = diffList.size() - 1; i >= 0; --i) {
                    DirectoryWithSnapshotFeature.DirectoryDiff diff = (DirectoryWithSnapshotFeature.DirectoryDiff)diffList.get(i);
                    FsImageProto.SnapshotDiffSection.DirectoryDiff.Builder db = FsImageProto.SnapshotDiffSection.DirectoryDiff.newBuilder().setSnapshotId(diff.getSnapshotId()).setChildrenSize(diff.getChildrenSize()).setIsSnapshotRoot(diff.isSnapshotRoot());
                    INodeDirectoryAttributes copy = (INodeDirectoryAttributes)diff.snapshotINode;
                    if (!diff.isSnapshotRoot() && copy != null) {
                        db.setName(ByteString.copyFrom((byte[])copy.getLocalNameBytes())).setSnapshotCopy(FSImageFormatPBINode.Saver.buildINodeDirectory(copy, this.parent.getSaverContext()));
                    }
                    List<INode> created = diff.getChildrenDiff().getCreatedUnmodifiable();
                    db.setCreatedListSize(created.size());
                    List deleted = diff.getChildrenDiff().getDeletedUnmodifiable();
                    INode previousNode = null;
                    boolean misordered = false;
                    for (INode d : deleted) {
                        int result;
                        int n = result = previousNode == null ? -1 : previousNode.compareTo(d.getLocalNameBytes());
                        if (result == 0) {
                            FSImage.LOG.error("Name '" + d.getLocalName() + "' is repeated in the 'deleted' difflist of directory " + dir.getFullPathName() + ", INodeId=" + dir.getId());
                            ++this.numImageErrors;
                        } else if (result > 0 && !misordered) {
                            misordered = true;
                            ++this.numImageErrors;
                        }
                        previousNode = d;
                        if (d.isReference()) {
                            refList.add(d.asReference());
                            db.addDeletedINodeRef(refList.size() - 1);
                            continue;
                        }
                        db.addDeletedINode(d.getId());
                    }
                    if (misordered) {
                        FSImage.LOG.error("Misordered entries in the 'deleted' difflist of directory " + dir.getFullPathName() + ", INodeId=" + dir.getId() + ". The full list is " + Arrays.toString(deleted.toArray()));
                    }
                    db.build().writeDelimitedTo(out);
                    this.saveCreatedList(created, out);
                }
            }
        }

        public long getNumImageErrors() {
            return this.numImageErrors;
        }
    }

    public static final class Loader {
        private final FSNamesystem fsn;
        private final FSDirectory fsDir;
        private final FSImageFormatProtobuf.Loader parent;
        private final Map<Integer, Snapshot> snapshotMap;

        public Loader(FSNamesystem fsn, FSImageFormatProtobuf.Loader parent) {
            this.fsn = fsn;
            this.fsDir = fsn.getFSDirectory();
            this.snapshotMap = new HashMap<Integer, Snapshot>();
            this.parent = parent;
        }

        public void loadINodeReferenceSection(InputStream in) throws IOException {
            FsImageProto.INodeReferenceSection.INodeReference e;
            ArrayList<INodeReference> refList = this.parent.getLoaderContext().getRefList();
            while ((e = FsImageProto.INodeReferenceSection.INodeReference.parseDelimitedFrom(in)) != null) {
                INodeReference ref = this.loadINodeReference(e);
                refList.add(ref);
            }
        }

        private INodeReference loadINodeReference(FsImageProto.INodeReferenceSection.INodeReference r) {
            long referredId = r.getReferredId();
            INode referred = this.fsDir.getInode(referredId);
            INodeReference.WithCount withCount = (INodeReference.WithCount)referred.getParentReference();
            if (withCount == null) {
                withCount = new INodeReference.WithCount(null, referred);
            }
            INodeReference ref = r.hasDstSnapshotId() ? new INodeReference.DstReference(null, withCount, r.getDstSnapshotId()) : new INodeReference.WithName(null, withCount, r.getName().toByteArray(), r.getLastSnapshotId());
            return ref;
        }

        public void loadSnapshotSection(InputStream in) throws IOException {
            SnapshotManager sm = this.fsn.getSnapshotManager();
            FsImageProto.SnapshotSection section = FsImageProto.SnapshotSection.parseDelimitedFrom(in);
            int snum = section.getNumSnapshots();
            sm.setNumSnapshots(snum);
            sm.setSnapshotCounter(section.getSnapshotCounter());
            for (long sdirId : section.getSnapshottableDirList()) {
                INodeDirectory dir = this.fsDir.getInode(sdirId).asDirectory();
                if (!dir.isSnapshottable()) {
                    dir.addSnapshottableFeature();
                } else {
                    dir.setSnapshotQuota(65536);
                }
                sm.addSnapshottable(dir);
            }
            this.loadSnapshots(in, snum);
        }

        private void loadSnapshots(InputStream in, int size) throws IOException {
            for (int i = 0; i < size; ++i) {
                FsImageProto.SnapshotSection.Snapshot pbs = FsImageProto.SnapshotSection.Snapshot.parseDelimitedFrom(in);
                INodeDirectory root = FSImageFormatPBINode.Loader.loadINodeDirectory(pbs.getRoot(), this.parent.getLoaderContext());
                int sid = pbs.getSnapshotId();
                INodeDirectory parent = this.fsDir.getInode(root.getId()).asDirectory();
                Snapshot snapshot = new Snapshot(sid, root, parent);
                parent.getDirectorySnapshottableFeature().addSnapshot(snapshot);
                this.snapshotMap.put(sid, snapshot);
            }
        }

        public void loadSnapshotDiffSection(InputStream in) throws IOException {
            FsImageProto.SnapshotDiffSection.DiffEntry entry;
            ArrayList<INodeReference> refList = this.parent.getLoaderContext().getRefList();
            while ((entry = FsImageProto.SnapshotDiffSection.DiffEntry.parseDelimitedFrom(in)) != null) {
                long inodeId = entry.getInodeId();
                INode inode = this.fsDir.getInode(inodeId);
                FsImageProto.SnapshotDiffSection.DiffEntry.Type type = entry.getType();
                switch (type) {
                    case FILEDIFF: {
                        this.loadFileDiffList(in, inode.asFile(), entry.getNumOfDiff());
                        break;
                    }
                    case DIRECTORYDIFF: {
                        this.loadDirectoryDiffList(in, inode.asDirectory(), entry.getNumOfDiff(), refList);
                    }
                }
            }
        }

        private void loadFileDiffList(InputStream in, INodeFile file, int size) throws IOException {
            FileDiffList diffs = new FileDiffList();
            FSImageFormatProtobuf.LoaderContext state = this.parent.getLoaderContext();
            BlockManager bm = this.fsn.getBlockManager();
            for (int i = 0; i < size; ++i) {
                FsImageProto.SnapshotDiffSection.FileDiff pbf = FsImageProto.SnapshotDiffSection.FileDiff.parseDelimitedFrom(in);
                INodeFileAttributes copy = null;
                if (pbf.hasSnapshotCopy()) {
                    FsImageProto.INodeSection.INodeFile fileInPb = pbf.getSnapshotCopy();
                    PermissionStatus permission = FSImageFormatPBINode.Loader.loadPermission(fileInPb.getPermission(), state.getStringTable());
                    AclFeature acl = null;
                    if (fileInPb.hasAcl()) {
                        int[] entries = AclEntryStatusFormat.toInt(FSImageFormatPBINode.Loader.loadAclEntries(fileInPb.getAcl(), state.getStringTable()));
                        acl = new AclFeature(entries);
                    }
                    XAttrFeature xAttrs = null;
                    if (fileInPb.hasXAttrs()) {
                        xAttrs = new XAttrFeature(FSImageFormatPBINode.Loader.loadXAttrs(fileInPb.getXAttrs(), state.getStringTable()));
                    }
                    boolean isStriped = fileInPb.getBlockType() == HdfsProtos.BlockTypeProto.STRIPED;
                    Short replication = !isStriped ? Short.valueOf((short)fileInPb.getReplication()) : null;
                    Byte ecPolicyID = isStriped ? Byte.valueOf((byte)fileInPb.getErasureCodingPolicyID()) : null;
                    copy = new INodeFileAttributes.SnapshotCopy(pbf.getName().toByteArray(), permission, acl, fileInPb.getModificationTime(), fileInPb.getAccessTime(), replication, ecPolicyID, fileInPb.getPreferredBlockSize(), (byte)fileInPb.getStoragePolicyID(), xAttrs, PBHelperClient.convert((HdfsProtos.BlockTypeProto)fileInPb.getBlockType()));
                }
                FileDiff diff = new FileDiff(pbf.getSnapshotId(), copy, null, pbf.getFileSize());
                List<HdfsProtos.BlockProto> bpl = pbf.getBlocksList();
                BlockInfo[] blocks = new BlockInfo[bpl.size()];
                int e = bpl.size();
                for (int j = 0; j < e; ++j) {
                    Block blk = PBHelperClient.convert((HdfsProtos.BlockProto)bpl.get(j));
                    BlockInfo storedBlock = bm.getStoredBlock(blk);
                    if (storedBlock == null) {
                        storedBlock = (BlockInfoContiguous)this.fsn.getBlockManager().addBlockCollectionWithCheck(new BlockInfoContiguous(blk, copy.getFileReplication()), file);
                    }
                    blocks[j] = storedBlock;
                }
                if (blocks.length > 0) {
                    diff.setBlocks(blocks);
                }
                diffs.addFirst(diff);
            }
            file.addSnapshotFeature(diffs);
            short repl = file.getPreferredBlockReplication();
            for (BlockInfo b : file.getBlocks()) {
                if (b.getReplication() >= repl) continue;
                bm.setReplication(b.getReplication(), repl, b);
            }
        }

        private List<INode> loadCreatedList(InputStream in, INodeDirectory dir, int size) throws IOException {
            ArrayList<INode> clist = new ArrayList<INode>(size);
            for (long c = 0L; c < (long)size; ++c) {
                FsImageProto.SnapshotDiffSection.CreatedListEntry entry = FsImageProto.SnapshotDiffSection.CreatedListEntry.parseDelimitedFrom(in);
                INode created = SnapshotFSImageFormat.loadCreated(entry.getName().toByteArray(), dir);
                clist.add(created);
            }
            return clist;
        }

        private void addToDeletedList(INode dnode, INodeDirectory parent) {
            dnode.setParent(parent);
            if (dnode.isFile()) {
                FSImageFormatPBINode.Loader.updateBlocksMap(dnode.asFile(), this.fsn.getBlockManager());
            }
        }

        private List<INode> loadDeletedList(List<INodeReference> refList, InputStream in, INodeDirectory dir, List<Long> deletedNodes, List<Integer> deletedRefNodes) throws IOException {
            ArrayList<INode> dlist = new ArrayList<INode>(deletedRefNodes.size() + deletedNodes.size());
            Iterator<Number> iterator = deletedNodes.iterator();
            while (iterator.hasNext()) {
                long deletedId = iterator.next();
                INode deleted = this.fsDir.getInode(deletedId);
                dlist.add(deleted);
                this.addToDeletedList(deleted, dir);
            }
            iterator = deletedRefNodes.iterator();
            while (iterator.hasNext()) {
                int refId = (Integer)iterator.next();
                INodeReference deletedRef = refList.get(refId);
                dlist.add(deletedRef);
                this.addToDeletedList(deletedRef, dir);
            }
            Collections.sort(dlist, new Comparator<INode>(){

                @Override
                public int compare(INode n1, INode n2) {
                    return n1.compareTo(n2.getLocalNameBytes());
                }
            });
            return dlist;
        }

        private void loadDirectoryDiffList(InputStream in, INodeDirectory dir, int size, List<INodeReference> refList) throws IOException {
            if (!dir.isWithSnapshot()) {
                dir.addSnapshotFeature(null);
            }
            DirectoryWithSnapshotFeature.DirectoryDiffList diffs = dir.getDiffs();
            FSImageFormatProtobuf.LoaderContext state = this.parent.getLoaderContext();
            for (int i = 0; i < size; ++i) {
                FsImageProto.SnapshotDiffSection.DirectoryDiff diffInPb = FsImageProto.SnapshotDiffSection.DirectoryDiff.parseDelimitedFrom(in);
                int snapshotId = diffInPb.getSnapshotId();
                Snapshot snapshot = this.snapshotMap.get(snapshotId);
                int childrenSize = diffInPb.getChildrenSize();
                boolean useRoot = diffInPb.getIsSnapshotRoot();
                INodeDirectoryAttributes copy = null;
                if (useRoot) {
                    copy = snapshot.getRoot();
                } else if (diffInPb.hasSnapshotCopy()) {
                    boolean noQuota;
                    FsImageProto.INodeSection.INodeDirectory dirCopyInPb = diffInPb.getSnapshotCopy();
                    byte[] name = diffInPb.getName().toByteArray();
                    PermissionStatus permission = FSImageFormatPBINode.Loader.loadPermission(dirCopyInPb.getPermission(), state.getStringTable());
                    AclFeature acl = null;
                    if (dirCopyInPb.hasAcl()) {
                        int[] entries = AclEntryStatusFormat.toInt(FSImageFormatPBINode.Loader.loadAclEntries(dirCopyInPb.getAcl(), state.getStringTable()));
                        acl = new AclFeature(entries);
                    }
                    XAttrFeature xAttrs = null;
                    if (dirCopyInPb.hasXAttrs()) {
                        xAttrs = new XAttrFeature(FSImageFormatPBINode.Loader.loadXAttrs(dirCopyInPb.getXAttrs(), state.getStringTable()));
                    }
                    long modTime = dirCopyInPb.getModificationTime();
                    boolean bl = noQuota = dirCopyInPb.getNsQuota() == -1L && dirCopyInPb.getDsQuota() == -1L && !dirCopyInPb.hasTypeQuotas();
                    if (noQuota) {
                        copy = new INodeDirectoryAttributes.SnapshotCopy(name, permission, acl, modTime, xAttrs);
                    } else {
                        EnumCounters<StorageType> typeQuotas = null;
                        if (dirCopyInPb.hasTypeQuotas()) {
                            ImmutableList<QuotaByStorageTypeEntry> qes = FSImageFormatPBINode.Loader.loadQuotaByStorageTypeEntries(dirCopyInPb.getTypeQuotas());
                            typeQuotas = new EnumCounters<StorageType>(StorageType.class, -1L);
                            for (QuotaByStorageTypeEntry qe : qes) {
                                if (qe.getQuota() < 0L || qe.getStorageType() == null || !qe.getStorageType().supportTypeQuota()) continue;
                                typeQuotas.set(qe.getStorageType(), qe.getQuota());
                            }
                        }
                        copy = new INodeDirectoryAttributes.CopyWithQuota(name, permission, acl, modTime, dirCopyInPb.getNsQuota(), dirCopyInPb.getDsQuota(), typeQuotas, xAttrs);
                    }
                }
                List<INode> clist = this.loadCreatedList(in, dir, diffInPb.getCreatedListSize());
                List<INode> dlist = this.loadDeletedList(refList, in, dir, diffInPb.getDeletedINodeList(), diffInPb.getDeletedINodeRefList());
                DirectoryWithSnapshotFeature.DirectoryDiff diff = new DirectoryWithSnapshotFeature.DirectoryDiff(snapshotId, copy, null, childrenSize, clist, dlist, useRoot);
                diffs.addFirst(diff);
            }
        }
    }
}

