/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode.snapshot;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.server.namenode.AclFeature;
import org.apache.hadoop.hdfs.server.namenode.ContentSummaryComputationContext;
import org.apache.hadoop.hdfs.server.namenode.DirectoryWithQuotaFeature;
import org.apache.hadoop.hdfs.server.namenode.FSImageFormat;
import org.apache.hadoop.hdfs.server.namenode.FSImageSerialization;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.hadoop.hdfs.server.namenode.INodeDirectory;
import org.apache.hadoop.hdfs.server.namenode.QuotaCounts;
import org.apache.hadoop.hdfs.server.namenode.XAttrFeature;
import org.apache.hadoop.hdfs.util.ReadOnlyList;
import org.apache.hadoop.security.AccessControlException;

@InterfaceAudience.Private
public class Snapshot
implements Comparable<byte[]> {
    public static final int CURRENT_STATE_ID = 0x7FFFFFFE;
    public static final int NO_SNAPSHOT_ID = -1;
    private static final String DEFAULT_SNAPSHOT_NAME_PATTERN = "'s'yyyyMMdd-HHmmss.SSS";
    public static final Comparator<Snapshot> ID_COMPARATOR = new Comparator<Snapshot>(){

        @Override
        public int compare(Snapshot left, Snapshot right) {
            return ID_INTEGER_COMPARATOR.compare(Snapshot.getSnapshotId(left), Snapshot.getSnapshotId(right));
        }
    };
    public static final Comparator<Integer> ID_INTEGER_COMPARATOR = new Comparator<Integer>(){

        @Override
        public int compare(Integer left, Integer right) {
            return left - right;
        }
    };
    private final int id;
    private final Root root;

    public static String generateDefaultSnapshotName() {
        return new SimpleDateFormat(DEFAULT_SNAPSHOT_NAME_PATTERN).format(new Date());
    }

    public static String generateDeletedSnapshotName(Snapshot s) {
        return Snapshot.getSnapshotName(s) + "#" + s.getId();
    }

    public static String getSnapshotPath(String snapshottableDir, String snapshotRelativePath) {
        StringBuilder b = new StringBuilder(snapshottableDir);
        if (b.charAt(b.length() - 1) != '/') {
            b.append("/");
        }
        return b.append(".snapshot").append("/").append(snapshotRelativePath).toString();
    }

    static String getSnapshotName(Snapshot s) {
        return s != null ? s.getRoot().getLocalName() : "";
    }

    public static int getSnapshotId(Snapshot s) {
        return s == null ? 0x7FFFFFFE : s.getId();
    }

    public static int findLatestSnapshot(INode inode, int anchor) {
        int latest = -1;
        while (inode != null) {
            INodeDirectory dir;
            if (inode.isDirectory() && (dir = inode.asDirectory()).isWithSnapshot()) {
                latest = dir.getDiffs().updatePrior(anchor, latest);
            }
            inode = inode.getParent();
        }
        return latest;
    }

    static Snapshot read(DataInput in, FSImageFormat.Loader loader) throws IOException {
        int snapshotId = in.readInt();
        INode root = loader.loadINodeWithLocalName(false, in, false);
        return new Snapshot(snapshotId, root.asDirectory(), null);
    }

    Snapshot(int id, String name, INodeDirectory dir) {
        this(id, dir, dir);
        this.root.setLocalName(DFSUtil.string2Bytes(name));
    }

    Snapshot(int id, INodeDirectory dir, INodeDirectory parent) {
        this.id = id;
        this.root = new Root(dir);
        this.root.setParent(parent);
    }

    public int getId() {
        return this.id;
    }

    public Root getRoot() {
        return this.root;
    }

    @Override
    public int compareTo(byte[] bytes) {
        return this.root.compareTo(bytes);
    }

    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (!(that instanceof Snapshot)) {
            return false;
        }
        return this.id == ((Snapshot)that).id;
    }

    public int hashCode() {
        return this.id;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "." + this.root.getLocalName() + "(id=" + this.id + ")";
    }

    void write(DataOutput out) throws IOException {
        out.writeInt(this.id);
        FSImageSerialization.writeINodeDirectory(this.root, out);
    }

    public static class Root
    extends INodeDirectory {
        Root(INodeDirectory other) {
            super(other, false, (INode.Feature[])Arrays.stream(other.getFeatures()).filter(feature -> feature instanceof AclFeature || feature instanceof XAttrFeature || feature instanceof DirectoryWithQuotaFeature).map(feature -> {
                if (feature instanceof DirectoryWithQuotaFeature) {
                    QuotaCounts quota = ((DirectoryWithQuotaFeature)feature).getSpaceAllowed();
                    return new DirectoryWithQuotaFeature.Builder().nameSpaceQuota(quota.getNameSpace()).storageSpaceQuota(quota.getStorageSpace()).typeQuotas(quota.getTypeSpaces()).build();
                }
                return feature;
            }).toArray(INode.Feature[]::new));
        }

        boolean isMarkedAsDeleted() {
            XAttrFeature f = this.getXAttrFeature();
            return f != null && f.getXAttr("system.hdfs.snapshot.deleted") != null;
        }

        @Override
        public ReadOnlyList<INode> getChildrenList(int snapshotId) {
            return this.getParent().getChildrenList(snapshotId);
        }

        @Override
        public INode getChild(byte[] name, int snapshotId) {
            return this.getParent().getChild(name, snapshotId);
        }

        @Override
        public ContentSummaryComputationContext computeContentSummary(int snapshotId, ContentSummaryComputationContext summary) throws AccessControlException {
            return this.computeDirectoryContentSummary(summary, snapshotId);
        }

        @Override
        public String getFullPathName() {
            return Snapshot.getSnapshotPath(this.getParent().getFullPathName(), this.getLocalName());
        }

        public String getRootFullPathName() {
            return this.getParent().getFullPathName();
        }
    }
}

