/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.File;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystemContractBaseTest;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.AppendTestUtil;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class TestHDFSFileSystemContract
extends FileSystemContractBaseTest {
    private MiniDFSCluster cluster;
    private String defaultWorkingDirectory;

    @Before
    public void setUp() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.set("fs.permissions.umask-mode", "062");
        File basedir = GenericTestUtils.getRandomizedTestDir();
        this.cluster = new MiniDFSCluster.Builder((Configuration)conf, basedir).numDataNodes(2).build();
        this.fs = this.cluster.getFileSystem();
        this.defaultWorkingDirectory = "/user/" + UserGroupInformation.getCurrentUser().getShortUserName();
    }

    @After
    public void tearDown() throws Exception {
        super.tearDown();
        if (this.cluster != null) {
            this.cluster.shutdown();
            this.cluster = null;
        }
    }

    protected String getDefaultWorkingDirectory() {
        return this.defaultWorkingDirectory;
    }

    protected int getGlobalTimeout() {
        return 60000;
    }

    @Test
    public void testAppend() throws IOException {
        AppendTestUtil.testAppend(this.fs, new Path("/testAppend/f"));
    }
}

