/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.IOException;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathHandle;
import org.apache.hadoop.fs.viewfs.ConfigUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.TestDistributedFileSystem;
import org.apache.hadoop.hdfs.ViewDistributedFileSystem;
import org.apache.hadoop.test.Whitebox;
import org.junit.Assert;
import org.junit.Test;

public class TestViewDistributedFileSystem
extends TestDistributedFileSystem {
    @Override
    HdfsConfiguration getTestConfiguration() {
        HdfsConfiguration conf = super.getTestConfiguration();
        conf.set("fs.hdfs.impl", ViewDistributedFileSystem.class.getName());
        return conf;
    }

    @Override
    public void testStatistics() throws IOException {
        FileSystem.getStatistics((String)"hdfs", ViewDistributedFileSystem.class).reset();
        ThreadLocal data = (ThreadLocal)Whitebox.getInternalState((Object)FileSystem.getStatistics((String)"hdfs", ViewDistributedFileSystem.class), (String)"threadData");
        data.set(null);
        super.testStatistics();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testOpenWithPathHandle() throws Exception {
        HdfsConfiguration conf = this.getTestConfiguration();
        MiniDFSCluster cluster = null;
        try {
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).build();
            DistributedFileSystem fileSys = cluster.getFileSystem();
            Path openTestPath = new Path("/testOpen");
            fileSys.create(openTestPath).close();
            PathHandle pathHandle = fileSys.getPathHandle(fileSys.getFileStatus(openTestPath), new Options.HandleOpt[0]);
            fileSys.open(pathHandle, 1024).close();
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void testEmptyDelegationToken() throws IOException {
        HdfsConfiguration conf = this.getTestConfiguration();
        MiniDFSCluster cluster = null;
        try {
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(0).build();
            URI defaultUri = URI.create(conf.get("fs.defaultFS"));
            ConfigUtil.addLinkFallback((Configuration)conf, (String)defaultUri.getHost(), (URI)defaultUri);
            try (FileSystem fileSys = FileSystem.get((Configuration)conf);){
                fileSys.getDelegationToken("");
            }
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRenameWithOptions() throws IOException {
        HdfsConfiguration conf = this.getTestConfiguration();
        MiniDFSCluster cluster = null;
        try {
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(0).build();
            URI defaultUri = URI.create(conf.get("fs.defaultFS"));
            conf.set("fs.viewfs.mounttable." + defaultUri.getHost() + ".linkFallback", defaultUri.toString());
            conf.setLong("fs.trash.interval", 30000L);
            try (ViewDistributedFileSystem fileSystem = (ViewDistributedFileSystem)FileSystem.get((Configuration)conf);){
                Path testDir = new Path("/test");
                Path renameDir = new Path("/testRename");
                fileSystem.mkdirs(testDir);
                fileSystem.rename(testDir, renameDir, new Options.Rename[]{Options.Rename.TO_TRASH});
                Assert.assertTrue((boolean)fileSystem.exists(renameDir));
                Assert.assertFalse((boolean)fileSystem.exists(testDir));
            }
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRenameWithOptionsWithMountEntries() throws IOException {
        HdfsConfiguration conf = this.getTestConfiguration();
        MiniDFSCluster cluster = null;
        try {
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).build();
            URI defaultUri = URI.create(conf.get("fs.defaultFS"));
            conf.set("fs.viewfs.mounttable." + defaultUri.getHost() + ".linkFallback", defaultUri.toString());
            Path target = new Path(defaultUri.toString(), "/src");
            ConfigUtil.addLink((Configuration)conf, (String)defaultUri.getHost(), (String)"/source", (URI)target.toUri());
            FileSystem defaultFs = FileSystem.get((URI)defaultUri, (Configuration)conf);
            defaultFs.mkdirs(target);
            try (ViewDistributedFileSystem fileSystem = (ViewDistributedFileSystem)FileSystem.get((Configuration)conf);){
                Path testDir = new Path("/source");
                Path filePath = new Path(testDir, "file");
                Path renamedFilePath = new Path(testDir, "fileRename");
                fileSystem.create(filePath).close();
                Assert.assertTrue((boolean)fileSystem.exists(filePath));
                fileSystem.rename(filePath, renamedFilePath, new Options.Rename[]{Options.Rename.NONE});
                Assert.assertFalse((boolean)fileSystem.exists(filePath));
                Assert.assertTrue((boolean)fileSystem.exists(renamedFilePath));
            }
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testQuota() throws IOException {
        HdfsConfiguration conf = this.getTestConfiguration();
        MiniDFSCluster cluster = null;
        try {
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(0).build();
            URI defaultUri = URI.create(conf.get("fs.defaultFS"));
            conf.set("fs.viewfs.mounttable." + defaultUri.getHost() + ".linkFallback", defaultUri.toString());
            Path target = new Path(defaultUri.toString(), "/src");
            ConfigUtil.addLink((Configuration)conf, (String)defaultUri.getHost(), (String)"/source", (URI)target.toUri());
            FileSystem defaultFs = FileSystem.get((URI)defaultUri, (Configuration)conf);
            defaultFs.mkdirs(target);
            try (ViewDistributedFileSystem fileSystem = (ViewDistributedFileSystem)FileSystem.get((Configuration)conf);){
                Path testDir = new Path("/source");
                fileSystem.setQuota(testDir, 10L, 10L);
                Assert.assertEquals((long)10L, (long)defaultFs.getQuotaUsage(target).getSpaceQuota());
            }
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }
}

