/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.tools.offlineImageViewer;

import java.io.File;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.UnresolvedLinkException;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.StripedFileTestUtil;
import org.apache.hadoop.hdfs.protocol.ErasureCodingPolicy;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.protocol.SnapshotAccessControlException;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfo;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfoStriped;
import org.apache.hadoop.hdfs.server.namenode.FSDirectory;
import org.apache.hadoop.hdfs.server.namenode.FSImageTestUtil;
import org.apache.hadoop.hdfs.server.namenode.INodeFile;
import org.apache.hadoop.hdfs.tools.offlineImageViewer.FSImageLoader;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestOfflineImageViewerWithStripedBlocks {
    private final ErasureCodingPolicy ecPolicy = StripedFileTestUtil.getDefaultECPolicy();
    private int dataBlocks = this.ecPolicy.getNumDataUnits();
    private int parityBlocks = this.ecPolicy.getNumParityUnits();
    private static MiniDFSCluster cluster;
    private static DistributedFileSystem fs;
    private final int cellSize = this.ecPolicy.getCellSize();
    private final int stripesPerBlock = 3;
    private final int blockSize = this.cellSize * 3;

    @Before
    public void setup() throws IOException {
        int numDNs = this.dataBlocks + this.parityBlocks + 2;
        Configuration conf = new Configuration();
        conf.setLong("dfs.blocksize", (long)this.blockSize);
        cluster = new MiniDFSCluster.Builder(conf).numDataNodes(numDNs).build();
        cluster.waitActive();
        cluster.getFileSystem().getClient().setErasureCodingPolicy("/", StripedFileTestUtil.getDefaultECPolicy().getName());
        fs = cluster.getFileSystem();
        fs.enableErasureCodingPolicy(StripedFileTestUtil.getDefaultECPolicy().getName());
        Path eczone = new Path("/eczone");
        fs.mkdirs(eczone);
    }

    @After
    public void tearDown() {
        if (cluster != null) {
            cluster.shutdown();
        }
    }

    @Test(timeout=60000L)
    public void testFileEqualToOneStripe() throws Exception {
        int numBytes = this.cellSize;
        this.testFileSize(numBytes);
    }

    @Test(timeout=60000L)
    public void testFileLessThanOneStripe() throws Exception {
        int numBytes = this.cellSize - 100;
        this.testFileSize(numBytes);
    }

    @Test(timeout=60000L)
    public void testFileHavingMultipleBlocks() throws Exception {
        int numBytes = this.blockSize * 3;
        this.testFileSize(numBytes);
    }

    @Test(timeout=60000L)
    public void testFileLargerThanABlockGroup1() throws IOException {
        this.testFileSize(this.blockSize * this.dataBlocks + this.cellSize + 123);
    }

    @Test(timeout=60000L)
    public void testFileLargerThanABlockGroup2() throws IOException {
        this.testFileSize(this.blockSize * this.dataBlocks * 3 + this.cellSize * this.dataBlocks + this.cellSize + 123);
    }

    @Test(timeout=60000L)
    public void testFileFullBlockGroup() throws IOException {
        this.testFileSize(this.blockSize * this.dataBlocks);
    }

    @Test(timeout=60000L)
    public void testFileMoreThanOneStripe() throws Exception {
        int numBytes = this.blockSize + this.blockSize / 2;
        this.testFileSize(numBytes);
    }

    private void testFileSize(int numBytes) throws IOException, UnresolvedLinkException, SnapshotAccessControlException {
        fs.setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_LEAVE);
        File orgFsimage = null;
        Path file = new Path("/eczone/striped");
        FSDataOutputStream out = fs.create(file, true);
        byte[] bytes = DFSTestUtil.generateSequentialBytes(0, numBytes);
        out.write(bytes);
        out.close();
        fs.setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_ENTER, false);
        fs.saveNamespace();
        orgFsimage = FSImageTestUtil.findLatestImageFile(FSImageTestUtil.getFSImage(cluster.getNameNode()).getStorage().getStorageDir(0));
        if (orgFsimage == null) {
            throw new RuntimeException("Didn't generate or can't find fsimage");
        }
        FSImageLoader loader = FSImageLoader.load((String)orgFsimage.getAbsolutePath());
        String fileStatus = loader.getFileStatus("/eczone/striped");
        long expectedFileSize = bytes.length;
        FSDirectory fsdir = cluster.getNamesystem().getFSDirectory();
        INodeFile fileNode = fsdir.getINode4Write(file.toString()).asFile();
        Assert.assertEquals((long)StripedFileTestUtil.getDefaultECPolicy().getId(), (long)fileNode.getErasureCodingPolicyID());
        Assert.assertTrue((String)"Invalid block size", (fileNode.getBlocks().length > 0 ? 1 : 0) != 0);
        long actualFileSize = 0L;
        for (BlockInfo blockInfo : fileNode.getBlocks()) {
            Assert.assertTrue((String)"Didn't find block striped information", (boolean)(blockInfo instanceof BlockInfoStriped));
            actualFileSize += blockInfo.getNumBytes();
        }
        Assert.assertEquals((String)"Wrongly computed file size contains striped blocks", (long)expectedFileSize, (long)actualFileSize);
        String EXPECTED_FILE_SIZE = "\"length\":" + String.valueOf(expectedFileSize);
        Assert.assertTrue((String)("Wrongly computed file size contains striped blocks, file status:" + fileStatus + ". Expected file size is : " + EXPECTED_FILE_SIZE), (boolean)fileStatus.contains(EXPECTED_FILE_SIZE));
    }
}

